/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.combobox;

import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Menu;
import javafx.scene.layout.Region;
import net.sipsnet.client.utils.viewers.combobox.IOnHiddenListener;

public class MaxSizedContextMenu
extends ContextMenu {
    private boolean isShowing = false;

    public MaxSizedContextMenu() {
        this.addEventHandler(Menu.ON_SHOWING, e -> {
            this.isShowing = true;
            Node content = this.getSkin().getNode();
            if (content instanceof Region) {
                ((Region)content).setMaxHeight(this.getMaxHeight());
                ((Region)content).setMaxWidth(this.getMinWidth());
                ((Region)content).setMinWidth(this.getMinWidth());
            }
        });
    }

    public void setHideListener(IOnHiddenListener iOnHiddenListener) {
        this.addEventHandler(Menu.ON_HIDDEN, e -> {
            this.isShowing = false;
            iOnHiddenListener.onHidden();
        });
    }

    public boolean isMenuShowing() {
        return this.isShowing;
    }
}

