/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.contextmenu;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Label;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.viewers.IActionOnRelease;
import net.sipsnet.client.utils.viewers.combobox.IComboBoxActionListener;
import net.sipsnet.client.utils.viewers.contextmenu.IMenuActionListener;
import net.sipsnet.client.utils.viewers.mylistview.MyListView;

public class MyContextMenu
implements IActionOnRelease {
    private String elementId;
    private MyListView myListView;
    private VBox mainPane;
    private Stage stage;
    private final String FOCUSED_BACKGROUND = "-fx-background-color: %s;-fx-text-fill: %s;";
    private String NOT_FOCUSED_BACKGROUND = "-fx-background-color: transparent;-fx-text-fill:black;";
    private final VBox menuPane;
    private final int MAX_MENU_HEIGHT = 350;
    private double MAX_MENU_WIDTH = 160.0;
    private final int MAX_ITEM_HEIGHT = 40;
    private int maxHeight = 40;
    private boolean withSelection = false;
    private int selectedIndex = -1;
    private boolean isShowing = false;
    private String extraBackgroundColor = null;
    private final List<Object> items = new ArrayList<Object>();
    private List<IMenuActionListener> iMenuActionListeners = new ArrayList<IMenuActionListener>();
    private final ChangeListener<Number> stageWidthListener = (observableValue, oldValue, newValue) -> {
        this.stage.setMaxWidth(this.MAX_MENU_WIDTH);
        this.stage.setWidth(this.MAX_MENU_WIDTH);
    };
    private final ChangeListener<Number> stageHeightListener = (observableValue, oldValue, newValue) -> this.stage.setMaxHeight((double)this.maxHeight);
    private final ChangeListener<Boolean> stageFocusListener = (observableValue, oldValue, newValue) -> {
        if (!newValue.booleanValue()) {
            this.hide();
        }
    };
    private final Map<String, EventHandler<MouseEvent>> eventMap = new HashMap<String, EventHandler<MouseEvent>>();
    private final EventHandler<MouseEvent> enteredEventHandler = mouseEvent -> {
        if (!this.isWithSelection()) {
            Pane labelItem = (Pane)mouseEvent.getSource();
            labelItem.setStyle(this.getFOCUSED_BACKGROUND());
        }
    };
    private final EventHandler<MouseEvent> exitedEventHandler = mouseEvent -> {
        if (!this.isWithSelection()) {
            Pane labelItem = (Pane)mouseEvent.getSource();
            labelItem.setStyle(this.NOT_FOCUSED_BACKGROUND);
        }
    };

    private Stage getStage() {
        return this.stage;
    }

    public MyContextMenu() {
        this(true, ClientSingleton.getInstance().getParentWindow());
    }

    public boolean isShowing() {
        return this.isShowing;
    }

    private MyContextMenu(boolean withSelection) {
        this.withSelection = withSelection;
        this.menuPane = this.getMenuPane();
        this.setMainBackground();
    }

    public void setExtraBackgroundColor(String extraBackgroundColor) {
        this.extraBackgroundColor = extraBackgroundColor;
    }

    private void setMainBackground() {
        String color = this.getBaseBackground();
        String style = "-fx-background-insets: 4 4 4 4; -fx-effect: dropshadow(three-pass-box, rgba(0, 0, 0, 0.23), 4, 0, 0, 0);-fx-background-color: %s;-fx-border-radius: 8 8 8 8;-fx-background-radius: 8 8 8 8;";
        this.mainPane.setStyle(Theme.getInstance().formatedString(style, color));
    }

    private String getBaseBackground() {
        if (this.extraBackgroundColor != null) {
            return this.extraBackgroundColor;
        }
        return Theme.getInstance().isDarkTheme() ? ClientSingleton.getInstance().getStyleValue(Theme.ThemeType.DARK, Constants.SECOND_BASE_COLOR) : "white";
    }

    public Pane getContextMenuMenuPane() {
        this.mainPane.setMaxHeight((double)this.maxHeight);
        return this.mainPane;
    }

    private MyContextMenu(boolean withSelection, Stage owner) {
        this.withSelection = withSelection;
        this.menuPane = this.getMenuPane();
        this.menuPane.setMinHeight(40.0);
        this.stage = new Stage();
        this.stage.initStyle(StageStyle.TRANSPARENT);
        Scene scene = new Scene((Parent)this.mainPane, 0.0, 0.0);
        scene.setFill((Paint)Color.TRANSPARENT);
        this.stage.setScene(scene);
        this.stage.setMinWidth(this.mainPane.minHeight(-1.0));
        this.stage.setMinHeight(this.mainPane.minHeight(-1.0));
        this.stage.initModality(Modality.NONE);
        this.stage.setMaxWidth(this.MAX_MENU_WIDTH);
        this.stage.setWidth(this.MAX_MENU_WIDTH);
        this.stage.initOwner((Window)owner);
        this.stage.widthProperty().addListener(this.stageWidthListener);
        this.stage.heightProperty().addListener(this.stageHeightListener);
        this.stage.focusedProperty().addListener(this.stageFocusListener);
        this.mainPane.focusedProperty().addListener(this.stageFocusListener);
        this.mainPane.minHeightProperty().bind((ObservableValue)this.stage.maxHeightProperty());
        this.mainPane.maxHeightProperty().bind((ObservableValue)this.stage.maxHeightProperty());
        this.mainPane.prefHeightProperty().bind((ObservableValue)this.stage.maxHeightProperty());
    }

    public static MyContextMenu getInstance() {
        return new MyContextMenu();
    }

    public static MyContextMenu getInstance(boolean withSelection, boolean isWithoutStage) {
        return new MyContextMenu(withSelection);
    }

    public static MyContextMenu getInstance(boolean withSelection, Stage owner) {
        return new MyContextMenu(withSelection, owner);
    }

    private boolean isWithoutStage() {
        return this.stage == null;
    }

    public void addItemsList(List<?> list, IMenuActionListener IMenuActionListener2, boolean withResize) {
        if (withResize) {
            for (Object item : list) {
                if (item.toString().isEmpty()) continue;
                Text text = new Text(item.toString());
                double width = text.getLayoutBounds().getWidth();
                this.MAX_MENU_WIDTH = Math.max(this.MAX_MENU_WIDTH, width);
            }
            this.MAX_MENU_WIDTH += 20.0;
            this.stage.setWidth(this.MAX_MENU_WIDTH);
            this.mainPane.setMinWidth(this.MAX_MENU_WIDTH);
        }
        for (Object item : list) {
            if (item.toString().isEmpty()) continue;
            this.addMenuItem(item, IMenuActionListener2);
        }
    }

    public void addIMenuActionListener(IMenuActionListener iMenuActionListener) {
        if (!this.iMenuActionListeners.contains(iMenuActionListener)) {
            this.iMenuActionListeners.add(iMenuActionListener);
        }
    }

    public void addMenuItem(Object title, EventHandler<MouseEvent> eventHandler) {
        this.addMenuItem(title, eventHandler, null, MyContextMenu.getColor());
    }

    public void addMenuItem(Object title, IMenuActionListener IMenuActionListener2) {
        this.addMenuItem(title, null, IMenuActionListener2, MyContextMenu.getColor());
    }

    public HBox addMenuItem(Object title, EventHandler<MouseEvent> eventHandler, IMenuActionListener iMenuActionListener_) {
        return this.addMenuItem(title, eventHandler, iMenuActionListener_, MyContextMenu.getColor());
    }

    private static String getColor() {
        return ClientSingleton.getInstance().getStyleValue(Constants.TABS_TITLE_TEXT_FILL);
    }

    public HBox addMenuItem(Object title, EventHandler<MouseEvent> eventHandler, IMenuActionListener iMenuActionListener_, String color) {
        this.addIMenuActionListener(iMenuActionListener_);
        this.NOT_FOCUSED_BACKGROUND = "-fx-background-color: transparent;-fx-text-fill:" + color + ";";
        HBox itemBox = new HBox();
        itemBox.setId(title.toString());
        itemBox.prefWidthProperty().bind((ObservableValue)this.myListView.widthProperty().subtract(10));
        itemBox.setMaxHeight(40.0);
        itemBox.setAlignment(Pos.CENTER);
        HBox.setHgrow((Node)itemBox, (Priority)Priority.ALWAYS);
        Label label = new Label(title.toString());
        label.setId(title.toString());
        label.setFont(Font.font((String)"Arial", (FontWeight)FontWeight.BOLD, (double)12.0));
        label.setStyle(this.NOT_FOCUSED_BACKGROUND);
        label.prefWidthProperty().bind((ObservableValue)itemBox.widthProperty());
        label.setPadding(new Insets(0.0, 0.0, 0.0, 16.0));
        label.setPrefHeight(40.0);
        if (this.isWithSelection()) {
            if (eventHandler == null && !this.iMenuActionListeners.isEmpty()) {
                eventHandler = mouseEvent -> {
                    Label labelItem = (Label)mouseEvent.getSource();
                    this.setSelectedItem(labelItem.getId());
                    labelItem.setStyle(this.getFOCUSED_BACKGROUND());
                    for (IMenuActionListener iMenuActionListener : this.iMenuActionListeners) {
                        if (iMenuActionListener instanceof IComboBoxActionListener) {
                            ((IComboBoxActionListener)iMenuActionListener).actionPerformed(this.elementId);
                            continue;
                        }
                        iMenuActionListener.actionPerformed(this.getSelectedItem());
                    }
                };
            }
            label.addEventFilter(MouseEvent.MOUSE_CLICKED, eventHandler);
        } else {
            if (eventHandler == null) {
                eventHandler = mouseEvent -> {
                    for (IMenuActionListener iMenuActionListener : this.iMenuActionListeners) {
                        if (iMenuActionListener instanceof IComboBoxActionListener) {
                            ((IComboBoxActionListener)iMenuActionListener).actionPerformed(this.elementId);
                            continue;
                        }
                        iMenuActionListener.actionPerformed(this.getSelectedItem());
                    }
                };
            }
            label.addEventFilter(MouseEvent.MOUSE_CLICKED, eventHandler);
            itemBox.addEventFilter(MouseEvent.MOUSE_ENTERED, this.enteredEventHandler);
            itemBox.addEventFilter(MouseEvent.MOUSE_EXITED, this.exitedEventHandler);
        }
        this.eventMap.put(title.toString(), (EventHandler<MouseEvent>)eventHandler);
        ClientSingleton.getInstance().setMouseCursor((Node)label);
        itemBox.getChildren().add((Object)label);
        this.myListView.add((Pane)itemBox);
        this.maxHeight = Math.min(this.myListView.getContentSize() * 40 + 2, 350) + 40;
        this.items.add(title);
        return itemBox;
    }

    public void removeMenuItem(Object title) {
        for (int i = this.menuPane.getChildren().size() - 1; i >= 0; --i) {
            Pane item = (Pane)this.menuPane.getChildren().get(i);
            if (!item.getId().equals(title.toString())) continue;
            this.menuPane.getChildren().remove(i);
            break;
        }
    }

    public void setMenuItemTitle(Object oldTitle, Object newTitle) {
        HBox hBox;
        String title = "";
        Optional<Node> item = this.menuPane.getChildren().stream().filter(pane -> pane.getId().equals(oldTitle.toString())).findAny();
        if (!item.isPresent()) {
            item = this.menuPane.getChildren().stream().filter(pane -> pane.getId().equals(newTitle.toString())).findAny();
            if (item.isPresent()) {
                title = oldTitle.toString();
            }
        } else {
            title = newTitle.toString();
        }
        if (!title.isEmpty() && !(hBox = (HBox)item.get()).getChildren().isEmpty() && hBox.getChildren().get(0) instanceof Label) {
            Label label = (Label)hBox.getChildren().get(0);
            label.setText(newTitle.toString());
        }
    }

    public void removeScrollBar() {
        this.myListView.removeScrollBar();
    }

    public void addIfAbsentMenuItem(Object title, EventHandler<MouseEvent> eventHandler, IMenuActionListener iMenuActionListener_) {
        if (this.menuPane.getChildren().stream().noneMatch(item -> item.getId().equals(title.toString()))) {
            this.addMenuItem(title, eventHandler, iMenuActionListener_, MyContextMenu.getColor());
        }
    }

    public void addIfAbsentMenuItem(int index, HBox menuItem) {
        if (this.menuPane.getChildren().stream().noneMatch(item -> item.getId().equals(menuItem.getId()))) {
            this.menuPane.getChildren().add(index, (Object)menuItem);
            this.maxHeight = Math.min(this.menuPane.getChildren().size() * 40 + 2, 350) + 40;
        }
    }

    public void removeIfPresentMenuItem(HBox menuItem) {
        for (int i = this.menuPane.getChildren().size() - 1; i >= 0; --i) {
            if (!((Node)this.menuPane.getChildren().get(i)).getId().equals(menuItem.getId())) continue;
            this.menuPane.getChildren().remove(i);
            this.maxHeight = Math.min(this.menuPane.getChildren().size() * 40 + 2, 350) + 40;
            return;
        }
    }

    public void clear() {
        this.myListView.clear();
        this.onRelease();
    }

    public void setWithSelection(boolean withSelection) {
        this.withSelection = withSelection;
    }

    private boolean isWithSelection() {
        return this.withSelection;
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public Object getSelectedItem() {
        if (this.selectedIndex >= 0 && this.selectedIndex < this.items.size()) {
            return this.items.get(this.selectedIndex);
        }
        return "";
    }

    public void setSelectedItem(Object title) {
        for (int i = 0; i < this.menuPane.getChildren().size(); ++i) {
            Node item = (Node)this.menuPane.getChildren().get(i);
            HBox hBox = (HBox)item;
            Label label = (Label)hBox.getChildren().get(0);
            if (label.getId().equals(title.toString())) {
                this.selectedIndex = i;
                label.setStyle(this.getFOCUSED_BACKGROUND());
                continue;
            }
            label.setStyle(this.NOT_FOCUSED_BACKGROUND);
        }
    }

    private String getFOCUSED_BACKGROUND() {
        String color1 = ClientSingleton.getInstance().getStyleValue(Theme.getInstance().getTheme(), Constants.TABS_TITLE_TEXT_FILL);
        String color2 = Theme.getInstance().isDarkTheme() ? "#595959" : "#d9e0ef";
        return Theme.getInstance().formatedString("-fx-background-color: %s;-fx-text-fill: %s;", color2, color1);
    }

    public void show(Node node) {
        Rectangle2D primaryScreenBounds = ClientSingleton.getInstance().getCurrentScreenBounds();
        double width = primaryScreenBounds.getWidth() - primaryScreenBounds.getMinX();
        double height = primaryScreenBounds.getHeight() - primaryScreenBounds.getMinY();
        Bounds boundsInScreen = node.localToScreen(node.getBoundsInLocal());
        double y = boundsInScreen.getMinY() + boundsInScreen.getHeight();
        double x = ClientSingleton.getInstance().getLastBounds().getMinX();
        boolean isUpStyle = boundsInScreen.getMinY() + boundsInScreen.getHeight() + (double)this.maxHeight > height;
        boolean isLeftStyle = boundsInScreen.getMinX() + this.MAX_MENU_WIDTH > ClientSingleton.getInstance().getLastBounds().getMaxX();
        Object baseStyle = "-fx-background-insets: 4 4 4 4; -fx-effect: dropshadow(three-pass-box, rgba(0, 0, 0, 0.23), 4, 0, 0, 0);-fx-background-color: %s;";
        if (isUpStyle) {
            boolean rounded = false;
            y = boundsInScreen.getMinY() - (double)this.maxHeight;
            if (y < primaryScreenBounds.getMinY()) {
                y = primaryScreenBounds.getMinY() + 10.0;
                rounded = true;
            }
            if (isLeftStyle) {
                x = boundsInScreen.getMinX() + boundsInScreen.getWidth() - this.MAX_MENU_WIDTH;
                baseStyle = (String)baseStyle + "-fx-border-radius: 8 8 " + (rounded ? 8 : 0) + " 8;-fx-background-radius: 8 8 " + (rounded ? 8 : 0) + " 8;";
            } else {
                x = boundsInScreen.getMinX();
                baseStyle = (String)baseStyle + "-fx-border-radius: 8 8 8 " + (rounded ? 8 : 0) + ";-fx-background-radius: 8 8 8 " + (rounded ? 8 : 0) + ";";
            }
        } else if (isLeftStyle) {
            x = boundsInScreen.getMinX() + boundsInScreen.getWidth() - this.MAX_MENU_WIDTH;
            baseStyle = (String)baseStyle + "-fx-border-radius: 8 0 8 8;-fx-background-radius: 8 0 8 8;";
        } else {
            x = boundsInScreen.getMinX();
            baseStyle = (String)baseStyle + "-fx-border-radius: 0 8 8 8;-fx-background-radius: 0 8 8 8;";
        }
        String background = Theme.getInstance().formatedString((String)baseStyle, this.getBaseBackground());
        this.mainPane.setStyle(background);
        this.stage.setHeight((double)this.maxHeight);
        this.stage.setAlwaysOnTop(true);
        this.stage.setX(x);
        this.stage.setY(y);
        ClientSingleton.getInstance().addToOpenedMenusList(this);
        this.mainPane.requestFocus();
        ClientSingleton.toLog(this.getClass().toString(), "show isLeftStyle=" + isLeftStyle + " isUpStyle=" + isUpStyle + " getHeight=" + this.stage.getHeight());
        this.isShowing = true;
        this.stage.show();
    }

    public void show(double x, double y) {
        if (this.items.isEmpty()) {
            return;
        }
        this.setMainBackground();
        this.stage.setHeight((double)this.maxHeight);
        this.stage.setAlwaysOnTop(true);
        this.stage.setX(x);
        this.stage.setY(y);
        ClientSingleton.getInstance().addToOpenedMenusList(this);
        this.isShowing = true;
        this.mainPane.requestLayout();
        this.stage.show();
    }

    public void hide() {
        this.stage.hide();
        this.isShowing = false;
        this.stage.setAlwaysOnTop(false);
        ClientSingleton.getInstance().getParentWindow().requestFocus();
        for (IMenuActionListener iMenuActionListener : this.iMenuActionListeners) {
            if (iMenuActionListener == null) continue;
            iMenuActionListener.dropDownHided();
        }
        TimerExecutor.getInstance().setMyAction(() -> ClientSingleton.getInstance().removeFromOpenedMenusList(this)).startWithDelay(100L);
    }

    private VBox getMenuPane() {
        this.mainPane = new VBox();
        this.mainPane.setPadding(new Insets(20.0, 0.0, 20.0, 4.0));
        this.mainPane.setSpacing(2.0);
        VBox vBox = new VBox();
        vBox.setSpacing(2.0);
        this.myListView = new MyListView();
        this.myListView.prefWidthProperty().bind((ObservableValue)this.mainPane.widthProperty());
        this.myListView.minWidthProperty().bind((ObservableValue)this.mainPane.minWidthProperty());
        this.myListView.maxWidthProperty().bind((ObservableValue)this.mainPane.maxWidthProperty());
        this.myListView.prefHeightProperty().bind((ObservableValue)this.mainPane.heightProperty().subtract(30));
        this.myListView.maxHeightProperty().bind((ObservableValue)this.mainPane.maxHeightProperty().subtract(30));
        this.myListView.minHeightProperty().bind((ObservableValue)this.mainPane.minHeightProperty().subtract(30));
        this.mainPane.getChildren().add((Object)this.myListView);
        this.myListView.setWithMouseDrag();
        this.myListView.setId(this.getClass().getSimpleName());
        this.myListView.setContent(vBox, null);
        vBox.prefWidthProperty().bind((ObservableValue)this.myListView.widthProperty());
        vBox.maxWidthProperty().bind((ObservableValue)this.myListView.maxWidthProperty());
        this.mainPane.setMaxWidth(this.MAX_MENU_WIDTH);
        this.mainPane.setMinWidth(this.MAX_MENU_WIDTH);
        this.mainPane.setPrefWidth(this.MAX_MENU_WIDTH);
        this.mainPane.setMinHeight(40.0);
        return vBox;
    }

    public void addTitlePane(Pane pane) {
        this.mainPane.getChildren().add(0, (Object)pane);
    }

    @Override
    public void onRelease() {
        this.items.clear();
        this.stage.widthProperty().removeListener(this.stageWidthListener);
        this.stage.heightProperty().removeListener(this.stageHeightListener);
        this.stage.focusedProperty().removeListener(this.stageFocusListener);
        this.menuPane.focusedProperty().removeListener(this.stageFocusListener);
        for (int i = 0; i < this.menuPane.getChildren().size(); ++i) {
            Node item = (Node)this.menuPane.getChildren().get(i);
            HBox hBox = (HBox)item;
            hBox.prefWidthProperty().unbind();
            Label label = (Label)hBox.getChildren().get(0);
            label.removeEventHandler(MouseEvent.MOUSE_ENTERED, this.enteredEventHandler);
            label.removeEventHandler(MouseEvent.MOUSE_EXITED, this.exitedEventHandler);
            label.prefWidthProperty().unbind();
            if (label.getId() == null || this.eventMap.get(label.getId()) == null) continue;
            label.addEventFilter(MouseEvent.MOUSE_CLICKED, this.eventMap.get(label.getId()));
        }
        this.eventMap.clear();
        this.menuPane.getChildren().clear();
        if (this.iMenuActionListeners == null) {
            this.iMenuActionListeners.clear();
            this.iMenuActionListeners = null;
        }
    }

    public void setWidth(int width) {
        this.MAX_MENU_WIDTH = width;
        this.stage.setWidth((double)width);
        this.stage.setMinWidth((double)width);
        this.mainPane.setMaxWidth((double)width);
        this.mainPane.setMinWidth((double)width);
        this.mainPane.setPrefWidth((double)width);
    }

    public void setElementId(String elementId) {
        this.elementId = elementId;
    }

    public String getElementId() {
        return this.elementId;
    }

    public void get() {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "Menu items : " + this.menuPane.getChildren().size() + " maxHeight = " + this.maxHeight);
    }
}

