/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.imageview;

import java.util.Optional;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ChangeListener;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundImage;
import javafx.scene.layout.BackgroundPosition;
import javafx.scene.layout.BackgroundRepeat;
import javafx.scene.layout.BackgroundSize;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.utils.viewers.IActionOnRelease;

public class MyBackgroundImageView
extends HBox
implements IActionOnRelease {
    private final SimpleIntegerProperty buttonWidth = new SimpleIntegerProperty((Object)10, "buttonWidth");
    private final SimpleIntegerProperty buttonHeight = new SimpleIntegerProperty((Object)10, "buttonHeight");
    private final SimpleStringProperty backgroundColor = new SimpleStringProperty((Object)"transparent", "backgroundColor");
    private final SimpleObjectProperty<Image> image = new SimpleObjectProperty(null, "setImage");
    private final Pane button = new Pane();
    private ChangeListener<Image> imageListener = (observable, oldValue, newValue) -> {
        BackgroundImage backgroundImage = new BackgroundImage((Image)this.image.get(), BackgroundRepeat.NO_REPEAT, BackgroundRepeat.NO_REPEAT, BackgroundPosition.CENTER, BackgroundSize.DEFAULT);
        Background background = new Background(new BackgroundImage[]{backgroundImage});
        this.button.setBackground(background);
    };
    private ChangeListener<String> colorListener = (observable, oldValue, newValue) -> {
        String baseStyle = "-fx-background-color: " + this.getBackgroundColor() + ";-fx-background-insets: 0 0 0 0;";
    };
    private ChangeListener<Number> widthListener = (observable, oldValue, newValue) -> {
        if (newValue.doubleValue() > 0.0) {
            this.setMinWidth(newValue.doubleValue());
            this.setMaxWidth(newValue.doubleValue());
        }
    };
    private ChangeListener<Number> heightListener = (observable, oldValue, newValue) -> {
        if (newValue.doubleValue() > 0.0) {
            this.setMinHeight(newValue.doubleValue());
            this.setMaxHeight(newValue.doubleValue());
        }
    };

    public MyBackgroundImageView() {
        this(10, 10);
    }

    public void setSize(int width, int height) {
        this.setButtonWidth(width);
        this.setButtonHeight(height);
    }

    private MyBackgroundImageView(int width, int height) {
        this.initPropertiesControls();
        HBox.setHgrow((Node)this.button, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)this.button, (Priority)Priority.ALWAYS);
        this.getChildren().add((Object)this.button);
        this.setStyle("-fx-background-color: transparent;");
        this.setSize(width, height);
        this.setPickOnBounds(true);
    }

    public static MyBackgroundImageView getInstance(int width, int height) {
        return new MyBackgroundImageView(width, height);
    }

    private void initPropertiesControls() {
        this.image.addListener(this.imageListener);
        this.backgroundColor.addListener(this.colorListener);
        this.buttonWidth.addListener(this.widthListener);
        this.buttonHeight.addListener(this.heightListener);
    }

    @Override
    public void onRelease() {
        this.image.removeListener(this.imageListener);
        this.backgroundColor.removeListener(this.colorListener);
        this.buttonWidth.removeListener(this.widthListener);
        this.buttonHeight.removeListener(this.heightListener);
        this.imageListener = null;
        this.colorListener = null;
        this.widthListener = null;
        this.heightListener = null;
    }

    public int getButtonWidth() {
        return this.buttonWidth.get();
    }

    public SimpleIntegerProperty buttonWidthProperty() {
        return this.buttonWidth;
    }

    public void setButtonWidth(int buttonWidth) {
        this.buttonWidth.set(buttonWidth);
    }

    public int getButtonHeight() {
        return this.buttonHeight.get();
    }

    public SimpleIntegerProperty buttonHeightProperty() {
        return this.buttonHeight;
    }

    public void setButtonHeight(int buttonHeight) {
        this.buttonHeight.set(buttonHeight);
    }

    public String getBackgroundColor() {
        return this.backgroundColor.get();
    }

    public SimpleStringProperty backgroundColorProperty() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor.set(backgroundColor);
    }

    public Image getImage() {
        return (Image)this.image.get();
    }

    public SimpleObjectProperty<Image> imageProperty() {
        return this.image;
    }

    public void setImage(Image image) {
        this.image.set((Object)image);
    }

    public void setImage(String imagePath) {
        Optional<Image> optionalImage = ClientSingleton.getInstance().getImageFromResources(imagePath);
        optionalImage.ifPresent(arg_0 -> this.image.set(arg_0));
    }
}

