/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.imageview;

import java.util.Optional;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import net.sipsnet.client.connector.ClientSingleton;

public class MyImageView
extends ImageView {
    public MyImageView(int width, int height) {
        this(null, width, height);
    }

    private MyImageView(String imagePath, int width, int height) {
        this.setStyle("-fx-background-color: transparent;");
        this.setFitWidth(width);
        this.setFitHeight(height);
        this.setPreserveRatio(true);
        this.setPickOnBounds(true);
        if (imagePath != null) {
            Optional<Image> optionalImage = ClientSingleton.getInstance().getImageFromResources(imagePath);
            optionalImage.ifPresent(arg_0 -> ((MyImageView)this).setImage(arg_0));
        }
    }

    public void setImage(String imagePath) {
        this.setImage(imagePath, false);
    }

    public void setImage(String imagePath, boolean resize) {
        ClientSingleton.getInstance().setImageToImageView(this, imagePath);
    }

    public static MyImageView getInstance(String imagePath, int width, int height) {
        return new MyImageView(imagePath, width, height);
    }

    public void clearImage() {
        super.setImage(null);
    }
}

