/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.mylistview.internal;

import javafx.scene.input.MouseEvent;

public final class VelocityTracker {
    private static final boolean DEBUG = false;
    private static final boolean localLOGV = false;
    private static final int NUM_PAST = 10;
    private static final int MAX_AGE_MILLISECONDS = 200;
    private static final int POINTER_POOL_CAPACITY = 20;
    private static Pointer sRecycledPointerListHead;
    private static int sRecycledPointerCount;
    private Pointer mPointerListHead;
    private int mLastTouchIndex;

    public VelocityTracker() {
        this.clear();
    }

    public void clear() {
        VelocityTracker.releasePointerList(this.mPointerListHead);
        this.mPointerListHead = null;
        this.mLastTouchIndex = 0;
    }

    public void addMovement(MouseEvent ev) {
        int finalTouchIndex;
        boolean historySize = false;
        int lastTouchIndex = this.mLastTouchIndex;
        int nextTouchIndex = (lastTouchIndex + 1) % 10;
        this.mLastTouchIndex = finalTouchIndex = (nextTouchIndex + 0) % 10;
        if (this.mPointerListHead == null) {
            this.mPointerListHead = VelocityTracker.obtainPointer();
        }
        float[] pastX = this.mPointerListHead.pastX;
        float[] pastY = this.mPointerListHead.pastY;
        long[] pastTime = this.mPointerListHead.pastTime;
        pastX[finalTouchIndex] = (float)ev.getX();
        pastY[finalTouchIndex] = (float)ev.getY();
        pastTime[finalTouchIndex] = System.currentTimeMillis();
    }

    public void computeCurrentVelocity(int units) {
        this.computeCurrentVelocity(units, Float.MAX_VALUE);
    }

    public void computeCurrentVelocity(int units, float maxVelocity) {
        int lastTouchIndex = this.mLastTouchIndex;
        Pointer pointer = this.mPointerListHead;
        while (pointer != null) {
            int nextOldestTouchIndex;
            long nextOldestTime;
            int numTouches;
            long[] pastTime = pointer.pastTime;
            int oldestTouchIndex = lastTouchIndex;
            long minTime = pastTime[lastTouchIndex] - 200L;
            for (numTouches = 1; numTouches < 10 && (nextOldestTime = pastTime[nextOldestTouchIndex = (oldestTouchIndex + 10 - 1) % 10]) >= minTime; ++numTouches) {
                oldestTouchIndex = nextOldestTouchIndex;
            }
            if (numTouches > 3) {
                --numTouches;
            }
            float[] pastX = pointer.pastX;
            float[] pastY = pointer.pastY;
            float oldestX = pastX[oldestTouchIndex];
            float oldestY = pastY[oldestTouchIndex];
            long oldestTime = pastTime[oldestTouchIndex];
            float accumX = 0.0f;
            float accumY = 0.0f;
            for (int i = 1; i < numTouches; ++i) {
                int touchIndex = (oldestTouchIndex + i) % 10;
                int duration = (int)(pastTime[touchIndex] - oldestTime);
                if (duration == 0) continue;
                float delta = pastX[touchIndex] - oldestX;
                float velocity = delta / (float)duration * (float)units;
                accumX = accumX == 0.0f ? velocity : (accumX + velocity) * 0.5f;
                delta = pastY[touchIndex] - oldestY;
                velocity = delta / (float)duration * (float)units;
                accumY = accumY == 0.0f ? velocity : (accumY + velocity) * 0.5f;
            }
            if (accumX < -maxVelocity) {
                accumX = -maxVelocity;
            } else if (accumX > maxVelocity) {
                accumX = maxVelocity;
            }
            if (accumY < -maxVelocity) {
                accumY = -maxVelocity;
            } else if (accumY > maxVelocity) {
                accumY = maxVelocity;
            }
            pointer.xVelocity = accumX;
            pointer.yVelocity = accumY;
            pointer = pointer.next;
        }
    }

    public float getXVelocity() {
        Pointer pointer = this.getPointer(0);
        return pointer != null ? pointer.xVelocity : 0.0f;
    }

    public float getYVelocity() {
        Pointer pointer = this.getPointer(0);
        return pointer != null ? pointer.yVelocity : 0.0f;
    }

    public float getXVelocity(int id) {
        Pointer pointer = this.getPointer(id);
        return pointer != null ? pointer.xVelocity : 0.0f;
    }

    public float getYVelocity(int id) {
        Pointer pointer = this.getPointer(id);
        return pointer != null ? pointer.yVelocity : 0.0f;
    }

    private final Pointer getPointer(int id) {
        Pointer pointer = this.mPointerListHead;
        while (pointer != null) {
            if (pointer.id == id) {
                return pointer;
            }
            pointer = pointer.next;
        }
        return null;
    }

    private static final Pointer obtainPointer() {
        if (sRecycledPointerCount != 0) {
            Pointer element = sRecycledPointerListHead;
            --sRecycledPointerCount;
            sRecycledPointerListHead = element.next;
            element.next = null;
            return element;
        }
        return new Pointer();
    }

    private static final void releasePointer(Pointer pointer) {
        if (sRecycledPointerCount < 20) {
            pointer.next = sRecycledPointerListHead;
            ++sRecycledPointerCount;
            sRecycledPointerListHead = pointer;
        }
    }

    private static final void releasePointerList(Pointer pointer) {
        if (pointer != null) {
            Pointer next;
            int count = sRecycledPointerCount;
            if (count >= 20) {
                return;
            }
            Pointer tail = pointer;
            while (++count < 20 && (next = tail.next) != null) {
                tail = next;
            }
            tail.next = sRecycledPointerListHead;
            sRecycledPointerCount = count;
            sRecycledPointerListHead = pointer;
        }
    }

    private static final class Pointer {
        public Pointer next;
        public int id;
        public float xVelocity;
        public float yVelocity;
        public final float[] pastX = new float[10];
        public final float[] pastY = new float[10];
        public final long[] pastTime = new long[10];

        private Pointer() {
        }
    }
}

