/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.phonesmenu;

import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.utils.popupstage.MyPopupWindow;
import net.sipsnet.client.utils.viewers.buttons.labelbutton.MyLabelButton;

public class MyPhonesMenu
extends BorderPane {
    private final MyPopupWindow myPopupWindow;
    private final VBox header;
    private String title = ClientSingleton.getInstance().getString("action_call_to_action");
    private final int HEADER_HEIGHT = 40;
    private final int PANE_WIDTH = 300;
    private final VBox buttonsPane = new VBox();
    private Label lbContactTitle;
    private Pane headerContent;

    private MyPhonesMenu() {
        this.myPopupWindow = MyPopupWindow.getNewInstance((Pane)this).setWindowModality();
        this.buttonsPane.setPadding(new Insets(5.0, 10.0, 10.0, 10.0));
        VBox.setVgrow((Node)this.buttonsPane, (Priority)Priority.ALWAYS);
        this.header = this.getHeader();
        this.buttonsPane.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        this.header.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        this.header.setPadding(new Insets(10.0, 0.0, 0.0, 0.0));
        this.setTop((Node)this.header);
        this.setCenter((Node)this.buttonsPane);
        this.setMaxWidth(310.0);
        this.setPrefWidth(310.0);
    }

    public static MyPhonesMenu getInstance() {
        return new MyPhonesMenu();
    }

    public MyPhonesMenu setTitle(String title) {
        this.title = title;
        return this;
    }

    public MyPhonesMenu setHeaderContent(Pane headerContent) {
        HBox hBox = new HBox();
        hBox.getChildren().add((Object)headerContent);
        hBox.setPadding(new Insets(5.0, 10.0, 10.0, 25.0));
        this.header.getChildren().add((Object)hBox);
        this.header.prefWidthProperty().bind((ObservableValue)this.buttonsPane.widthProperty());
        return this;
    }

    public String showAndWait(List<String> numbers) {
        AtomicReference atomicReference = new AtomicReference();
        this.lbContactTitle.setText(this.title);
        for (String number : numbers) {
            AnchorPane buttonPane = this.addButton(number, (EventHandler<MouseEvent>)((EventHandler)event -> {
                atomicReference.set(number);
                this.myPopupWindow.hide();
            }));
            buttonPane.prefWidthProperty().bind((ObservableValue)this.buttonsPane.widthProperty());
            this.buttonsPane.getChildren().add((Object)buttonPane);
        }
        HBox buttonPane = new HBox();
        MyLabelButton myLabelButton = new MyLabelButton(ClientSingleton.getInstance().getString("cancel"), 30);
        myLabelButton.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.myPopupWindow.hide()));
        buttonPane.getChildren().add((Object)myLabelButton);
        buttonPane.setPadding(new Insets(5.0, 15.0, 0.0, 5.0));
        buttonPane.setAlignment(Pos.CENTER_RIGHT);
        buttonPane.prefWidthProperty().bind((ObservableValue)this.buttonsPane.widthProperty());
        this.buttonsPane.getChildren().add((Object)buttonPane);
        this.setMinHeight((numbers.size() + (this.header.getChildren().size() == 1 ? 2 : 3)) * 40);
        this.setMaxHeight((numbers.size() + (this.header.getChildren().size() == 1 ? 2 : 3)) * 40);
        this.myPopupWindow.showAndWait();
        return (String)atomicReference.get();
    }

    private VBox getHeader() {
        VBox vBox = new VBox();
        vBox.prefWidthProperty().bind((ObservableValue)this.widthProperty().subtract(20));
        HBox hBox = new HBox();
        HBox.setHgrow((Node)hBox, (Priority)Priority.ALWAYS);
        hBox.setMinHeight(35.0);
        hBox.setMaxHeight(35.0);
        hBox.setAlignment(Pos.CENTER_LEFT);
        HBox hbAvatarBox = new HBox();
        hbAvatarBox.prefHeightProperty().bind((ObservableValue)hBox.prefHeightProperty());
        hbAvatarBox.setMinHeight(40.0);
        hbAvatarBox.prefHeight(40.0);
        hbAvatarBox.setFillHeight(true);
        hbAvatarBox.setAlignment(Pos.CENTER);
        ImageView ivAvatar = new ImageView();
        ClientSingleton.getInstance().setImageToImageView(ivAvatar, "notify_emblem.png");
        hbAvatarBox.getChildren().add((Object)ivAvatar);
        HBox.setMargin((Node)hbAvatarBox, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
        hBox.getChildren().add((Object)hbAvatarBox);
        this.lbContactTitle = new Label();
        HBox.setMargin((Node)this.lbContactTitle, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
        this.lbContactTitle.setStyle("-fx-text-fill: #656a7c;     -fx-font-family: \"HelveticaNeue\";     -fx-font-weight: bold;     -fx-font-size: 13pt;     -fx-background-color: transparent;");
        HBox.setHgrow((Node)this.lbContactTitle, (Priority)Priority.ALWAYS);
        this.lbContactTitle.prefHeightProperty().bind((ObservableValue)hBox.prefHeightProperty());
        hBox.getChildren().add((Object)this.lbContactTitle);
        vBox.getChildren().add((Object)hBox);
        ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "headerContent = " + this.headerContent);
        return vBox;
    }

    private AnchorPane addButton(String buttonTitle, EventHandler<MouseEvent> event) {
        AnchorPane anchorPane = new AnchorPane();
        MyLabelButton myLabelButton = new MyLabelButton(buttonTitle, 30);
        myLabelButton.addMouseEventHandler(event);
        anchorPane.getChildren().add((Object)myLabelButton);
        AnchorPane.setLeftAnchor((Node)myLabelButton, (Double)15.0);
        AnchorPane.setTopAnchor((Node)myLabelButton, (Double)5.0);
        AnchorPane.setRightAnchor((Node)myLabelButton, (Double)15.0);
        AnchorPane.setBottomAnchor((Node)myLabelButton, (Double)5.0);
        return anchorPane;
    }
}

