/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.richtext;

import java.util.function.IntFunction;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import net.sipsnet.client.utils.viewers.richtext.Indent;
import net.sipsnet.client.utils.viewers.richtext.MyStyledTextArea;
import net.sipsnet.client.utils.viewers.richtext.ParStyle;

public class BulletFactory
implements IntFunction<Node> {
    private final MyStyledTextArea area;
    private static final Font DEFAULT_FONT = Font.font((String)"monospace", (FontPosture)FontPosture.ITALIC, (double)13.0);

    public BulletFactory(MyStyledTextArea area) {
        area.getParagraphs().sizeProperty().addListener((ob, ov, nv) -> {
            if (nv <= ov) {
                Platform.runLater(() -> {
                    try {
                        this.deleteParagraphCheck();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            } else {
                Platform.runLater(() -> {
                    try {
                        this.insertParagraphCheck();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
        });
        this.area = area;
    }

    @Override
    public Node apply(int value) {
        ParStyle ps = (ParStyle)this.area.getParagraph(value).getParagraphStyle();
        return this.createGraphic(ps, value);
    }

    private Node createGraphic(ParStyle ps, int idx) {
        Label foldIndicator = new Label("  ");
        VBox.setVgrow((Node)foldIndicator, (Priority)Priority.ALWAYS);
        foldIndicator.setMaxHeight(Double.MAX_VALUE);
        foldIndicator.setAlignment(Pos.TOP_LEFT);
        foldIndicator.setFont(DEFAULT_FONT);
        if (this.area.getParagraphs().size() > idx + 1 && ((ParStyle)this.area.getParagraph(idx + 1).getParagraphStyle()).isFolded() && !ps.isFolded()) {
            foldIndicator.setOnMouseClicked(ME -> this.area.unfoldParagraphs(idx));
            foldIndicator.getStyleClass().add((Object)"fold-indicator");
            foldIndicator.setCursor(Cursor.HAND);
            foldIndicator.setText("+ ");
        }
        if (ps.isIndented() && !ps.isFolded()) {
            foldIndicator.setGraphic(this.createBullet(ps.getIndent()));
            foldIndicator.setContentDisplay(ContentDisplay.RIGHT);
        }
        return new VBox(0.0, new Node[]{foldIndicator});
    }

    private Node createBullet(Indent in) {
        Circle result;
        switch (in.level) {
            case 1: {
                Circle c = new Circle(2.5);
                c.setFill((Paint)Color.BLACK);
                c.setStroke((Paint)Color.BLACK);
                result = c;
                break;
            }
            case 2: {
                Circle c = new Circle(2.5);
                c.setFill((Paint)Color.WHITE);
                c.setStroke((Paint)Color.BLACK);
                result = c;
                break;
            }
            case 3: {
                Rectangle r = new Rectangle(5.0, 5.0);
                r.setFill((Paint)Color.BLACK);
                r.setStroke((Paint)Color.BLACK);
                result = r;
                break;
            }
            default: {
                Rectangle r = new Rectangle(5.0, 5.0);
                r.setFill((Paint)Color.WHITE);
                r.setStroke((Paint)Color.BLACK);
                result = r;
            }
        }
        Label bullet = new Label(" ", (Node)result);
        bullet.setPadding(new Insets(0.0, 0.0, 0.0, (double)in.level * in.width));
        bullet.setContentDisplay(ContentDisplay.LEFT);
        return bullet;
    }

    private void deleteParagraphCheck() throws Exception {
        int p = this.area.getCurrentParagraph();
        if (p >= this.area.firstVisibleParToAllParIndex() && p <= this.area.lastVisibleParToAllParIndex()) {
            int col = this.area.getCaretColumn();
            if (col == 0) {
                if (((ParStyle)this.area.getParagraph(p).getParagraphStyle()).isFolded()) {
                    p = Math.max(p - 1, 0);
                    this.area.recreateParagraphGraphic(p);
                    this.area.moveTo(p, 0);
                }
            } else if (col == this.area.getParagraph(p).length()) {
                this.area.recreateParagraphGraphic(p);
            }
        }
    }

    private void insertParagraphCheck() throws Exception {
        int p = this.area.getCurrentParagraph();
        if (p > this.area.firstVisibleParToAllParIndex() && p <= this.area.lastVisibleParToAllParIndex() && p > 0 && p + 1 < this.area.getParagraphs().size() && ((ParStyle)this.area.getParagraph(p + 1).getParagraphStyle()).isFolded()) {
            this.area.recreateParagraphGraphic(p - 1);
        }
    }
}

