/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.richtext;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.utils.viewers.richtext.LinkedImage;
import smile.cti.client.ContactInfo;
import smile.cti.client.SessionInfo;

public class MentionLinkedText
implements LinkedImage {
    private final String text;
    private final int radius = 7;
    private final String selectedStyle = "-fx-border-radius: 7 7 7 7; -fx-background-radius: 7 7 7 7; -fx-background-color:#878991;";
    private ContactInfo contactInfo;
    private HBox myLabel;

    public MentionLinkedText(String text) {
        this.text = text;
    }

    public MentionLinkedText(ContactInfo contactInfo) {
        this.contactInfo = contactInfo;
        this.text = "@" + contactInfo.toString();
    }

    public ContactInfo getContactInfo() {
        return this.contactInfo;
    }

    public String toString() {
        return this.text;
    }

    @Override
    public boolean isReal() {
        return true;
    }

    @Override
    public String getImagePath() {
        return "";
    }

    @Override
    public Node createNode() {
        if (this.myLabel == null) {
            this.myLabel = new HBox();
            this.myLabel.setAlignment(Pos.CENTER);
            this.myLabel.setPadding(new Insets(0.0, 10.0, 0.0, 10.0));
            this.myLabel.setMinHeight(18.0);
            Label label = new Label(this.text);
            label.setFont(Font.font((String)"Roboto", (FontWeight)FontWeight.NORMAL, (double)12.0));
            label.setTextFill((Paint)Color.WHITE);
            label.prefHeightProperty().bind((ObservableValue)this.myLabel.heightProperty());
            this.myLabel.getChildren().add((Object)label);
            this.myLabel.setStyle("-fx-border-radius: 7 7 7 7; -fx-background-radius: 7 7 7 7; -fx-background-color:#878991;");
        }
        return this.myLabel;
    }

    public String getText() {
        return this.text;
    }

    public static Map<Integer, ContactInfo> getMentions(String content) {
        HashMap<Integer, ContactInfo> map = new HashMap<Integer, ContactInfo>();
        if (!content.contains("@")) {
            return map;
        }
        SessionInfo sessionInfo = ClientSingleton.getInstance().getCurrentSessionInfo();
        if (!sessionInfo.isGroup()) {
            return map;
        }
        ArrayList<ContactInfo> parties = new ArrayList<ContactInfo>(sessionInfo.getParties());
        parties.add(ClientSingleton.getInstance().getUserInfo());
        ((Stream)parties.stream().parallel()).filter(member -> content.contains(member.toString())).forEach(member -> {
            String mention = "@" + member;
            int mentionLen = 0;
            int index = 0;
            while (index != -1) {
                if ((index = content.indexOf(mention, index + mentionLen)) != -1) {
                    map.put(index, (ContactInfo)member);
                }
                mentionLen = mention.length();
            }
        });
        return map;
    }

    public static String removeMentions(Map<Integer, String> map) {
        return null;
    }
}

