/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.richtext;

import java.io.File;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.IntStream;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.IndexRange;
import javafx.scene.control.MenuItem;
import javafx.scene.input.Clipboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.HBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import net.sipsnet.client.click2dial.GetSelectedText;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.connector.utils.ClientUtil;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.MyUtils;
import net.sipsnet.client.utils.StyledWord;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.viewers.richtext.BulletFactory;
import net.sipsnet.client.utils.viewers.richtext.LinkedImage;
import net.sipsnet.client.utils.viewers.richtext.LinkedImageOps;
import net.sipsnet.client.utils.viewers.richtext.MentionLinkedText;
import net.sipsnet.client.utils.viewers.richtext.ParStyle;
import net.sipsnet.client.utils.viewers.richtext.RealLinkedImage;
import net.sipsnet.client.utils.viewers.richtext.TextStyle;
import net.sipsnet.client.views.chat.messagepane.IChatInputTextArea;
import net.sipsnet.client.views.chat.messagepane.IInnerMessageTextArea;
import net.sipsnet.client.views.emoji.utils.EmojiClass;
import net.sipsnet.client.views.emoji.utils.EmojiUtils;
import org.fxmisc.richtext.CharacterHit;
import org.fxmisc.richtext.GenericStyledArea;
import org.fxmisc.richtext.NavigationActions;
import org.fxmisc.richtext.StyledTextArea;
import org.fxmisc.richtext.TextExt;
import org.fxmisc.richtext.model.Codec;
import org.fxmisc.richtext.model.Paragraph;
import org.fxmisc.richtext.model.ReadOnlyStyledDocument;
import org.fxmisc.richtext.model.SegmentOps;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyledDocument;
import org.fxmisc.richtext.model.StyledSegment;
import org.fxmisc.richtext.model.TextOps;
import org.fxmisc.wellbehaved.event.EventPattern;
import org.fxmisc.wellbehaved.event.InputMap;
import org.fxmisc.wellbehaved.event.Nodes;
import org.reactfx.collection.LiveList;
import org.reactfx.util.Either;
import smile.cti.client.ContactInfo;
import smile.cti.client.SessionInfo;

public class MyStyledTextArea
extends GenericStyledArea<ParStyle, Either<String, LinkedImage>, TextStyle> {
    private static final String Default_Font_Family = "Arial";
    private static final String Default_Font_Color = MyStyledTextArea.getFontColor();
    private static final String Underlined_Font_Color = MyStyledTextArea.getFontColor();
    private static final String Underlined_Background_Color = "#E65D5D";
    private static final String Link_Color = "#0a5ca1";
    private final TextStyle underlineTypeStyle;
    private final TextStyle defaultTypeStyle = TextStyle.EMPTY.updateFontSize(12).updateFontFamily("Arial").updateTextColor(Color.web((String)Default_Font_Color));
    private final double LINE_HEIGHT = 22.0;
    private final double TOP_PADDING = 2.0;
    private final double BOTTOM_PADDING = 2.0;
    public static final int lineHeight = 25;
    private final IInnerMessageTextArea iInnerMessageTextArea;
    private final String helloMessage = ClientSingleton.getInstance().getString("write_message");
    private final String helloComment = ClientSingleton.getInstance().getString("write_message_comment");
    private final String replyMessage = ClientSingleton.getInstance().getString("reply_message");
    private static final TextOps<String, TextStyle> styledTextOps = SegmentOps.styledTextOps();
    private static final LinkedImageOps<TextStyle> linkedImageOps = new LinkedImageOps();
    private double caretPositionX = -1.0;
    private double caretPositionY = -1.0;
    public static final int REPLY_TYPE_CODE = 1025;
    private final List<StyledWord> styledLinkList = new ArrayList<StyledWord>();
    private Object tag;

    public Object getTag() {
        return this.tag;
    }

    public void setTag(Object tag) {
        this.tag = tag;
    }

    public MyStyledTextArea(IInnerMessageTextArea iInnerMessageTextArea) {
        this(iInnerMessageTextArea, null, MyStyledTextArea.getFontColor());
        this.setEditable(false);
    }

    public MyStyledTextArea(IInnerMessageTextArea iInnerMessageTextArea, String textColor) {
        this(iInnerMessageTextArea, null, textColor);
        this.setEditable(false);
    }

    public MyStyledTextArea(IInnerMessageTextArea iInnerMessageTextArea, ChangeListener<Boolean> listener) {
        this(iInnerMessageTextArea, listener, MyStyledTextArea.getFontColor());
    }

    public static String getFontColor() {
        return Theme.getInstance().isDarkTheme() ? "white" : "#252b40";
    }

    public MyStyledTextArea(IInnerMessageTextArea iInnerMessageTextArea, ChangeListener<Boolean> listener, String textColor) {
        this(iInnerMessageTextArea, listener, textColor, 12);
    }

    public MyStyledTextArea(IInnerMessageTextArea iInnerMessageTextArea, ChangeListener<Boolean> listener, String textColor, int size) {
        super((Object)ParStyle.EMPTY.updateAlignment(TextAlignment.LEFT), (paragraph, style) -> paragraph.setStyle(style.toCss()), (Object)TextStyle.EMPTY.updateFontSize(size).updateFontFamily(Default_Font_Family).updateTextColor(Color.web((String)textColor)), styledTextOps._or(linkedImageOps, (s1, s2) -> Optional.empty()), seg -> MyStyledTextArea.createNode((StyledSegment<Either<String, LinkedImage>, TextStyle>)seg, (text, style) -> text.setStyle(style.toCss())));
        String color = ClientSingleton.getInstance().getStyleValue(Constants.CHAT_LINKS_TEXT_FILL).replace(";", "");
        this.underlineTypeStyle = TextStyle.EMPTY.updateItalic(true).updateUnderline(true).updateFontSize(12).updateFontFamily(Default_Font_Family).updateTextColor(Color.web((String)color));
        this.setWrapText(true);
        this.setStyleCodecs(ParStyle.CODEC, Codec.styledSegmentCodec((Codec)Codec.eitherCodec((Codec)Codec.STRING_CODEC, LinkedImage.codec()), TextStyle.CODEC));
        this.setParagraphGraphicFactory(new BulletFactory(this));
        this.iInnerMessageTextArea = iInnerMessageTextArea;
        this.init();
        if (listener != null) {
            this.focusedProperty().addListener(listener);
        }
    }

    public void createPalaceHolder(int mode) {
        TimerExecutor.getInstance().startInGUI(() -> {
            String placeHolderString = mode == 1024 ? this.helloComment : (mode == 1025 ? this.replyMessage : this.helloMessage);
            Text placeHolder = new Text(placeHolderString);
            try {
                ClientSingleton.getInstance().setStyledTextFont(placeHolder, false, "#A7AAB2");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            int width = ClientSingleton.getInstance().getContentTextWidth(25, placeHolderString);
            int height = ClientSingleton.getInstance().getContentTextHeight(25, placeHolderString);
            HBox hBox = new HBox();
            hBox.setMaxSize((double)width, (double)height);
            hBox.getChildren().add((Object)placeHolder);
            this.setPlaceholder((Node)hBox);
        });
    }

    protected void configurePlaceholder(Node placeholder) {
        placeholder.layoutYProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> 0.0, (Observable[])new Observable[]{this.heightProperty(), placeholder.layoutBoundsProperty()}));
        placeholder.layoutXProperty().bind((ObservableValue)Bindings.createDoubleBinding(() -> 10.0, (Observable[])new Observable[]{this.widthProperty(), placeholder.layoutBoundsProperty()}));
    }

    public void insertImage(String imagePath, boolean isEmoji) {
        ReadOnlyStyledDocument ros = ReadOnlyStyledDocument.fromSegment((Object)Either.right((Object)new RealLinkedImage(imagePath, isEmoji)), (Object)ParStyle.EMPTY, (Object)TextStyle.EMPTY, (SegmentOps)this.getSegOps());
        this.replaceSelection((StyledDocument)ros);
    }

    public void insertEmoji(EmojiClass emoji) {
        ReadOnlyStyledDocument ros = ReadOnlyStyledDocument.fromSegment((Object)Either.right((Object)new RealLinkedImage(emoji)), (Object)ParStyle.EMPTY, (Object)TextStyle.EMPTY.updateFontSize(12).updateFontFamily(Default_Font_Family).updateTextColor(Color.web((String)Default_Font_Color)), (SegmentOps)this.getSegOps());
        this.replaceSelection((StyledDocument)ros);
    }

    public void insertMentionText(ContactInfo contactInfo) {
        ReadOnlyStyledDocument ros = ReadOnlyStyledDocument.fromSegment((Object)Either.right((Object)new MentionLinkedText(contactInfo)), (Object)ParStyle.EMPTY, (Object)TextStyle.EMPTY.updateFontSize(12).updateFontFamily(Default_Font_Family).updateTextColor(Color.web((String)Default_Font_Color)), (SegmentOps)this.getSegOps());
        this.replaceSelection((StyledDocument)ros);
    }

    public String getTextString() {
        String content = this.getText();
        char[] chrs = content.toCharArray();
        if (IntStream.range(0, chrs.length).anyMatch(index -> chrs[index] == '\ufffc')) {
            StringBuilder stringBuilder = new StringBuilder();
            LiveList pars = this.getParagraphs();
            for (Paragraph paragraph : pars) {
                List segs = paragraph.getSegments();
                for (Object seg : segs) {
                    if (seg instanceof Either) {
                        String text2;
                        Either either = (Either)seg;
                        if (either.isLeft()) {
                            if (either.getLeft() instanceof RealLinkedImage) {
                                text2 = this.parseEmoji((RealLinkedImage)either.getLeft());
                                stringBuilder.append(text2);
                                continue;
                            }
                            stringBuilder.append(either.getLeft().toString());
                            continue;
                        }
                        if (either.getRight() instanceof RealLinkedImage) {
                            text2 = this.parseEmoji((RealLinkedImage)either.getRight());
                            stringBuilder.append(text2);
                            continue;
                        }
                        stringBuilder.append(either.getRight().toString());
                        continue;
                    }
                    stringBuilder.append(seg.toString());
                }
                stringBuilder.append("\n");
            }
            return stringBuilder.toString();
        }
        return content;
    }

    private String parseEmoji(RealLinkedImage realLinkedImage) {
        String emojiName = realLinkedImage.getEmojiName();
        String ret = "";
        if (emojiName == null) {
            return ret;
        }
        if (!emojiName.contains("-")) {
            ret = String.valueOf(Character.toChars(Integer.parseInt(emojiName, 16)));
        } else {
            String[] emojisNames;
            for (String name : emojisNames = emojiName.split("-")) {
                ret = ret.concat(String.valueOf(Character.toChars(Integer.parseInt(name, 16))));
            }
        }
        return ret;
    }

    private void moveCaretToEnd() {
        this.lineEnd(NavigationActions.SelectionPolicy.CLEAR);
    }

    private void setCaretPosition(int position) {
        this.moveTo(position);
    }

    public void setContentToStyledTextArea(String text) {
        ClientSingleton.getInstance().runLater(() -> this.setContent(text));
    }

    private void setContent(String text) {
        this.styledLinkList.clear();
        TreeMap treeMap = new TreeMap(Comparator.reverseOrder());
        TreeMap<Integer, String> emoji = EmojiUtils.containsEmojiAt(text);
        if (!emoji.isEmpty()) {
            text = EmojiUtils.removeEmoji(text);
            treeMap.putAll(emoji);
        }
        this.replaceText(text);
        SessionInfo sessionInfo = ClientSingleton.getInstance().getCurrentSessionInfo();
        if (sessionInfo != null && sessionInfo.isGroup()) {
            Map<Integer, ContactInfo> mentions = MentionLinkedText.getMentions(text);
            treeMap.putAll(mentions);
        }
        treeMap.forEach((index, object) -> {
            if (object instanceof ContactInfo) {
                ContactInfo contactInfo = (ContactInfo)object;
                ReadOnlyStyledDocument ros = ReadOnlyStyledDocument.fromSegment((Object)Either.right((Object)new MentionLinkedText(contactInfo)), (Object)ParStyle.EMPTY, (Object)TextStyle.EMPTY.updateFontSize(12).updateFontFamily(Default_Font_Family).updateTextColor(Color.web((String)Default_Font_Color)), (SegmentOps)this.getSegOps());
                this.deleteText(new IndexRange(index.intValue(), index + contactInfo.toString().length() + 1));
                this.replace(new IndexRange(index.intValue(), index.intValue()), (StyledDocument)ros);
            } else {
                String fileName = EmojiUtils.isHasExternalEmoji() ? "/ext/emojis/" + object.toString() + ".png" : "/emoji/emoji_chat/" + object.toString() + ".png";
                RealLinkedImage realLinkedImage = new RealLinkedImage(fileName, true);
                ReadOnlyStyledDocument ros = ReadOnlyStyledDocument.fromSegment((Object)Either.right((Object)realLinkedImage), (Object)ParStyle.EMPTY, (Object)TextStyle.EMPTY, (SegmentOps)this.getSegOps());
                if (index > this.getText().length()) {
                    index = this.getText().length();
                }
                this.replace(new IndexRange(index.intValue(), index + 1), (StyledDocument)ros);
            }
        });
        this.layoutChildren();
    }

    public void setTAText() {
        if (this.getText().isEmpty()) {
            return;
        }
        try {
            this.replaceText(0, this.getText().length(), "");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void clearMessage(String message) {
        if (message != null && !message.isEmpty()) {
            this.setContentToStyledTextArea(message);
        } else if (this.iInnerMessageTextArea != null) {
            this.iInnerMessageTextArea.clearMessagePane(25);
            this.setTAText();
            this.styledLinkList.clear();
        }
    }

    private void init() {
        this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, CornerRadii.EMPTY, Insets.EMPTY)}));
        ContextMenu contextMenu = new ContextMenu();
        MenuItem menuItem1 = new MenuItem(ClientSingleton.getInstance().getString("context_menu_copy"));
        MenuItem menuItem2 = new MenuItem(ClientSingleton.getInstance().getString("context_menu_select_all"));
        MenuItem menuItem3 = new MenuItem(ClientSingleton.getInstance().getString("context_menu_past"));
        menuItem1.setOnAction(event -> this.copy());
        menuItem2.setOnAction(event -> this.selectAll());
        menuItem3.setOnAction(event -> this.sendFromClipboard());
        contextMenu.getItems().addAll((Object[])new MenuItem[]{menuItem1, menuItem2});
        this.setContextMenu(contextMenu);
        contextMenu.setOnShowing(windowEvent -> {
            if (!this.styledLinkList.isEmpty()) {
                if (contextMenu.getItems().size() > 3) {
                    contextMenu.getItems().remove(contextMenu.getItems().size() - 1);
                    contextMenu.getItems().remove(contextMenu.getItems().size() - 1);
                }
                TextStyle textStyle = (TextStyle)this.getStyleAtPosition(this.getCaretPosition());
                textStyle.underline.ifPresent(b -> this.styledLinkList.stream().filter(styledWord -> styledWord.inInterval(this.getCaretPosition())).findAny().ifPresent(styledWord -> {
                    MenuItem menuItem4 = new MenuItem(ClientSingleton.getInstance().getString("linkItem1"));
                    menuItem4.setOnAction(event -> ClientSingleton.getInstance().openWebBrowser(styledWord.getWord()));
                    contextMenu.getItems().add((Object)menuItem4);
                    MenuItem menuItem5 = new MenuItem(ClientSingleton.getInstance().getString("linkItem2"));
                    menuItem4.setOnAction(event -> {
                        try {
                            GetSelectedText.setClipboardText(styledWord.getWord());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        ClientSingleton.getInstance().openWebBrowser(styledWord.getWord());
                    });
                    contextMenu.getItems().add((Object)menuItem5);
                }));
            }
            if (this.isEditable()) {
                Clipboard clipboard = Clipboard.getSystemClipboard();
                if (this.getStyleCodecs().isPresent() && clipboard != null) {
                    if (!clipboard.getString().isEmpty() && !contextMenu.getItems().contains((Object)menuItem3)) {
                        contextMenu.getItems().add((Object)menuItem3);
                    } else {
                        contextMenu.getItems().remove((Object)menuItem3);
                    }
                }
            }
        });
        this.totalHeightEstimateProperty().addListener((observableValue, oldValue, newValue) -> {
            if (newValue != null && this.iInnerMessageTextArea != null) {
                ClientSingleton.getInstance().runLater(this::notifyResizePane);
            }
        });
        this.textProperty().addListener((observableValue, oldValue, newValue) -> {
            if (oldValue != null && oldValue.length() > 20 && newValue.length() == 0) {
                this.iInnerMessageTextArea.resizeParent(25, 1);
            }
        });
        this.caretBoundsProperty().addListener((observableValue, bounds, newValue) -> newValue.ifPresent(bounds1 -> {
            this.caretPositionX = bounds1.getMaxX();
            this.caretPositionY = bounds1.getMinY();
        }));
    }

    public void addInputMap() {
        Nodes.addInputMap((Node)this, (InputMap)InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCombination)new KeyCodeCombination(KeyCode.ENTER, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_ANY})), event -> {
            String message = this.getTextString().trim();
            if (!message.isEmpty() && this.iInnerMessageTextArea != null) {
                this.iInnerMessageTextArea.sendMessage(message);
                this.clearMessage(null);
            }
        }));
        boolean isMac = ClientUtil.getOS() == ClientUtil.OS.MAC;
        KeyCombination.Modifier currentModifier = isMac ? KeyCombination.SHORTCUT_DOWN : KeyCombination.CONTROL_DOWN;
        Nodes.addInputMap((Node)this, (InputMap)InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCombination)new KeyCodeCombination(KeyCode.C, new KeyCombination.Modifier[]{currentModifier})), event -> this.copy()));
        Nodes.addInputMap((Node)this, (InputMap)InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCombination)new KeyCodeCombination(KeyCode.V, new KeyCombination.Modifier[]{currentModifier})), event -> this.sendFromClipboard()));
        if (isMac) {
            Nodes.addInputMap((Node)this, (InputMap)InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCombination)new KeyCodeCombination(KeyCode.ENTER, new KeyCombination.Modifier[]{KeyCombination.SHORTCUT_DOWN})), event -> this.insertNewLineInText()));
        }
        Nodes.addInputMap((Node)this, (InputMap)InputMap.consume((EventPattern)EventPattern.keyPressed((KeyCombination)new KeyCodeCombination(KeyCode.ENTER, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN})), event -> this.insertNewLineInText()));
    }

    private void sendFromClipboard() {
        Clipboard clipboard = Clipboard.getSystemClipboard();
        if (clipboard != null) {
            if (clipboard.getFiles() != null && !clipboard.getFiles().isEmpty() && this.iInnerMessageTextArea instanceof IChatInputTextArea) {
                for (File file : clipboard.getFiles()) {
                    ((IChatInputTextArea)this.iInnerMessageTextArea).sendFile(file);
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                }
            } else if (this.getStyleCodecs().isPresent()) {
                int position = this.getCaretPosition();
                String text = clipboard.getString();
                if (text != null) {
                    this.insertText(position, clipboard.getString());
                    this.notifyResizePane();
                }
            }
        }
    }

    public void insertNewLineInText() {
        if (this.getText().isEmpty()) {
            this.insertText(this.getText().length(), "\n");
            this.moveCaretToEnd();
        } else {
            int position = this.getCaretPosition() > this.getText().length() ? this.getText().length() - 1 : this.getCaretPosition();
            this.insertText(position, "\n");
        }
    }

    public void setEditable(boolean mode) {
        if (!mode) {
            this.addEventFilter(MouseEvent.MOUSE_RELEASED, mouseEvent -> this.copy());
        }
        super.setEditable(mode);
    }

    private void notifyResizePane() {
        int count = 0;
        int height = 0;
        try {
            for (int i = 0; i < this.getParagraphs().size(); ++i) {
                count += this.getParagraphLinesCount(i);
            }
            height = (int)this.computePrefHeight(this.getLayoutBounds().getWidth());
            this.iInnerMessageTextArea.resizeParent(height, this.getParagraphs().size());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public int getTextLinesCount() {
        int count = 0;
        for (int i = 0; i < this.getParagraphs().size(); ++i) {
            count += this.getParagraphLinesCount(i);
        }
        return count;
    }

    private static Node createNode(StyledSegment<Either<String, LinkedImage>, TextStyle> seg, BiConsumer<? super TextExt, TextStyle> applyStyle) {
        return (Node)((Either)seg.getSegment()).unify(text -> StyledTextArea.createStyledTextNode((String)text, (Object)((TextStyle)seg.getStyle()), (BiConsumer)applyStyle), LinkedImage::createNode);
    }

    public void unfoldParagraphs(int startingFromPar) {
        this.unfoldParagraphs(startingFromPar, this.getFoldStyleCheck(), this.getRemoveFoldStyle());
    }

    protected UnaryOperator<ParStyle> getAddFoldStyle() {
        return pstyle -> pstyle.updateFold(true);
    }

    protected UnaryOperator<ParStyle> getRemoveFoldStyle() {
        return pstyle -> pstyle.updateFold(false);
    }

    protected Predicate<ParStyle> getFoldStyleCheck() {
        return pstyle -> pstyle.isFolded();
    }

    public int getComputePrefHeight() {
        this.applyCss();
        this.layoutChildren();
        return (int)this.computePrefHeight(this.getLayoutBounds().getWidth());
    }

    public CharacterHit hit(double x, double y) {
        CharacterHit hit = null;
        try {
            hit = super.hit(x, y);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (hit == null) {
            hit = CharacterHit.insertionAt((int)0);
        }
        return hit;
    }

    public double getCaretPositionX() {
        if (this.caretPositionX == -1.0) {
            Bounds boundsInScene = this.localToScreen(this.getBoundsInLocal());
            this.caretPositionX = boundsInScene.getMinX() + 25.0;
        }
        return this.caretPositionX;
    }

    public double getCaretPositionY() {
        if (this.caretPositionY == -1.0) {
            Bounds boundsInScene = this.localToScreen(this.getBoundsInLocal());
            this.caretPositionY = boundsInScene.getMinY();
        }
        return this.caretPositionY;
    }

    public List<String> getMentionsList() {
        ArrayList<String> list = new ArrayList<String>();
        LiveList pars = this.getParagraphs();
        for (Paragraph paragraph : pars) {
            List segs = paragraph.getSegments();
            for (Object seg : segs) {
                String text2;
                if (!(seg instanceof Either)) continue;
                Either either = (Either)seg;
                if (either.isLeft()) {
                    if (!(either.getLeft() instanceof MentionLinkedText)) continue;
                    text2 = ((MentionLinkedText)either.getLeft()).getContactInfo().getUserID();
                    list.add(text2);
                    continue;
                }
                if (!either.isRight() || !(either.getRight() instanceof MentionLinkedText)) continue;
                text2 = ((MentionLinkedText)either.getRight()).getContactInfo().getUserID();
                list.add(text2);
            }
        }
        return list;
    }

    public void makeLinks() {
        this.setStyleToDefault();
        ArrayList<StyledWord> urls = MyUtils.getLinks(this.getText());
        if (!urls.isEmpty()) {
            this.styledLinkList.clear();
            this.styledLinkList.addAll(urls);
            urls.forEach(integerIntegerPair -> this.setStyle(integerIntegerPair.getFirstIndex(), integerIntegerPair.getLastIndex(), this.underlineTypeStyle));
        }
    }

    public void setUnderLine() {
        this.setStyle(0, this.getText().length(), this.underlineTypeStyle);
    }

    private void setStyleToDefault() {
        if (this.getText().isEmpty()) {
            this.setStyle(0, this.defaultTypeStyle);
        } else {
            this.setStyle(0, this.getText().length() - 1, this.defaultTypeStyle);
        }
    }

    public void updateTextColor(List<IndexRange> indexRanges, Color color) {
        this.updateStyleInSelection(indexRanges, TextStyle.textColor(color));
    }

    public void updateTextColor(List<IndexRange> indexRanges, String color) {
        this.updateStyleInSelection(indexRanges, TextStyle.textColor(Color.web((String)color)));
    }

    public void updateBackgroundColor(List<IndexRange> indexRanges, Color color) {
        this.updateStyleInSelection(indexRanges, TextStyle.backgroundColor(color));
    }

    public void updateBackgroundColor(List<IndexRange> indexRanges, String color) {
        this.updateStyleInSelection(indexRanges, TextStyle.backgroundColor(Color.web((String)color)));
    }

    public void updateBackgroundColor(List<IndexRange> indexRanges, String fontFamily, String color, int fontSize) {
        this.updateStyleInSelection(indexRanges, TextStyle.EMPTY.updateFontSize(fontSize).updateFontFamily(fontFamily).updateTextColor(Color.web((String)color)));
    }

    private void updateStyleInSelection(List<IndexRange> indexRanges, Function<StyleSpans<TextStyle>, TextStyle> mixinGetter) {
        for (IndexRange indexRange : indexRanges) {
            if (indexRange.getLength() == 0) continue;
            StyleSpans styles = this.getStyleSpans(indexRange);
            TextStyle colorStyle = mixinGetter.apply((StyleSpans<TextStyle>)styles);
            StyleSpans newStyles = styles.mapStyles(style -> style.updateWith(colorStyle));
            this.setStyleSpans(indexRange.getStart(), newStyles);
        }
    }

    public void updateStyleInSelection(List<IndexRange> indexRanges, TextStyle colorStyle) {
        for (IndexRange indexRange : indexRanges) {
            if (indexRange.getLength() == 0) continue;
            StyleSpans styles = this.getStyleSpans(indexRange);
            StyleSpans newStyles = styles.mapStyles(style -> style.updateWith(colorStyle));
            this.setStyleSpans(indexRange.getStart(), newStyles);
        }
    }

    public void clearStyleInSelection() {
        this.clearStyle(0, this.getText().length());
    }
}

