/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.richtext;

import java.util.concurrent.atomic.AtomicReference;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.utils.viewers.richtext.LinkedImage;
import net.sipsnet.client.views.emoji.utils.EmojiClass;
import net.sipsnet.client.views.emoji.utils.EmojiUtils;

public class RealLinkedImage
implements LinkedImage {
    private final boolean isEmoji;
    private final String imagePath;
    private EmojiClass emoji;
    private ImageView imageView;

    public RealLinkedImage(EmojiClass emoji) {
        this.emoji = emoji;
        this.imagePath = emoji.getFileNameForChat();
        this.isEmoji = true;
    }

    public RealLinkedImage(String imagePath, boolean isEmoji) {
        this.imagePath = imagePath;
        this.isEmoji = isEmoji;
        if (imagePath.endsWith(".png")) {
            String emCode = imagePath.substring(imagePath.lastIndexOf("/") + 1, imagePath.indexOf(".png"));
            this.emoji = EmojiUtils.getEmojiClass(emCode);
        }
    }

    @Override
    public boolean isReal() {
        return true;
    }

    @Override
    public String getImagePath() {
        return this.imagePath;
    }

    public String toString() {
        return String.format("RealLinkedImage[path=%s, emoji=%s]", this.imagePath, this.emoji);
    }

    @Override
    public Node createNode() {
        if (this.imageView == null) {
            AtomicReference atomicReference = new AtomicReference();
            if (!this.isEmoji) {
                ClientSingleton.getInstance().getImageFromResources(this.imagePath).ifPresent(atomicReference::set);
            } else {
                ClientSingleton.getInstance().getEmojiImage(this.imagePath).ifPresent(atomicReference::set);
            }
            Image image = (Image)atomicReference.get();
            this.imageView = new ImageView(image);
            if (this.isEmoji) {
                this.imageView.setFitWidth(20.0);
                this.imageView.setFitHeight(20.0);
            }
        }
        return this.imageView;
    }

    public String getEmojiName() {
        return this.emoji != null ? this.emoji.getEmojiCode() : "";
    }
}

