/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.scrollbar;

import javafx.beans.value.ChangeListener;
import javafx.geometry.Orientation;
import javafx.scene.Cursor;
import javafx.scene.control.ScrollBar;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import net.sipsnet.client.utils.viewers.mylistview.interfaces.ScrollingState;
import net.sipsnet.client.utils.viewers.scrollbar.IScrollBar;

public class MyScrollBar
extends HBox {
    private final IScrollBar iScrollBar;
    private final ScrollBar scrollBar = new ScrollBar();
    int FOCUSED_WIDTH = 10;

    public MyScrollBar(IScrollBar iScrollBar) {
        this.iScrollBar = iScrollBar;
        this.scrollBar.setOrientation(Orientation.VERTICAL);
        this.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/fxml/utils/scrollbar.css").toExternalForm());
        this.getScrollBar();
        this.setScrollBarPaneWidth(false, Cursor.DEFAULT);
        this.getChildren().add((Object)this.scrollBar);
        this.setPrefWidth(this.FOCUSED_WIDTH);
        this.setMinWidth(this.FOCUSED_WIDTH);
        this.setMaxWidth(this.FOCUSED_WIDTH);
    }

    public void setOnValueChangedAction(ChangeListener<Number> changedAction) {
        this.scrollBar.valueProperty().addListener(changedAction);
    }

    private void getScrollBar() {
        this.setOnMouseExited(event -> {
            if (this.iScrollBar.getCurrentScrollState() != ScrollingState.SCROLLBAR_SCROLLING) {
                this.setScrollBarPaneWidth(false, Cursor.DEFAULT);
            }
        });
        this.setOnMouseEntered(event -> this.setScrollBarPaneWidth(true, Cursor.HAND));
        this.addEventFilter(MouseEvent.MOUSE_PRESSED, event -> this.iScrollBar.changeScrollState(ScrollingState.SCROLLBAR_SCROLLING));
        this.addEventFilter(MouseEvent.MOUSE_RELEASED, event -> {
            this.iScrollBar.changeScrollState(ScrollingState.NOT_SCROLLING);
            this.setScrollBarPaneWidth(false, Cursor.DEFAULT);
        });
    }

    public void setScrollBarPaneWidth(boolean isFocused, Cursor cursor) {
        int NOT_FOCUSED_WIDTH = 5;
        int oldWidth = (int)this.getWidth();
        int width = this.FOCUSED_WIDTH;
        if (this.scrollBar.getMaxWidth() != (double)width) {
            this.scrollBar.setPrefWidth((double)width);
            this.scrollBar.setMinWidth((double)width);
            this.scrollBar.setMaxWidth((double)width);
        }
        if (this.getCursor() != cursor) {
            this.setCursor(cursor);
        }
    }

    public void setValue(int value) {
        this.scrollBar.setValue((double)value);
    }

    public void setMax(int max) {
        this.scrollBar.setMax((double)max);
    }
}

