/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.slider;

import javafx.scene.control.Control;
import javafx.scene.control.Slider;
import javafx.scene.layout.StackPane;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.viewers.slider.IMySliderPane;

public class MySlider
extends Slider {
    private IMySliderPane iMySliderPane;

    public MySlider() {
        this.getStyleClass().add((Object)"slider");
        Theme.getInstance().applyTo(Constants.SLIDER_BAR_STYLE, (Control)this);
        this.valueProperty().addListener((obs, oldValue, newValue) -> {
            double percentage = 100.0 * (newValue.doubleValue() - this.getMin()) / (this.getMax() - this.getMin());
            StackPane sliderTrack = (StackPane)this.lookup(".track");
            String color = ClientSingleton.getInstance().getStyleValue(Constants.PROGRESS_INDICATOR_STYLE);
            String style = "-fx-background-color: linear-gradient(to right," + color + " " + percentage + "%, #f1f2f5 " + percentage + "%);";
            sliderTrack.setStyle(style);
            if (this.iMySliderPane != null) {
                this.iMySliderPane.moveToX(percentage);
            }
        });
    }

    public void setIMySliderPane(IMySliderPane iMySliderPane) {
        this.iMySliderPane = iMySliderPane;
    }
}

