/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.textfieldwithsearch;

import java.util.MissingResourceException;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.TextField;
import javafx.scene.control.TextFormatter;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.utils.viewers.imageview.MyImageView;

public class TextFieldWithSearch
extends HBox {
    private final SimpleIntegerProperty textFontSize = new SimpleIntegerProperty((Object)12, "textFontSize");
    private final SimpleStringProperty textFontFamily = new SimpleStringProperty((Object)"Roboto-Regular", "textFontFamily");
    private final SimpleStringProperty textFontColor = new SimpleStringProperty((Object)"#656a7c", "textFontColor");
    private final SimpleStringProperty backgroundColor = new SimpleStringProperty((Object)"#f1f2f5", "backgroundColor");
    private final SimpleIntegerProperty textMarginLeft = new SimpleIntegerProperty((Object)0, "textMarginLeft");
    private final SimpleIntegerProperty textMarginRight = new SimpleIntegerProperty((Object)0, "textMarginRight");
    private final SimpleIntegerProperty textWidth = new SimpleIntegerProperty((Object)100, "textWidth");
    private final SimpleIntegerProperty textHeight = new SimpleIntegerProperty((Object)30, "textHeight");
    private final SimpleStringProperty promptText = new SimpleStringProperty((Object)"", "promptText");
    private final SimpleIntegerProperty cornerRadius = new SimpleIntegerProperty((Object)13, "cornerRadius");
    private final SimpleBooleanProperty withSearch = new SimpleBooleanProperty((Object)false, "withSearch");
    private final SimpleBooleanProperty isEditable = new SimpleBooleanProperty((Object)true, "isEditable");
    private final SimpleBooleanProperty isClearWhenNotEditable = new SimpleBooleanProperty((Object)true, "isClearWhenNotEditable");
    private final TextField textField = new TextField();

    public String getText() {
        return this.textField.getText();
    }

    public void setContextMenu(ContextMenu contextMenu) {
        this.textField.setContextMenu(contextMenu);
    }

    public void setTextAlignment(Pos pos) {
        this.textField.setAlignment(pos);
    }

    public void setTextStyle(String style) {
        this.textField.setStyle(style);
    }

    public void setText(String txt) {
        ClientSingleton.getInstance().runLater(() -> {
            String text = txt;
            if (text.startsWith("#")) {
                try {
                    text = ClientSingleton.getInstance().getString(text.substring(1));
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            if (this.textField != null) {
                this.textField.setText(text);
                this.textField.positionCaret(this.textField.getText().length());
            }
        });
    }

    public void insertText(String text) {
        if (this.textField != null) {
            ClientSingleton.getInstance().runLater(() -> this.textField.insertText(this.textField.getCaretPosition(), text));
        }
    }

    public void setCaretPosition() {
        this.textField.positionCaret(this.textField.getText().length());
    }

    public void setInputFilter(EventHandler<KeyEvent> event) {
        this.textField.addEventFilter(KeyEvent.KEY_TYPED, event);
    }

    public void setOnKeyPressedHandler(EventHandler<KeyEvent> event) {
        this.textField.setOnKeyPressed(event);
    }

    public void setInputNumbersFilter() {
        this.textField.addEventFilter(KeyEvent.KEY_TYPED, event -> {
            char[] ar = event.getCharacter().toCharArray();
            char ch = ar[event.getCharacter().toCharArray().length - 1];
            if ((ch < '0' || ch > '9') && ch != '#' && ch != '*') {
                event.consume();
            }
        });
    }

    public void setFocusInTextField() {
        this.textField.requestFocus();
    }

    private String getTextFieldBaseStyle() {
        return " -fx-control-inner-background: " + this.backgroundColor.get() + ";    -fx-font-family: " + this.textFontFamily.get() + ";    -fx-font-size: " + this.textFontSize.get() + "px ;    -fx-text-fill: " + this.textFontColor.get() + ";   -fx-text-box-border: transparent;    -fx-border-radius: " + this.cornerRadius.get() + " " + this.cornerRadius.get() + " " + this.cornerRadius.get() + " " + this.cornerRadius.get() + ";    -fx-background-radius: " + this.cornerRadius.get() + " " + this.cornerRadius.get() + " " + this.cornerRadius.get() + " " + this.cornerRadius.get() + ";    -fx-padding: 0;-fx-background-insets: 0;-fx-background-color: transparent, " + this.backgroundColor.get() + ", transparent, " + this.backgroundColor.get() + ";-fx-prompt-text-fill: #989898;";
    }

    private String getSearchHBoxStyle() {
        return " -fx-control-inner-background: " + this.backgroundColor.get() + ";    -fx-padding: 0;-fx-background-insets: 0;    -fx-border-radius: " + this.cornerRadius.get() + " " + this.cornerRadius.get() + " " + this.cornerRadius.get() + " " + this.cornerRadius.get() + ";    -fx-background-radius: " + this.cornerRadius.get() + " " + this.cornerRadius.get() + " " + this.cornerRadius.get() + " " + this.cornerRadius.get() + ";-fx-background-color: transparent, " + this.backgroundColor.get() + ", transparent, " + this.backgroundColor.get() + ";";
    }

    public TextFieldWithSearch() {
        this.textHeight.addListener((observable, oldValue, newValue) -> {
            this.setMinHeight(newValue.doubleValue());
            this.setMaxHeight(newValue.doubleValue());
        });
        this.textWidth.addListener((observable, oldValue, newValue) -> {
            this.setMinWidth(newValue.doubleValue());
            this.setMaxWidth(newValue.doubleValue());
        });
        this.textMarginLeft.addListener((observable, oldValue, newValue) -> HBox.setMargin((Node)this.textField, (Insets)new Insets(5.0, (double)this.getTextMarginRight(), 5.0, (double)newValue.intValue())));
        this.textMarginRight.addListener((observable, oldValue, newValue) -> HBox.setMargin((Node)this.textField, (Insets)new Insets(5.0, (double)newValue.intValue(), 5.0, (double)this.getTextMarginLeft())));
        this.textFontSize.addListener((observable, oldValue, newValue) -> this.textField.setStyle(this.getTextFieldBaseStyle()));
        this.textFontFamily.addListener((observable, oldValue, newValue) -> this.textField.setStyle(this.getTextFieldBaseStyle()));
        this.textFontColor.addListener((observable, oldValue, newValue) -> this.textField.setStyle(this.getTextFieldBaseStyle()));
        this.backgroundColor.addListener((observable, oldValue, newValue) -> {
            this.setStyle(this.getSearchHBoxStyle());
            this.textField.setStyle(this.getTextFieldBaseStyle());
        });
        this.cornerRadius.addListener((observable, oldValue, newValue) -> this.setStyle(this.getSearchHBoxStyle()));
        this.promptText.addListener((observable, oldValue, newValue) -> this.textField.setPromptText(ClientSingleton.getInstance().getString((String)newValue)));
        this.withSearch.addListener((observable, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.addSearchImage();
            }
        });
        this.isEditable.addListener((observable, oldValue, newValue) -> {
            this.textField.setEditable(newValue.booleanValue());
            if (!newValue.booleanValue() && this.isClearWhenNotEditable.get()) {
                this.textField.setText("");
            }
        });
        this.setAlignment(Pos.CENTER_LEFT);
        this.initComponent();
        HBox.setHgrow((Node)this.textField, (Priority)Priority.ALWAYS);
        this.textField.setAlignment(Pos.CENTER_LEFT);
        this.getChildren().add((Object)this.textField);
        this.setStyle(this.getSearchHBoxStyle());
        this.textField.setStyle(this.getTextFieldBaseStyle());
        TextFormatter textFormatter = new TextFormatter(change -> {
            if (!this.textField.isFocused() && !change.isContentChange()) {
                return null;
            }
            return change;
        });
        this.textField.setTextFormatter(textFormatter);
        this.isClearWhenNotEditable.set(true);
    }

    private void addSearchImage() {
        this.addSearchImage("search/searchbar_search.png");
    }

    public void addSearchImage(String imagePath) {
        MyImageView myImageView = new MyImageView(14, 14);
        myImageView.setImage(imagePath);
        HBox.setMargin((Node)myImageView, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
        this.getChildren().add(0, (Object)myImageView);
        this.textMarginLeft.set(2);
    }

    private void initComponent() {
        this.setTextFontSize(14);
        this.setTextFontColor("#656a7c");
        this.setTextFontFamily("Roboto-Regular");
        this.setBackgroundColor("#f1f2f5");
        this.setTextHeight(30);
        this.setCornerRadius(13);
        this.setWithSearch(false);
        this.setIsEditable(true);
        this.setTextMarginLeft(5);
    }

    public void addListener(ChangeListener<? super String> changeListener) {
        this.textField.textProperty().addListener(changeListener);
    }

    private void setSize() {
        this.setMinHeight(this.textWidth.doubleValue());
        this.setMaxHeight(this.textHeight.doubleValue());
    }

    public StringProperty getTextProperty() {
        return this.textField.textProperty();
    }

    public boolean isIsEditable() {
        return this.isEditable.get();
    }

    public SimpleBooleanProperty isEditableProperty() {
        return this.isEditable;
    }

    public void setIsEditable(boolean isEditable) {
        this.isEditable.set(isEditable);
    }

    public int getTextWidth() {
        return this.textWidth.get();
    }

    public SimpleIntegerProperty textWidthProperty() {
        return this.textWidth;
    }

    public void setTextWidth(int textWidth) {
        this.textWidth.set(textWidth);
    }

    public boolean isWithSearch() {
        return this.withSearch.get();
    }

    public SimpleBooleanProperty withSearchProperty() {
        return this.withSearch;
    }

    public void setWithSearch(boolean withSearch) {
        this.withSearch.set(withSearch);
    }

    public int getTextHeight() {
        return this.textHeight.get();
    }

    public SimpleIntegerProperty textHeightProperty() {
        return this.textHeight;
    }

    public void setTextHeight(int textHeight) {
        this.textHeight.set(textHeight);
    }

    public String getPromptText() {
        return this.promptText.get();
    }

    public SimpleStringProperty promptTextProperty() {
        return this.promptText;
    }

    public void setPromptText(String textLabel) {
        this.promptText.set(textLabel);
    }

    public int getTextMarginLeft() {
        return this.textMarginLeft.get();
    }

    public SimpleIntegerProperty textMarginLeftProperty() {
        return this.textMarginLeft;
    }

    public void setTextMarginLeft(int textMarginLeft) {
        this.textMarginLeft.set(textMarginLeft);
    }

    public int getTextMarginRight() {
        return this.textMarginRight.get();
    }

    public SimpleIntegerProperty textMarginRightProperty() {
        return this.textMarginRight;
    }

    public void setTextMarginRight(int textMarginRight) {
        this.textMarginRight.set(textMarginRight);
    }

    public int getTextFontSize() {
        return this.textFontSize.get();
    }

    public SimpleIntegerProperty textFontSizeProperty() {
        return this.textFontSize;
    }

    public void setTextFontSize(int textFontSize) {
        this.textFontSize.set(textFontSize);
    }

    public String getTextFontFamily() {
        return this.textFontFamily.get();
    }

    public SimpleStringProperty textFontFamilyProperty() {
        return this.textFontFamily;
    }

    public void setTextFontFamily(String textFontFamily) {
        this.textFontFamily.set(textFontFamily);
    }

    public String getTextFontColor() {
        return this.textFontColor.get();
    }

    public SimpleStringProperty textFontColorProperty() {
        return this.textFontColor;
    }

    public void setTextFontColor(String textFontColor) {
        this.textFontColor.set(textFontColor);
    }

    public String getBackgroundColor() {
        return this.backgroundColor.get();
    }

    public SimpleStringProperty backgroundColorProperty() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(String backgroundColor) {
        this.backgroundColor.set(backgroundColor);
    }

    public int getCornerRadius() {
        return this.cornerRadius.get();
    }

    public SimpleIntegerProperty cornerRadiusProperty() {
        return this.cornerRadius;
    }

    public void setCornerRadius(int cornerRadius) {
        this.cornerRadius.set(cornerRadius);
    }

    public void setIsClearWhenNotEditable(boolean isClearWhenNotEditable) {
        this.isClearWhenNotEditable.set(isClearWhenNotEditable);
    }

    public void setTextPadding() {
        this.textField.minHeightProperty().bind((ObservableValue)this.minHeightProperty().add(10));
        this.textField.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        this.textField.setAlignment(Pos.CENTER_LEFT);
    }

    public void setTextFormatter(TextFormatter<String> textFormatter) {
        this.textField.setTextFormatter(textFormatter);
        this.textField.setAlignment(Pos.CENTER);
    }
}

