/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.toogleswitch;

import javafx.animation.TranslateTransition;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.util.Duration;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.viewers.IActionOnRelease;
import net.sipsnet.client.utils.viewers.toogleswitch.IMyToggleSwitcher;

public class MyToggleSwitch
extends Pane
implements IActionOnRelease {
    private final TranslateTransition transition;
    private final SimpleBooleanProperty selectedThumb = new SimpleBooleanProperty((Object)false, "selectedThumb");
    private final SimpleBooleanProperty disableThumb = new SimpleBooleanProperty((Object)false, "disableThumb");
    private final int PADDING = 2;
    private IMyToggleSwitcher iMyToggleSwitcher;
    private Pane thumbArea = new Pane();
    private Circle thumb = new Circle();
    private StackPane basePane = new StackPane();
    private boolean withAction = true;
    private final ChangeListener<Number> changeListener = (event, oldValue, newValue) -> {
        this.thumb.setCenterX(2.0);
        this.thumb.setRadius((this.getPrefHeight() - 4.0) / 2.0);
        this.setStyle(this.getThumbAreaStyle());
    };
    private final ChangeListener<Boolean> st = (event, oldValue, newValue) -> {
        if (newValue != oldValue) {
            this.selectedStateChanged();
            this.setStyle(this.getThumbAreaStyle());
            if (this.withAction) {
                if (this.iMyToggleSwitcher != null) {
                    this.iMyToggleSwitcher.setToggleSwitcherSelected((boolean)newValue);
                }
            } else {
                this.withAction = true;
            }
        }
    };
    private final ChangeListener<Boolean> dt = (event, oldValue, newValue) -> {
        if (newValue != oldValue) {
            this.selectedStateChanged();
            this.setStyle(this.getThumbAreaStyle());
        }
    };

    public MyToggleSwitch() {
        this.thumb.setFill((Paint)Color.WHITE);
        this.setPrefHeight(18.0);
        this.setMaxHeight(18.0);
        this.basePane.setAlignment(Pos.CENTER_LEFT);
        this.basePane.getChildren().addAll((Object[])new Node[]{this.thumbArea, this.thumb});
        this.basePane.setPadding(new Insets(2.0, 2.0, 2.0, 2.0));
        this.basePane.prefWidthProperty().bind((ObservableValue)this.prefWidthProperty());
        this.basePane.prefHeightProperty().bind((ObservableValue)this.prefHeightProperty());
        this.basePane.setStyle("-fx-background-color:transparent;");
        this.getChildren().add((Object)this.basePane);
        this.transition = new TranslateTransition(Duration.millis((double)200.0), (Node)this.thumb);
        this.transition.setFromX(2.0);
        this.heightProperty().addListener(this.changeListener);
        this.selectedThumb.addListener(this.st);
        this.disableThumb.addListener(this.dt);
        ClientSingleton.getInstance().setMouseCursor((Node)this.thumb);
        ClientSingleton.getInstance().setMouseCursor((Node)this.thumbArea);
        this.thumbArea.setOnMouseClicked(event -> this.setSelectedWithAction(!this.isSelected()));
        this.thumb.setOnMouseClicked(event -> this.setSelectedWithAction(!this.isSelected()));
    }

    public void addSelectedListener(IMyToggleSwitcher iMyToggleSwitcher) {
        this.iMyToggleSwitcher = iMyToggleSwitcher;
    }

    private void selectedStateChanged() {
        this.transition.stop();
        this.transition.setToX(this.getToX());
        this.transition.play();
    }

    private double getToX() {
        double toX = 0.0;
        if (this.isSelected()) {
            toX = this.getPrefWidth() - this.getPrefHeight();
        }
        return toX;
    }

    private String getThumbAreaStyle() {
        int radius = (int)this.getPrefHeight() / 2;
        String selectedBackgroundColor = ClientSingleton.getInstance().getStyle(Constants.BUTTON_INNER_BACKGROUND_STYLE).get();
        String unselectedBackgroundColor = "-fx-control-inner-background:#a1accc;";
        String backgroundColor = this.isDisableThumb() ? unselectedBackgroundColor : (this.isSelected() ? selectedBackgroundColor : unselectedBackgroundColor);
        String style = backgroundColor + "-fx-border-radius: " + radius + " " + radius + " " + radius + " " + radius + ";-fx-background-radius: " + radius + " " + radius + " " + radius + " " + radius + ";-fx-background-color: -fx-control-inner-background;";
        return style;
    }

    public boolean isSelected() {
        return this.selectedThumb.get();
    }

    public SimpleBooleanProperty selectedThumbProperty() {
        return this.selectedThumb;
    }

    public void setSelectedWithAction(boolean selectedThumb) {
        if (this.isDisableThumb()) {
            return;
        }
        this.withAction = true;
        this.selectedThumb.set(selectedThumb);
    }

    public void setSelected(boolean selectedThumb) {
        if (this.isDisableThumb()) {
            return;
        }
        this.withAction = false;
        this.selectedThumb.set(selectedThumb);
    }

    public boolean isDisableThumb() {
        return this.disableThumb.get();
    }

    public SimpleBooleanProperty disableThumbProperty() {
        return this.disableThumb;
    }

    public void setDisableThumb(boolean disable) {
        this.disableThumb.set(disable);
    }

    @Override
    public void onRelease() {
        this.basePane.prefHeightProperty().unbind();
        this.basePane.prefWidthProperty().unbind();
        this.thumbArea.setOnMouseClicked(null);
        this.thumb.setOnMouseClicked(null);
        this.heightProperty().removeListener(this.changeListener);
        this.selectedThumb.removeListener(this.st);
        this.disableThumb.removeListener(this.dt);
        ClientSingleton.getInstance().removeMouseCursor((Node)this.thumb);
        ClientSingleton.getInstance().removeMouseCursor((Node)this.thumbArea);
        this.basePane.getChildren().clear();
        this.getChildren().clear();
        this.basePane = null;
        this.thumbArea = null;
        this.thumb = null;
        this.iMyToggleSwitcher = null;
    }

    public void removeListener() {
        this.selectedThumb.removeListener(this.st);
    }

    public void addListener() {
        this.selectedThumb.addListener(this.st);
    }

    public void setSelectedView(boolean mode) {
        if (mode && !this.isSelected() || !mode && this.isSelected()) {
            this.removeListener();
            this.setSelected(mode);
            this.selectedStateChanged();
            this.setStyle(this.getThumbAreaStyle());
            this.addListener();
        }
    }
}

