/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.utils.viewers.trunksmenu;

import java.util.List;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.utils.MyAction;
import net.sipsnet.client.utils.MyActionWithParameter;
import net.sipsnet.client.utils.popupstage.MyPopupWindow;
import net.sipsnet.client.utils.viewers.buttons.labelbutton.MyLabelButton;

public class MyTrunksMenu
extends BorderPane {
    private final MyPopupWindow myPopupWindow;
    private final String title;
    private final int HEADER_HEIGHT = 40;
    private final int PANE_WIDTH = 300;
    private final VBox buttonsPane = new VBox();
    private Label lbContactTitle;
    private MyAction myAction;

    public MyTrunksMenu(String title) {
        this.title = title;
        this.myPopupWindow = MyPopupWindow.getNewInstance((Pane)this).setAlwaysOnTop(true).setWindowModality();
        this.buttonsPane.setPadding(new Insets(5.0, 10.0, 10.0, 10.0));
        VBox.setVgrow((Node)this.buttonsPane, (Priority)Priority.ALWAYS);
        HBox header = this.getHeader();
        this.buttonsPane.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        header.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        header.setPadding(new Insets(10.0, 0.0, 0.0, 0.0));
        this.setTop((Node)header);
        this.setCenter((Node)this.buttonsPane);
        this.setMaxWidth(310.0);
        this.setPrefWidth(310.0);
    }

    public void showAndWait(String number, List<String> trunks, MyActionWithParameter<String> myAction) {
        int linesCount = 3;
        this.lbContactTitle.setText(number);
        if (this.title != null) {
            HBox headerPane = new HBox();
            headerPane.setMinHeight(40.0);
            headerPane.setPadding(new Insets(0.0, 15.0, 0.0, 15.0));
            headerPane.setAlignment(Pos.CENTER_LEFT);
            Label myLabel = new Label();
            myLabel.setStyle("-fx-text-fill: #656a7c;     -fx-font-family: \"HelveticaNeue\";     -fx-font-weight: bold;     -fx-font-size: 12pt;     -fx-background-color: transparent;");
            myLabel.setText(this.title);
            headerPane.getChildren().add((Object)myLabel);
            myLabel.prefHeightProperty().bind((ObservableValue)headerPane.heightProperty());
            this.buttonsPane.getChildren().add((Object)headerPane);
        } else {
            linesCount = 2;
        }
        for (String trunk : trunks) {
            AnchorPane buttonPane = this.addButton(trunk, (EventHandler<MouseEvent>)((EventHandler)event -> {
                ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "showAndWait get trunk=" + trunk);
                myAction.execute(trunk);
                this.myPopupWindow.hide();
            }));
            buttonPane.prefWidthProperty().bind((ObservableValue)this.buttonsPane.widthProperty());
            this.buttonsPane.getChildren().add((Object)buttonPane);
        }
        HBox buttonPane = new HBox();
        MyLabelButton myLabelButton = new MyLabelButton(ClientSingleton.getInstance().getString("cancel"), 30);
        myLabelButton.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.myPopupWindow.hide()));
        buttonPane.getChildren().add((Object)myLabelButton);
        buttonPane.setPadding(new Insets(5.0, 15.0, 0.0, 5.0));
        buttonPane.setAlignment(Pos.CENTER_RIGHT);
        buttonPane.prefWidthProperty().bind((ObservableValue)this.buttonsPane.widthProperty());
        this.buttonsPane.getChildren().add((Object)buttonPane);
        this.setMinHeight((trunks.size() + linesCount) * 40);
        this.setMaxHeight((trunks.size() + linesCount) * 40);
        this.myPopupWindow.showAndWait();
    }

    private HBox getHeader() {
        HBox hBox = new HBox();
        HBox.setHgrow((Node)hBox, (Priority)Priority.ALWAYS);
        hBox.setMinHeight(35.0);
        hBox.setMaxHeight(35.0);
        hBox.setAlignment(Pos.CENTER_LEFT);
        HBox hbAvatarBox = new HBox();
        hbAvatarBox.prefHeightProperty().bind((ObservableValue)hBox.prefHeightProperty());
        hbAvatarBox.setMinHeight(40.0);
        hbAvatarBox.prefHeight(40.0);
        hbAvatarBox.setFillHeight(true);
        hbAvatarBox.setAlignment(Pos.CENTER);
        ImageView ivAvatar = new ImageView();
        ClientSingleton.getInstance().setImageToImageView(ivAvatar, "notify_emblem.png");
        hbAvatarBox.getChildren().add((Object)ivAvatar);
        HBox.setMargin((Node)hbAvatarBox, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
        hBox.getChildren().add((Object)hbAvatarBox);
        this.lbContactTitle = new Label();
        HBox.setMargin((Node)this.lbContactTitle, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
        this.lbContactTitle.setStyle("-fx-text-fill: #656a7c;     -fx-font-family: \"HelveticaNeue\";     -fx-font-weight: bold;     -fx-font-size: 13pt;     -fx-background-color: transparent;");
        HBox.setHgrow((Node)this.lbContactTitle, (Priority)Priority.ALWAYS);
        this.lbContactTitle.prefHeightProperty().bind((ObservableValue)hBox.prefHeightProperty());
        hBox.getChildren().add((Object)this.lbContactTitle);
        return hBox;
    }

    private AnchorPane addButton(String buttonTitle, EventHandler<MouseEvent> event) {
        AnchorPane anchorPane = new AnchorPane();
        MyLabelButton myLabelButton = new MyLabelButton(buttonTitle, 30);
        myLabelButton.addMouseEventHandler(event);
        anchorPane.getChildren().add((Object)myLabelButton);
        AnchorPane.setLeftAnchor((Node)myLabelButton, (Double)15.0);
        AnchorPane.setTopAnchor((Node)myLabelButton, (Double)5.0);
        AnchorPane.setRightAnchor((Node)myLabelButton, (Double)15.0);
        AnchorPane.setBottomAnchor((Node)myLabelButton, (Double)5.0);
        return anchorPane;
    }
}

