/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.activityviewer;

import io.reactivex.Observable;
import io.reactivex.Observer;
import io.reactivex.Scheduler;
import io.reactivex.rxjavafx.observables.JavaFxObservable;
import io.reactivex.rxjavafx.schedulers.JavaFxScheduler;
import io.reactivex.subjects.PublishSubject;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.WorkerStateEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Duration;
import javafx.util.Pair;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.WhiteLabels;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.connector.utils.JsonMessageParser;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.scheduledwork.MyScheduledService;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.viewers.buttoncombobox.MenuImageButton;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.CloseImageButton;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButton;
import net.sipsnet.client.utils.viewers.combobox.MyContextComboBox;
import net.sipsnet.client.utils.viewers.label.MyLabel;
import net.sipsnet.client.utils.viewers.mylistview.internal.IOnScrollAction;
import net.sipsnet.client.utils.viewers.textfieldwithsearch.TextFieldWithSearch;
import net.sipsnet.client.views.chat.holders.viewerholders.callviewer.CallViewerBase;
import net.sipsnet.client.views.chat.interfaces.IOnCloseViewer;
import net.sipsnet.client.views.tabs.UpdateLists;
import org.fxmisc.flowless.Cell;
import org.fxmisc.flowless.VirtualFlow;
import org.fxmisc.flowless.VirtualizedScrollPane;
import org.json.smile.JSONException;
import smile.cti.client.Activity;
import smile.cti.client.ClientConnector;
import smile.cti.client.ContactInfo;
import smile.cti.client.MessageInfo;
import smile.cti.client.SessionInfo;

public class ActivityViewerController
implements IOnScrollAction {
    private final int HEADER_HEIGHT = 40;
    private final int LINE_HEIGHT = 30;
    private final List<MenuImageButton> menuImageButtons = new ArrayList<MenuImageButton>();
    private final ContactInfo contactInfo;
    private MyContextComboBox usersComboBox;
    private MyContextComboBox datesComboBox;
    private final IOnCloseViewer iOnCloseViewer;
    private final VBox mainScrollNode = new VBox();
    private final Map<String, Pane> records = new HashMap<String, Pane>();
    private SessionInfo sessionInfo = null;
    private final boolean withExitButton;
    private final ObservableList<Activity> activitiesList = FXCollections.observableArrayList();
    private final VirtualFlow<Activity, ?> virtualFlow = VirtualFlow.createVertical(this.activitiesList, activity -> {
        HBox activityCell = this.getActivity((Activity)activity);
        activityCell.applyCss();
        activityCell.layout();
        return Cell.wrapNode((Node)activityCell);
    });
    private final VirtualizedScrollPane<VirtualFlow<Activity, ?>> scrollPane = new VirtualizedScrollPane(this.virtualFlow, ScrollPane.ScrollBarPolicy.NEVER, ScrollPane.ScrollBarPolicy.AS_NEEDED);

    public VBox getNode() {
        return this.mainScrollNode;
    }

    public ActivityViewerController(IOnCloseViewer iOnCloseViewer, ContactInfo contactInfo) {
        this(iOnCloseViewer, contactInfo, false);
    }

    public ActivityViewerController(IOnCloseViewer iOnCloseViewer, ContactInfo contactInfo, boolean withExitButton) {
        this.iOnCloseViewer = iOnCloseViewer;
        this.contactInfo = contactInfo;
        this.withExitButton = withExitButton;
        try {
            this.sessionInfo = ClientSingleton.getInstance().getExistSessionInfoByUserId(ClientSingleton.getInstance().getUserID(contactInfo));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.mainScrollNode.setMaxWidth(295.0);
        this.mainScrollNode.setMinWidth(295.0);
        this.mainScrollNode.setPrefWidth(295.0);
        VBox header = this.getHeader();
        header.setMaxWidth(295.0);
        header.setMinWidth(295.0);
        header.setPrefWidth(295.0);
        this.mainScrollNode.setPadding(new Insets(0.0, 0.0, withExitButton ? 10.0 : 0.0, 0.0));
        this.mainScrollNode.setStyle("-fx-background-color:transparent");
        AnchorPane anchorPane = new AnchorPane();
        Theme.getInstance().applyTo(Constants.TABS_VIRTUALIZED_SCROLL, (Pane)anchorPane);
        anchorPane.prefWidthProperty().bind((ObservableValue)this.mainScrollNode.widthProperty());
        anchorPane.getChildren().add(this.scrollPane);
        VBox.setVgrow((Node)anchorPane, (Priority)Priority.ALWAYS);
        this.mainScrollNode.getChildren().addAll((Object[])new Node[]{header, anchorPane});
        AnchorPane.setTopAnchor(this.scrollPane, (Double)10.0);
        AnchorPane.setRightAnchor(this.scrollPane, (Double)0.0);
        AnchorPane.setBottomAnchor(this.scrollPane, (Double)10.0);
        AnchorPane.setLeftAnchor(this.scrollPane, (Double)0.0);
        Task task = new Task(){

            public List<Activity> call() {
                return ActivityViewerController.this.loadActivities();
            }
        };
        MyScheduledService.getInstance((Task<Object>)task, this.getClass().getSimpleName()).setOnSchedulerSucceeded((EventHandler<WorkerStateEvent>)((EventHandler)event -> {
            this.usersComboBox.setSelectedItem(ClientSingleton.getInstance().getString("activity_all_users"));
            this.setActivities((List)task.getValue());
        })).startWithDelay(Duration.millis((double)300.0));
        Theme.getInstance().applyTo(Constants.PROFILE_VIRTUALIZED_SCROLL, (Pane)this.mainScrollNode);
        Theme.getInstance().applyProfilesPaneTo((Pane)header);
        Theme.getInstance().applyProfilesPaneTo((Pane)anchorPane);
        anchorPane.getStyleClass().add((Object)"blockPane");
        header.getStyleClass().add((Object)"blockPane");
        Theme.getInstance().applyTo(Constants.CONTEXT_MENU, (Pane)this.mainScrollNode, true);
    }

    private void setActivities(List<Activity> activities) {
        this.sort(activities);
        this.activitiesList.clear();
        this.activitiesList.addAll(activities);
        this.virtualFlow.visibleCells();
        this.virtualFlow.applyCss();
        this.virtualFlow.layout();
    }

    private void sort(List<Activity> list) {
        Collections.sort(list, (o1, o2) -> {
            Activity activity1 = (Activity)o1;
            Activity activity2 = (Activity)o2;
            return activity1.getTimestart() - activity2.getTimestart() > 0L ? 1 : -1;
        });
    }

    private List<Activity> loadActivities() {
        List<Object> activities = new ArrayList<Activity>();
        Optional<ClientConnector> optionalClientConnector = ClientSingleton.getInstance().getClientConnector();
        if (optionalClientConnector.isPresent()) {
            ClientConnector clientConnector = optionalClientConnector.get();
            try {
                clientConnector.getActivities(this.contactInfo);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ArrayList<String> owners = new ArrayList<String>();
            activities = this.contactInfo.getActivities();
            ClientSingleton.toLog(this.getClass().getSimpleName(), "loadActivities activities.size()=" + activities.size());
            for (Activity activity : activities) {
                if (ClientSingleton.getInstance().getClientConnector().get().getUserId().equals(activity.getOwnerId()) || owners.contains(activity.getOwnerName())) continue;
                owners.add(activity.getOwnerName());
            }
            if (!owners.isEmpty()) {
                owners.add(ClientSingleton.getInstance().getUserInfo().toString());
            }
            if (owners.size() > 1) {
                Collections.sort(owners);
            }
            ArrayList<String> list = new ArrayList<String>();
            String string = ClientSingleton.getInstance().getString("activity_all_users");
            list.add(string);
            list.addAll(owners);
            this.usersComboBox.addItemsListToMenu(list, (title, index) -> {
                List<Activity> filtrList = this.setUserFilter(title);
                if (filtrList == null) {
                    return;
                }
                this.setActivities(filtrList);
            });
        }
        return activities;
    }

    private void addAllActivities(List<Activity> activities) {
        ArrayList<Activity> list = new ArrayList<Activity>();
        int dateSelectedIndex = this.datesComboBox.getSelectedIndex();
        int userSelectedIndex = this.usersComboBox.getSelectedIndex();
        ClientSingleton.toLog(this.getClass().getSimpleName(), "addAllActivities activities.size()=" + activities.size() + " userSelectedIndex = " + userSelectedIndex + " dateSelectedIndex=" + dateSelectedIndex);
        for (Activity activity : activities) {
            if (!this.checkActivity(activity)) continue;
            list.add(activity);
        }
        this.setActivities(list);
    }

    private boolean checkActivity(Activity activity) {
        int dateSelectedIndex = this.datesComboBox.getSelectedIndex();
        int userSelectedIndex = this.usersComboBox.getSelectedIndex();
        boolean check = false;
        check = dateSelectedIndex == 0 && userSelectedIndex == 0 ? true : (dateSelectedIndex > 0 && userSelectedIndex == 0 ? this.addActivityWithOwnerCheck(activity) : (dateSelectedIndex == 0 && userSelectedIndex > 0 ? this.addActivityWithDeepCheck(activity) : this.addActivityWithCheck(activity)));
        return check;
    }

    private HBox getActivity(Activity activity) {
        Pair<String, ImageButton> labels = this.getLabels(activity);
        HBox mainPane = new HBox();
        mainPane.getChildren().add((Object)((Node)labels.getValue()));
        mainPane.prefWidthProperty().bind((ObservableValue)this.scrollPane.widthProperty().subtract(30));
        VBox activityPane = new VBox();
        mainPane.getChildren().add((Object)activityPane);
        HBox.setHgrow((Node)activityPane, (Priority)Priority.ALWAYS);
        HBox activityHeader = this.getActivityHeader(activity, labels);
        activityHeader.prefWidthProperty().bind((ObservableValue)activityPane.widthProperty());
        activityPane.getChildren().add((Object)activityHeader);
        String subject = activity.getSubject();
        ClientSingleton.toLog(this.getClass().getSimpleName(), "getActivity subject=" + subject + " " + activity.getComment());
        if (subject != null && !subject.isEmpty() || activity.getAssignedDuration() > 0L) {
            Label activitySubject = new Label();
            HBox.setHgrow((Node)activitySubject, (Priority)Priority.ALWAYS);
            activitySubject.setPrefHeight(30.0);
            Theme.getInstance().applyTo(Constants.TAB_CELL_DATE_TEXT_FILL, (Labeled)activitySubject);
            if (subject != null && !subject.isEmpty()) {
                if (subject.startsWith("{") && subject.contains("\"number\":")) {
                    Pair<String, Integer> pair = null;
                    try {
                        pair = JsonMessageParser.getMessageString(subject, -1, false);
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    subject = pair != null ? (String)pair.getKey() : null;
                }
                if (subject != null && !subject.isEmpty()) {
                    activitySubject.setText(subject);
                }
                activityPane.getChildren().add((Object)activitySubject);
            }
            VBox.setMargin((Node)activitySubject, (Insets)new Insets(0.0, 12.0, 0.0, 0.0));
        }
        if (activity.getComment() != null && !activity.getComment().isEmpty()) {
            HBox textPane = new HBox();
            textPane.prefWidthProperty().bind((ObservableValue)activityPane.widthProperty());
            Label label = new Label();
            label.setWrapText(true);
            label.setStyle("-fx-background-color:white");
            label.setText(activity.getComment());
            VBox.setMargin((Node)textPane, (Insets)new Insets(0.0, 12.0, 0.0, 0.0));
            label.setTextFill((Paint)Color.web((String)"#656a7c"));
            textPane.getChildren().add((Object)label);
            activityPane.getChildren().add((Object)textPane);
        }
        activityPane.getChildren().add((Object)this.getActivityFooter(activity, activityPane));
        activityPane.setStyle("   -fx-border-color: #f1f2f5;    -fx-border-width: 1 0 0 0;");
        return mainPane;
    }

    private HBox getActivityHeader(Activity activity, Pair<String, ImageButton> labels) {
        HBox activityHeader = new HBox();
        activityHeader.setAlignment(Pos.CENTER_LEFT);
        Label myLabel = new Label();
        myLabel.setAlignment(Pos.CENTER_LEFT);
        myLabel.setPrefHeight(30.0);
        Theme.getInstance().applyTo(Constants.TAB_CELL_TEXT_FILL, (Labeled)myLabel);
        myLabel.setText((String)labels.getKey());
        long timeStart = activity.getTimestart();
        Label dateLabel = new Label();
        HBox.setMargin((Node)dateLabel, (Insets)new Insets(0.0, 5.0, 0.0, 5.0));
        dateLabel.setPrefHeight(30.0);
        dateLabel.setAlignment(Pos.CENTER_LEFT);
        Theme.getInstance().applyTo(Constants.TAB_CELL_DATE_TEXT_FILL, (Labeled)dateLabel);
        dateLabel.setText(ClientSingleton.getInstance().getDateTimeString(timeStart));
        HBox dummy = new HBox();
        HBox.setHgrow((Node)dummy, (Priority)Priority.ALWAYS);
        activityHeader.getChildren().addAll((Object[])new Node[]{myLabel, dummy, dateLabel});
        Label myLabelDuration = new Label();
        HBox.setHgrow((Node)myLabelDuration, (Priority)Priority.ALWAYS);
        myLabelDuration.setAlignment(Pos.CENTER_LEFT);
        myLabelDuration.setPrefHeight(30.0);
        Theme.getInstance().applyTo(Constants.TAB_CELL_DATE_TEXT_FILL, (Labeled)myLabelDuration);
        if (activity.getAssignedDuration() > 0L) {
            myLabelDuration.setText(" (" + ClientSingleton.getInstance().getTimeDuration(activity.getAssignedDuration()) + ") ");
        }
        activityHeader.getChildren().add((Object)myLabelDuration);
        return activityHeader;
    }

    private HBox getActivityFooter(Activity activity, VBox activityPane) {
        HBox activityFooter = new HBox();
        activityFooter.prefWidthProperty().bind((ObservableValue)activityPane.widthProperty());
        activityFooter.setAlignment(Pos.CENTER_LEFT);
        MyLabel activityOwner = new MyLabel();
        HBox.setHgrow((Node)activityOwner, (Priority)Priority.ALWAYS);
        activityOwner.setAlignment(Pos.CENTER_LEFT);
        activityOwner.setPrefHeight(30.0);
        activityOwner.setLabelFontSize(12);
        activityOwner.setLabelFontFamily("HelveticaNeue");
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            if (clientConnector.getUserId().equals(activity.getOwnerId())) {
                activityOwner.setLabelFontColor(WhiteLabels.getCustomBlueColor());
            }
        });
        activityOwner.setText(activity.getOwnerName());
        activityFooter.getChildren().add((Object)activityOwner);
        VBox.setMargin((Node)activityFooter, (Insets)new Insets(0.0, 5.0, 0.0, 0.0));
        return activityFooter;
    }

    private void createMenu(MenuImageButton menuImageButton, Activity activity) {
        Activity activity1;
        menuImageButton.clear();
        MessageInfo messageInfo = null;
        if (this.sessionInfo != null) {
            messageInfo = ClientSingleton.getInstance().getClientConnector().get().getMessageInfo(activity.getMessageId(), this.sessionInfo.getSessionId());
        }
        MessageInfo messageInfo1 = messageInfo;
        if (messageInfo != null && (activity1 = messageInfo.getActivity()).getFile() != null && !activity1.getFile().isEmpty() && ClientSingleton.getInstance().getClientConnector().get().getUserId().equals(activity.getOwnerId())) {
            menuImageButton.addMenuItem((Object)ClientSingleton.getInstance().getString("activity_edit"), (EventHandler<MouseEvent>)((EventHandler)action -> {
                menuImageButton.hideMenu();
                if (this.sessionInfo != null) {
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("messageInfo", messageInfo1);
                    ClientSingleton.getInstance().doNotify(Constants.OPEN_CALL_DETAILS, data);
                }
            }));
        }
        menuImageButton.addMenuItem((Object)ClientSingleton.getInstance().getString("activity_share"), (EventHandler<MouseEvent>)((EventHandler)action -> menuImageButton.hideMenu()));
        menuImageButton.addMenuItem((Object)ClientSingleton.getInstance().getString("activity_send"), (EventHandler<MouseEvent>)((EventHandler)action -> {
            menuImageButton.hideMenu();
            if (messageInfo1 != null) {
                ClientSingleton.getInstance().shareMessage(messageInfo1);
            }
        }));
    }

    private VBox addFileRecord(Activity activity) {
        VBox fx_RecordViewPane = new VBox();
        fx_RecordViewPane.setId(activity.getId());
        MyLabel myLabel = new MyLabel();
        myLabel.setPrefHeight(25.0);
        myLabel.setText(ClientSingleton.getInstance().getString("call_detail_comment_recording"));
        myLabel.setLabelMarginLeft(15);
        myLabel.setLabelFontColor("#656a7c");
        myLabel.setLabelFontFamily("Roboto");
        myLabel.setLabelFontSize(12);
        HBox recordBox = new HBox();
        recordBox.setAlignment(Pos.CENTER);
        ImageButton imageButton = new ImageButton();
        imageButton.setSize(20, 20);
        imageButton.setImagePath("calldetails/download.png");
        imageButton.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> ClientSingleton.getInstance().saveCallRecordFile(activity.getFile())));
        CallViewerBase callViewerBase = new CallViewerBase(activity);
        recordBox.getChildren().addAll((Object[])new Node[]{callViewerBase, imageButton});
        VBox.setMargin((Node)fx_RecordViewPane, (Insets)new Insets(10.0, 0.0, 10.0, 0.0));
        fx_RecordViewPane.setStyle("-fx-background-color: white;-fx-border-radius: 0 10 10 10;-fx-background-radius: 10 10 10 10;");
        VBox.setMargin((Node)recordBox, (Insets)new Insets(0.0, 10.0, 0.0, 15.0));
        VBox.setMargin((Node)fx_RecordViewPane, (Insets)new Insets(0.0, 10.0, 8.0, 0.0));
        fx_RecordViewPane.setPadding(new Insets(10.0, 0.0, 10.0, 0.0));
        fx_RecordViewPane.getChildren().addAll((Object[])new Node[]{myLabel, recordBox});
        return fx_RecordViewPane;
    }

    private Pair<String, ImageButton> getLabels(Activity activity) {
        String type = activity.getType();
        ImageButton imageView = new ImageButton();
        imageView.setBackgroundColor("transparent");
        imageView.setSize(40, 40);
        imageView.setImagePath("activity/email.png");
        if (type.equals("inbound")) {
            type = ClientSingleton.getInstance().getString("call_incoming");
            imageView.setImagePath("activity/activity_incomingcall_icon.png");
        } else if (type.equals("outbound")) {
            type = ClientSingleton.getInstance().getString("call_outgoing");
            imageView.setImagePath("activity/activity_outgoingcall_icon.png");
        } else if (type.equals("missed")) {
            type = ClientSingleton.getInstance().getString("call_missed");
            imageView.setImagePath("activity/activity_incomingcall_icon.png");
        } else if (!type.equals("comment") && !type.equals("update")) {
            if (type.equals("Email")) {
                type = ClientSingleton.getInstance().getString("email_incoming");
                imageView.setImagePath("activity/email.png");
            } else if (type.equals("EmailOut")) {
                type = ClientSingleton.getInstance().getString("email_outgoing");
                imageView.setImagePath("activity/email.png");
            } else if (!(type.equals("received") || type.equals("sent") || type.equals("mail") || type.equals("meeting") || type.equals("task") || type.equals("WebChat"))) {
                if (type.equals("FacebookMessenger")) {
                    type = ClientSingleton.getInstance().getString("activity_messenger");
                    imageView.setImagePath("activity/messenger.png");
                } else if (type.equals("Facebook")) {
                    type = ClientSingleton.getInstance().getString("activity_facebook");
                    imageView.setImagePath("activity/facebook.png");
                } else if (type.equals("Twitter")) {
                    type = ClientSingleton.getInstance().getString("activity_twitter");
                    imageView.setImagePath("activity/twitter.png");
                } else if (type.equals("Viber")) {
                    type = ClientSingleton.getInstance().getString("activity_viber");
                    imageView.setImagePath("activity/viber.png");
                } else if (type.equals("Skype")) {
                    type = ClientSingleton.getInstance().getString("activity_skype");
                    imageView.setImagePath("activity/skype.png");
                }
            }
        }
        return new Pair((Object)type, (Object)imageView);
    }

    private VBox getHeader() {
        VBox headerVBox = new VBox();
        headerVBox.setMinHeight(100.0);
        headerVBox.setMaxHeight(100.0);
        HBox searchBox = new HBox();
        searchBox.setAlignment(Pos.CENTER_LEFT);
        TextFieldWithSearch textFieldWithSearch = new TextFieldWithSearch();
        textFieldWithSearch.setBackgroundColor(ClientSingleton.getInstance().getStyleValue(Constants.BASE_COLOR));
        textFieldWithSearch.setTextFontColor(ClientSingleton.getInstance().getStyleValue(Constants.CALLS_PANES_AND_SEARCH_TEXT_FILL));
        textFieldWithSearch.addListener((ChangeListener<? super String>)((ChangeListener)(observable, oldValue, newValue) -> {
            if (oldValue.isEmpty() && newValue.isEmpty()) {
                return;
            }
            this.searchContact((String)newValue);
        }));
        PublishSubject inputedText = PublishSubject.create();
        inputedText.observeOn(UpdateLists.scheduler).debounce(200L, TimeUnit.MILLISECONDS).switchMap(input -> {
            List<Activity> list = this.searchContact((String)input);
            if (list == null) {
                return Observable.empty();
            }
            return Observable.just(list);
        }).observeOn((Scheduler)JavaFxScheduler.platform()).doOnError(throwable -> {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "ERROR12378");
            throwable.printStackTrace();
        }).subscribe(list -> this.setActivities((List<Activity>)list));
        JavaFxObservable.valuesOf((ObservableValue)textFieldWithSearch.getTextProperty()).subscribe((Observer)inputedText);
        textFieldWithSearch.setPromptText("filter");
        textFieldWithSearch.setTextWidth(this.withExitButton ? 280 : 270);
        textFieldWithSearch.setWithSearch(true);
        searchBox.getChildren().add((Object)textFieldWithSearch);
        searchBox.setPadding(new Insets(10.0, 5.0, 0.0, 0.0));
        HBox.setMargin((Node)textFieldWithSearch, (Insets)new Insets(0.0, 12.0, 0.0, 12.0));
        if (this.withExitButton) {
            HBox closeBox = new HBox();
            searchBox.getChildren().add((Object)closeBox);
            VBox.setVgrow((Node)closeBox, (Priority)Priority.ALWAYS);
            VBox.setVgrow((Node)searchBox, (Priority)Priority.ALWAYS);
            closeBox.setMinWidth(20.0);
            closeBox.setAlignment(Pos.CENTER_RIGHT);
            CloseImageButton closeImageButton = new CloseImageButton();
            closeImageButton.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.iOnCloseViewer.onCloseViewer()));
            closeBox.getChildren().add((Object)closeImageButton);
        }
        headerVBox.requestFocus();
        HBox comboBox = new HBox();
        comboBox.setMinHeight(40.0);
        comboBox.setMaxHeight(40.0);
        comboBox.setAlignment(Pos.CENTER);
        HBox.setHgrow((Node)comboBox, (Priority)Priority.ALWAYS);
        HBox.setMargin((Node)comboBox, (Insets)new Insets(5.0, 0.0, 5.0, 0.0));
        this.getUserComboBox();
        VBox.setMargin((Node)comboBox, (Insets)new Insets(5.0, 12.0, 5.0, 12.0));
        comboBox.getChildren().add((Object)this.usersComboBox);
        HBox dummy = new HBox();
        HBox.setHgrow((Node)dummy, (Priority)Priority.ALWAYS);
        comboBox.getChildren().add((Object)dummy);
        this.getDatesComboBox();
        comboBox.getChildren().add((Object)this.datesComboBox);
        headerVBox.getChildren().add((Object)searchBox);
        headerVBox.getChildren().add((Object)comboBox);
        VBox.setMargin((Node)headerVBox, (Insets)new Insets(0.0, 0.0, 8.0, 0.0));
        return headerVBox;
    }

    private List<Activity> searchContact(String str) {
        if (str.isEmpty()) {
            return this.setUserFilter(ClientSingleton.getInstance().getString("activity_all_users"), true);
        }
        return this.setUserFilter(str, false);
    }

    private void getUserComboBox() {
        this.usersComboBox = MyContextComboBox.getInstance().setBackgroundColor(ClientSingleton.getInstance().getStyleValue(Constants.BASE_COLOR)).setArrowPosition(Pos.CENTER_RIGHT).setWidth(100).setRoundedCorners(true).build();
        this.usersComboBox.setElementId("usersComboBox");
    }

    private void getDatesComboBox() {
        this.datesComboBox = MyContextComboBox.getInstance().setBackgroundColor(ClientSingleton.getInstance().getStyleValue(Constants.BASE_COLOR)).setArrowPosition(Pos.CENTER_RIGHT).setWidth(100).setRoundedCorners(true).build();
        this.datesComboBox.setElementId("datesComboBox");
        String item0 = ClientSingleton.getInstance().getString("activity_all");
        ArrayList<String> list = new ArrayList<String>();
        list.add(item0);
        list.add(ClientSingleton.getInstance().getString("activity_today"));
        list.add(ClientSingleton.getInstance().getString("activity_yesterday"));
        list.add(ClientSingleton.getInstance().getString("activity_last7"));
        list.add(ClientSingleton.getInstance().getString("activity_last30"));
        list.add(ClientSingleton.getInstance().getString("activity_last60"));
        this.datesComboBox.addItemsListToMenu(list, (title, index) -> this.setDateFilter(index));
        this.datesComboBox.setSelectedItem(item0);
    }

    private List<Activity> setUserFilter(String owner) {
        return this.setUserFilter(owner, true);
    }

    private List<Activity> setUserFilter(String owner, boolean withEquals) {
        ArrayList<Activity> list = new ArrayList<Activity>();
        List activities = this.contactInfo.getActivities();
        String item0 = ClientSingleton.getInstance().getString("activity_all_users");
        if (owner.equals(item0)) {
            TimerExecutor.getInstance().startInGUI(() -> this.addAllActivities(activities));
            return null;
        }
        for (Activity activity : activities) {
            boolean add;
            boolean bl = add = withEquals ? activity.getOwnerName().equals(owner) : activity.getOwnerName().contains(owner);
            if (!add && activity.getSubject() != null) {
                boolean bl2 = add = withEquals ? activity.getSubject().equals(owner) : activity.getSubject().contains(owner);
            }
            if (!add || !this.addActivityWithDeepCheck(activity)) continue;
            list.add(activity);
        }
        return list;
    }

    private void setDateFilter(int mode) {
        ArrayList<Activity> list = new ArrayList<Activity>();
        List activities = this.contactInfo.getActivities();
        VBox mainScrollPane = new VBox();
        if (mode == 0) {
            this.addAllActivities(activities);
        } else if (mode == 2) {
            for (Activity activity : activities) {
                if (!this.deepCheck(activity) || !this.addActivityWithOwnerCheck(activity)) continue;
                list.add(activity);
            }
            this.setActivities(list);
        } else {
            long deep = this.getDeepCheck(mode);
            for (Activity activity : activities) {
                if (deep >= activity.getTimestart() || !this.addActivityWithOwnerCheck(activity)) continue;
                list.add(activity);
            }
            this.setActivities(list);
        }
    }

    private boolean addActivityWithDeepCheck(Activity activity) {
        return this.deepCheck(activity);
    }

    private boolean deepCheck(Activity activity) {
        int dateSelectedIndex = this.datesComboBox.getSelectedIndex();
        if (dateSelectedIndex == 2) {
            return this.deepCheck2(activity);
        }
        if (dateSelectedIndex > 0) {
            long deep = this.getDeepCheck(dateSelectedIndex);
            return deep < activity.getTimestart();
        }
        return true;
    }

    private boolean deepCheck2(Activity activity) {
        LocalDateTime localDate = LocalDate.now().atTime(LocalTime.MIN);
        long deep = localDate.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        long deep1 = localDate.minusDays(1L).atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
        return deep1 < activity.getTimestart() && activity.getTimestart() < deep;
    }

    private boolean addActivityWithOwnerCheck(Activity activity) {
        return this.ownerCheck(activity);
    }

    private boolean ownerCheck(Activity activity) {
        int userSelectedIndex = this.usersComboBox.getSelectedIndex();
        if (userSelectedIndex > 0) {
            String owner = this.usersComboBox.getSelectedItem();
            return owner.equals(activity.getOwnerName());
        }
        return true;
    }

    private boolean addActivityWithCheck(Activity activity) {
        return this.deepCheck(activity) && this.ownerCheck(activity);
    }

    private long getDeepCheck(int mode) {
        LocalDateTime localDate = LocalDateTime.now();
        switch (mode) {
            case 1: {
                localDate = LocalDate.now().atTime(LocalTime.MIN);
                break;
            }
            case 3: {
                localDate = localDate.minusDays(7L);
                break;
            }
            case 4: {
                localDate = localDate.minusDays(30L);
                break;
            }
            case 5: {
                localDate = localDate.minusDays(60L);
            }
        }
        return localDate.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    @Override
    public void scrolling() {
        for (MenuImageButton menuImageButton : this.menuImageButtons) {
            menuImageButton.hideMenu();
        }
    }
}

