/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.callactivity;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.Pair;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.connector.utils.JsonMessageParser;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.threadpool.MyThreadPoolManager;
import net.sipsnet.client.utils.viewers.RichTextViwer.MyTextArea;
import net.sipsnet.client.utils.viewers.buttoncombobox.ContextMenuImageButton;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.CloseImageButton;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButton;
import net.sipsnet.client.utils.viewers.buttons.labelbutton.MyLabelButton;
import net.sipsnet.client.utils.viewers.combobox.IContextMenuActionListener;
import net.sipsnet.client.utils.viewers.combobox.MyContextComboBox;
import net.sipsnet.client.utils.viewers.mylistview.MyListView;
import net.sipsnet.client.utils.viewers.mylistview.internal.IOnScrollAction;
import net.sipsnet.client.views.chat.interfaces.IOnCloseViewer;
import org.json.smile.JSONException;
import smile.cti.client.Activity;
import smile.cti.client.ClientConnector;
import smile.cti.client.ContactInfo;
import smile.cti.client.LineEventListener;
import smile.cti.client.LineInfo;
import smile.cti.client.MessageInfo;
import smile.cti.client.SessionEventListener;
import smile.cti.client.SessionInfo;

public class CallActivityViewController
extends MyListView
implements IOnScrollAction,
IContextMenuActionListener,
SessionEventListener,
LineEventListener {
    private final IOnCloseViewer iOnCloseViewer;
    private final double defaultPanelWidth = 300.0;
    private MyContextComboBox contextMenu;
    private Activity activity;
    private final LineInfo lineInfo;
    private final SessionInfo sessionInfo;
    private MessageInfo messageInfo;
    @FXML
    private Pane fx_AvatarViewPane;
    @FXML
    private Pane fx_CommentsPane;
    @FXML
    private VBox fx_ActivityPane;
    @FXML
    private HBox fx_hbForCloseButton;
    @FXML
    private Label fx_CallType;
    @FXML
    private VBox fx_scrollMainPane;
    @FXML
    private Label fx_CallFrom;
    @FXML
    private VBox fx_InfoPane;
    @FXML
    private Label fx_ContactName;
    @FXML
    private Label fx_ContactNumber;
    @FXML
    private VBox fx_RecordViewPane;
    @FXML
    private Label fx_Purpose;
    @FXML
    private Label fx_Comment;
    @FXML
    private TextField fx_CallTheme;
    @FXML
    private ContextMenuImageButton fx_ThemeList;
    private MyTextArea fx_taComment;
    @FXML
    private ImageButton fx_ivCallType;
    @FXML
    private HBox fx_hbCallTheme;
    @FXML
    private HBox fx_hbComment;
    @FXML
    private MyLabelButton fx_SaveButton;
    @FXML
    private VBox fx_ActivityLinkPane;

    public CallActivityViewController(IOnCloseViewer iOnCloseViewer, LineInfo lineInfo) {
        this(iOnCloseViewer, lineInfo, false);
    }

    public CallActivityViewController(IOnCloseViewer iOnCloseViewer, LineInfo lineInfo, boolean withExitButton) {
        this.iOnCloseViewer = iOnCloseViewer;
        this.lineInfo = lineInfo;
        this.activity = lineInfo.getActivity();
        this.sessionInfo = lineInfo.getSessionInfo();
        this.sessionInfo.addSessionEventListener((SessionEventListener)this);
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fxml/callactivitydetail/callactivitydetail.fxml"));
        loader.setResources(ClientSingleton.getInstance().getResourceBundle());
        loader.setController((Object)this);
        try {
            this.fx_scrollMainPane = (VBox)loader.load();
            loader.setController((Object)this);
            this.initComponents();
            this.setWithMouseDrag();
            this.setId(this.getClass().getSimpleName());
            this.setContent(this.fx_scrollMainPane, this);
            if (withExitButton) {
                HBox closeBox = new HBox();
                closeBox.setAlignment(Pos.CENTER_LEFT);
                HBox.setHgrow((Node)closeBox, (Priority)Priority.ALWAYS);
                this.fx_hbForCloseButton.getChildren().add((Object)closeBox);
                closeBox.setMinWidth(20.0);
                closeBox.setAlignment(Pos.CENTER_RIGHT);
                CloseImageButton closeImageButton = new CloseImageButton();
                closeImageButton.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> {
                    if (this.sessionInfo != null) {
                        this.sessionInfo.removeSessionEventListener((SessionEventListener)this);
                    }
                    lineInfo.removeLineEventListener((LineEventListener)this);
                    iOnCloseViewer.onCloseViewer();
                }));
                closeBox.setPadding(new Insets(0.0, 5.0, 0.0, 0.0));
                closeBox.getChildren().add((Object)closeImageButton);
                this.setAlignment(Pos.CENTER);
                this.removeScrollBar();
            } else {
                this.fx_scrollMainPane.setPadding(new Insets(0.0, 10.0, 0.0, 0.0));
            }
            this.setMinWidth(300.0);
            this.setMaxWidth(300.0);
            this.fx_scrollMainPane.setMinWidth(300.0);
            this.fx_scrollMainPane.setMaxWidth(300.0);
            Theme.getInstance().applyProfilesPaneTo(this.fx_AvatarViewPane);
            Theme.getInstance().applyProfilesPaneTo((Pane)this.fx_RecordViewPane);
            Theme.getInstance().applyProfilesPaneTo((Pane)this.fx_ActivityLinkPane);
            Theme.getInstance().applyProfilesPaneTo(this.fx_CommentsPane);
            Theme.getInstance().applyProfilesPaneTo(this.fx_CommentsPane);
            Theme.getInstance().applyTo(Constants.CONTEXT_MENU, (Pane)this.fx_scrollMainPane, true);
            Theme.getInstance().applyTo(Constants.SCROLL_PANE_SECOND_STYLE, (Pane)this.fx_scrollMainPane);
            Theme.getInstance().applyTo(Constants.TAB_CELL_TEXT_FILL, (Labeled)this.fx_CallType);
            Theme.getInstance().applyTo(Constants.TABS_TITLE_TEXT_FILL, (Labeled)this.fx_ContactName);
            Theme.getInstance().applyTo(Constants.TABS_TITLE_TEXT_FILL, (Labeled)this.fx_ContactNumber);
            Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.fx_Purpose);
            Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.fx_Comment);
            Theme.getInstance().applyTo(Constants.TAB_CELL_DATE_TEXT_FILL, (Labeled)this.fx_CallFrom);
            Theme.getInstance().applyTo(Constants.TAB_CELL_TEXT_FILL, (Control)this.fx_CallTheme);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        lineInfo.addLineEventListener((LineEventListener)this);
    }

    public Pane getNode() {
        return this;
    }

    private void initComponents() {
        String image;
        String message;
        String from;
        this.fx_ActivityPane.prefWidthProperty().bind((ObservableValue)this.fx_scrollMainPane.widthProperty());
        this.fx_ActivityPane.prefHeightProperty().bind((ObservableValue)this.fx_scrollMainPane.heightProperty());
        if (this.lineInfo.isInbound()) {
            from = ClientSingleton.getInstance().getString("call_detail_from");
            message = ClientSingleton.getInstance().getString("call_detail_incoming");
            image = "calldetails/activity_incomingcall_icon.png";
        } else {
            from = ClientSingleton.getInstance().getString("call_detail_to");
            message = ClientSingleton.getInstance().getString("call_detail_outgoing");
            image = "calldetails/activity_outgoingcall_icon.png";
        }
        this.fx_CallType.setText(message);
        this.fx_CallFrom.setText(from);
        this.fx_ivCallType.setImagePath(image);
        Optional<ContactInfo> contactInfo = ClientSingleton.getInstance().getContactInfo(this.lineInfo);
        if (contactInfo.isPresent()) {
            if (!this.fx_InfoPane.getChildren().contains((Object)this.fx_ContactName)) {
                this.fx_InfoPane.getChildren().add(0, (Object)this.fx_ContactName);
            }
            this.fx_ContactName.setText(contactInfo.get().toString());
        } else {
            this.fx_InfoPane.getChildren().remove((Object)this.fx_ContactName);
        }
        this.fx_ContactNumber.setText(this.lineInfo.getPartyNumber().length() < 20 ? this.lineInfo.getPartyNumber() : "");
        String textFieldStyle = "    -fx-background-color: %s;    -fx-border-radius: 15 15 15 15;    -fx-background-radius: 15 15 15 15;";
        this.fx_hbCallTheme.setStyle(Theme.getInstance().formatedString(textFieldStyle, ClientSingleton.getInstance().getStyleValue(Constants.BASE_COLOR)));
        this.fx_ThemeList.setShowNode((Node)this.fx_CallTheme);
        TimerExecutor.getInstance().start(() -> {
            List subjects = ClientSingleton.getInstance().getClientConnector().get().getActivitySubjects(this.lineInfo.getSessionInfo().getStatus() >= 0 ? 0 : 1);
            if (subjects != null && !subjects.isEmpty()) {
                subjects.removeIf(s -> s.trim().isEmpty());
                this.fx_ThemeList.addItemsListToMenu(subjects, this);
            }
        });
        this.initTextArea();
        this.fx_SaveButton.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> {
            if (this.sessionInfo.isExternal()) {
                this.updateActivity(this.fx_CallTheme.getText(), this.fx_taComment.getText());
            } else if (this.lineInfo.getState() == 8 || this.lineInfo.getState() == 18 || this.lineInfo.getState() == 0) {
                this.updateActivity(this.fx_CallTheme.getText(), this.fx_taComment.getText());
            }
        }));
        this.fx_SaveButton.removeMouseListeners();
        this.fx_SaveButton.setButtonLabelText(ClientSingleton.getInstance().getString("save"));
        this.fx_SaveButton.setButtonWidth(-1);
        this.fx_SaveButton.prefWidthProperty().bind((ObservableValue)this.fx_scrollMainPane.widthProperty());
        ClientSingleton.toLog(this.getClass().getSimpleName(), "MyLabelButton initComponent");
        this.fx_SaveButton.setEnabled(false);
        this.fx_CallTheme.textProperty().addListener((observableValue, oldValue, newValue) -> this.setButtonEnabled((String)oldValue, (String)newValue));
        this.fx_CallTheme.setPromptText(ClientSingleton.getInstance().getString("call_detail_prompt"));
        this.fx_taComment.setPromptText(ClientSingleton.getInstance().getString("call_detail_comment_prompt"));
        this.setActivity();
    }

    private void initTextArea() {
        String style = " -fx-background-color: %s;-fx-padding:  5;\n-fx-border-insets:  0;\n-fx-background-insets: 0;\n-fx-text-fill: rgb(69,90,100);\n-fx-font-family:\"Roboto\";\n -fx-font-size: 12px;\n -fx-control-inner-background: #f1f2f5;    -fx-border-radius: 15 15 15 15;    -fx-background-radius: 15 15 15 15;";
        this.fx_hbComment.setStyle(Theme.getInstance().formatedString(style, ClientSingleton.getInstance().getStyleValue(Constants.BASE_COLOR)));
        this.fx_taComment = new MyTextArea("", (Pane)this.fx_hbComment, false);
        this.fx_taComment.setWhiteBackground();
        this.fx_taComment.setEditable(true);
        this.fx_taComment.setPromptText(ClientSingleton.getInstance().getString("call_detail_comment_prompt"));
        this.fx_taComment.setMinHeight(200.0);
        this.fx_hbComment.getChildren().clear();
        this.fx_hbComment.getChildren().add((Object)this.fx_taComment);
        this.fx_hbComment.setMinHeight(210.0);
        this.fx_taComment.getTextProperty().addListener((observableValue, oldValue, newValue) -> this.setButtonEnabled((String)oldValue, (String)newValue));
    }

    private void setButtonEnabled(String oldValue, String newValue) {
        if (!newValue.isEmpty() && !oldValue.equals(newValue) || !this.fx_CallTheme.getText().isEmpty()) {
            this.fx_SaveButton.setEnabled(true);
        } else if (newValue.isEmpty() && this.fx_taComment.getText().isEmpty()) {
            this.fx_SaveButton.setEnabled(false);
        }
    }

    private void setActivity() {
        String comment;
        String subject;
        String string = subject = this.activity.getSubject() == null ? "" : this.activity.getSubject();
        if (!subject.isEmpty()) {
            if (subject.startsWith("{") && subject.contains("\"number\":")) {
                Pair<String, Integer> pair = null;
                try {
                    pair = JsonMessageParser.getMessageString(subject, -1, false);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                subject = pair != null ? (String)pair.getKey() : null;
            }
            if (subject != null) {
                this.fx_CallTheme.setText(subject);
            }
        }
        String string2 = comment = this.activity.getComment() == null ? "" : this.activity.getComment();
        if (!comment.isEmpty()) {
            this.fx_taComment.setText(comment);
        }
        AtomicReference<String> title = new AtomicReference<String>("Pop-up URL");
        String url = this.activity.getApplicationUrl();
        if (url != null) {
            String serviceId = this.activity.getServiceId();
            if (serviceId != null) {
                ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> title.set(clientConnector.getServiceName(serviceId)));
            }
            HashMap<String, String> link = new HashMap<String, String>();
            link.put("url", url);
            link.put("title", title.get());
            link.put("open_url", ClientSingleton.getInstance().getString("open_url"));
            Pane node = ClientSingleton.getInstance().addServiceLocation(link);
            node.prefWidthProperty().bind((ObservableValue)this.fx_ActivityLinkPane.widthProperty());
            this.fx_ActivityLinkPane.getChildren().add(0, (Object)node);
            VBox.setMargin((Node)this.fx_ActivityLinkPane, (Insets)new Insets(0.0, 0.0, 8.0, 0.0));
        } else if (!this.fx_ActivityLinkPane.getChildren().isEmpty()) {
            VBox.setMargin((Node)this.fx_ActivityLinkPane, (Insets)new Insets(0.0, 0.0, 0.0, 0.0));
            this.fx_ActivityLinkPane.getChildren().clear();
        }
    }

    private void updateActivity(String subject, String comment) {
        if (!comment.isEmpty() || !subject.isEmpty()) {
            ClientSingleton.getInstance().runLater(() -> this.fx_CallTheme.setText(subject));
            this.activity.setSubject(subject);
            this.activity.setComment(comment);
            MyThreadPoolManager.getInstance().execute(() -> {
                Optional<ClientConnector> optionalClientConnector = ClientSingleton.getInstance().getClientConnector();
                if (optionalClientConnector.isPresent()) {
                    try {
                        optionalClientConnector.get().updateActivity(this.activity);
                        if (this.messageInfo != null) {
                            ClientSingleton.getInstance().getMainViewModel().onMessageUpdated(this.sessionInfo, this.messageInfo);
                        }
                        ClientSingleton.toLog(this.getClass().getSimpleName(), "updateActivity from form activity=" + this.activity);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.fx_SaveButton.setEnabled(false);
                }
            });
        }
        if (this.sessionInfo != null) {
            this.sessionInfo.removeSessionEventListener((SessionEventListener)this);
        }
    }

    public void sessionEvent(int i, SessionInfo sessionInfo) {
    }

    public void messagesLoaded(List<MessageInfo> list, SessionInfo sessionInfo) {
    }

    public void messageReceived(MessageInfo messageInfo, SessionInfo sessionInfo) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "messageReceived messageInfo.getType()=" + messageInfo.getType());
        if (messageInfo.getType() == 8) {
            Activity act = messageInfo.getActivity();
            if (this.activity == null || this.activity.getTimestart() == 0L || act.getTimestart() == this.activity.getTimestart()) {
                this.messageInfo = messageInfo;
                this.activity = act;
                this.setActivity();
            }
        }
        if (sessionInfo != null) {
            sessionInfo.removeSessionEventListener((SessionEventListener)this);
        }
    }

    public void messageUpdated(MessageInfo messageInfo, SessionInfo sessionInfo) {
    }

    public void messageRemoved(MessageInfo messageInfo, SessionInfo sessionInfo) {
    }

    @Override
    public void scrolling() {
    }

    @Override
    public void actionPerformed(String title, int index) {
        this.fx_CallTheme.setText(title);
    }

    public void stateChanged(LineInfo lineInfo) {
        if (lineInfo.getState() == 8 || lineInfo.getState() == 18 || lineInfo.getState() == 0) {
            this.fx_SaveButton.setEnabled(true);
        }
        lineInfo.removeLineEventListener((LineEventListener)this);
    }

    public void identityChanged(LineInfo lineInfo) {
    }

    public void setRecording(LineInfo lineInfo, boolean b) {
    }

    public void setMaxWidth(int defaultPanelWidth) {
        this.fx_scrollMainPane.setMaxWidth((double)(defaultPanelWidth + 5));
        this.fx_scrollMainPane.setMinWidth((double)(defaultPanelWidth + 5));
        this.setMaxWidth(defaultPanelWidth);
        this.setMinWidth(defaultPanelWidth);
    }

    public void removeSessionInfoListener() {
        if (this.sessionInfo != null) {
            this.sessionInfo.removeSessionEventListener((SessionEventListener)this);
        }
    }
}

