/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.calldetails;

import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.rxjavafx.schedulers.JavaFxScheduler;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicReference;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.Pair;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.connector.utils.JsonMessageParser;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.threadpool.MyThreadPoolManager;
import net.sipsnet.client.utils.viewers.RichTextViwer.MyTextArea;
import net.sipsnet.client.utils.viewers.buttoncombobox.ContextMenuImageButton;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButton;
import net.sipsnet.client.utils.viewers.buttons.labelbutton.MyLabelButton;
import net.sipsnet.client.utils.viewers.combobox.IContextMenuActionListener;
import net.sipsnet.client.utils.viewers.mylistview.MyListView;
import net.sipsnet.client.utils.viewers.mylistview.internal.IOnScrollAction;
import net.sipsnet.client.views.chat.holders.viewerholders.callviewer.CallViewerBase;
import net.sipsnet.client.views.chat.interfaces.IOnCloseViewer;
import net.sipsnet.client.views.chat.messageutil.MessageInfoCellLabels;
import net.sipsnet.client.views.tabs.UpdateLists;
import org.json.smile.JSONException;
import smile.cti.client.Activity;
import smile.cti.client.ClientConnector;
import smile.cti.client.ContactInfo;
import smile.cti.client.MessageInfo;
import smile.cti.client.SessionInfo;

public class CallDetailsViewController
extends MyListView
implements IOnScrollAction,
IContextMenuActionListener {
    private final MessageInfo messageInfo;
    private final IOnCloseViewer iOnCloseViewer;
    private final String textFieldStyle = "    -fx-background-color: %s;    -fx-border-radius: 15 15 15 15;    -fx-background-radius: 15 15 15 15;";
    private CallViewerBase callViewerBase;
    @FXML
    private Label fx_CallType;
    @FXML
    private VBox fx_scrollMainPane;
    @FXML
    private Label fx_DateLabel;
    @FXML
    private Label fx_TimeLabel;
    @FXML
    private Label fx_CallFrom;
    @FXML
    private VBox fx_InfoPane;
    @FXML
    private Label fx_ContactName;
    @FXML
    private Label fx_ContactNumber;
    @FXML
    private VBox fx_RecordViewPane;
    @FXML
    private VBox fx_AvatarViewPane;
    @FXML
    private Label fx_Purpose;
    @FXML
    private Label fx_Comment;
    @FXML
    private TextField fx_CallTheme;
    @FXML
    private ContextMenuImageButton fx_ThemeList;
    private MyTextArea fx_taComment;
    @FXML
    private ImageButton fx_ivCallType;
    @FXML
    private HBox fx_hbCallTheme;
    @FXML
    private VBox fx_hbComment;
    @FXML
    private MyLabelButton fx_SaveButton;
    @FXML
    private VBox fx_CommentsPane;
    @FXML
    private VBox fx_ActivityLinkPane;

    public CallDetailsViewController(ResourceBundle resourceBundle, MessageInfo messageInfo, IOnCloseViewer iOnCloseViewer) {
        this.messageInfo = messageInfo;
        this.iOnCloseViewer = iOnCloseViewer;
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fxml/calldetails/calldetails.fxml"));
        loader.setResources(resourceBundle);
        loader.setController((Object)this);
        try {
            this.fx_scrollMainPane = (VBox)loader.load();
            loader.setController((Object)this);
            this.initComponents();
            this.setWithMouseDrag();
            this.setId(this.getClass().getSimpleName());
            this.setContent(this.fx_scrollMainPane, this);
            Theme.getInstance().applyProfilesPaneTo((Pane)this.fx_AvatarViewPane);
            Theme.getInstance().applyProfilesPaneTo((Pane)this.fx_RecordViewPane);
            Theme.getInstance().applyProfilesPaneTo((Pane)this.fx_ActivityLinkPane);
            Theme.getInstance().applyProfilesPaneTo((Pane)this.fx_CommentsPane);
            Theme.getInstance().applyTo(Constants.CONTEXT_MENU, (Pane)this.fx_scrollMainPane, true);
            Theme.getInstance().applyTo(Constants.SCROLL_PANE_SECOND_STYLE, (Pane)this.fx_scrollMainPane);
            Theme.getInstance().applyTo(Constants.TAB_CELL_TEXT_FILL, (Labeled)this.fx_CallType);
            Theme.getInstance().applyTo(Constants.TABS_TITLE_TEXT_FILL, (Labeled)this.fx_ContactName);
            Theme.getInstance().applyTo(Constants.TABS_TITLE_TEXT_FILL, (Labeled)this.fx_ContactNumber);
            Theme.getInstance().applyTo(Constants.TAB_CELL_DATE_TEXT_FILL, (Labeled)this.fx_DateLabel);
            Theme.getInstance().applyTo(Constants.TAB_CELL_DATE_TEXT_FILL, (Labeled)this.fx_TimeLabel);
            Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.fx_Purpose);
            Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.fx_Comment);
            Theme.getInstance().applyTo(Constants.TAB_CELL_DATE_TEXT_FILL, (Labeled)this.fx_CallFrom);
            Theme.getInstance().applyTo(Constants.TAB_CELL_TEXT_FILL, (Control)this.fx_CallTheme);
            String style = "-fx-background-color: %s;    -fx-border-radius: 15 15 15 15;    -fx-background-radius: 15 15 15 15;";
            this.fx_hbComment.setStyle(Theme.getInstance().formatedString(style, ClientSingleton.getInstance().getStyleValue(Constants.BASE_COLOR)));
            this.setId("CallDetailsViewController");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Node getNode() {
        return this;
    }

    private void initComponents() {
        String recordFile;
        String image;
        String message;
        String from;
        ClientSingleton.toLog(this.getClass().getSimpleName(), "messageInfo=" + this.messageInfo + " content=" + this.messageInfo.getContent());
        if (this.messageInfo.getStatus() == 5 || this.messageInfo.getStatus() == 13) {
            from = ClientSingleton.getInstance().getString("call_detail_from");
            message = ClientSingleton.getInstance().getString("call_detail_incoming");
            image = "calldetails/activity_incomingcall_icon.png";
        } else {
            from = ClientSingleton.getInstance().getString("call_detail_to");
            message = ClientSingleton.getInstance().getString("call_detail_outgoing");
            image = "calldetails/activity_outgoingcall_icon.png";
        }
        this.fx_CallType.setText(message);
        this.fx_CallFrom.setText(from);
        this.fx_ivCallType.setImagePath(image);
        String number = MessageInfoCellLabels.setContentLabel(this.messageInfo);
        ClientSingleton.toLog(this.getClass().getSimpleName(), "number=" + number);
        if (number.contains(ClientSingleton.getInstance().getString("call_from"))) {
            number = number.replace(ClientSingleton.getInstance().getString("call_from"), "").trim();
        }
        if (number.contains(ClientSingleton.getInstance().getString("call_to"))) {
            number = number.replace(ClientSingleton.getInstance().getString("call_to"), "").trim();
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "message=" + message + " from=" + from + " number=" + number);
        this.fx_hbCallTheme.setStyle(Theme.getInstance().formatedString("    -fx-background-color: %s;    -fx-border-radius: 15 15 15 15;    -fx-background-radius: 15 15 15 15;", ClientSingleton.getInstance().getStyleValue(Constants.BASE_COLOR)));
        Activity activity = this.messageInfo.getActivity();
        this.fx_CallTheme.setPromptText(ClientSingleton.getInstance().getString("call_detail_prompt"));
        String subject = activity.getSubject();
        if (subject != null) {
            if (subject.startsWith("{") && subject.contains("\"number\":")) {
                Pair<String, Integer> pair = null;
                try {
                    pair = JsonMessageParser.getMessageString(subject, -1, false);
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
                subject = pair != null ? (String)pair.getKey() : null;
            }
            if (subject != null) {
                this.fx_CallTheme.setText(subject);
            }
        }
        if ((recordFile = this.messageInfo.getActivity().getFile()) != null && !recordFile.isEmpty()) {
            Label myLabel = new Label();
            VBox.setMargin((Node)myLabel, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
            myLabel.setPrefHeight(25.0);
            myLabel.setText(ClientSingleton.getInstance().getString("call_detail_comment_recording"));
            Theme.getInstance().applyTo(Constants.TAB_CELL_TEXT_FILL, (Labeled)myLabel);
            HBox recordBox = new HBox();
            recordBox.setAlignment(Pos.CENTER);
            ImageButton imageButton = new ImageButton();
            imageButton.setBackgroundColor("transparent");
            imageButton.setSize(20, 20);
            imageButton.setImagePath("calldetails/download.png");
            imageButton.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> ClientSingleton.getInstance().saveCallRecordFile(recordFile)));
            this.callViewerBase = new CallViewerBase(this.messageInfo);
            HBox.setHgrow((Node)this.callViewerBase, (Priority)Priority.ALWAYS);
            recordBox.getChildren().addAll((Object[])new Node[]{this.callViewerBase, imageButton});
            VBox.setMargin((Node)this.fx_RecordViewPane, (Insets)new Insets(10.0, 0.0, 10.0, 0.0));
            Theme.getInstance().applyProfilesPaneTo((Pane)this.fx_RecordViewPane);
            VBox.setMargin((Node)recordBox, (Insets)new Insets(0.0, 10.0, 0.0, 15.0));
            VBox.setMargin((Node)this.fx_RecordViewPane, (Insets)new Insets(0.0, 10.0, 8.0, 0.0));
            this.fx_RecordViewPane.setPadding(new Insets(10.0, 0.0, 10.0, 0.0));
            this.fx_RecordViewPane.getChildren().addAll((Object[])new Node[]{myLabel, recordBox});
            recordBox.prefWidthProperty().bind((ObservableValue)this.fx_RecordViewPane.widthProperty());
        }
        AtomicReference<String> title = new AtomicReference<String>("Pop-up URL");
        String url = activity.getApplicationUrl();
        String serviceId = activity.getServiceId();
        ClientSingleton.toLog(this.getClass().getSimpleName(), "activity url=[" + url + "] serviceId=" + serviceId);
        if (url != null && !url.isEmpty()) {
            if (serviceId != null) {
                ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "activity clientConnector.getServiceName(serviceId)=" + clientConnector.getServiceName(serviceId));
                    title.set(clientConnector.getServiceName(serviceId));
                });
            }
            if (title.get() != null) {
                HashMap<String, String> link = new HashMap<String, String>();
                link.put("url", url);
                link.put("title", title.get());
                link.put("open_url", ClientSingleton.getInstance().getString("open_url"));
                Pane node = ClientSingleton.getInstance().addServiceLocation(link);
                node.prefWidthProperty().bind((ObservableValue)this.fx_ActivityLinkPane.widthProperty());
                this.fx_ActivityLinkPane.getChildren().add(0, (Object)node);
                VBox.setMargin((Node)this.fx_ActivityLinkPane, (Insets)new Insets(0.0, 10.0, 8.0, 0.0));
            } else if (!this.fx_ActivityLinkPane.getChildren().isEmpty()) {
                VBox.setMargin((Node)this.fx_ActivityLinkPane, (Insets)new Insets(0.0, 0.0, 0.0, 0.0));
                this.fx_ActivityLinkPane.getChildren().clear();
            }
        } else if (!this.fx_ActivityLinkPane.getChildren().isEmpty()) {
            VBox.setMargin((Node)this.fx_ActivityLinkPane, (Insets)new Insets(0.0, 0.0, 0.0, 0.0));
            this.fx_ActivityLinkPane.getChildren().clear();
        }
        this.fx_ThemeList.setShowNode((Node)this.fx_CallTheme);
        this.initTextArea(activity);
        this.fx_SaveButton.setButtonLabelText(ClientSingleton.getInstance().getString("save"));
        this.fx_SaveButton.setButtonWidth(-1);
        this.fx_SaveButton.prefWidthProperty().bind((ObservableValue)this.fx_CommentsPane.widthProperty());
        this.fx_SaveButton.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.updateActivity(this.fx_CallTheme.getText(), this.fx_taComment.getText())));
        this.fx_SaveButton.setEnabled(false);
        this.fx_CallTheme.textProperty().addListener((observableValue, oldValue, newValue) -> this.setButtonEnabled((String)oldValue, (String)newValue));
        this.fx_TimeLabel.setText(ClientSingleton.getInstance().getTimeLabel(this.messageInfo.getTime()));
        this.fx_DateLabel.setText(ClientSingleton.getInstance().getDateLabel(this.messageInfo.getTime()));
        Optional<SessionInfo> optionalSessionInfo = ClientSingleton.getInstance().getSessionInfo(this.messageInfo.getSessionId());
        if (optionalSessionInfo.isPresent()) {
            SessionInfo sessionInfo = optionalSessionInfo.get();
            this.fx_ContactName.setText(sessionInfo.toString());
            if (number.endsWith(this.fx_ContactName.getText())) {
                if (sessionInfo.getParties().size() == 1) {
                    ContactInfo contactInfo = (ContactInfo)sessionInfo.getParties().get(0);
                    Optional<String> ext = Optional.ofNullable(Optional.ofNullable((String)contactInfo.getProperty("extension")).orElse((String)contactInfo.getProperty("ext")));
                    if (ext.isPresent()) {
                        this.fx_ContactNumber.setText(ext.get());
                    } else {
                        this.fx_ContactNumber.setText("");
                    }
                } else {
                    this.fx_ContactNumber.setText("");
                }
            } else if (sessionInfo.getParties().size() == 1 && ClientSingleton.getInstance().isChatWithTrunks()) {
                String num = number.replace(ClientSingleton.getInstance().getString("call_to_with_trunk") + " ", "");
                ClientSingleton.toLog(this.getClass().getSimpleName(), "num=" + num);
                ContactInfo contactInfo = (ContactInfo)sessionInfo.getParties().get(0);
                Optional<String> ext = Optional.ofNullable(Optional.ofNullable((String)contactInfo.getProperty("extension")).orElse((String)contactInfo.getProperty("ext")));
                if (ext.isPresent() && num.equals(ext.get())) {
                    this.fx_ContactNumber.setText(ext.get());
                } else {
                    this.fx_ContactNumber.setText(number);
                }
            } else {
                this.fx_ContactNumber.setText(number);
            }
            Observable.just((Object)true).observeOn(UpdateLists.scheduler).doOnError(Throwable::printStackTrace).flatMap(bl -> {
                List subjects = ClientSingleton.getInstance().getClientConnector().get().getActivitySubjects(sessionInfo.getStatus() >= 0 ? 0 : 1);
                if (subjects == null || subjects.isEmpty()) {
                    return Observable.empty();
                }
                return Observable.just((Object)subjects);
            }).observeOn((Scheduler)JavaFxScheduler.platform()).subscribe(subjects -> this.fx_ThemeList.addItemsListToMenu((List<?>)subjects, this));
        }
        if (this.fx_ContactName.getText().equals(this.fx_ContactNumber.getText())) {
            this.fx_ContactNumber.setText("");
        }
    }

    public void stopPlaying() {
        if (this.callViewerBase != null) {
            this.callViewerBase.stopPlayback();
        }
    }

    private void initTextArea(Activity activity) {
        String style = " -fx-background-color: %s;-fx-padding:  5;\n-fx-border-insets:  0;\n-fx-background-insets: 0;\n-fx-text-fill: rgb(69,90,100);\n-fx-font-family:\"Roboto\";\n -fx-font-size: 12px;\n -fx-control-inner-background: #f1f2f5;    -fx-border-radius: 15 15 15 15;    -fx-background-radius: 15 15 15 15;";
        this.fx_hbComment.setStyle(Theme.getInstance().formatedString(style, ClientSingleton.getInstance().getStyleValue(Constants.BASE_COLOR)));
        this.fx_taComment = new MyTextArea("", (Pane)this.fx_hbComment, false);
        this.fx_taComment.setWhiteBackground();
        this.fx_taComment.setEditable(true);
        this.fx_taComment.setText(activity.getComment() == null ? "" : activity.getComment());
        this.fx_taComment.setPromptText(ClientSingleton.getInstance().getString("call_detail_comment_prompt"));
        this.fx_taComment.setMinHeight(200.0);
        this.fx_hbComment.getChildren().clear();
        this.fx_hbComment.getChildren().add((Object)this.fx_taComment);
        this.fx_hbComment.setMinHeight(210.0);
        this.fx_taComment.getTextProperty().addListener((observableValue, oldValue, newValue) -> this.setButtonEnabled((String)oldValue, (String)newValue));
    }

    private void setButtonEnabled(String oldValue, String newValue) {
        if (!newValue.isEmpty() && !oldValue.equals(newValue) || !this.fx_CallTheme.getText().isEmpty()) {
            this.fx_SaveButton.setEnabled(true);
        } else if (newValue.isEmpty() && this.fx_taComment.getText().isEmpty()) {
            this.fx_SaveButton.setEnabled(false);
        }
    }

    private void updateActivity(String subject, String comnt) {
        if (!comnt.isEmpty() || !subject.isEmpty()) {
            ClientSingleton.getInstance().addLoadingPane(ClientSingleton.getInstance().getString("activity_save"));
            this.fx_CallTheme.setText(subject);
            String comment = comnt;
            MyThreadPoolManager.getInstance().execute(() -> {
                Activity activity = this.messageInfo.getActivity();
                activity.setSubject(subject);
                activity.setComment(comment);
                Optional<ClientConnector> optionalClientConnector = ClientSingleton.getInstance().getClientConnector();
                if (optionalClientConnector.isPresent()) {
                    try {
                        optionalClientConnector.get().updateActivity(activity);
                        ClientSingleton.getInstance().getSessionInfo(this.messageInfo.getSessionId()).ifPresent(sessionInfo -> ClientSingleton.getInstance().getMainViewModel().onMessageUpdated((SessionInfo)sessionInfo, this.messageInfo));
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    ClientSingleton.getInstance().removeLoadingPane();
                    this.fx_SaveButton.setEnabled(false);
                }
            });
        }
    }

    @Override
    public void scrolling() {
    }

    @Override
    public void actionPerformed(String title, int index) {
        this.fx_CallTheme.setText(title);
    }
}

