/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.calls.audiocallnotification;

import javafx.animation.FadeTransition;
import javafx.scene.Node;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.stage.Stage;
import javafx.util.Duration;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.views.calls.audiocallnotification.CallBasePane;
import net.sipsnet.client.views.calls.audiocallnotification.CallBigNotificationPane;
import net.sipsnet.client.views.calls.audiocallnotification.CallIncomingNotificationPane;
import net.sipsnet.client.views.calls.audiocallnotification.CallSmallNotificationPane;
import net.sipsnet.client.views.calls.audiocallnotification.ICallNotificationPaneResize;
import net.sipsnet.client.views.mainview.ringtonemode.IRingtoneMuteState;
import smile.cti.client.LineInfo;

public class CallLineNotification
extends HBox {
    private final IRingtoneMuteState iRingtoneMuteState;
    private CallSmallNotificationPane outgoingCallPane;
    private CallBasePane incomingCallPane;
    private CallBigNotificationPane connectedBigCallPane;
    private final LineInfo lineInfo;
    private final Stage stage;
    private final ICallNotificationPaneResize iCallNotificationPaneResize;

    public CallBigNotificationPane getConnectedBigCallPane() {
        if (this.connectedBigCallPane == null) {
            this.connectedBigCallPane = new CallBigNotificationPane(this.stage, this.lineInfo, this.iCallNotificationPaneResize);
        }
        return this.connectedBigCallPane;
    }

    public CallLineNotification(Stage stage, LineInfo lineInfo, ICallNotificationPaneResize iCallNotificationPaneResize, IRingtoneMuteState iRingtoneMuteState) {
        this.lineInfo = lineInfo;
        this.stage = stage;
        this.iCallNotificationPaneResize = iCallNotificationPaneResize;
        this.iRingtoneMuteState = iRingtoneMuteState;
    }

    public LineInfo getLineInfo() {
        return this.lineInfo;
    }

    public void switchCallLinePane() {
        ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "switchCallLinePane lineInfo=" + this.lineInfo + " lineInfo.getState()=" + this.lineInfo.getState());
        if (this.lineInfo.getState() != 0 && this.lineInfo.getState() != 8 && this.lineInfo.getState() != 18) {
            Pane pane = null;
            if (this.lineInfo.getState() == 2 || this.lineInfo.getState() == 1) {
                if (this.lineInfo.getState() == 2 && CallBasePane.getCallViewNotificationMode() != 0) {
                    pane = this.getCurrentView().setLineInfoParameters();
                } else if (this.lineInfo.getState() == 1) {
                    pane = this.getCurrentView().setLineInfoParameters();
                }
            } else {
                pane = this.getCurrentView().setLineInfoParameters();
            }
            if (pane == null) {
                this.getConnectedBigCallPane().clearTimer();
                this.getChildren().clear();
                return;
            }
            if (this.getChildren().isEmpty()) {
                this.setOpacity(0.0);
            }
            this.getChildren().clear();
            this.getChildren().add((Object)pane);
            this.getCurrentView().setBackgroundColor(this.lineInfo.getState() == 4);
            this.layout();
            if (this.getOpacity() != 1.0) {
                FadeTransition ft = new FadeTransition(Duration.millis((double)300.0), (Node)this);
                ft.setOnFinished(event -> this.setOpacity(1.0));
                ft.setFromValue(0.0);
                ft.setToValue(1.0);
                ft.play();
            }
            this.getConnectedBigCallPane().setLineInfoParameters();
        } else {
            this.getConnectedBigCallPane().clearTimer();
            this.getChildren().clear();
        }
    }

    public void onMute() {
        this.getConnectedBigCallPane().onMute();
    }

    public void onHoldCall() {
        this.getConnectedBigCallPane().setBackgroundColor(this.getLineInfo().getState() == 4);
        if (!this.getChildren().isEmpty()) {
            ((CallBasePane)((Object)this.getChildren().get(0))).setCurrentSize();
        }
    }

    public void onRecordCall(LineInfo lineInfo, boolean isRecording) {
        this.getConnectedBigCallPane().onRecordCall(lineInfo, isRecording);
    }

    public void hidePopupWindows() {
        this.getConnectedBigCallPane().onHidePane();
    }

    public int getNodeHeight() {
        return this.getCurrentView().getNodeHeight();
    }

    public boolean isActiveState() {
        return this.lineInfo.getState() != 0 && this.lineInfo.getState() != 8 && this.lineInfo.getState() != 18;
    }

    public int getNodeWidth() {
        return this.getCurrentView().getNodeWidth();
    }

    private CallBasePane getCurrentView() {
        CallBasePane pane;
        switch (this.lineInfo.getState()) {
            case 1: 
            case 15: {
                pane = this.getOutgoingPane();
                break;
            }
            case 2: {
                pane = this.getIncomingPane();
                break;
            }
            default: {
                pane = this.getConnectedBigCallPane();
            }
        }
        return pane;
    }

    private CallBasePane getIncomingPane() {
        if (this.incomingCallPane == null) {
            this.incomingCallPane = new CallIncomingNotificationPane(this.stage, this.lineInfo, this.iCallNotificationPaneResize, this.iRingtoneMuteState);
        }
        return this.incomingCallPane;
    }

    private CallSmallNotificationPane getOutgoingPane() {
        if (this.outgoingCallPane == null) {
            this.outgoingCallPane = new CallSmallNotificationPane(this.stage, this.lineInfo, this.iCallNotificationPaneResize);
            this.outgoingCallPane.setSmallOutcomePane();
        }
        return this.outgoingCallPane;
    }

    public String toString() {
        return (this.getChildren().isEmpty() ? ((Object)((Object)this)).getClass().getSimpleName() : this.getChildren().get(0)) + " size=" + this.getNodeWidth() + "x" + this.getNodeHeight();
    }

    public void init() {
        ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "First lineInfo init : " + this.lineInfo);
        this.connectedBigCallPane = new CallBigNotificationPane(this.stage, this.lineInfo, this.iCallNotificationPaneResize);
        if (CallBasePane.getCallViewNotificationMode() == 1) {
            this.getIncomingPane();
        }
    }

    public void setRingtoneMuteState() {
        if (this.incomingCallPane != null) {
            this.incomingCallPane.setRingtoneMuteState();
        }
    }
}

