/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.calls.audiocallnotification;

import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.rxjavafx.schedulers.JavaFxScheduler;
import io.reactivex.subjects.PublishSubject;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.Rectangle2D;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import javafx.util.Duration;
import javafx.util.Pair;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.utils.AudioCaller;
import net.sipsnet.client.connector.utils.ClientUtil;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.stage.ResizeHelper;
import net.sipsnet.client.views.calls.audiocallnotification.CallBasePane;
import net.sipsnet.client.views.calls.audiocallnotification.CallLineNotification;
import net.sipsnet.client.views.calls.audiocallnotification.ICallNotificationPaneResize;
import net.sipsnet.client.views.calls.audiocallnotification.inoutcall.CallInOutNotificationStage;
import net.sipsnet.client.views.calls.videocall.IVideoProcessor;
import net.sipsnet.client.views.calls.videocall.notification.VideoNotificationPane;
import net.sipsnet.client.views.mainview.ringtonemode.IRingtoneMuteState;
import net.sipsnet.client.views.tabs.UpdateLists;
import net.sipsnet.client.views.tabs.utils.ICheckNewMessagesNotification;
import smile.cti.client.LineInfo;

public class CallNotificationPane
implements ICallNotificationPaneResize {
    private final Stage mainStage;
    private final HBox rootPane;
    private final VideoNotificationPane videoPane;
    private final CallInOutNotificationStage centerIncomingCallPane;
    private final VBox audioCallPane = new VBox();
    private Pane videoRootPane;
    private final SimpleBooleanProperty showing = new SimpleBooleanProperty();
    private ICheckNewMessagesNotification iCheckNewMessagesNotification;
    private double lastPositionX = -5000.0;
    private double lastPositionY = Constants.INVISIBLE_POSITION_Y;
    private PublishSubject<Integer> resizeObserver;
    private Disposable disposableResize;
    private final CompositeDisposable disposables = new CompositeDisposable();
    private double xOffset;
    private double yOffset;

    public CallNotificationPane(IVideoProcessor iVideoProcessor, IRingtoneMuteState iRingtoneMuteState) {
        this.rootPane = this.loadRoot();
        this.audioCallPane.prefWidthProperty().bind((ObservableValue)this.rootPane.widthProperty());
        this.mainStage = new Stage();
        Scene scene = new Scene((Parent)this.rootPane, 10.0, 10.0);
        scene.setFill((Paint)Color.TRANSPARENT);
        this.mainStage.setScene(scene);
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            for (int i = clientConnector.getLines().size() - 1; i >= 0; --i) {
                LineInfo lineInfo = (LineInfo)clientConnector.getLines().get(i);
                CallLineNotification callLineNotification = new CallLineNotification(this.mainStage, lineInfo, this, iRingtoneMuteState);
                if (i == 0) {
                    callLineNotification.init();
                }
                VBox.setMargin((Node)callLineNotification, (Insets)new Insets(3.0, 0.0, 3.0, 0.0));
                this.audioCallPane.getChildren().add((Object)callLineNotification);
            }
        });
        this.centerIncomingCallPane = new CallInOutNotificationStage(iRingtoneMuteState);
        this.videoPane = new VideoNotificationPane(this.mainStage, iVideoProcessor, this);
        this.mainStage.initStyle(StageStyle.TRANSPARENT);
        this.mainStage.initModality(Modality.NONE);
        Stage primaryStage = new Stage();
        primaryStage.initModality(Modality.NONE);
        primaryStage.initStyle(StageStyle.UTILITY);
        primaryStage.setOpacity(0.0);
        primaryStage.setHeight(0.0);
        primaryStage.setWidth(0.0);
        if (ClientUtil.getOS() == ClientUtil.OS.WINDOWS) {
            primaryStage.show();
        }
        this.mainStage.initOwner((Window)primaryStage);
        this.mainStage.setMinWidth(this.rootPane.minHeight(-1.0));
        this.mainStage.setMinHeight(this.rootPane.minHeight(-1.0));
        this.mainStage.xProperty().addListener((observable, oldValue, newValue) -> {
            this.mainStage.getScene().getRoot().applyCss();
            this.mainStage.getScene().getRoot().layout();
        });
        this.mainStage.setX(-5000.0);
        this.mainStage.setY(Constants.INVISIBLE_POSITION_Y);
        this.showing.addListener((observable, oldValue, newValue) -> {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "ShowCallPane isShowing =" + newValue + " size=" + this.mainStage.getWidth() + "x" + this.mainStage.getHeight() + " at x=" + this.mainStage.getX() + " y=" + this.mainStage.getY() + " isFocused=" + this.mainStage.isFocused());
            if (newValue.booleanValue()) {
                this.rootPane.setVisible(true);
                this.mainStage.setAlwaysOnTop(newValue.booleanValue());
                this.mainStage.show();
            } else {
                this.mainStage.hide();
                this.onHide();
            }
        });
        this.initDragListener();
        this.mainStage.setOnShown(event -> {
            this.rootPane.applyCss();
            this.rootPane.requestFocus();
            this.mainStage.requestFocus();
        });
        this.initResizeObserver();
        this.showing.set(false);
        this.initHotKey();
    }

    public void setRingtoneMuteState() {
        this.centerIncomingCallPane.setRingtoneMuteState();
        this.audioCallPane.getChildren().forEach(audioCallPane -> {
            if (audioCallPane instanceof CallLineNotification) {
                ((CallLineNotification)((Object)audioCallPane)).setRingtoneMuteState();
            }
        });
    }

    private void onHide() {
        this.mainStage.setAlwaysOnTop(false);
        this.mainStage.toBack();
        try {
            for (Node node : this.audioCallPane.getChildren()) {
                CallLineNotification callLineNotification = (CallLineNotification)node;
                callLineNotification.hidePopupWindows();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        this.rootPane.setVisible(false);
        this.rootPane.getChildren().clear();
        this.mainStage.setX(-5000.0);
        this.mainStage.setY(Constants.INVISIBLE_POSITION_Y);
        ClientSingleton.toLog(this.getClass().getSimpleName(), "ShowCallPane onHide");
    }

    public void addVideoPane(LineInfo lineInfo) {
        if (!ClientSingleton.getInstance().canVideo()) {
            return;
        }
        this.videoPane.setCurrentSize();
        this.onInvalidateRootPane(this.videoPane, lineInfo);
        this.videoPane.startPlaying();
        this.relocate((Pair<Integer, Integer>)new Pair((Object)((int)this.videoRootPane.getPrefWidth()), (Object)((int)this.videoRootPane.getPrefHeight())));
    }

    public void hideNotification() {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "HideNotification isShowing()=" + this.isShowing() + " ClientSingleton.getInstance().getWorkingLinesCount()=" + AudioCaller.getWorkingLinesCount() + " ClientSingleton.getInstance().getParentWindow().isFocused()=" + ClientSingleton.getInstance().getParentWindow().isFocused());
        if (AudioCaller.getWorkingLinesCount() == 0) {
            if (this.isShowing()) {
                this.setShowing(null, false);
            } else {
                this.onHide();
                this.lastPositionY = Constants.INVISIBLE_POSITION_Y;
                this.lastPositionX = -5000.0;
                this.invalidatePane();
            }
            TimerExecutor.getInstance().setMyAction(() -> this.iCheckNewMessagesNotification.checkNewMessages()).startWithDelay(500L);
        }
    }

    private void invalidatePane() {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "invalidatePane()");
        for (Node node : this.audioCallPane.getChildren()) {
            CallLineNotification callLineNotification = (CallLineNotification)node;
            callLineNotification.switchCallLinePane();
        }
    }

    public void showCallNotification(LineInfo lineInfo) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "ShowCallNotification stage=" + this.mainStage + " lineINfo=" + lineInfo + " isShowing()=" + this.isShowing() + " lastPositionX=" + this.lastPositionX + " lastPositionY=" + this.lastPositionY + "CallBasePane.getCallViewNotificationMode() " + CallBasePane.getCallViewNotificationMode() + " ClientSingleton.getInstance().isOpenedPopupsListEmpty()=" + ClientSingleton.getInstance().isOpenedPopupsListEmpty());
        if (ClientSingleton.getInstance().isShareDesktopPaneShowing()) {
            return;
        }
        if (lineInfo.getState() == 2 && CallBasePane.getCallViewNotificationMode() == 0 && !this.centerIncomingCallPane.isMuting()) {
            this.centerIncomingCallPane.initView(lineInfo, true);
            this.centerIncomingCallPane.setShowing(true);
            return;
        }
        if (lineInfo.getState() != 0 && lineInfo.getState() != 8 && lineInfo.getState() != 18) {
            if (lineInfo.getState() != 2 && lineInfo.getState() != 1 && ClientSingleton.getInstance().isMyVideoEnabledFlag(lineInfo)) {
                this.addVideoPane(lineInfo);
            } else {
                this.invalidatePane();
                this.onNext();
            }
        } else {
            this.invalidatePane();
            this.onNext();
        }
        if (!this.isShowing()) {
            this.setShowing(null, true);
        }
        this.centerIncomingCallPane.hideNotification();
    }

    private void onNext() {
        this.resizeObserver.onNext((Object)1);
    }

    public boolean isShowing() {
        return this.showing.get();
    }

    public void setShowing(LineInfo lineInfo, boolean showing) {
        if (AudioCaller.getWorkingLinesCount() == 0) {
            if (this.centerIncomingCallPane.isShowing()) {
                this.centerIncomingCallPane.hideNotification();
            }
            this.centerIncomingCallPane.setMuting(false);
            this.showing.set(false);
            return;
        }
        if (CallBasePane.getCallViewNotificationMode() == 0 && lineInfo != null && (lineInfo.getState() == 2 || lineInfo.getState() == 1 && AudioCaller.getWorkingLinesCount() == 1 || lineInfo.getState() == 15)) {
            this.centerIncomingCallPane.setShowing(showing);
        } else {
            this.showing.set(showing);
        }
    }

    public void onMute() {
        for (Node node : this.audioCallPane.getChildren()) {
            CallLineNotification callLineNotification = (CallLineNotification)node;
            callLineNotification.onMute();
        }
    }

    public void onHoldCall(LineInfo lineInfo) {
        this.getLinePane(lineInfo).ifPresent(CallLineNotification::onHoldCall);
    }

    public void onRecordCall(LineInfo lineInfo, boolean isRecording) {
        this.getLinePane(lineInfo).ifPresent(pane -> pane.onRecordCall(lineInfo, isRecording));
    }

    private HBox loadRoot() {
        HBox parent = new HBox();
        parent.setStyle("-fx-background-color:transparent;-fx-border-radius: 8 8 8 8;\n    -fx-background-radius: 8 8 8 8;-fx-effect: dropshadow(gaussian, rgba(0, 0, 0, 0.2), 12, 0.0, 0, 8);");
        parent.setAlignment(Pos.CENTER);
        return parent;
    }

    private Optional<CallLineNotification> getLinePane(LineInfo lineInfo) {
        for (Node node : this.audioCallPane.getChildren()) {
            CallLineNotification callLineNotification = (CallLineNotification)node;
            if (callLineNotification.getLineInfo().hashCode() != lineInfo.hashCode()) continue;
            return Optional.of(callLineNotification);
        }
        return Optional.empty();
    }

    @Override
    public boolean onResize() {
        return this.relocate(this.getStageSize());
    }

    private boolean relocate(Pair<Integer, Integer> stageSize) {
        int width = (Integer)stageSize.getKey();
        int height = (Integer)stageSize.getValue();
        int screenPadding = ClientUtil.getOS() == ClientUtil.OS.MAC ? 0 : 20;
        boolean isRelocate = false;
        if (this.mainStage.getWidth() != (double)width) {
            this.mainStage.setWidth((double)width);
            isRelocate = true;
        }
        if (this.mainStage.getHeight() != (double)height) {
            this.mainStage.setHeight((double)height);
            isRelocate = true;
        }
        Rectangle2D screenBounds = ClientSingleton.getInstance().getCurrentScreenBounds();
        Pair<Double, Double> pair = ResizeHelper.getNotificationPosition(this.mainStage, height);
        double toX = (Double)pair.getKey();
        double toY = (Double)pair.getValue();
        double h = this.mainStage.getHeight() + (double)screenPadding + this.mainStage.getY();
        double w = this.mainStage.getWidth() + (double)screenPadding + this.mainStage.getX();
        if (h < screenBounds.getHeight() && w < screenBounds.getWidth()) {
            isRelocate = false;
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "lastPositionX=" + this.lastPositionX + " lastPositionY=" + this.lastPositionY + " " + this.mainStage.getX() + " " + this.mainStage.getY() + " w=" + this.mainStage.getWidth() + " h=" + this.mainStage.getHeight());
        if (this.lastPositionX != -5000.0 || this.lastPositionY != Constants.INVISIBLE_POSITION_Y) {
            if (!isRelocate) {
                isRelocate = this.mainStage.getX() == this.lastPositionX && this.mainStage.getY() == this.lastPositionY;
            }
            this.mainStage.setX(this.lastPositionX);
            this.mainStage.setY(this.lastPositionY);
        } else {
            if (!isRelocate) {
                isRelocate = this.mainStage.getX() == toX && this.mainStage.getY() == toY;
            }
            this.mainStage.setY((double)((int)toY));
            TimerExecutor.getInstance().startInGUI(() -> this.mainStage.setX((double)((int)toX)));
            ClientSingleton.toLog(this.getClass().getSimpleName(), this.mainStage.getX() + " " + this.mainStage.getY() + " " + this.mainStage.isShowing());
        }
        return isRelocate;
    }

    @Override
    public void relocateOnStartPosition() {
        this.lastPositionX = -5000.0;
        this.lastPositionY = Constants.INVISIBLE_POSITION_Y;
    }

    private Pair<Integer, Integer> getStageSize() {
        int padding;
        int width = 0;
        int height = padding = 10;
        int heightOnHoldState = 117 + padding;
        for (Node node : this.audioCallPane.getChildren()) {
            CallLineNotification callLineNotification = (CallLineNotification)node;
            if (callLineNotification.getLineInfo() != null && callLineNotification.getLineInfo().getState() == 4 && callLineNotification.getNodeHeight() != heightOnHoldState && AudioCaller.getWorkingLinesCount() > 1) {
                height += heightOnHoldState;
            } else if (callLineNotification.isActiveState()) {
                height += callLineNotification.getNodeHeight() + padding;
            }
            width = Math.max(width, callLineNotification.getNodeWidth() + padding);
        }
        return new Pair((Object)width, (Object)height);
    }

    private void goToXYLocation() {
        Timeline timelineX;
        Rectangle2D screenBounds = ClientSingleton.getInstance().getCurrentScreenBounds();
        double toY = screenBounds.getHeight() - this.mainStage.getHeight() - 20.0;
        double toX = screenBounds.getWidth() - this.mainStage.getWidth() - 20.0;
        ClientSingleton.toLog(this.getClass().getSimpleName(), "onResize goToXYLocation toY=" + toY + " mainStage.getY()=" + this.mainStage.getY() + " toX = " + toX + " mainStage.getX()=" + this.mainStage.getX());
        if (toY < this.mainStage.getY()) {
            SimpleDoubleProperty moveY = new SimpleDoubleProperty(this.mainStage.getY());
            timelineX = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)100.0), new KeyValue[]{new KeyValue((WritableValue)moveY, (Object)toY)})});
            moveY.addListener((obs, oldValue, newValue) -> this.mainStage.setY(newValue.doubleValue()));
            timelineX.play();
        }
        if (toX < this.mainStage.getX()) {
            SimpleDoubleProperty moveX = new SimpleDoubleProperty(this.mainStage.getY());
            timelineX = new Timeline(new KeyFrame[]{new KeyFrame(Duration.millis((double)100.0), new KeyValue[]{new KeyValue((WritableValue)moveX, (Object)toX)})});
            moveX.addListener((obs, oldValue, newValue) -> this.mainStage.setY(newValue.doubleValue()));
            timelineX.play();
        }
    }

    private void onInvalidateRootPane(CallBasePane callBasePane, LineInfo lineInfo) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), " onInvalidateRootPane =[" + lineInfo + "] callBasePane=" + callBasePane);
        callBasePane.setLineInfo(lineInfo);
        Pane pane = callBasePane.setLineInfoParameters();
        if (ClientSingleton.getInstance().isMyVideoEnabledFlag(lineInfo) && lineInfo.getState() == 3 || callBasePane instanceof VideoNotificationPane) {
            this.videoRootPane = pane;
        }
        this.rootPane.getChildren().clear();
        this.rootPane.getChildren().add((Object)pane);
        ClientSingleton.toLog(this.getClass().getSimpleName(), "addToActiveLines onInvalidateRootPane=" + lineInfo + " lines =  " + this.rootPane.getChildren().size());
        this.mainStage.setWidth((double)callBasePane.getNodeWidth());
        this.mainStage.setHeight((double)callBasePane.getNodeHeight());
    }

    public Pair<Double, Double> setCallPanePosition() {
        Rectangle2D rectangle2D = ClientSingleton.getInstance().getCurrentScreenBounds();
        ClientSingleton.toLog(this.getClass().toString(), "getCurrentScreenBounds rectangle2D=" + rectangle2D + " " + this.mainStage.getWidth() + "x" + this.mainStage.getHeight());
        Pair pair = new Pair((Object)(rectangle2D.getMinX() + rectangle2D.getWidth() - this.mainStage.getWidth() - 20.0), (Object)(rectangle2D.getHeight() - this.mainStage.getHeight() - 20.0));
        ClientSingleton.toLog(this.getClass().toString(), "getCurrentScreenBounds pair=" + pair);
        return pair;
    }

    public void setCheckNewMessagesNotification(ICheckNewMessagesNotification iCheckNewMessagesNotification) {
        this.iCheckNewMessagesNotification = iCheckNewMessagesNotification;
    }

    private void initResizeObserver() {
        this.resizeObserver = PublishSubject.create();
        this.disposableResize = this.resizeObserver.compose(ClientSingleton.getInstance().debounceTime(50L, TimeUnit.MILLISECONDS, UpdateLists.scheduler, v -> ClientSingleton.toLog(this.getClass().getSimpleName(), "Dropped: " + v + " @ T=" + UpdateLists.scheduler.now(TimeUnit.MILLISECONDS)))).subscribe(v -> this.disposables.add(Observable.just((Object)v).doOnError(Throwable::printStackTrace).observeOn((Scheduler)JavaFxScheduler.platform()).flatMap(pair -> {
            if (!this.rootPane.getChildren().contains((Object)this.audioCallPane)) {
                this.rootPane.getChildren().clear();
                this.rootPane.getChildren().add((Object)this.audioCallPane);
            }
            ClientSingleton.toLog(this.getClass().getSimpleName(), "rootPane.getChildren().contains(audioCallPane)=" + this.rootPane.getChildren().contains((Object)this.audioCallPane));
            return Observable.just((Object)this.onResize());
        }).subscribe(isRelocate -> {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "isRelocate=" + isRelocate);
            if (isRelocate.booleanValue()) {
                // empty if block
            }
        })), Throwable::printStackTrace, () -> ClientSingleton.toLog(this.getClass().getSimpleName(), "Done  @ T=" + UpdateLists.scheduler.now(TimeUnit.MILLISECONDS)));
    }

    private void initDragListener() {
        this.rootPane.setCursor(Cursor.DEFAULT);
        this.rootPane.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> {
            this.xOffset = this.mainStage.getX() - event.getScreenX();
            this.yOffset = this.mainStage.getY() - event.getScreenY();
            this.rootPane.setCursor(Cursor.MOVE);
            event.consume();
        });
        this.rootPane.addEventHandler(MouseEvent.MOUSE_RELEASED, event -> this.rootPane.setCursor(Cursor.DEFAULT));
        this.rootPane.addEventHandler(MouseEvent.MOUSE_DRAGGED, event -> {
            if (this.rootPane.getCursor() != Cursor.DEFAULT) {
                this.lastPositionX = event.getScreenX() + this.xOffset;
                this.lastPositionY = event.getScreenY() + this.yOffset;
            }
            event.consume();
        });
    }

    private void initHotKey() {
        boolean isMac = ClientUtil.getOS() == ClientUtil.OS.MAC;
        KeyCombination.Modifier currentModifier = isMac ? KeyCombination.SHORTCUT_DOWN : KeyCombination.CONTROL_DOWN;
        KeyCodeCombination kcAnswerCall = new KeyCodeCombination(KeyCode.UP, new KeyCombination.Modifier[]{currentModifier});
        this.mainStage.getScene().getAccelerators().put((Object)kcAnswerCall, () -> {
            LineInfo lineInfo = AudioCaller.getActiveLine();
            if (lineInfo != null && lineInfo.getState() == 2) {
                AudioCaller.answerCall(lineInfo, false);
            }
        });
        KeyCodeCombination kcDropCall = new KeyCodeCombination(KeyCode.DOWN, new KeyCombination.Modifier[]{currentModifier});
        this.mainStage.getScene().getAccelerators().put((Object)kcDropCall, () -> {
            LineInfo lineInfo = AudioCaller.getActiveLine();
            if (lineInfo != null) {
                AudioCaller.dropCall(lineInfo);
            }
        });
        KeyCodeCombination transferHotKey = new KeyCodeCombination(KeyCode.T, new KeyCombination.Modifier[]{currentModifier, KeyCombination.SHIFT_DOWN});
        this.mainStage.getScene().getAccelerators().put((Object)transferHotKey, () -> {
            LineInfo lineInfo = AudioCaller.getActiveLine();
            if (lineInfo != null) {
                ClientSingleton.getInstance().transferCallTo(lineInfo, true, true);
            }
        });
        KeyCodeCombination muteHotKey = new KeyCodeCombination(KeyCode.M, new KeyCombination.Modifier[]{currentModifier, KeyCombination.SHIFT_DOWN});
        this.mainStage.getScene().getAccelerators().put((Object)muteHotKey, AudioCaller::setMute);
        KeyCodeCombination holdHotKey = new KeyCodeCombination(KeyCode.H, new KeyCombination.Modifier[]{currentModifier, KeyCombination.SHIFT_DOWN});
        this.mainStage.getScene().getAccelerators().put((Object)holdHotKey, () -> {
            LineInfo lineInfo = AudioCaller.getActiveLine();
            if (lineInfo != null) {
                TimerExecutor.getInstance().start(() -> {
                    if (lineInfo.getState() == 4) {
                        AudioCaller.setActiveLine(lineInfo);
                    } else {
                        AudioCaller.setHoldLine(lineInfo);
                    }
                });
            }
        });
        KeyCodeCombination addToCallHotKey = new KeyCodeCombination(KeyCode.A, new KeyCombination.Modifier[]{currentModifier, KeyCombination.SHIFT_DOWN});
        this.mainStage.getScene().getAccelerators().put((Object)addToCallHotKey, () -> {
            LineInfo lineInfo = AudioCaller.getActiveLine();
            if (lineInfo != null) {
                ClientSingleton.getInstance().addParticipantToCall(lineInfo, true, true);
            }
        });
    }
}

