/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.calls.audiocontrolls;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javafx.animation.AnimationTimer;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.connector.utils.AudioCaller;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.constants.IntentConstants;
import net.sipsnet.client.utils.usb.IUsbNotification;
import net.sipsnet.client.utils.viewers.label.MyLabel;
import net.sipsnet.client.views.calls.audiocontrolls.CallLineBigNotificationPane;
import net.sipsnet.client.views.calls.audiocontrolls.CallLinePaneBase;
import net.sipsnet.client.views.calls.audiocontrolls.ILineInfoPaneListener;
import net.sipsnet.client.views.calls.audiocontrolls.ILineListener;
import net.sipsnet.client.views.calls.audiocontrolls.SimpleCallLinePane;
import net.sipsnet.client.views.calls.callconference.CallConferenceController;
import net.sipsnet.client.views.calls.chatline.ICallLineState;
import net.sipsnet.client.views.calls.utils.LineTimer;
import net.sipsnet.client.views.chat.utils.ICallPanesVisibility;
import net.sipsnet.client.views.mainview.ringtonemode.IRingtoneMuteState;
import smile.cti.client.LineEventListener;
import smile.cti.client.LineInfo;
import smile.cti.client.SessionInfo;

public class LineInfoPane
extends VBox
implements LineEventListener,
ICallPanesVisibility,
ILineInfoPaneListener {
    private final String TAG = "LineListener";
    private final ILineListener iLineListener;
    public final int VIEW_STATE_NOT_ADDED_TO_PARENT = 0;
    public final int VIEW_STATE_ADDED_TO_PARENT = 1;
    private int currentViewState = 0;
    private final LineInfo lineInfo;
    private CallLinePaneBase firstLine;
    private CallLinePaneBase simpleLineViewPane;
    private CallLinePaneBase bigLineViewPane;
    private AnimationTimer memTimer;
    private final List<ICallLineState> iCallLineState = new ArrayList<ICallLineState>();
    private Label fx_lbCallTrunk;
    private IUsbNotification usbNotification;
    private HBox mergeHBox;
    public static final int LINE_HEIGHT = 40;
    private final SimpleBooleanProperty bigViewMode;

    public void addCallLineStateListener(ICallLineState iCallLineState) {
        this.iCallLineState.removeIf(icallLineState -> icallLineState.getClass().getSimpleName().equals(iCallLineState.getClass().getSimpleName()));
        this.iCallLineState.add(iCallLineState);
        ClientSingleton.toLog(this.getClass().getSimpleName(), "this.lineInfo=" + this.lineInfo + " this.iCallLineState =  " + this.iCallLineState.size());
    }

    public LineInfoPane(LineInfo lineInfo, ILineListener iLineListener, int currentViewPaneMode) {
        this.lineInfo = lineInfo;
        this.iLineListener = iLineListener;
        this.initPane();
        this.bigViewMode = new SimpleBooleanProperty(currentViewPaneMode != 0);
        this.bigViewMode.addListener((observable, oldValue, newValue) -> {
            if (this.getLineInfo() == null) {
                return;
            }
            if (this.getLineInfo().getState() == 4) {
                this.setHoldPane();
            } else {
                this.setViewPane();
            }
        });
    }

    public LineInfo getLineInfo() {
        return this.lineInfo;
    }

    public void invalidateLinePane() {
        if (this.firstLine instanceof CallLineBigNotificationPane) {
            ((CallLineBigNotificationPane)this.firstLine).invalidateLinePane();
        } else if (this.firstLine instanceof SimpleCallLinePane) {
            ((SimpleCallLinePane)this.firstLine).invalidateLinePane();
        }
    }

    public void stateChanged(LineInfo lineInfo) {
        ClientSingleton.getInstance().runLater(() -> this.onStateChanged(lineInfo));
    }

    public void identityChanged(LineInfo lineInfo) {
        if (this.getLineInfo() != null && lineInfo != null && this.getLineInfo().hashCode() == lineInfo.hashCode()) {
            ClientSingleton.toLog("LineListener", "identityChanged ");
            this.print();
            ClientSingleton.getInstance().runLater(() -> this.firstLine.setCallInfo());
            for (ICallLineState ics : this.iCallLineState) {
                try {
                    ics.identityChanged(this.getLineInfo());
                    Thread.sleep(150L);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    private void onStateChanged(LineInfo lineInfo) {
        if (this.getLineInfo() == null || this.getLineInfo().hashCode() != lineInfo.hashCode() || ClientSingleton.getInstance().getMainViewModel().isSystemSleep()) {
            return;
        }
        ClientSingleton.toLog("LineListener", "LINE STATE CHANGED " + this.getLineInfo() + " stateChanged line=" + this.getLineInfo().getName() + "\nstate=" + this.getLineInfo().getState() + " video 1=" + this.getLineInfo().isVideoEnabled() + " video 2=" + ClientSingleton.getInstance().isMyVideoEnabledFlag(this.getLineInfo()) + " parties=" + lineInfo.getContacts() + "\nlineInfo.getDescription()=" + this.getLineInfo().getDescription() + " currentViewState =" + this.currentViewState);
        this.print();
        switch (this.getLineInfo().getState()) {
            case 1: 
            case 2: {
                ClientSingleton.getInstance().setMyVideoEnabledFlag(this.getLineInfo(), this.getLineInfo().isVideoEnabled());
                if (AudioCaller.getWorkingLinesCount() == 1 && this.usbNotification != null) {
                    this.usbNotification.onPresentCall(this.getLineInfo().getState() == 2);
                }
            }
            case 3: 
            case 10: 
            case 15: {
                int lineCount;
                if (this.getLineInfo().getState() != 15 && this.getLineInfo().getState() != 10) {
                    this.setViewPane();
                    if (this.getLineInfo().getState() == 3) {
                        LineTimer.getInstance().startConnectLine(this.getLineInfo());
                    }
                } else {
                    this.invalidateCallLineView();
                }
                if (this.getLineInfo().getState() != 2 && this.getLineInfo().getState() != 1 && (lineCount = AudioCaller.getWorkingLinesCount()) == 1 && this.usbNotification != null) {
                    this.usbNotification.onConnectedCall();
                }
                if (this.currentViewState == 1) break;
                this.iLineListener.addToActiveLine(this);
                this.currentViewState = 1;
                break;
            }
            case 5: {
                this.invalidateCallLineView();
                break;
            }
            case 4: 
            case 16: {
                this.setHoldPane();
                break;
            }
            case 0: 
            case 8: 
            case 18: {
                ClientSingleton.getInstance().setMyVideoEnabledFlag(this.getLineInfo(), false);
                if (AudioCaller.getWorkingLinesCount() == 0) {
                    if (this.usbNotification != null) {
                        this.usbNotification.onDisconnectCall();
                    }
                    ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                        if (clientConnector.getMute()) {
                            AudioCaller.setMute(false);
                        }
                    });
                    ClientSingleton.getInstance().setConferenceOwner(false);
                    ClientSingleton.memoryReport();
                }
                if (this.currentViewState == 1) {
                    this.currentViewState = 0;
                    this.iLineListener.removeFromActiveLine(this);
                    this.firstLine.removeMenu();
                }
                LineTimer.getInstance().stopConnectLine(this.getLineInfo());
            }
        }
        CallConferenceController.getInstance().onCloseViewer();
        this.setBackgroundColor(this.getLineInfo().getState() == 4);
        if (this.firstLine != null) {
            this.firstLine.setHoldState(this.getLineInfo().getState() == 4);
        }
        if (this.getLineInfo().getState() == 3) {
            this.iLineListener.connectedLineState();
        }
        for (ICallLineState ics : this.iCallLineState) {
            try {
                ics.setLineViewState(this.getLineInfo());
                Thread.sleep(150L);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    private void setViewPane() {
        boolean isInvalidated = false;
        ClientSingleton.toLog("LineListener", "setViewPane lineInFO: " + this.getLineInfo() + " lineInfo.getState()=" + this.getLineInfo().getState() + " " + this.bigViewMode.get() + " firstLine=" + this.firstLine);
        if (!this.bigViewMode.get() || this.getLineInfo().getState() == 2 || this.getLineInfo().getState() == 1 || ClientSingleton.getInstance().getCurrentViewMode() == 0) {
            if (!(this.firstLine instanceof SimpleCallLinePane)) {
                if (this.simpleLineViewPane == null) {
                    this.simpleLineViewPane = new SimpleCallLinePane(this.getLineInfo(), this, this);
                }
                this.firstLine = this.simpleLineViewPane;
                isInvalidated = true;
            }
        } else if (!(this.firstLine instanceof CallLineBigNotificationPane)) {
            if (this.bigLineViewPane == null) {
                this.bigLineViewPane = new CallLineBigNotificationPane(this.getLineInfo(), this, this);
            }
            this.firstLine = this.bigLineViewPane;
            isInvalidated = true;
        }
        this.invalidateCallLineView();
        if (isInvalidated) {
            this.getChildren().clear();
            this.getChildren().add(0, (Object)this.firstLine);
            if (this.getParent() != null) {
                this.getParent().layout();
            }
        }
    }

    private void setHoldPane() {
        boolean isInvalidated = false;
        if (!this.bigViewMode.get()) {
            if (!(this.firstLine instanceof SimpleCallLinePane)) {
                if (this.simpleLineViewPane == null) {
                    this.simpleLineViewPane = new SimpleCallLinePane(this.getLineInfo(), this, this);
                }
                this.firstLine = this.simpleLineViewPane;
                isInvalidated = true;
            }
        } else if (!(this.firstLine instanceof CallLineBigNotificationPane)) {
            if (this.bigLineViewPane == null) {
                this.bigLineViewPane = new CallLineBigNotificationPane(this.getLineInfo(), this, this);
            }
            this.firstLine = this.bigLineViewPane;
            isInvalidated = true;
        }
        this.invalidateCallLineView();
        if (isInvalidated) {
            this.getChildren().clear();
            this.getChildren().add(0, (Object)this.firstLine);
        }
    }

    public void invalidateCallLineView() {
        this.firstLine.setCallInfo();
    }

    public void setRecording(LineInfo lineInfo, boolean b) {
        if (this.getLineInfo() != null && this.getLineInfo().hashCode() != lineInfo.hashCode()) {
            return;
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "setRecording lineInfo=" + this.getLineInfo() + " b=" + b);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("lineInfo", this.getLineInfo());
        data.put("isRecording", b);
        ClientSingleton.getInstance().doNotify(IntentConstants.LINE_INFO_RECORD_LINE, data);
        this.firstLine.setRecording(this.getLineInfo(), b);
    }

    @Override
    public EventHandler<MouseEvent> getMouseHandler() {
        return mouseEvent -> {
            String id;
            if (mouseEvent.getSource() instanceof ImageView) {
                ImageView imageView = (ImageView)mouseEvent.getSource();
                id = imageView.getId();
            } else {
                MyLabel label = (MyLabel)mouseEvent.getSource();
                id = label.getId();
            }
            ClientSingleton.toLog(this.getClass().getSimpleName(), id + " was pressed lineInfo=" + this.getLineInfo());
            switch (id) {
                case "hbAnswerCall": {
                    AudioCaller.answerCall(this.getLineInfo());
                    mouseEvent.consume();
                    break;
                }
                case "hbVideoCall": {
                    AudioCaller.answerCall(this.getLineInfo(), true);
                    mouseEvent.consume();
                    break;
                }
                case "transferCall": {
                    AudioCaller.transferCallTo(this.getLineInfo());
                    mouseEvent.consume();
                    break;
                }
                case "mergeCall": {
                    AudioCaller.joinToConference(this.getLineInfo());
                    mouseEvent.consume();
                    break;
                }
                case "hbMuteButton": {
                    AudioCaller.setMute();
                    mouseEvent.consume();
                    break;
                }
                case "hbHangupCall": {
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "getVideoMode = " + ClientSingleton.getInstance().getClientConnector().get().getVideoMode() + " lineInfo.isVideoEnabled()=" + this.getLineInfo().isVideoEnabled());
                    AudioCaller.dropCall(this.getLineInfo());
                    if (this.currentViewState == 1) {
                        this.iLineListener.removeFromActiveLine(this);
                        this.currentViewState = 0;
                    }
                    mouseEvent.consume();
                    break;
                }
                case "hbAddUserToConference": {
                    ClientSingleton.getInstance().addParticipantToCall(this.getLineInfo(), true, true);
                    mouseEvent.consume();
                }
                case "hbHoldCall": {
                    AudioCaller.setActiveLine(this.getLineInfo());
                    mouseEvent.consume();
                }
            }
        };
    }

    public void setBackgroundColor(boolean isHold) {
        if (isHold) {
            Theme.getInstance().applyCallPaneTo(Theme.CALL_PANE_HOLD_BACKGROUND, (Pane)this);
        } else {
            Theme.getInstance().applyCallPaneTo(Theme.CALL_LINE_BACKGROUND, (Pane)this);
        }
    }

    private void initPane() {
        this.setBackgroundColor(false);
        this.setMaxWidth(290.0);
        this.setMinWidth(290.0);
        VBox.setMargin((Node)this, (Insets)new Insets(3.0, 8.0, 3.0, 0.0));
        this.setAlignment(Pos.CENTER_LEFT);
    }

    @Override
    public void openSession() {
        SessionInfo sessionInfo = this.getLineInfo().getSessionInfo();
        if (sessionInfo != null) {
            if (!sessionInfo.isGroup() && (this.getLineInfo().isConference() || this.getLineInfo().getState() == 5)) {
                return;
            }
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("sessionInfo", sessionInfo);
            ClientSingleton.getInstance().doNotify(Constants.OPEN_SESSION, data);
            ClientSingleton.getInstance().getParentWindow().requestFocus();
        }
    }

    @Override
    public void openHistoryViewer() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("sessionInfo", this.getLineInfo().getSessionInfo());
        data.put(Constants.OPEN_SESSION_MODE, Constants.OPEN_SESSION_WITH_CALL_HISTORY);
        ClientSingleton.getInstance().doNotify(Constants.OPEN_SESSION, data);
        ClientSingleton.getInstance().getParentWindow().requestFocus();
    }

    @Override
    public void openCallActivityViewer() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("sessionInfo", this.getLineInfo().getSessionInfo());
        data.put(Constants.OPEN_SESSION_MODE, Constants.OPEN_SESSION_WITH_ACTIVITY);
        ClientSingleton.getInstance().doNotify(Constants.OPEN_SESSION, data);
        ClientSingleton.getInstance().getParentWindow().requestFocus();
    }

    public void setUsbNotification(IUsbNotification usbNotification) {
        this.usbNotification = usbNotification;
    }

    @Override
    public void setCallPanesVisible() {
    }

    @Override
    public void setCallPanesUnVisible() {
    }

    @Override
    public void switchToFilter() {
    }

    private void startMemoInfo() {
        this.memTimer = new AnimationTimer(){

            public void handle(long now) {
                long free = Runtime.getRuntime().freeMemory();
                long total = Runtime.getRuntime().totalMemory();
                long max = Runtime.getRuntime().maxMemory();
                ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), String.format("Free memory: %,d", free));
                ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), String.format("Used memory: %,d", total - free));
                ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), String.format("Total memory: %,d", total));
                ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), String.format("Max memory: %,d", max));
            }
        };
        this.memTimer.start();
    }

    private void stopMemInfo() {
        this.memTimer.stop();
    }

    public void onMute() {
        this.firstLine.onMute();
    }

    public void onRecordCall() {
        if (this.firstLine instanceof CallLineBigNotificationPane) {
            ((CallLineBigNotificationPane)this.firstLine).onRecordCall();
        }
    }

    public void switchViewMode(boolean mode) {
        this.bigViewMode.set(mode);
    }

    public void initTestPane() {
        this.firstLine = this.bigLineViewPane = new CallLineBigNotificationPane(this.getLineInfo(), this, this);
        this.firstLine.setCallInfo();
        this.getChildren().clear();
        this.getChildren().add(0, (Object)this.firstLine);
        if (this.getParent() != null) {
            this.getParent().layout();
        }
    }

    public void addRingtoneMuteStateListener(IRingtoneMuteState iRingtoneMuteState) {
        if (this.simpleLineViewPane == null) {
            this.simpleLineViewPane = new SimpleCallLinePane(this.getLineInfo(), this, this);
        }
        this.simpleLineViewPane.addRingtoneMuteStateListener(iRingtoneMuteState);
    }

    public void setRingtoneMuteState() {
        this.simpleLineViewPane.setRingtoneMuteState();
    }

    private void print() {
        ClientSingleton.toLog("LineListener", Thread.currentThread() + " setCallInfo getLineInfo()=" + this.getLineInfo() + " state=" + this.getLineInfo().getState() + "\ngetLineInfo()=" + this.getLineInfo() + " state=" + this.getLineInfo().getState() + "\ngetLineInfo().getPartyNumber()=" + this.getLineInfo().getPartyNumber() + "\ngetLineInfo().getPartyName()=" + this.getLineInfo().getPartyName() + "\ngetLineInfo().getContacts()=" + this.getLineInfo().getContacts() + "\ngetLineInfo().isConference()=" + this.getLineInfo().isConference() + "\ngetLineInfo().getCallerName()=" + this.getLineInfo().getCallerName() + "\ngetLineInfo().getCalledName()=" + this.getLineInfo().getCalledName());
    }
}

