/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.calls.audiocontrolls;

import java.util.HashMap;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.MenuItem;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.WhiteLabels;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.connector.utils.AudioCaller;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.viewers.avatar.AvatarPane;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButton;
import net.sipsnet.client.utils.viewers.callStateArrow.CallStateArrowPane;
import net.sipsnet.client.utils.viewers.combobox.MaxSizedContextMenu;
import net.sipsnet.client.views.calls.audiocontrolls.CallLinePaneBase;
import net.sipsnet.client.views.calls.audiocontrolls.HoldToggleSwitch;
import net.sipsnet.client.views.calls.audiocontrolls.ILineInfoPaneListener;
import net.sipsnet.client.views.calls.audiocontrolls.RecordingToggleSwitch;
import net.sipsnet.client.views.calls.callaudiosettings.AudioSettingsController;
import net.sipsnet.client.views.calls.callconference.CallConferenceController;
import net.sipsnet.client.views.calls.utils.CallLineUtils;
import net.sipsnet.client.views.calls.utils.LineTimer;
import net.sipsnet.client.views.chat.utils.ICallPanesVisibility;
import net.sipsnet.client.views.mainview.ringtonemode.IRingtoneMuteState;
import smile.cti.client.LineInfo;

public class SimpleCallLinePane
extends CallLinePaneBase {
    private static final String TAG = "SimpleCallPane";
    private HBox hbAvatarBox;
    private Label lbContactTitle;
    private HBox hbButton1;
    private HBox hbButton2;
    private HBox hbButton3;
    private HBox hbButton4;
    private ImageView hbAnswerCall;
    private ImageView hbHangupCall;
    private ImageView hbVideoCall;
    private ImageView hbHoldCall;
    private ImageView hbConferenceCall;
    private RecordingToggleSwitch recordingToggleSwitch;
    private HoldToggleSwitch holdToggleSwitch;
    private MenuItem videoMenuItem;
    private MenuItem addParticipantMenuItem;
    private MenuItem transferMenuItem;
    private MenuItem callControlItem;
    private Label fx_lbCallTrunk;
    private Label fx_lbCallTimer;
    private Label fx_lbConnectCallingNumber;
    private Label fx_lbCallType;
    private HBox callTrunkBox;
    private HBox callTypeBox;
    private HBox callTimerBox;
    private HBox callNumberBox;
    private CallStateArrowPane fx_hbIvCallArrowContainer;
    private HBox titleBox;
    private ImageView hbIncomingMuteButton;
    private MaxSizedContextMenu myContextMenu;
    private ImageButton fx_ivCallTopMenu;
    private IRingtoneMuteState iRingtoneMuteState;
    private MenuItem holdMenuItem;
    private ImageView hbMergeCall;
    private ImageView hbTransferCall;
    private ImageView hbMuteButton;
    private MenuItem recordMenuItem;
    private MenuItem showPopupMenuItem;

    public SimpleCallLinePane(LineInfo lineInfo, ILineInfoPaneListener iLineInfoPaneListener, ICallPanesVisibility iCallPanesVisibility) {
        super(iLineInfoPaneListener, iCallPanesVisibility);
        this.setLineInfo(lineInfo);
        this.init();
    }

    private void init() {
        this.setMinHeight(40.0);
        this.prefHeight(40.0);
        this.setAlignment(Pos.CENTER_LEFT);
        this.prefWidthProperty().bind((ObservableValue)this.widthProperty());
        this.hbAvatarBox = new HBox();
        this.hbAvatarBox.setMinHeight(40.0);
        this.hbAvatarBox.prefHeight(40.0);
        this.hbAvatarBox.setFillHeight(true);
        this.hbAvatarBox.setAlignment(Pos.CENTER);
        HBox.setMargin((Node)this.hbAvatarBox, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
        this.getChildren().add((Object)this.hbAvatarBox);
        VBox vBox = new VBox();
        vBox.setAlignment(Pos.CENTER_LEFT);
        HBox.setMargin((Node)vBox, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
        HBox.setHgrow((Node)vBox, (Priority)Priority.ALWAYS);
        this.titleBox = new HBox();
        this.titleBox.setAlignment(Pos.CENTER_LEFT);
        this.lbContactTitle = new Label();
        Theme.getInstance().applyTo(Constants.TAB_CELL_TEXT_FILL, (Labeled)this.lbContactTitle, Theme.WHITE_EXTRA_COLOR);
        ClientSingleton.getInstance().setMouseCursor((Node)this);
        this.lbContactTitle.setOnMouseClicked(eventMouse -> this.iLineInfoPaneListener.openSession());
        this.titleBox.setOnMouseClicked(eventMouse -> this.iLineInfoPaneListener.openSession());
        this.fx_hbIvCallArrowContainer = CallStateArrowPane.getInstance();
        this.titleBox.getChildren().add((Object)this.lbContactTitle);
        vBox.getChildren().add((Object)this.titleBox);
        HBox numberBox = new HBox();
        numberBox.setAlignment(Pos.CENTER_LEFT);
        this.fx_lbConnectCallingNumber = this.getLabel();
        this.callNumberBox = new HBox();
        this.callNumberBox.setAlignment(Pos.CENTER_LEFT);
        this.callNumberBox.getChildren().add((Object)this.fx_lbConnectCallingNumber);
        this.fx_lbCallTrunk = this.getLabel();
        this.callTrunkBox = new HBox();
        this.callTrunkBox.setAlignment(Pos.CENTER_LEFT);
        this.callTrunkBox.getChildren().add((Object)this.fx_lbCallTrunk);
        this.fx_lbCallType = this.getLabel(false);
        this.callTypeBox = new HBox();
        this.callTypeBox.setAlignment(Pos.CENTER_LEFT);
        this.callTypeBox.getChildren().add((Object)this.fx_lbCallType);
        this.fx_lbCallTimer = this.getLabel();
        this.callTimerBox = new HBox();
        this.callTimerBox.setAlignment(Pos.CENTER_LEFT);
        this.callTimerBox.getChildren().add((Object)this.fx_lbCallTimer);
        numberBox.setOnMouseClicked(eventMouse -> this.iLineInfoPaneListener.openSession());
        numberBox.getChildren().addAll((Object[])new Node[]{this.callTypeBox, this.callNumberBox, this.callTrunkBox, this.callTimerBox});
        vBox.prefHeightProperty().bind((ObservableValue)this.prefHeightProperty());
        vBox.getChildren().add((Object)numberBox);
        this.getChildren().add((Object)vBox);
        HBox.setHgrow((Node)this.titleBox, (Priority)Priority.ALWAYS);
        Region region1 = new Region();
        this.getChildren().add((Object)region1);
        this.hbButton1 = new HBox();
        this.hbButton1.prefHeightProperty().bind((ObservableValue)this.prefHeightProperty());
        this.getChildren().add((Object)this.hbButton1);
        this.hbButton2 = new HBox();
        this.hbButton2.prefHeightProperty().bind((ObservableValue)this.prefHeightProperty());
        this.getChildren().add((Object)this.hbButton2);
        this.hbButton3 = new HBox();
        this.hbButton3.prefHeightProperty().bind((ObservableValue)this.prefHeightProperty());
        this.getChildren().add((Object)this.hbButton3);
        this.hbButton4 = new HBox();
        this.hbButton4.prefHeightProperty().bind((ObservableValue)this.prefHeightProperty());
        this.getChildren().add((Object)this.hbButton4);
        this.hbAnswerCall = this.initButton("hbAnswerCall", WhiteLabels.isCustomAnswerButton() ? "answer_button/answer_small.png" : "line/answer_small.png");
        this.hbHangupCall = this.initButton("hbHangupCall", WhiteLabels.isCustomHangupButton() ? "hangup_button/hangup_small.png" : "line/hangup_small.png");
        this.hbIncomingMuteButton = this.initButton("hbIncomingMuteButton", "call_notification/callpanel_incoming_mute_off.png", (EventHandler<MouseEvent>)((EventHandler)event -> this.iRingtoneMuteState.setRingtoneMuteState(true)));
        if (ClientSingleton.getInstance().canVideo()) {
            this.hbVideoCall = this.initButton("hbVideoCall", WhiteLabels.isCustomAnswerButton() ? "answer_button/callpanel_answer_video.png" : "call_notification/callpanel_answer_video.png");
        }
        this.hbHoldCall = this.initButton("hbHoldCall", "line/hold_small.png");
        this.hbMergeCall = this.initButton("mergeCall", "notification/call/callpanel_merge.png");
        this.hbTransferCall = this.initButton("transferCall", "notification/call/callpanel_transfer_on.png");
        this.hbMuteButton = this.initButton("hbMuteButton", "call_notification/callpanel_mute_off.png");
        this.initCallMenu();
    }

    private ImageView initButton(String id, String imagePath) {
        return this.initButton(id, imagePath, null);
    }

    private ImageView initButton(String id, String imagePath, EventHandler<MouseEvent> event) {
        ImageView imageView = new ImageView();
        imageView.setId(id);
        imageView.setPreserveRatio(true);
        imageView.setPickOnBounds(true);
        ClientSingleton.getInstance().setCachedImage(imageView, imagePath);
        imageView.setFitHeight(25.0);
        imageView.setFitWidth(25.0);
        imageView.addEventHandler(MouseEvent.MOUSE_CLICKED, event != null ? event : this.iLineInfoPaneListener.getMouseHandler());
        HBox.setMargin((Node)imageView, (Insets)new Insets(8.0, 8.0, 0.0, 8.0));
        ClientSingleton.getInstance().setMouseCursor((Node)imageView);
        return imageView;
    }

    private Label getLabel() {
        return this.getLabel(true);
    }

    private Label getLabel(boolean isWithMargin) {
        Label label = new Label();
        Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)label, Theme.WHITE_EXTRA_COLOR);
        ClientSingleton.getInstance().setMouseCursor((Node)this);
        label.setOnMouseClicked(eventMouse -> this.iLineInfoPaneListener.openSession());
        if (isWithMargin) {
            HBox.setMargin((Node)label, (Insets)new Insets(0.0, 5.0, 0.0, 0.0));
        }
        return label;
    }

    private void initButtons() {
        if (this.getLineInfo().getState() == 1 || this.getLineInfo().getState() == 2) {
            this.fx_lbCallTimer.setText("");
        }
        AudioCaller.addTrunkLabel(this.getLineInfo(), this.fx_lbCallTrunk, (Pane)this.callTrunkBox);
        this.hbButton1.getChildren().clear();
        this.hbButton2.getChildren().clear();
        this.hbButton3.getChildren().clear();
        this.hbButton4.getChildren().clear();
        switch (this.getLineInfo().getState()) {
            case 2: {
                boolean isMuting = this.iRingtoneMuteState == null || !this.iRingtoneMuteState.isRingtoneMuted();
                ClientSingleton.getInstance().setCachedImage(this.hbIncomingMuteButton, isMuting ? "call_notification/callpanel_incoming_mute_off.png" : "call_notification/callpanel_incoming_mute_on.png");
                this.hbIncomingMuteButton.setFitWidth(25.0);
                this.hbIncomingMuteButton.setFitHeight(25.0);
                this.hbButton1.getChildren().add((Object)this.hbIncomingMuteButton);
                boolean isVideoConnected = ClientSingleton.getInstance().canVideo(this.getLineInfo()) && this.getLineInfo().isVideoEnabled();
                this.hbButton2.getChildren().add((Object)this.hbAnswerCall);
                if (isVideoConnected) {
                    this.hbButton3.getChildren().add((Object)this.hbVideoCall);
                }
                this.hbButton4.getChildren().add((Object)this.hbHangupCall);
                ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "initButtons hbButton2=" + this.hbButton2.getChildren().size() + " isVisible " + this.hbButton2.isVisible());
                break;
            }
            case 1: {
                this.hbButton3.getChildren().add((Object)this.hbHangupCall);
                break;
            }
            case 5: {
                this.setConferenceMenuMode(true);
            }
            case 3: {
                if (this.getLineInfo().isConference() || this.getLineInfo().getState() == 5) {
                    this.hbButton2.getChildren().add((Object)this.hbMuteButton);
                }
                this.hbButton1.getChildren().add((Object)this.hbHangupCall);
                LineTimer.getInstance().addToLine(this.getLineInfo(), this.fx_lbCallTimer);
                break;
            }
            case 4: {
                if (AudioCaller.getWorkingLinesCount() > 1) {
                    this.hbButton4.getChildren().add((Object)this.hbTransferCall);
                    this.hbButton4.getChildren().add((Object)this.hbMergeCall);
                }
                this.hbButton3.getChildren().add((Object)this.hbHoldCall);
                this.hbButton4.getChildren().add((Object)this.hbHangupCall);
            }
        }
        this.setManaged(true);
    }

    @Override
    public void setCallInfo() {
        this.lbContactTitle.setText(CallLineUtils.getName(this.getLineInfo()));
        AvatarPane avatarPane = AvatarPane.getInstance(this.getLineInfo().getSessionInfo(), 32, 16, false);
        if (this.hbAvatarBox != null) {
            this.hbAvatarBox.getChildren().clear();
            this.hbAvatarBox.getChildren().add((Object)avatarPane);
        }
        if (this.getLineInfo().getState() == 3 || this.getLineInfo().getState() == 5 || this.getLineInfo().getState() == 10) {
            this.removeFromBox(this.callNumberBox, this.fx_lbConnectCallingNumber);
            if (this.getLineInfo().getState() == 3) {
                this.setConferenceMenuMode(false);
            }
            if (!this.getChildren().contains((Object)this.fx_ivCallTopMenu)) {
                this.getChildren().add(0, (Object)this.fx_ivCallTopMenu);
            }
        } else {
            if (this.fx_ivCallTopMenu != null) {
                this.getChildren().remove((Object)this.fx_ivCallTopMenu);
            }
            CallLineUtils.getNumber(this.getLineInfo(), this.fx_lbConnectCallingNumber, (Pane)this.callNumberBox, false);
        }
        AudioCaller.addTrunkLabel(this.getLineInfo(), this.fx_lbCallTrunk, (Pane)this.callTrunkBox);
        this.initButtons();
    }

    private void removeFromBox(HBox parent, Label child) {
        parent.getChildren().remove((Object)child);
    }

    private void addToBox(HBox parent, Label child) {
        if (!parent.getChildren().contains((Object)child)) {
            parent.getChildren().add((Object)child);
        }
    }

    private void initCallMenu() {
        this.myContextMenu = new MaxSizedContextMenu();
        this.myContextMenu.setMaxHeight(300.0);
        this.myContextMenu.setMinWidth(200.0);
        this.myContextMenu.setPrefWidth(200.0);
        this.myContextMenu.setMaxWidth(200.0);
        Theme.getInstance().applyTo(Constants.CONTEXT_MENU, (Pane)this);
        this.fx_ivCallTopMenu = new ImageButton();
        this.fx_ivCallTopMenu.setSize(20, 32);
        this.fx_ivCallTopMenu.setImagePath("call_notification/callpanel_menu.png");
        this.fx_ivCallTopMenu.setStyle("-fx-background-color:transparent;");
        this.fx_ivCallTopMenu.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)mouseEvent -> {
            ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "fx_ivCallTopMenu MouseEventHandler");
            this.setMenu();
            this.myContextMenu.show((Node)this.fx_ivCallTopMenu, mouseEvent.getScreenX(), mouseEvent.getScreenY());
        }));
        this.transferMenuItem = new MenuItem(ClientSingleton.getInstance().getString("chat_call_line_menu1"));
        this.transferMenuItem.setOnAction(event -> ClientSingleton.getInstance().transferCallTo(this.getLineInfo(), this.iCallPanesVisibility, true));
        this.callControlItem = new MenuItem(ClientSingleton.getInstance().getString("chat_call_line_menu7"));
        this.callControlItem.setOnAction(event -> CallConferenceController.getInstance().showPopUP(this.getLineInfo()));
        this.addParticipantMenuItem = new MenuItem(ClientSingleton.getInstance().getString("chat_call_line_menu2"));
        this.addParticipantMenuItem.setOnAction(event -> ClientSingleton.getInstance().addParticipantToCall(this.getLineInfo(), this.iCallPanesVisibility, true));
        if (ClientSingleton.getInstance().canRecord()) {
            this.recordMenuItem = new MenuItem(ClientSingleton.getInstance().getString("chat_call_line_menu3"));
            this.recordMenuItem.setOnAction(event -> this.recordingToggleSwitch.setSelectedWithAction(!this.getLineInfo().isRecording()));
            this.recordingToggleSwitch = new RecordingToggleSwitch();
            this.recordingToggleSwitch.setSelected(this.getLineInfo().isRecording());
            this.recordMenuItem.setGraphic((Node)this.recordingToggleSwitch);
            this.myContextMenu.getItems().add((Object)this.recordMenuItem);
        }
        this.showPopupMenuItem = new MenuItem(ClientSingleton.getInstance().getString("chat_call_line_menu5"));
        this.showPopupMenuItem.setOnAction(event -> AudioSettingsController.getInstance().showPopUP());
        this.myContextMenu.getItems().add((Object)this.showPopupMenuItem);
        this.holdToggleSwitch = new HoldToggleSwitch(this.getLineInfo());
        this.holdToggleSwitch.setSelected(false);
        this.holdMenuItem = new MenuItem(ClientSingleton.getInstance().getString("chat_call_line_menu4"));
        this.holdMenuItem.setGraphic((Node)this.holdToggleSwitch);
        this.holdMenuItem.setOnAction(event -> {
            ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "setToggleSwitcherSelected setOnAction");
            this.holdToggleSwitch.onHold();
        });
        this.myContextMenu.getItems().add((Object)this.holdMenuItem);
    }

    private void setConferenceMenuMode(boolean isConference) {
        this.transferMenuItem.setVisible(!isConference);
        this.holdMenuItem.setVisible(!isConference);
        this.showPopupMenuItem.setVisible(!isConference);
        if (isConference && ClientSingleton.getInstance().isConferenceOwner()) {
            if (!this.myContextMenu.getItems().contains((Object)this.callControlItem)) {
                this.myContextMenu.getItems().add(0, (Object)this.callControlItem);
            }
        } else {
            this.myContextMenu.getItems().remove((Object)this.callControlItem);
        }
    }

    private void createVideoMenuItem() {
        if (this.videoMenuItem == null) {
            this.videoMenuItem = new MenuItem(ClientSingleton.getInstance().getString("chat_call_line_menu0"));
            this.videoMenuItem.setOnAction(event -> {
                HashMap<String, Object> data = new HashMap<String, Object>();
                data.put("lineInfo", this.getLineInfo());
                ClientSingleton.getInstance().doNotify(Constants.START_VIDEO, data);
            });
        }
    }

    private void setMenu() {
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "setMenu getLineInfo() =" + this.getLineInfo() + " getLineInfo().isConference()=" + this.getLineInfo().isConference());
            if (clientConnector.getPhoneDevice().getVideoMode() == 0) {
                this.myContextMenu.getItems().remove((Object)this.videoMenuItem);
                this.myContextMenu.getItems().remove((Object)this.transferMenuItem);
                this.myContextMenu.getItems().remove((Object)this.addParticipantMenuItem);
            } else if (this.getLineInfo().isConference() || this.getLineInfo().getState() == 5) {
                this.myContextMenu.getItems().remove((Object)this.holdMenuItem);
                this.myContextMenu.getItems().remove((Object)this.transferMenuItem);
                if (!this.myContextMenu.getItems().contains((Object)this.addParticipantMenuItem)) {
                    this.myContextMenu.getItems().add((Object)this.addParticipantMenuItem);
                }
            } else if (this.getLineInfo() != null && ClientSingleton.getInstance().canVideo(this.getLineInfo())) {
                this.createVideoMenuItem();
                this.myContextMenu.getItems().add((Object)this.videoMenuItem);
                this.addMenuItems();
            } else {
                if (this.videoMenuItem != null) {
                    this.myContextMenu.getItems().remove((Object)this.videoMenuItem);
                }
                this.addMenuItems();
            }
            if (this.getLineInfo() != null) {
                if (this.recordingToggleSwitch != null) {
                    this.recordingToggleSwitch.setSelectedView(this.getLineInfo().isRecording());
                }
                this.holdToggleSwitch.setSelected(this.getLineInfo().getState() == 4);
            }
            if (!this.getChildren().contains((Object)this.fx_ivCallTopMenu)) {
                this.getChildren().add(0, (Object)this.fx_ivCallTopMenu);
            }
        });
    }

    private void addMenuItems() {
        if (!this.myContextMenu.getItems().contains((Object)this.holdMenuItem)) {
            this.myContextMenu.getItems().add((Object)this.holdMenuItem);
        }
        if (!this.myContextMenu.getItems().contains((Object)this.transferMenuItem)) {
            this.myContextMenu.getItems().add((Object)this.transferMenuItem);
        }
        if (!this.myContextMenu.getItems().contains((Object)this.addParticipantMenuItem)) {
            this.myContextMenu.getItems().add((Object)this.addParticipantMenuItem);
        }
    }

    @Override
    public void setRecording(LineInfo lineInfo, boolean mode) {
        if (this.recordingToggleSwitch != null) {
            this.recordingToggleSwitch.setSelectedView(mode);
        }
    }

    @Override
    public void setHoldState(boolean mode) {
        if (this.holdToggleSwitch != null) {
            this.holdToggleSwitch.setSelected(mode);
        }
    }

    @Override
    public void removeMenu() {
        this.getChildren().remove((Object)this.fx_ivCallTopMenu);
    }

    @Override
    public void setRingtoneMuteState() {
        ClientSingleton.getInstance().setCachedImage(this.hbIncomingMuteButton, "call_notification/callpanel_incoming_mute_on.png");
        this.hbIncomingMuteButton.setFitWidth(25.0);
        this.hbIncomingMuteButton.setFitHeight(25.0);
    }

    @Override
    public void addRingtoneMuteStateListener(IRingtoneMuteState iRingtoneMuteState) {
        this.iRingtoneMuteState = iRingtoneMuteState;
    }

    @Override
    public void onMute() {
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            ClientSingleton.getInstance().setImageToImageView(this.hbMuteButton, clientConnector.getMute() ? "call_notification/callpanel_mute_on.png" : "call_notification/callpanel_mute_off.png");
            this.hbMuteButton.setFitWidth(25.0);
            this.hbMuteButton.setFitHeight(25.0);
        });
    }

    public void invalidateLinePane() {
        this.initButtons();
    }
}

