/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.calls.callaudiosettings;

import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.rxjavafx.schedulers.JavaFxScheduler;
import io.reactivex.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Pos;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.viewers.MyAlert;
import net.sipsnet.client.utils.viewers.combobox.MyComboBox;
import net.sipsnet.client.utils.viewers.contextmenu.IMenuActionListener;
import net.sipsnet.client.utils.viewers.label.MyLabel;
import net.sipsnet.client.views.settings.SettingsController;
import smile.cti.phone.PhoneDevice;

public class AudioSettingsController {
    private VBox fx_vbCallaudio;
    @FXML
    private HBox fx_hbRecordDevices;
    @FXML
    private HBox fx_hbPlaybackDevices;
    private MyComboBox fx_cbRecordDevices;
    private MyComboBox fx_cbPlaybackDevices;
    @FXML
    private MyLabel fx_lbRecordDevices;
    @FXML
    private MyLabel fx_lbPlaybackDevices;
    private float currentRecordLevel;
    private String currentSpeakerDevice;
    private String currentRecordDevice;

    private AudioSettingsController() {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fxml/settings/callaudio/callaudio.fxml"));
        loader.setResources(ClientSingleton.getInstance().getResourceBundle());
        loader.setController((Object)this);
        try {
            this.fx_vbCallaudio = (VBox)loader.load();
            loader.setController((Object)this);
            this.fx_cbRecordDevices = this.addMyComboBox((Pane)this.fx_hbRecordDevices, -1);
            this.fx_cbPlaybackDevices = this.addMyComboBox((Pane)this.fx_hbPlaybackDevices, -1);
            this.fx_lbPlaybackDevices.setLabelFontColor(ClientSingleton.getInstance().getStyleValue(Constants.TABS_TITLE_TEXT_FILL));
            this.fx_lbRecordDevices.setLabelFontColor(ClientSingleton.getInstance().getStyleValue(Constants.TABS_TITLE_TEXT_FILL));
            this.fx_cbPlaybackDevices.setBackgroundColor(ClientSingleton.getInstance().getStyleValue(Constants.BASE_COLOR));
            this.fx_cbRecordDevices.setBackgroundColor(ClientSingleton.getInstance().getStyleValue(Constants.BASE_COLOR));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.initAudioDevicesLists();
    }

    public void showPopUP() {
        MyAlert myMessageAlert = new MyAlert();
        myMessageAlert.setContentPane((Pane)this.fx_vbCallaudio).addPositiveButton(ClientSingleton.getInstance().getString("save"), (EventHandler<MouseEvent>)((EventHandler)event -> {
            myMessageAlert.close();
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                HashMap<String, String> localProperties;
                PhoneDevice device = ClientSingleton.getInstance().getClientConnector().get().getPhoneDevice();
                if (!this.currentRecordDevice.equals(this.fx_cbRecordDevices.getSelectedItem())) {
                    try {
                        device.setRecordLevel(this.currentRecordLevel);
                        localProperties = new HashMap<String, String>();
                        device.setAudioTargetLine((String)this.fx_cbRecordDevices.getSelectedItem());
                        localProperties.put("Microphone device", this.fx_cbRecordDevices.getSelectedItem().toString());
                        clientConnector.setProperties(localProperties);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                if (!this.currentSpeakerDevice.equals(this.fx_cbPlaybackDevices.getSelectedItem())) {
                    try {
                        localProperties = new HashMap();
                        localProperties.put("Speaker device", this.fx_cbPlaybackDevices.getSelectedItem().toString());
                        clientConnector.getPhoneDevice().setAudioSourceLine((String)this.fx_cbPlaybackDevices.getSelectedItem());
                        clientConnector.setProperties(localProperties);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        })).addNegativeButton(ClientSingleton.getInstance().getString("cancel"), (EventHandler<MouseEvent>)((EventHandler)event1 -> myMessageAlert.close())).showAndWait();
    }

    private void initAudioDevicesLists() {
        Observable.just((Object)true).observeOn(Schedulers.computation()).flatMap(b -> {
            PhoneDevice device = ClientSingleton.getInstance().getClientConnector().get().getPhoneDevice();
            return Observable.just((Object)device);
        }).observeOn((Scheduler)JavaFxScheduler.platform()).subscribe(device -> {
            String name;
            Map localProperties = ClientSingleton.getInstance().getClientConnector().get().getProperties();
            Number recordLevel = (Number)localProperties.get("Record level");
            if (recordLevel == null) {
                recordLevel = Float.valueOf(device.getRecordLevel());
            }
            this.currentRecordLevel = recordLevel.floatValue();
            ArrayList<String> recordDevicesList = new ArrayList<String>();
            ArrayList<String> playbackDevicesList = new ArrayList<String>();
            Enumeration en = device.getAudioSourceLines();
            while (en.hasMoreElements()) {
                name = en.nextElement().toString();
                playbackDevicesList.add(name);
            }
            en = device.getAudioTargetLines();
            while (en.hasMoreElements()) {
                name = en.nextElement().toString();
                recordDevicesList.add(name);
            }
            this.fx_cbRecordDevices.setArrowPosition(Pos.CENTER_RIGHT);
            this.fx_cbRecordDevices.addItemsList(recordDevicesList, new IMenuActionListener(){

                @Override
                public void actionPerformed(Object item) {
                }

                @Override
                public void dropDownHided() {
                }
            }, true);
            this.currentRecordDevice = (String)SettingsController.getCurrentDeviceName(recordDevicesList, (String)localProperties.get("Microphone device")).getValue();
            this.fx_cbRecordDevices.setSelectedItem(!this.currentRecordDevice.isEmpty() ? this.currentRecordDevice : device.getAudioTargetLine());
            this.fx_cbPlaybackDevices.setArrowPosition(Pos.CENTER_RIGHT);
            this.fx_cbPlaybackDevices.addItemsList(playbackDevicesList, new IMenuActionListener(){

                @Override
                public void actionPerformed(Object item) {
                }

                @Override
                public void dropDownHided() {
                }
            }, true);
            this.currentSpeakerDevice = (String)SettingsController.getCurrentDeviceName(playbackDevicesList, (String)localProperties.get("Speaker device")).getValue();
            this.fx_cbPlaybackDevices.setSelectedItem(!this.currentSpeakerDevice.isEmpty() ? this.currentSpeakerDevice : device.getAudioSourceLine());
            this.fx_cbPlaybackDevices.setPopUpWidth(390);
            this.fx_cbRecordDevices.setPopUpWidth(390);
        });
    }

    public static AudioSettingsController getInstance() {
        return new AudioSettingsController();
    }

    private MyComboBox addMyComboBox(Pane pane, int index) {
        MyComboBox myComboBox = MyComboBox.getInstance().setArrowPosition(Pos.CENTER_RIGHT).setRoundedCorners(true).setBackgroundColor(ClientSingleton.getInstance().getStyleValue(Constants.BASE_COLOR)).setExtraBackgroundColor().build();
        myComboBox.setNotFocusedStyle();
        if (index != -1) {
            pane.getChildren().add(index, (Object)myComboBox);
        } else {
            pane.getChildren().add((Object)myComboBox);
        }
        myComboBox.prefWidthProperty().bind((ObservableValue)pane.widthProperty());
        return myComboBox;
    }
}

