/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.calls.callconference;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.skin.ScrollPaneSkin;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.observer.IGUIObservable;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.connector.utils.ClientUtil;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.constants.IntentConstants;
import net.sipsnet.client.utils.popupstage.MyPopupWindow;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButton;
import net.sipsnet.client.utils.viewers.combobox.IOnHiddenListener;
import net.sipsnet.client.utils.viewers.combobox.MaxSizedContextMenu;
import net.sipsnet.client.views.calls.utils.CallLineUtils;
import net.sipsnet.client.views.chat.utils.ICallPanesVisibility;
import net.sipsnet.client.views.profiles.contactpane.ContactInfoPane;
import smile.cti.client.ContactInfo;
import smile.cti.client.LineInfo;

public class CallConferenceController
implements IGUIObservable,
IOnHiddenListener {
    private final double HEADER_HEIGHT = 40.0;
    private VBox participateBox;
    private final MaxSizedContextMenu participantContextMenu;
    private Label participantCount;
    private LineInfo lineInfo;
    private MyPopupWindow myPopupWindow;
    private static CallConferenceController callConferenceController;
    int height = 350;
    @FXML
    private HBox fx_MainAvatarPane;
    @FXML
    private VBox fx_vbMainPane;
    @FXML
    private Label fx_GroupName;
    @FXML
    private VBox fx_MembersViewPane;
    @FXML
    private ScrollPane fx_spMembersViewPane;
    @FXML
    private ImageButton fx_ivClose;

    public static CallConferenceController getInstance() {
        if (callConferenceController == null) {
            callConferenceController = new CallConferenceController();
        }
        return callConferenceController;
    }

    private CallConferenceController() {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fxml/callcontroll/callconferenceviewer.fxml"));
        loader.setResources(ClientSingleton.getInstance().getResourceBundle());
        loader.setController((Object)this);
        try {
            this.fx_vbMainPane = (VBox)loader.load();
            loader.setController((Object)this);
            this.fx_vbMainPane.setId(this.getClass().getSimpleName());
            this.fx_spMembersViewPane.prefWidthProperty().bind((ObservableValue)this.fx_vbMainPane.widthProperty().subtract(5));
            this.fx_MainAvatarPane.prefWidthProperty().bind((ObservableValue)this.fx_vbMainPane.widthProperty().subtract(10));
            Theme.getInstance().applyProfilesPaneTo((Pane)this.fx_MembersViewPane);
            Theme.getInstance().applyTo(Constants.TABS_TITLE_TEXT_FILL, (Labeled)this.fx_GroupName);
            Theme.getInstance().applyTo(Constants.CONTEXT_MENU, (Pane)this.fx_vbMainPane);
            Theme.getInstance().applyTo(Constants.SCROLL_PANE_SECOND_STYLE, (Control)this.fx_spMembersViewPane);
            this.fx_spMembersViewPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String[] actions = new String[]{IntentConstants.CONTACT_STATE_CHANGED};
        ClientSingleton.getInstance().addObserver(this, actions);
        this.participantContextMenu = new MaxSizedContextMenu();
        this.participantContextMenu.setMaxHeight(300.0);
        this.participantContextMenu.setMinWidth(150.0);
        this.participantContextMenu.setPrefWidth(150.0);
        this.participantContextMenu.setMaxWidth(150.0);
        this.participantContextMenu.setHideListener(this);
        this.getParticipatePane();
        this.fx_spMembersViewPane.skinProperty().addListener((observable, oldValue, newValue) -> {
            ScrollBar scrollBar;
            if (newValue != null && (scrollBar = ((ScrollPaneSkin)newValue).getVerticalScrollBar()) != null) {
                scrollBar.visibleProperty().addListener((observable1, oldValue1, newValue1) -> this.setPaneInScrollPaneWidth((Pane)this.fx_MembersViewPane, (boolean)newValue1));
            }
        });
        this.fx_ivClose.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.onCloseViewer()));
    }

    private void setPaneInScrollPaneWidth(Pane pane, boolean isScrollBarVisible) {
        pane.maxWidthProperty().unbind();
        pane.maxWidthProperty().unbind();
        if (isScrollBarVisible) {
            pane.maxWidthProperty().bind((ObservableValue)this.fx_spMembersViewPane.widthProperty().subtract(15));
            pane.minWidthProperty().bind((ObservableValue)this.fx_spMembersViewPane.widthProperty().subtract(15));
        } else {
            pane.maxWidthProperty().bind((ObservableValue)this.fx_spMembersViewPane.widthProperty());
            pane.minWidthProperty().bind((ObservableValue)this.fx_spMembersViewPane.widthProperty());
        }
    }

    public String getSessionId() {
        if (this.lineInfo != null && this.lineInfo.getSessionInfo() != null) {
            return this.lineInfo.getSessionInfo().getSessionId();
        }
        return "";
    }

    private void getParticipatePane() {
        this.fx_MembersViewPane.getChildren().clear();
        HBox countBox = new HBox();
        VBox.setMargin((Node)countBox, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
        countBox.setMinHeight(40.0);
        countBox.setMaxHeight(40.0);
        this.fx_MembersViewPane.getChildren().add((Object)countBox);
        countBox.setAlignment(Pos.CENTER_LEFT);
        this.participantCount = new Label();
        HBox.setHgrow((Node)countBox, (Priority)Priority.ALWAYS);
        countBox.getChildren().add((Object)this.participantCount);
        HBox.setMargin((Node)this.participantCount, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
        this.participateBox = new VBox();
        this.fx_MembersViewPane.setAlignment(Pos.CENTER);
        this.participateBox.prefWidthProperty().bind((ObservableValue)this.fx_MembersViewPane.prefWidthProperty());
        VBox.setMargin((Node)this.participateBox, (Insets)new Insets(0.0, 10.0, 10.0, 10.0));
        this.participateBox.prefWidthProperty().bind((ObservableValue)this.fx_MembersViewPane.prefWidthProperty());
        this.fx_MembersViewPane.getChildren().add((Object)this.participateBox);
        Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.participantCount);
    }

    private void makeParticipateList(VBox participateBox) {
        participateBox.getChildren().clear();
        Set members = this.lineInfo.getContacts();
        ContactInfo userInfo = ClientSingleton.getInstance().getUserInfo();
        Optional<String> str = members.stream().map(contactInfo -> ClientSingleton.getInstance().getUserID((ContactInfo)contactInfo)).filter(userInfo.getUserID()::equals).findAny();
        if (str.isEmpty()) {
            ParticipateContact participateContact = new ParticipateContact(userInfo);
            participateBox.getChildren().add((Object)participateContact);
            participateContact.minWidthProperty().bind((ObservableValue)participateBox.widthProperty());
        }
        for (ContactInfo contactInfo2 : members) {
            ParticipateContact participateContact = new ParticipateContact(contactInfo2);
            participateBox.getChildren().add((Object)participateContact);
            participateContact.minWidthProperty().bind((ObservableValue)participateBox.widthProperty());
        }
    }

    @Override
    public void onNotifiedMessage(String action, Map<String, Object> data) {
        TimerExecutor.getInstance().setMyAction(() -> {
            if (action.equals(IntentConstants.CONTACT_STATE_CHANGED)) {
                ContactInfo contactInfo = (ContactInfo)data.get("contactInfo");
                this.contactInfoStateChanged(contactInfo);
            }
        }).startWithDelayInGUIThread(200L);
    }

    private void makeMenu(ParticipateContact participateContact) {
        this.participantContextMenu.getItems().clear();
        this.participantContextMenu.setId(participateContact.contactInfo == null ? "" : ClientSingleton.getInstance().getUserID(participateContact.contactInfo));
        this.participantContextMenu.getItems().add((Object)this.addMenuItem(ClientSingleton.getInstance().getString("group_menu5"), (EventHandler<ActionEvent>)((EventHandler)action -> {
            this.participantContextMenu.hide();
            TimerExecutor.getInstance().setMyAction(this::onCloseViewer).startWithDelay(100L);
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                try {
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "dropFromConference contactInfo = " + participateContact.contactInfo);
                    clientConnector.dropFromConference(participateContact.contactInfo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }), null));
        this.participantContextMenu.getItems().add((Object)this.addMenuItem(ClientSingleton.getInstance().getString("group_menu3"), (EventHandler<ActionEvent>)((EventHandler)action -> {
            this.participantContextMenu.hide();
            TimerExecutor.getInstance().setMyAction(this::onCloseViewer).startWithDelay(100L);
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("contactInfo", participateContact.contactInfo);
            ClientSingleton.getInstance().doNotify(Constants.OPEN_SESSION, data);
        }), null));
        Bounds boundsInScene = participateContact.menuImageButton.localToScreen(participateContact.menuImageButton.getBoundsInLocal());
        this.participantContextMenu.show((Node)participateContact.menuImageButton, boundsInScene.getMinX(), boundsInScene.getMaxY());
    }

    private MenuItem addMenuItem(String title, EventHandler<ActionEvent> eventHandler, String color) {
        MenuItem menuItem = new MenuItem(title);
        menuItem.setOnAction(eventHandler);
        if (color != null) {
            menuItem.setStyle("-fx-text-fill: " + color + ";");
        }
        return menuItem;
    }

    @Override
    public void onHidden() {
        for (Node child : this.participateBox.getChildren()) {
            ParticipateContact participateContact = (ParticipateContact)child;
            participateContact.unChecked(this.participantContextMenu.getId());
        }
    }

    public void contactInfoStateChanged(ContactInfo contactInfo) {
        for (Node child : this.participateBox.getChildren()) {
            ParticipateContact participateContact = (ParticipateContact)child;
            participateContact.contactInfoStateChanged(contactInfo);
        }
    }

    public void onCloseViewer() {
        this.hidePopupWindow();
        ClientSingleton.getInstance().removeObserver(this, new String[]{Constants.DO_NOT_DISTURB_});
        ClientSingleton.getInstance().releaseViewResources((Pane)this.fx_MainAvatarPane);
        callConferenceController = null;
    }

    private void hidePopupWindow() {
        if (this.myPopupWindow != null && this.myPopupWindow.isShowing()) {
            this.myPopupWindow.hide();
            ClientSingleton.getInstance().releaseViewResources(this.myPopupWindow.getContent());
        }
    }

    public void showPopUP(LineInfo lineInfo) {
        if (this.myPopupWindow != null && this.myPopupWindow.isShowing()) {
            return;
        }
        this.hidePopupWindow();
        this.lineInfo = lineInfo;
        this.fx_GroupName.setText(CallLineUtils.getName(lineInfo));
        this.participateBox.getChildren().clear();
        this.makeParticipateList(this.participateBox);
        this.participantCount.setText(this.participateBox.getChildren().size() + " " + ClientSingleton.getInstance().getString("group_members"));
        this.fx_vbMainPane.applyCss();
        this.fx_vbMainPane.layout();
        this.fx_vbMainPane.setId("GroupProfileViewController");
        if (this.myPopupWindow == null) {
            ClientSingleton.getInstance().runLater(this::onShowPopup);
        } else {
            this.myPopupWindow.showInCenter();
        }
    }

    private void onShowPopup() {
        Stage primaryStage = new Stage();
        primaryStage.initModality(Modality.NONE);
        primaryStage.initStyle(StageStyle.UTILITY);
        primaryStage.setOpacity(0.0);
        primaryStage.setHeight(0.0);
        primaryStage.setWidth(0.0);
        if (ClientUtil.getOS() == ClientUtil.OS.WINDOWS) {
            primaryStage.show();
        }
        this.myPopupWindow = MyPopupWindow.getNewInstance((Pane)this.fx_vbMainPane, (Window)primaryStage).setAlwaysOnTop(true).setMaxWidth(this.fx_vbMainPane.getMaxWidth() + 10.0).setNoneModality().initMotionListeners((Node)this.fx_MainAvatarPane).setMaxHeight(this.fx_vbMainPane.getMaxHeight());
        this.myPopupWindow.setMaxHeight(this.height);
        this.myPopupWindow.showInCenter();
    }

    public int getRealHeight(Pane parent) {
        for (Node node : parent.getChildren()) {
            if (node instanceof ScrollPane) {
                this.getRealHeight((Pane)((ScrollPane)node).getChildrenUnmodifiable().get(0));
            }
            Bounds bounds = node.getBoundsInLocal();
            this.height = (int)((double)this.height + bounds.getHeight());
        }
        return this.height;
    }

    public void setMaxWidth(int defaultPanelWidth) {
        this.fx_vbMainPane.setMaxWidth((double)(defaultPanelWidth + 5));
        this.fx_vbMainPane.setMinWidth((double)(defaultPanelWidth + 5));
    }

    private class ParticipateContact
    extends HBox
    implements ICallPanesVisibility {
        private final ContactInfoPane contactInfoPane;
        private ContactInfo contactInfo = null;
        private ImageButton menuImageButton;

        private ParticipateContact(ContactInfo ci) {
            VBox.setMargin((Node)this, (Insets)new Insets(2.0, 0.0, 2.0, 0.0));
            this.contactInfo = ci;
            StackPane stackPane = new StackPane();
            stackPane.setMaxWidth(20.0);
            stackPane.setMaxHeight(32.0);
            HBox.setMargin((Node)stackPane, (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
            this.contactInfoPane = ContactInfoPane.getInstance().setDefaultSelectColor("transparent").setDefaultTextFontColor(this.isContactInfoInConnect() ? "#252b40" : "#646a7e").setLabel(ci).setWithAvatar(false).setSelected(false).setWithState(true).setWithMouseSelection(false).setItemPaneHeight(32).setPreventSelection(false);
            AtomicBoolean withSelection = new AtomicBoolean(true);
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                if (clientConnector.getUserId().equals(this.contactInfo.getUserID())) {
                    withSelection.set(false);
                }
            });
            if (withSelection.get()) {
                this.menuImageButton = new ImageButton();
                this.addEventFilter(MouseEvent.MOUSE_ENTERED, event -> {
                    if (CallConferenceController.this.participantContextMenu.isMenuShowing()) {
                        return;
                    }
                    this.setCursor(Cursor.HAND);
                    if (this.menuImageButton != null) {
                        this.menuImageButton.setVisible(true);
                    }
                    Theme.getInstance().applyTabCellTo((Pane)this, true, false);
                });
                this.addEventFilter(MouseEvent.MOUSE_EXITED, event -> this.unChecked());
                this.menuImageButton.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
                    if (CallConferenceController.this.participantContextMenu.isMenuShowing()) {
                        CallConferenceController.this.participantContextMenu.hide();
                    } else {
                        CallConferenceController.this.makeMenu(this);
                    }
                    event.consume();
                });
                stackPane.getChildren().add((Object)this.menuImageButton);
                this.menuImageButton.setImagePath("buttons/dot_menu.png");
                this.menuImageButton.setBackgroundColor("transparent");
                this.menuImageButton.setVisible(false);
                HBox.setMargin((Node)this.menuImageButton, (Insets)new Insets(0.0, 10.0, 0.0, 8.0));
                Theme.getInstance().applyTabCellTo((Pane)this, false, false);
            }
            this.contactInfoPane.build();
            HBox.setHgrow((Node)this.contactInfoPane, (Priority)Priority.ALWAYS);
            this.getChildren().add((Object)this.contactInfoPane);
            if (this.contactInfo != null) {
                this.contactInfoPane.getChildren().add((Object)stackPane);
            }
        }

        private boolean isContactInfoInConnect() {
            return this.contactInfo != null && this.contactInfo.getState() >= 6 && this.contactInfo.getState() <= 8;
        }

        @Override
        public void setCallPanesVisible() {
        }

        @Override
        public void setCallPanesUnVisible() {
            this.unChecked();
        }

        @Override
        public void switchToFilter() {
        }

        private void unChecked() {
            this.setCursor(Cursor.DEFAULT);
            if (CallConferenceController.this.participantContextMenu.isMenuShowing()) {
                return;
            }
            if (this.menuImageButton != null) {
                this.menuImageButton.setVisible(false);
            }
            Theme.getInstance().applyTabCellTo((Pane)this, false, false);
        }

        public void contactInfoStateChanged(ContactInfo contactInfo) {
            if (this.contactInfo != null && ClientSingleton.getInstance().getUserID(this.contactInfo).equals(ClientSingleton.getInstance().getUserID(contactInfo))) {
                this.contactInfoPane.setDefaultTextFontColor(this.isContactInfoInConnect() ? "#252b40" : "#646a7e");
                this.contactInfoPane.setTextFontStyle(this.isContactInfoInConnect());
                this.contactInfoPane.setState();
            }
        }

        public void unChecked(String elementId) {
            if (this.contactInfo != null && ClientSingleton.getInstance().getUserID(this.contactInfo).equals(elementId)) {
                this.unChecked();
            }
        }
    }
}

