/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.calls.videocall;

import javafx.beans.value.ObservableValue;
import javafx.geometry.Pos;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.image.Image;
import javafx.scene.image.PixelFormat;
import javafx.scene.image.PixelWriter;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.util.Pair;
import net.sipsnet.client.utils.stage.ResizeHelper;
import net.sipsnet.client.views.calls.videocall.DisplayPane;
import net.sipsnet.client.views.calls.videocall.Frame;

public class VideoFrameView
extends DisplayPane {
    private final VBox videoPane = new VBox();
    private int minWidth;
    private int minHeight;
    private GraphicsContext graphicsContext;
    private Canvas canvas;
    public static final int CAMERA_VIEW_MODE = 0;
    public static final int SETTINGS_CAMERA_VIEW_MODE = 1;
    public static final int NOTIFICATION_VIEW_MODE = 2;
    public static final int NOTIFICATION_CAMERA_VIEW_MODE = 3;
    public static final int BIG_VIEW_MODE = 4;
    private double width;
    private double height;
    private double x;
    private double y;
    private PixelWriter pixelWriter;

    private VideoFrameView(String id, int mode) {
        super(id, mode);
        switch (mode) {
            case 0: {
                this.minWidth = 124;
                this.minHeight = 93;
                break;
            }
            case 2: {
                this.minWidth = 318;
                this.minHeight = 243;
                break;
            }
            case 3: {
                this.minWidth = 93;
                this.minHeight = 73;
                break;
            }
            case 4: {
                this.minWidth = 640;
                this.minHeight = 480;
            }
        }
        this.videoPane.setAlignment(Pos.CENTER);
    }

    public static VideoFrameView getInstance(String id, int mode) {
        return new VideoFrameView(id, mode);
    }

    public Pane getFrameView() {
        return this.videoPane;
    }

    @Override
    public void startPlaying() {
        if (this.canvas != null) {
            this.stopPlaying();
        }
        this.canvas = new Canvas();
        this.canvas.widthProperty().bind((ObservableValue)this.videoPane.prefWidthProperty());
        this.canvas.heightProperty().bind((ObservableValue)this.videoPane.prefHeightProperty());
        this.videoPane.getChildren().clear();
        this.videoPane.getChildren().add((Object)this.canvas);
        super.startPlaying();
    }

    @Override
    public void stopPlaying() {
        super.stopPlaying();
        if (this.canvas != null) {
            this.videoPane.getChildren().clear();
            this.canvas.widthProperty().unbind();
            this.canvas.heightProperty().unbind();
            this.graphicsContext = this.canvas.getGraphicsContext2D();
            this.graphicsContext.clearRect(0.0, 0.0, this.canvas.getWidth(), this.canvas.getHeight());
            this.graphicsContext.setFill((Paint)Color.BLACK);
            this.graphicsContext.fillRect(0.0, 0.0, this.canvas.getWidth(), this.canvas.getHeight());
        }
        this.graphicsContext = null;
        this.canvas = null;
    }

    @Override
    public boolean drawFrame() throws Exception {
        if (!super.drawFrame() || this.getWritableImage() == null || this.canvas == null) {
            return false;
        }
        Frame frame = this.getFrame();
        if (frame == null || frame.getIntPixels() == null) {
            return false;
        }
        this.graphicsContext = this.canvas.getGraphicsContext2D();
        this.width = this.videoPane.getPrefWidth();
        this.height = this.videoPane.getPrefHeight();
        if (this.getMode() == 0 || this.getMode() == 3) {
            this.width = this.minWidth;
            this.height = this.minHeight;
        } else {
            double delta;
            double ratio;
            this.width = this.getCurrentFrameWidth();
            this.height = this.getCurrentFrameHeight();
            if (this.width == 0.0 || this.height == 0.0) {
                this.width = this.minWidth;
                this.height = this.minHeight;
            }
            ResizeHelper.isResize = true;
            if (this.getCurrentFrameWidth() > this.getCurrentFrameHeight()) {
                ratio = this.canvas.getWidth() / (double)this.getCurrentFrameWidth();
                this.width = this.canvas.getWidth();
                this.height = (double)this.getCurrentFrameHeight() * ratio;
            } else {
                ratio = this.canvas.getHeight() / (double)this.getCurrentFrameHeight();
                this.width = (double)this.getCurrentFrameWidth() * ratio;
                this.height = this.canvas.getHeight();
            }
            if (this.height > this.canvas.getHeight()) {
                delta = this.height - this.canvas.getHeight();
                this.height -= delta;
                this.width -= delta * ratio;
            }
            if (this.width > this.canvas.getWidth()) {
                delta = this.width - this.canvas.getWidth();
                this.width -= delta;
                this.height -= delta / ratio;
            }
            ResizeHelper.isResize = false;
        }
        if (this.getMode() == 4 || this.getMode() == 2 || this.getMode() == 1) {
            this.x = (this.canvas.getWidth() - this.width) / 2.0;
            this.y = (this.canvas.getHeight() - this.height) / 2.0;
        }
        this.pixelWriter = this.getWritableImage().getPixelWriter();
        this.pixelWriter.setPixels(0, 0, this.getCurrentFrameWidth(), this.getCurrentFrameHeight(), (PixelFormat)PixelFormat.getIntArgbInstance(), frame.getIntPixels(), 0, this.getCurrentFrameWidth());
        this.graphicsContext.clearRect(0.0, 0.0, this.canvas.getWidth(), this.canvas.getHeight());
        this.graphicsContext.drawImage((Image)this.getWritableImage(), 0.0, 0.0, (double)this.getCurrentFrameWidth(), (double)this.getCurrentFrameHeight(), this.x, this.y, this.width, this.height);
        this.pixelWriter = null;
        return true;
    }

    public VideoFrameView setResizeFitToPane(Pair<Double, Double> fitToPane) {
        this.setFitToPane(fitToPane);
        return this;
    }

    public double getPrefWidth() {
        return this.videoPane.getPrefWidth();
    }

    public void setMinWidth(double width) {
        this.videoPane.setMinWidth(width);
    }

    public void setMaxWidth(double width) {
        this.videoPane.setMaxWidth(width);
    }

    public double getPrefHeight() {
        return this.videoPane.getPrefHeight();
    }

    public void setMinHeight(double height) {
        this.videoPane.setMinHeight(height);
    }

    public void setMaxHeight(double height) {
        this.videoPane.setMaxHeight(height);
    }

    public VideoFrameView setIsWithNotification(boolean b) {
        this.setWithNotification(b);
        return this;
    }

    @Override
    public boolean isCameraViewer() {
        return this.getMode() == 0 || this.getMode() == 3 || this.getMode() == 1;
    }
}

