/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.calls.videocall;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javafx.stage.Screen;
import javafx.util.Pair;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.views.calls.videocall.Frame;
import net.sipsnet.client.views.calls.videocall.IDisplayPane;
import net.sipsnet.client.views.calls.videocall.IVideoProcessor;
import net.sipsnet.client.views.calls.videocall.VideoProcessorHelper;
import smile.cti.phone.video.DisplayPane;
import smile.cti.phone.video.VideoDevice;

public class VideoProcessor
implements DisplayPane,
IVideoProcessor {
    public static final String OUTPUT_PIX_FORMAT = "RGB24";
    private ExecutorService executorService;
    private boolean showDesktop = false;
    private final VideoProcessorHelper videoProcessorHelper;
    private boolean isLastFocusState = false;
    private final VideoDevice device;
    private boolean capturing = false;
    private final LocalImagePainter localImagePainter;
    private static final List<Pair<Double, Double>> videoCapabilities = new ArrayList<Pair<Double, Double>>();

    public VideoProcessor() {
        videoCapabilities.add((Pair<Double, Double>)new Pair((Object)800.0, (Object)600.0));
        videoCapabilities.add((Pair<Double, Double>)new Pair((Object)1024.0, (Object)768.0));
        videoCapabilities.add((Pair<Double, Double>)new Pair((Object)1280.0, (Object)720.0));
        videoCapabilities.add((Pair<Double, Double>)new Pair((Object)1280.0, (Object)960.0));
        videoCapabilities.add((Pair<Double, Double>)new Pair((Object)1280.0, (Object)1024.0));
        videoCapabilities.add((Pair<Double, Double>)new Pair((Object)1408.0, (Object)960.0));
        videoCapabilities.add((Pair<Double, Double>)new Pair((Object)1408.0, (Object)1152.0));
        videoCapabilities.add((Pair<Double, Double>)new Pair((Object)1600.0, (Object)1200.0));
        videoCapabilities.add((Pair<Double, Double>)new Pair((Object)1920.0, (Object)1080.0));
        this.device = ClientSingleton.getInstance().getClientConnector().get().getPhoneDevice().getVideoDevice();
        this.localImagePainter = new LocalImagePainter();
        this.videoProcessorHelper = new VideoProcessorHelper();
        this.setDisplayChannel(true);
        this.setShowingDesktop(false);
    }

    @Override
    public void addImageViewer(IDisplayPane frameViewer) {
        this.videoProcessorHelper.addImageViewer(frameViewer);
    }

    public void addImageViewerAndStart(IDisplayPane frameViewer) {
        this.videoProcessorHelper.addImageViewerAndStart(frameViewer);
    }

    public void removeSettingCamera() {
        this.videoProcessorHelper.removeSettingCamera();
    }

    public DisplayPane getLocalView() {
        return this.localImagePainter;
    }

    public void setCapturing() {
        TimerExecutor.getInstance().setMyAction(() -> {
            this.capturing = this.device.isCapturing();
        }).startWithDelay(100L);
    }

    @Override
    public void setCapturing(boolean b) {
        this.capturing = b;
        ClientSingleton.toLog(this.getClass().getSimpleName(), "Constants.START_VIDEO setCapturing = " + this.capturing);
        if (this.capturing) {
            this.executorService = Executors.newSingleThreadExecutor();
            this.executorService.execute(() -> {
                this.setDeviceCapture(true);
                TimerExecutor.getInstance().setMyAction(() -> ClientSingleton.getInstance().doNotify("smile.uccproject.CHANGE_CAPTURING_STATE")).startWithDelay(200L);
                while (this.capturing) {
                    try {
                        Thread.sleep(20L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.device.setCapturing(false);
                TimerExecutor.getInstance().setMyAction(() -> ClientSingleton.getInstance().doNotify("smile.uccproject.CHANGE_CAPTURING_STATE")).startWithDelay(200L);
            });
        } else if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        } else if (this.device.isCapturing()) {
            this.executorService = Executors.newSingleThreadExecutor();
            this.executorService.execute(() -> {
                this.device.setCapturing(false);
                TimerExecutor.getInstance().setMyAction(() -> ClientSingleton.getInstance().doNotify("smile.uccproject.CHANGE_CAPTURING_STATE")).startWithDelay(200L);
            });
        }
    }

    @Override
    public boolean isCapturing() {
        return this.capturing;
    }

    private void setDeviceCapture(boolean mode) {
        if (this.device != null && Boolean.compare(mode, this.device.isCapturing()) != 0) {
            this.device.setCapturing(mode);
        }
    }

    public void setDisplayChannel(boolean b) {
        if (b) {
            this.device.setDisplayChannel((DisplayPane)this);
            this.device.setLocalView((DisplayPane)this.localImagePainter);
            this.setShowingDesktop(false);
        } else {
            this.device.setDisplayChannel(null);
            this.device.setLocalView(null);
            this.clear();
        }
    }

    @Override
    public void setShowingDesktop(boolean mode) {
        this.showDesktop = mode;
        if (mode) {
            this.isLastFocusState = ClientSingleton.getInstance().isFocused();
            ClientSingleton.getInstance().doNotify(Constants.SHARE_DESKTOP);
        } else {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("lastFocusState", this.isLastFocusState);
            this.isLastFocusState = false;
            ClientSingleton.getInstance().doNotify(Constants.DISMISS_SHARE_DESKTOP, data);
        }
        if (this.showDesktop) {
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                double height;
                Screen screen = ClientSingleton.getInstance().getCurrentScreen();
                double width = screen.getVisualBounds().getWidth();
                double ratio = width > (height = screen.getVisualBounds().getHeight()) ? width / height : height / width;
                ClientSingleton.toLog(this.getClass().getSimpleName(), "setShowingDesktop size = " + width + "x" + height + " ratio=" + ratio);
                List list = videoCapabilities.stream().filter(pair -> ratio >= (Double)pair.getKey() / (Double)pair.getValue()).collect(Collectors.toList());
                if (list.size() == videoCapabilities.size()) {
                    list = videoCapabilities.stream().filter(pair -> (Double)pair.getKey() / (Double)pair.getValue() > 1.7).collect(Collectors.toList());
                }
                Pair curPair = null;
                for (Pair pair2 : list) {
                    if (width > height) {
                        if (!((Double)pair2.getKey() >= width)) continue;
                        curPair = pair2;
                        continue;
                    }
                    if (!((Double)pair2.getValue() >= height)) continue;
                    curPair = pair2;
                }
                ClientSingleton.toLog(this.getClass().getSimpleName(), "setShowingDesktop  list curPair " + curPair);
                if (width > height) {
                    width = curPair != null ? (Double)curPair.getKey() : 1280.0;
                    height = curPair != null ? (Double)curPair.getValue() : 960.0;
                } else {
                    width = curPair != null ? (Double)curPair.getValue() : 960.0;
                    height = curPair != null ? (Double)curPair.getKey() : 1280.0;
                }
                ClientSingleton.toLog(this.getClass().getSimpleName(), "setShowingDesktop  list near size " + width + "x" + height);
                this.device.setShowDesktop(width, height, true);
            });
            this.setFrameViewers(false);
        } else {
            this.device.setShowDesktop(false);
            this.setFrameViewers(true);
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "setShowingDesktop showDesktop=" + this.showDesktop + " device.isShowingDesktop() = " + this.device.isShowingDesktop());
    }

    private void setFrameViewers(boolean isStart) {
        this.videoProcessorHelper.setFrameViewers(isStart);
    }

    public void setOutputFrameSize() {
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            int width = 640;
            int height = 480;
            Map localProperties = clientConnector.getProperties();
            String fmt = (String)localProperties.get("Camera format");
            if (fmt == null || fmt.isEmpty()) {
                fmt = "640x480";
            }
            String[] formats = fmt.split("x");
            try {
                width = Integer.parseInt(formats[0]);
                height = Integer.parseInt(formats[1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ClientSingleton.toLog(this.getClass().getSimpleName(), "setOutputFrameSize showDesktop=" + this.showDesktop + " device.isShowingDesktop() = " + this.device.isShowingDesktop() + " " + width + "x" + height);
            this.setOutputPixFormat(width, height);
        });
    }

    public void setOutputPixFormat(int width, int height) {
        if (width <= 0 || height <= 0) {
            width = 640;
            height = 480;
        }
        this.device.setOutputFormat(width, height, OUTPUT_PIX_FORMAT);
    }

    @Override
    public boolean isDesktopShowing() {
        return this.showDesktop;
    }

    public void setLocalPicture(boolean on) {
        if (on) {
            this.device.setLocalView((DisplayPane)this.localImagePainter);
        } else if (!this.isDesktopShowing()) {
            this.device.setLocalView(null);
        }
    }

    private void clear() {
        this.setShowingDesktop(false);
        this.videoProcessorHelper.clear();
    }

    public void drawImage(byte[] data, int width, int height, int bpr, boolean invert) {
        if (!this.isDesktopShowing()) {
            this.videoProcessorHelper.addFrame(new Frame(data, width, height), true);
        }
    }

    public String getPixelFormat() {
        return OUTPUT_PIX_FORMAT;
    }

    public void clearDesktopShowing() {
        this.showDesktop = false;
    }

    class LocalImagePainter
    implements DisplayPane {
        LocalImagePainter() {
        }

        public void drawImage(byte[] pixels, int width, int height, int bpr, boolean invert) {
            if (!VideoProcessor.this.isDesktopShowing()) {
                VideoProcessor.this.videoProcessorHelper.addFrame(new Frame(pixels, width, height), false);
            }
        }

        public String getPixelFormat() {
            return VideoProcessor.OUTPUT_PIX_FORMAT;
        }
    }
}

