/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.calls.videocall;

import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.views.calls.videocall.Frame;
import net.sipsnet.client.views.calls.videocall.IDisplayPane;

public class VideoProcessorHelper {
    private final ArrayList<IDisplayPane> imageViewers = new ArrayList();
    private ExecutorService executorService;

    public void addImageViewerAndStart(IDisplayPane frameViewer) {
        this.imageViewers.add(frameViewer);
        if (this.executorService != null) {
            frameViewer.start();
        }
    }

    public void addImageViewer(IDisplayPane frameViewer) {
        this.imageViewers.add(frameViewer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSettingCamera() {
        ArrayList<IDisplayPane> arrayList = this.imageViewers;
        synchronized (arrayList) {
            this.imageViewers.removeIf(iDisplayPane -> iDisplayPane.getMode() == 1);
        }
    }

    public void clear() {
        for (IDisplayPane frameViewer : this.imageViewers) {
            frameViewer.clear();
        }
    }

    public void setFrameViewers(boolean isStart) {
        TimerExecutor.getInstance().setMyAction(() -> {
            if (isStart) {
                this.start();
            }
            for (IDisplayPane frameViewer : this.imageViewers) {
                if (isStart) {
                    frameViewer.start();
                    continue;
                }
                frameViewer.clear();
            }
            if (!isStart) {
                this.stop();
            }
        }).startWithDelayInGUIThread(200L);
    }

    public void addFrame(Frame frame, boolean isVideoFrame) {
        if (this.executorService == null) {
            this.start();
        }
        this.executorService.execute(() -> {
            frame.convertByteArray();
            for (IDisplayPane displayPane : this.imageViewers) {
                if (isVideoFrame && !displayPane.isCameraViewer()) {
                    displayPane.addVideoFrame(frame);
                    continue;
                }
                if (isVideoFrame || !displayPane.isCameraViewer()) continue;
                displayPane.addVideoFrame(frame);
            }
        });
    }

    private void start() {
        if (this.executorService == null) {
            this.executorService = Executors.newSingleThreadExecutor();
        }
    }

    private void stop() {
        if (this.executorService != null) {
            this.executorService.shutdownNow();
            this.executorService = null;
        }
    }
}

