/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.calls.videocall.notification;

import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.stage.Window;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.utils.AudioCaller;
import net.sipsnet.client.connector.utils.ClientUtil;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.popupstage.MyPopupWindow;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.CallViewButton;

public class ShareDesktopPane
extends HBox {
    private MyPopupWindow myPopupWindow;
    private final int EXPANDED_WIDTH = 130;
    private CallViewButton muteCallImageButton;

    public ShareDesktopPane() {
        this.initComponents();
    }

    private void initComponents() {
        boolean isMute = AudioCaller.isMute();
        this.muteCallImageButton = new CallViewButton(true, isMute ? "notification/call/callpanel_mute_on.png" : "notification/call/callpanel_mute_off.png", (EventHandler<MouseEvent>)((EventHandler)str -> AudioCaller.setMute()));
        this.muteCallImageButton.setTooltip(isMute ? "tooltip_unmute" : "tooltip_mute");
        CallViewButton shareDesktopImageButton = new CallViewButton(true, "notification/call/widget_show_screen.png", (EventHandler<MouseEvent>)((EventHandler)str -> ClientSingleton.getInstance().doNotify(Constants.DISMISS_SHARE_DESKTOP)));
        shareDesktopImageButton.setTooltip("tooltip_dismiss_share_screen");
        HBox.setHgrow((Node)this.muteCallImageButton, (Priority)Priority.ALWAYS);
        HBox.setHgrow((Node)shareDesktopImageButton, (Priority)Priority.ALWAYS);
        this.setAlignment(Pos.CENTER);
        HBox hBox = new HBox();
        HBox.setMargin((Node)hBox, (Insets)new Insets(5.0, 0.0, 5.0, 0.0));
        String color = ClientSingleton.getInstance().getStyleValue(Constants.CALL_NOTIFICATION_STYLE);
        String style = "-fx-background-color: " + color + ";-fx-border-radius: 10 10 10 10;-fx-background-radius: 10 10 10 10;";
        hBox.setStyle(style);
        hBox.prefWidthProperty().bind((ObservableValue)this.maxWidthProperty());
        hBox.prefHeightProperty().bind((ObservableValue)this.maxHeightProperty());
        hBox.getChildren().addAll((Object[])new Node[]{this.muteCallImageButton, shareDesktopImageButton});
        this.getChildren().add((Object)hBox);
        this.setMaxWidth(130.0);
        this.setMaxHeight(60.0);
        this.setMinWidth(130.0);
        this.setMinHeight(60.0);
        this.setAlignment(Pos.CENTER);
        this.setStyle(style);
        Stage primaryStage = new Stage();
        primaryStage.initModality(Modality.NONE);
        primaryStage.initStyle(StageStyle.UTILITY);
        primaryStage.setOpacity(0.0);
        primaryStage.setHeight(0.0);
        primaryStage.setWidth(0.0);
        if (ClientUtil.getOS() == ClientUtil.OS.WINDOWS) {
            primaryStage.show();
        }
        this.myPopupWindow = MyPopupWindow.getNewInstance((Pane)this, (Window)primaryStage).setWindowModality().initMotionListeners((Node)this).setMaxWidth(this.getMaxWidth()).setMaxHeight(this.getMaxHeight());
    }

    public void show() {
        ClientSingleton.getInstance().runLater(() -> {
            boolean isMute = AudioCaller.isMute();
            this.muteCallImageButton.setImageView(isMute ? "notification/call/callpanel_mute_on.png" : "notification/call/callpanel_mute_off.png");
            this.myPopupWindow.showFromRight(130.0);
        });
    }

    public void hide() {
        ClientSingleton.getInstance().runLater(() -> this.myPopupWindow.hideToRight(false));
    }

    public boolean isShowing() {
        return this.myPopupWindow.isShowing();
    }

    public void onMute() {
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            boolean isMute = clientConnector.getMute();
            this.muteCallImageButton.setImageView(isMute ? "notification/call/callpanel_mute_on.png" : "notification/call/callpanel_mute_off.png");
            this.muteCallImageButton.setTooltip(isMute ? "tooltip_unmute" : "tooltip_mute");
        });
    }
}

