/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.chat;

import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.rxjavafx.schedulers.JavaFxScheduler;
import io.reactivex.subjects.PublishSubject;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javafx.animation.Animation;
import javafx.animation.FadeTransition;
import javafx.application.Platform;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.input.TransferMode;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Popup;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.util.Duration;
import javafx.util.Pair;
import javax.imageio.ImageIO;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.observer.IGUIObservable;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.connector.utils.AudioCaller;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.constants.IntentConstants;
import net.sipsnet.client.utils.MyUtils;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.threadpool.MyThreadPoolManager;
import net.sipsnet.client.utils.viewers.avatar.AvatarPane;
import net.sipsnet.client.utils.viewers.buttoncombobox.ContextMenuImageButton;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.CloseImageButton;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButton;
import net.sipsnet.client.utils.viewers.combobox.MaxSizedContextMenu;
import net.sipsnet.client.utils.viewers.contextmenu.MyContextMenu;
import net.sipsnet.client.utils.viewers.imageview.MyImageView;
import net.sipsnet.client.utils.viewers.label.MyLabel;
import net.sipsnet.client.utils.viewers.richtext.MyStyledTextArea;
import net.sipsnet.client.utils.viewers.statespane.StatesPane;
import net.sipsnet.client.utils.viewers.textfieldwithsearch.TextFieldWithSearch;
import net.sipsnet.client.views.audiomessage.AudioMessagePane;
import net.sipsnet.client.views.calls.audiocontrolls.LineInfoPane;
import net.sipsnet.client.views.calls.chatline.CallLinePane;
import net.sipsnet.client.views.calls.chatline.ICallLineState;
import net.sipsnet.client.views.calls.videocall.videoscreen.IVCScreenController;
import net.sipsnet.client.views.chat.cell.ChatCell;
import net.sipsnet.client.views.chat.cell.ChatCellPane;
import net.sipsnet.client.views.chat.cell.MessageInfoDate;
import net.sipsnet.client.views.chat.cell.ReplyImageTask;
import net.sipsnet.client.views.chat.holders.viewerholders.LinkHBoxViewHolder;
import net.sipsnet.client.views.chat.holders.viewerholders.callviewer.CallViewerBase;
import net.sipsnet.client.views.chat.interfaces.IChatListCell;
import net.sipsnet.client.views.chat.messagepane.IChatInputTextArea;
import net.sipsnet.client.views.chat.messagepane.IInnerMessageTextArea;
import net.sipsnet.client.views.chat.messageutil.MessageInfoCellLabels;
import net.sipsnet.client.views.chat.utils.ICallPanesVisibility;
import net.sipsnet.client.views.emoji.EmojiActionEvent;
import net.sipsnet.client.views.emoji.EmojisController;
import net.sipsnet.client.views.emoji.ExtEmojisController;
import net.sipsnet.client.views.emoji.IEmojiController;
import net.sipsnet.client.views.emoji.utils.EmojiUtils;
import net.sipsnet.client.views.group.createeditgroup.GroupCreatorEditor;
import net.sipsnet.client.views.mainview.MainViewSceneController;
import net.sipsnet.client.views.mainview.ringtonemode.IRingtoneMuteState;
import net.sipsnet.client.views.tabs.UpdateLists;
import net.sipsnet.client.views.tabs.utils.INewMessagesNotification;
import org.fxmisc.flowless.Cell;
import org.fxmisc.flowless.VirtualFlow;
import org.fxmisc.flowless.VirtualizedScrollPane;
import org.fxmisc.richtext.EditActions;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import smile.cti.client.ClientConnector;
import smile.cti.client.ContactInfo;
import smile.cti.client.FileInfo;
import smile.cti.client.LineInfo;
import smile.cti.client.MessageInfo;
import smile.cti.client.SessionInfo;

public class ChatPaneWithFlowListController
implements Initializable,
IChatInputTextArea,
IGUIObservable,
IChatListCell,
ICallPanesVisibility,
ICallLineState {
    public HBox fx_MessageType;
    public HBox fx_hbReply;
    public Label fx_Reply;
    public HBox fx_hbComments;
    public Label fx_Comment;
    public HBox fx_BottomContainer;
    public Label fx_lbCallTimer;
    public Label fx_lbCallTrunk;
    private CallLinePane callLinePane;
    private Popup popup;
    private final Map<String, String> oldMessages = new HashMap<String, String>();
    private final int MAX_INSERTED_ITEMS = 15;
    private MessageInfoDate lastDay = null;
    private int countOfLoadedCellsOnScreen;
    private MessageInfo messageEdited;
    private final int ACTION_FOOL_MODE = 0;
    private final int ACTION_SMS_MODE = 1;
    private final int ACTION_TEXT_MODE = 2;
    private final int ACTION_MMS_MODE = 3;
    public static final int FILTER_ALL = 0;
    public static final int FILTER_CALLS = 1;
    public static final int FILTER_STAR = 2;
    public static final int FILTER_LINKS = 3;
    public static final int FILTER_FILES = 4;
    public static final int FILTER_SEARCH = 5;
    public static final int INFO_PROFILE = 0;
    public static final int INFO_ACTIVITY = 1;
    public static final int INFO_COMMENT = 2;
    public static final int DO_NOT_SCROLL = -1;
    private final int DO_NOT_SCROLL_ON_START = -2;
    private final int SCROLL_TO_BOTTOM = -3;
    private final SimpleIntegerProperty lastScrollMode = new SimpleIntegerProperty(-1);
    public ProgressIndicator progressIndicator = ClientSingleton.getInstance().getProgressIndicator();
    public static int currentFilter = 0;
    private IVCScreenController ivcScreenController;
    private SessionInfo sessionInfo;
    public static int PREF_BOTTOM_PANE_HEIGHT = 34;
    public static int PREF_PADDING = 5;
    private MyStyledTextArea myStyledTextArea;
    private final SimpleBooleanProperty isSimpleViewMode = new SimpleBooleanProperty((Object)false, "isSimpleViewMode");
    private final SimpleBooleanProperty loadingPreviousMessages = new SimpleBooleanProperty(false);
    private boolean isCallPanesVisible;
    private MessageInfo replayMessageInfo = null;
    private MessageInfo getReplyMessageInfo = null;
    private final ObservableList<MessageInfo> messageInfos = FXCollections.observableArrayList();
    private final ObservableMap<String, ChatCellPane> chatCells = FXCollections.observableHashMap();
    private boolean isRefreshingList;
    private boolean isAddingMessageToList;
    private int currentVisibleInfoPane = -1;
    private KeyCode lastPressedKey;
    public AnchorPane fx_RootPane;
    private int textAreaWidth;
    private TimerExecutor timerExecutor;
    private VirtualFlow<MessageInfo, ?> virtualFlow;
    private VirtualizedScrollPane<VirtualFlow<MessageInfo, ?>> scrollPane;
    private double draggedLayoutY = -1.0;
    private MaxSizedContextMenu mentionMenu;
    private final int ACTION_RECEIVE_MESSAGE = 0;
    private final int ACTION_UPDATE_MESSAGE = 1;
    private final int ACTION_REMOVE_MESSAGE = 2;
    private final int ACTION_UPDATE_AVATARS = 3;
    private final int ACTION_LOAD_MESSAGES = 4;
    private final String LINK_MESSAGE_ID = "link_messageId";
    private final String LINK_URL = "link_url";
    private final String LINK_INDEX = "link_index";
    private final BlockingQueue<Map<String, Object>> queueUrls = new ArrayBlockingQueue<Map<String, Object>>(20);
    private final BlockingQueue<Pair<Integer, MessageInfo>> queueMessagesForUpdate = new ArrayBlockingQueue<Pair<Integer, MessageInfo>>(200);
    protected PublishSubject<Integer> messagesListObserver;
    private Disposable disposableUrl;
    private Disposable disposableMessageUpdate;
    protected CompositeDisposable disposables = new CompositeDisposable();
    private final SimpleBooleanProperty isAddUrl = new SimpleBooleanProperty();
    private final SimpleBooleanProperty isAddingMessageForUpdate = new SimpleBooleanProperty();
    private int currentMessageType = -1;
    private final int MESSAGE_TYPE_CODE = 0;
    public static final int COMMENT_TYPE_CODE = 1024;
    private StatesPane statesPane;
    private INewMessagesNotification iNewMessagesNotification;
    private final ChangeListener<Number> onScrollFinished = (event, oldValue, newValue) -> {
        if (!this.messageInfos.isEmpty()) {
            if (this.virtualFlow.getLastVisibleIndex() != this.messageInfos.size() - 1) {
                this.showScrollButton();
            } else {
                this.hideScrollButton();
            }
        }
        if ((this.virtualFlow.getFirstVisibleIndex() == 1 || this.virtualFlow.getFirstVisibleIndex() == 2) && newValue.doubleValue() - oldValue.doubleValue() < 0.0) {
            this.onPreviousMessagesRequest();
        }
    };
    private final EventHandler<MouseEvent> eventHandlerMousePressed = event -> {
        if (!this.isLoadingPreviousMessages() && this.scrollPane.getCursor() != Cursor.CLOSED_HAND && this.virtualFlow.getFirstVisibleIndex() == 0) {
            this.scrollPane.setCursor(Cursor.CLOSED_HAND);
            this.draggedLayoutY = event.getScreenY();
        }
    };
    private final EventHandler<MouseEvent> eventHandlerMouseClicked = event -> {
        if (this.scrollPane.getCursor() != Cursor.DEFAULT) {
            this.scrollPane.setCursor(Cursor.DEFAULT);
        }
    };
    private final EventHandler<MouseEvent> eventHandlerMouseReleased = event -> {
        if (this.scrollPane.getCursor() == Cursor.CLOSED_HAND && !this.isLoadingPreviousMessages() && this.draggedLayoutY != -1.0 && event.getScreenY() - this.draggedLayoutY > 0.0) {
            this.onPreviousMessagesRequest();
        }
    };
    private MyContextMenu myContextMenu;
    private MyContextMenu mySendContextMenu;
    private PublishSubject<Boolean> loadingPreviousMessagesObserver;
    private IEmojiController emojiController;
    private PublishSubject<Integer> resizeObserver;
    public StackPane fx_MainStackPane;
    public HBox fx_ButtonsPane;
    public VBox fx_vbCallAvatar;
    public Label fx_lbCallContactName;
    public Label fx_lbCallType;
    public HBox fx_hbCallButton;
    public StackPane fx_hbCallTopPaneBackground;
    public HBox fx_hbCallTopPane;
    public VBox fx_vbCallInfoButtons;
    public ImageButton fx_ivInfo;
    public ImageButton fx_ivActivity;
    public ImageButton fx_ivComment;
    public ImageView fx_hbCallTopPaneImage;
    public HBox fx_LoadFileReceiverPane;
    private HBox filterPane;
    public AnchorPane fx_hbChatListPane;
    @FXML
    public StackPane fx_spTopPane;
    @FXML
    public ContextMenuImageButton fx_ivTopMenu;
    @FXML
    public ImageButton fx_ivVideoCall;
    @FXML
    public ImageButton fx_ivAudioCall;
    @FXML
    public Label fx_lbContactName;
    @FXML
    public Label fx_lbStateName;
    @FXML
    public HBox fx_hbStatePane;
    private ImageButton fx_ivEmojiPane;
    private ImageButton fx_ivAudioMessage;
    private ImageButton fx_ivSendMessage;
    private ImageButton fx_ivFileChooser;
    @FXML
    public AnchorPane fx_InputPane;
    @FXML
    public VBox fx_ChatBottomPane;
    @FXML
    private StackPane fx_lvChatListPane;
    @FXML
    public VBox fx_ReplayPane;
    @FXML
    public VBox fx_EditPane;
    @FXML
    public VBox fx_EmojiPane;
    @FXML
    public StackPane fx_vbAvatar;
    public ImageButton fx_ivMoveDown;
    public HBox fx_hbChatTopPaneBackground;
    public VBox fx_vbTopLine;
    public TextFieldWithSearch fx_FilterSearch;
    public CloseImageButton fx_CloseFilterLine;
    public ImageButton fx_FilterAll;
    public ImageButton fx_FilterStar;
    public ImageButton fx_FilterCalls;
    public ImageButton fx_FilterLinks;
    public ImageButton fx_FilterFiles;
    public VBox fx_FilterPane;
    public ImageButton fx_Search;
    public HBox fx_MainButtonsPane;
    public HBox fx_Indicator;
    public MyLabel fx_SMSLabel;
    public BorderPane fx_MainChatPane;
    public VBox fx_vbTitle;
    public HBox fx_hbMutePane;
    public ImageView fx_ivMute;
    public Label fx_lbMute;
    public HBox fx_CallButtonsPane;

    public void setINewMessagesNotification(INewMessagesNotification iNewMessagesNotification) {
        this.iNewMessagesNotification = iNewMessagesNotification;
    }

    private Optional<MyStyledTextArea> getStyledTextArea() {
        return this.myStyledTextArea != null ? Optional.of(this.myStyledTextArea) : Optional.empty();
    }

    public void initialize(URL location, ResourceBundle resources) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "initialize start");
        this.fx_RootPane.setId(this.getClass().getSimpleName());
        this.fx_MainStackPane.getChildren().remove((Object)this.fx_LoadFileReceiverPane);
        this.fx_ivAudioCall.setEnableDelay();
        this.fx_ivVideoCall.setEnableDelay();
        String color = ClientSingleton.getInstance().getStyleValue(Constants.SECOND_BASE_COLOR);
        String style = " -fx-opacity: 0.7;    -fx-line-height: 1.19;    -fx-border-color: #969aae;    -fx-border-insets: 2 2 2 2;    -fx-border-width: 2 2 2 2;    -fx-padding: 0 0 0 0;-fx-background-color: %s;-fx-border-style: dashed;    -fx-border-radius: 2;";
        this.fx_LoadFileReceiverPane.setStyle(Theme.getInstance().formatedString(style, color));
        Theme.getInstance().applyTo(Constants.CHAT_TOP_AND_BOTTOM_BACKGROUND, (Pane)this.fx_ChatBottomPane);
        Theme.getInstance().applyTo(Constants.CHAT_TOP_AND_BOTTOM_BACKGROUND, (Pane)this.fx_spTopPane);
        Theme.getInstance().applyTo(Constants.CHAT_TOP_AND_BOTTOM_BACKGROUND, (Pane)this.fx_FilterPane);
        Theme.getInstance().applyTo(Constants.TAB_CELL_TEXT_FILL, (Labeled)this.fx_lbContactName);
        Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.fx_lbStateName);
        Theme.getInstance().applyTo(Constants.TAB_CELL_TEXT_FILL, (Labeled)this.fx_lbCallContactName, Theme.WHITE_EXTRA_COLOR);
        Theme.getInstance().applyTo(Constants.TAB_CELL_TEXT_FILL, (Labeled)this.fx_lbCallTrunk, Theme.WHITE_EXTRA_COLOR);
        Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.fx_lbCallType, Theme.WHITE_EXTRA_COLOR);
        Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.fx_lbCallTimer, Theme.WHITE_EXTRA_COLOR);
        Theme.getInstance().applyTo(Constants.TABS_VIRTUALIZED_SCROLL, (Pane)this.fx_RootPane);
        Theme.getInstance().applyTo(Constants.PROFILE_VIRTUALIZED_SCROLL, (Pane)this.fx_ChatBottomPane);
        Theme.getInstance().applyTo(Constants.CHAT_REPLY_MESSAGE_BACKGROUND, (Pane)this.fx_ReplayPane);
        Theme.getInstance().applyTo(Constants.CHAT_REPLY_MESSAGE_BACKGROUND, (Pane)this.fx_EditPane);
        Theme.getInstance().applyTo(Constants.REPLY_VIRTUALIZED_SCROLL, (Pane)this.fx_ReplayPane);
        Theme.getInstance().applyTo(Constants.REPLY_VIRTUALIZED_SCROLL, (Pane)this.fx_EditPane);
        this.fx_EmojiPane.addEventHandler(KeyEvent.KEY_PRESSED, keyEvent -> {
            String text;
            if (keyEvent.getCode() == KeyCode.ENTER && !(text = this.myStyledTextArea.getTextString()).isEmpty()) {
                this.sendMessage(text);
                this.getStyledTextArea().ifPresent(b -> b.clearMessage(null));
            }
        });
        this.fx_FilterSearch.setTextFontColor(ClientSingleton.getInstance().getStyleValue(Constants.CALLS_PANES_AND_SEARCH_TEXT_FILL));
        this.fx_ivInfo.addEventHandler(MouseEvent.MOUSE_CLICKED, mouseEvent -> this.fx_ivInfo.requestFocus());
        this.fx_ivInfo.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> {
            if (this.sessionInfo.getStatus() <= 3 && this.ivcScreenController != null) {
                if (this.setInfoPaneImages(0)) {
                    this.ivcScreenController.openProfile(this.sessionInfo);
                } else {
                    this.ivcScreenController.closePaneView();
                }
            }
        }));
        Tooltip tooltip = new Tooltip(ClientSingleton.getInstance().getString("tooltip_open_info"));
        Tooltip.install((Node)this.fx_ivInfo, (Tooltip)tooltip);
        this.fx_ivActivity.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> {
            if (this.ivcScreenController != null) {
                if (this.currentVisibleInfoPane != 1) {
                    this.ivcScreenController.openCallHistory(this.callLinePane.getLineInfo());
                } else {
                    this.ivcScreenController.closePaneView();
                }
            }
        }));
        tooltip = new Tooltip(ClientSingleton.getInstance().getString("tooltip_open_call_activity"));
        Tooltip.install((Node)this.fx_ivActivity, (Tooltip)tooltip);
        this.fx_ivComment.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> {
            if (this.ivcScreenController != null) {
                if (this.currentVisibleInfoPane != 2) {
                    this.ivcScreenController.openCallActivity(this.callLinePane.getLineInfo());
                } else {
                    this.ivcScreenController.closePaneView();
                }
            }
        }));
        tooltip = new Tooltip(ClientSingleton.getInstance().getString("tooltip_open_activities"));
        Tooltip.install((Node)this.fx_ivActivity, (Tooltip)tooltip);
        this.fx_ivTopMenu.setMenuWidth(150);
        this.initTopAndBottomPane();
        this.addMessageTextPane();
        this.initObservable();
        this.progressIndicator.prefHeightProperty().bind((ObservableValue)this.fx_hbChatTopPaneBackground.heightProperty().subtract(20));
        this.progressIndicator.prefWidthProperty().bind((ObservableValue)this.fx_hbChatTopPaneBackground.heightProperty().subtract(20));
        this.fx_hbChatListPane.prefWidthProperty().bind((ObservableValue)this.fx_MainChatPane.widthProperty());
        AnchorPane.setTopAnchor((Node)this.fx_lvChatListPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.fx_lvChatListPane, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)this.fx_lvChatListPane, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.fx_lvChatListPane, (Double)0.0);
        AnchorPane.setTopAnchor((Node)this.fx_MainStackPane, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.fx_MainStackPane, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)this.fx_MainStackPane, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.fx_MainStackPane, (Double)0.0);
        ClientSingleton.getInstance().setBackground((Pane)this.fx_MainChatPane, "chat/chat_background.png");
        BorderPane.setMargin((Node)this.fx_ChatBottomPane, (Insets)new Insets((double)PREF_PADDING, 0.0, 0.0, 0.0));
        this.callLinePane = new CallLinePane(this.fx_spTopPane, this);
        StackPane.setAlignment((Node)this.fx_hbCallTopPaneImage, (Pos)Pos.CENTER_LEFT);
        this.fx_spTopPane.getChildren().remove((Object)this.fx_hbCallTopPaneBackground);
        this.fx_vbTopLine.getChildren().remove((Object)this.fx_FilterPane);
        this.fx_spTopPane.getChildren().addListener(change -> {
            if (this.fx_spTopPane.getChildren().size() == 1) {
                ((Node)this.fx_spTopPane.getChildren().get(0)).setVisible(true);
                this.fx_vbCallInfoButtons.getChildren().remove((Object)this.fx_ivActivity);
                this.fx_vbCallInfoButtons.getChildren().remove((Object)this.fx_ivComment);
                if (this.currentVisibleInfoPane != -1) {
                    this.clearInfoPaneImages();
                }
            }
        });
        PREF_BOTTOM_PANE_HEIGHT = PREF_PADDING;
        this.getStyledTextArea().ifPresent(myStyledTextArea1 -> PREF_BOTTOM_PANE_HEIGHT += 25);
        this.onClearMessagePane(PREF_BOTTOM_PANE_HEIGHT);
        this.fx_vbCallInfoButtons.getChildren().remove((Object)this.fx_ivActivity);
        this.fx_vbCallInfoButtons.getChildren().remove((Object)this.fx_ivComment);
        this.isSimpleViewMode.addListener((event, oldValue, newValue) -> {
            if (newValue.booleanValue()) {
                this.getStyledTextArea().ifPresent(EditActions::clear);
                this.fx_vbTopLine.getChildren().remove((Object)this.fx_spTopPane);
            } else {
                ((Node)this.fx_spTopPane.getChildren().get(0)).setVisible(true);
                this.fx_vbTopLine.getChildren().add(0, (Object)this.fx_spTopPane);
            }
            this.fx_vbCallInfoButtons.setVisible(newValue == false);
            this.refreshList(this.virtualFlow.getLastVisibleIndex());
            ClientSingleton.toLog(this.getClass().getSimpleName(), "isSimpleViewMode = " + newValue);
            ClientSingleton.toLog(this.getClass().getSimpleName(), "fx_spTopPane.isVisible = " + this.fx_spTopPane.isVisible());
            ClientSingleton.toLog(this.getClass().getSimpleName(), "fx_spTopPane.getChildren().get(0).isVisible = " + ((Node)this.fx_spTopPane.getChildren().get(0)).isVisible());
        });
        ClientSingleton.getInstance().setMouseCursor((Node)this.fx_EditPane);
        ClientSingleton.getInstance().setMouseCursor((Node)this.fx_ReplayPane);
        this.fx_ReplayPane.widthProperty().addListener((event, oldValue, newValue) -> {
            this.textAreaWidth = newValue.intValue();
        });
        this.fx_FilterSearch.addEventHandler(KeyEvent.KEY_PRESSED, keyEvent -> {
            if (keyEvent.getCode() == KeyCode.ENTER && !this.fx_FilterSearch.getText().isEmpty()) {
                this.switchFilter(5);
            }
        });
        for (LineInfoPane lineInfoPane : ClientSingleton.getInstance().getLineInfoPanes()) {
            lineInfoPane.addCallLineStateListener(this);
        }
        this.loadingPreviousMessages.addListener((observable, oldValue, newValue) -> {
            if (this.scrollPane.getCursor() != Cursor.DEFAULT) {
                this.scrollPane.setCursor(Cursor.DEFAULT);
            }
            this.showProgressIndicator((boolean)newValue);
        });
        this.statesPane = StatesPane.getInstance(StatesPane.VIEW_MODE.HANDLER_MODE);
        this.fx_hbStatePane.getChildren().add(0, (Object)this.statesPane);
        this.initScrollPane();
        this.initUpdateMessagesObservable();
        if (this.messagesListObserver == null || this.disposables.size() == 0) {
            this.initMessagesListObserver();
        }
        if (this.currentMessageType == -1) {
            this.currentMessageType = 0;
            this.fx_Reply.getStylesheets().add((Object)MyUtils.getResourceUrl(MainViewSceneController.class, "/extracss/chat_message_type.css"));
            this.fx_Reply.setOnMousePressed(e -> this.messageTypeSelector(0));
            this.fx_Comment.getStylesheets().add((Object)MyUtils.getResourceUrl(MainViewSceneController.class, "/extracss/chat_message_type.css"));
            this.fx_Comment.setOnMousePressed(e -> this.messageTypeSelector(1024));
        }
        this.messageTypeSelector(this.currentMessageType);
        ClientSingleton.toLog(this.getClass().getSimpleName(), "initialize stop");
    }

    private void messageTypeSelector(int type) {
        this.currentMessageType = type;
        this.fx_Reply.getStyleClass().clear();
        this.fx_Reply.getStyleClass().add((Object)"dateLabelClass");
        this.fx_Comment.getStyleClass().clear();
        this.fx_Comment.getStyleClass().add((Object)"dateLabelClass");
        if (this.currentMessageType == 0) {
            this.fx_Reply.getStyleClass().add((Object)"selectedClass");
            this.fx_Comment.getStyleClass().add((Object)"unselectedClass");
        } else {
            this.fx_Comment.getStyleClass().add((Object)"selectedClass");
            this.fx_Reply.getStyleClass().add((Object)"unselectedClass");
        }
        this.getStyledTextArea().ifPresent(myStyledTextArea1 -> myStyledTextArea1.createPalaceHolder(this.currentMessageType));
    }

    public void addRingtoneMuteState(IRingtoneMuteState iRingtoneMuteState) {
        this.callLinePane.addRingtoneMuteStateStateListener(iRingtoneMuteState);
    }

    public void setRingtoneMuteState() {
        this.callLinePane.setRingtoneMuteState();
    }

    public double getChatPaneWidth() {
        return this.fx_hbChatListPane.widthProperty().get();
    }

    public void clearChatList() {
        this.stopAllPlayers();
        this.messageInfos.setAll(new ArrayList());
    }

    public void setIvcScreenController(IVCScreenController ivcScreenController) {
        this.ivcScreenController = ivcScreenController;
    }

    @Override
    public boolean isSimpleViewMode() {
        return this.isSimpleViewMode.get();
    }

    @Override
    public void showScrollButton() {
        this.fx_ivMoveDown.showButton();
    }

    @Override
    public void hideScrollButton() {
        this.fx_ivMoveDown.hideButton();
    }

    @Override
    public SessionInfo getSessionInfo() {
        return this.sessionInfo;
    }

    public void setSimpleViewMode(boolean mode) {
        this.isSimpleViewMode.set(mode);
    }

    private void addToOldMessages() {
        if (this.sessionInfo != null) {
            this.getStyledTextArea().ifPresent(myStyledTextArea1 -> {
                String message = myStyledTextArea1.getTextString();
                if (!message.isEmpty()) {
                    this.oldMessages.put(this.sessionInfo.getSessionId(), message);
                    myStyledTextArea1.clearMessage(null);
                }
            });
        }
    }

    public void removeFromOldMessages() {
        this.getStyledTextArea().ifPresent(myStyledTextArea1 -> {
            String message = this.oldMessages.remove(this.sessionInfo.getSessionId());
            myStyledTextArea1.clearMessage(message);
        });
    }

    public void setSessionInfo(SessionInfo sessionInfo) {
        if (this.equalsCurrentSessionInfo(sessionInfo)) {
            this.sessionInfo = sessionInfo;
            this.initTopMenu();
        }
    }

    public void openNewChat(SessionInfo sessionInfo) throws Exception {
        if (this.equalsCurrentSessionInfo(sessionInfo)) {
            this.addLineInfoPane();
            this.refreshList(-3);
            return;
        }
        this.openChat(sessionInfo);
    }

    public void openChat(SessionInfo sessionInfo) throws Exception {
        this.dispose();
        this.setRefreshingList(false);
        ClientSingleton.getInstance().setChatWithTrunks();
        ClientSingleton.toLog(this.getClass().getSimpleName(), "setCreateChat start. isChatWithTrunks=" + ClientSingleton.getInstance().isChatWithTrunks());
        this.addToOldMessages();
        this.sessionInfo = sessionInfo;
        this.replayMessageInfo = null;
        this.getReplyMessageInfo = null;
        this.fx_vbTopLine.getChildren().remove((Object)this.fx_FilterPane);
        this.initTopMenu();
        ClientSingleton.toLog(this.getClass().getSimpleName(), "setCreateChat clear");
        this.getStyledTextArea().ifPresent(myStyledTextArea1 -> {
            if (sessionInfo.canChat()) {
                this.setActionBottomPane(0);
            } else if (this.canMMS()) {
                this.setActionBottomPane(3);
            } else if (this.canSMS()) {
                this.setActionBottomPane(1);
            } else {
                this.fx_ButtonsPane.getChildren().clear();
            }
            if (!sessionInfo.canChat() && (this.canSMS() || this.canMMS())) {
                if (!this.fx_MainButtonsPane.getChildren().contains((Object)this.fx_SMSLabel)) {
                    this.fx_MainButtonsPane.getChildren().add(0, (Object)this.fx_SMSLabel);
                }
            } else {
                this.fx_MainButtonsPane.getChildren().remove((Object)this.fx_SMSLabel);
            }
            if (sessionInfo.getDialogType() == 3) {
                if (!this.fx_BottomContainer.getChildren().contains((Object)this.fx_MessageType)) {
                    this.fx_BottomContainer.getChildren().add(0, (Object)this.fx_MessageType);
                }
            } else {
                this.fx_BottomContainer.getChildren().remove((Object)this.fx_MessageType);
            }
            ClientSingleton.getInstance().setMouseCursor((Node)this.fx_Reply);
            ClientSingleton.getInstance().setMouseCursor((Node)this.fx_Comment);
            this.messageTypeSelector(0);
            myStyledTextArea1.createPalaceHolder(this.currentMessageType);
        });
        this.setVisibilityOfCallButtons();
        this.clearReplay();
        this.initTitle();
        ClientSingleton.toLog(this.getClass().getSimpleName(), "setCreateChat refreshList start");
        ClientSingleton.toLog(this.getClass().getSimpleName(), "setCreateChat disposables");
        this.switchFilterOnStart();
        this.removeFromOldMessages();
        this.setLoadingPreviousMessages(false);
        ClientSingleton.getInstance().setProperty(Constants.LAST_VISIBLE_SESSION, sessionInfo.getSessionId());
        this.virtualFlow.requestFocus();
        this.addLineInfoPane();
        this.print();
    }

    private void addLineInfoPane() {
        LineInfo lineInfo = AudioCaller.getLineInfo(this.sessionInfo.getSessionId());
        if (lineInfo != null) {
            ClientSingleton.getInstance().runLater(() -> {
                if (lineInfo.getState() != 2) {
                    this.callLinePane.setTitles(lineInfo);
                }
                this.setLineViewState(lineInfo);
                if (lineInfo.getState() == 4) {
                    this.callLinePane.setConnectCallSet(lineInfo);
                }
            });
        } else {
            this.removeCallTopPane();
        }
    }

    private void initScrollPane() {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "initScrollPane scrollPane=" + this.scrollPane + " start ");
        if (this.scrollPane != null) {
            this.scrollPane.prefHeightProperty().unbind();
            this.fx_lvChatListPane.getChildren().remove(this.scrollPane);
            this.scrollPane.estimatedScrollYProperty().removeListener(this.onScrollFinished);
            this.scrollPane.removeEventHandler(MouseEvent.MOUSE_CLICKED, this.eventHandlerMouseClicked);
            this.scrollPane.removeEventHandler(MouseEvent.MOUSE_ENTERED, this.eventHandlerMouseClicked);
            this.scrollPane.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.eventHandlerMousePressed);
            this.scrollPane.removeEventHandler(MouseEvent.MOUSE_RELEASED, this.eventHandlerMouseReleased);
        }
        this.virtualFlow = VirtualFlow.createVertical(this.messageInfos, messageInfo -> new ChatCell(this.scrollPane, this, (MessageInfo)messageInfo), (VirtualFlow.Gravity)VirtualFlow.Gravity.REAR);
        this.scrollPane = new VirtualizedScrollPane(this.virtualFlow, ScrollPane.ScrollBarPolicy.NEVER, ScrollPane.ScrollBarPolicy.AS_NEEDED);
        this.scrollPane.prefHeightProperty().bind((ObservableValue)this.fx_lvChatListPane.prefHeightProperty());
        this.fx_lvChatListPane.getChildren().add(0, this.scrollPane);
        this.scrollPane.estimatedScrollYProperty().addListener(this.onScrollFinished);
        this.scrollPane.addEventHandler(MouseEvent.MOUSE_CLICKED, this.eventHandlerMouseClicked);
        this.scrollPane.addEventHandler(MouseEvent.MOUSE_ENTERED, this.eventHandlerMouseClicked);
        this.scrollPane.addEventHandler(MouseEvent.MOUSE_PRESSED, this.eventHandlerMousePressed);
        this.scrollPane.addEventHandler(MouseEvent.MOUSE_RELEASED, this.eventHandlerMouseReleased);
        this.virtualFlow.totalHeightEstimateProperty().addListener((observableValue, oldValue, newValue) -> {
            if (this.lastScrollMode.get() == -3) {
                int index = this.messageInfos.size() - 1;
                ClientSingleton.getInstance().runLater(() -> this.showAsLast(index));
            }
        });
        ClientSingleton.toLog(this.getClass().getSimpleName(), "initScrollPane scrollPane=" + this.scrollPane + " done ");
    }

    public void setRefreshingList(boolean refreshingList) {
        this.isRefreshingList = refreshingList;
    }

    public void chatFireScrollEvent(ScrollEvent scrollEvent) {
        this.virtualFlow.fireEvent((Event)scrollEvent);
    }

    private void removeCallTopPane() {
        if (this.fx_spTopPane.getChildren().contains((Object)this.fx_hbCallTopPaneBackground)) {
            this.fx_ivAudioCall.addCoverPane();
            this.fx_ivVideoCall.addCoverPane();
        }
        this.fx_spTopPane.getChildren().remove((Object)this.fx_hbCallTopPaneBackground);
    }

    public void refreshList() {
        this.refreshList(-3);
    }

    public void refreshList(int mode) {
        if (this.messagesListObserver == null || this.disposables.size() == 0) {
            this.initMessagesListObserver();
        }
        this.messagesListObserver.onNext((Object)mode);
    }

    public void clearReplay() {
        this.replayMessageInfo = null;
        this.fx_ReplayPane.getChildren().clear();
    }

    private void initTitle() {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "initTitle sessionInfo hash :" + this.sessionInfo.hashCode() + " sessionInfo=" + this.sessionInfo + " sessionInfo.getName()=" + this.sessionInfo.getName());
        this.fx_lbContactName.setText(this.sessionInfo.toString());
        this.fx_vbAvatar.getChildren().clear();
        AvatarPane avatarPane = AvatarPane.getInstance(this.sessionInfo, 32, 15, true);
        this.fx_vbAvatar.getChildren().add((Object)avatarPane);
        StackPane.setAlignment((Node)avatarPane, (Pos)Pos.CENTER);
        this.setState();
    }

    public void setState() {
        ClientSingleton.getInstance().runLater(this::setContactState);
    }

    private void setContactState() {
        boolean isVisibility = true;
        if (this.sessionInfo == null) {
            return;
        }
        if (this.sessionInfo.isGroup() || this.sessionInfo.isChannel() || this.sessionInfo.isPublic() || this.sessionInfo.getStatus() > 3 || this.sessionInfo.getParties() != null && this.sessionInfo.getParties().size() > 1) {
            isVisibility = false;
        } else {
            Optional<ContactInfo> oContactInfo = ClientSingleton.getInstance().getContactInfoFromSession(this.sessionInfo);
            if (oContactInfo.isPresent()) {
                if (!ClientSingleton.getInstance().isMemberOfList(oContactInfo.get()) || oContactInfo.get().getState() == -1) {
                    isVisibility = false;
                } else {
                    this.statesPane.setState(oContactInfo.get().getState());
                    Optional<String> title = ClientSingleton.getInstance().getStateString(oContactInfo.get());
                    if (title.isPresent()) {
                        this.fx_lbStateName.setText(ClientSingleton.getInstance().getString(title.get()));
                    } else {
                        this.fx_lbStateName.setText(ClientSingleton.getInstance().getString("state_away"));
                    }
                }
            } else {
                isVisibility = false;
            }
        }
        boolean check = false;
        if (this.sessionInfo.getProperty("nodisturb") != null) {
            check = (Boolean)this.sessionInfo.getProperty("nodisturb");
        }
        String groupMute = ClientSingleton.getInstance().getString("group_mute");
        this.fx_ivTopMenu.setItemTitleById(ClientSingleton.getInstance().getString(check ? "group_unmute" : "group_mute"), groupMute);
        if (check) {
            this.fx_vbTitle.getChildren().remove((Object)this.fx_hbStatePane);
            if (!this.fx_vbTitle.getChildren().contains((Object)this.fx_hbMutePane)) {
                this.fx_vbTitle.getChildren().add((Object)this.fx_hbMutePane);
            }
        } else {
            this.fx_vbTitle.getChildren().remove((Object)this.fx_hbMutePane);
            if (isVisibility) {
                if (!this.fx_vbTitle.getChildren().contains((Object)this.fx_hbStatePane)) {
                    this.fx_vbTitle.getChildren().add((Object)this.fx_hbStatePane);
                }
            } else {
                this.fx_vbTitle.getChildren().remove((Object)this.fx_hbStatePane);
            }
        }
        check = false;
        if (this.sessionInfo.getProperty("PinChat") != null) {
            check = (Boolean)this.sessionInfo.getProperty("PinChat");
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "pinChat sessionInfo.getProperty(Constants.PIN_CHAT)=" + this.sessionInfo.getProperty("PinChat"));
        String pinChat = ClientSingleton.getInstance().getString("chat_pin");
        this.fx_ivTopMenu.setItemTitleById(ClientSingleton.getInstance().getString(check ? "chat_unpin" : "chat_pin"), pinChat);
        this.setVisibilityOfCallButtons();
        if (!ClientSingleton.getInstance().isShowChatInputMessagePane(this.sessionInfo)) {
            this.fx_MainChatPane.getChildren().remove((Object)this.fx_ChatBottomPane);
            if (this.fx_LoadFileReceiverPane.getOnDragOver() != null) {
                this.fx_LoadFileReceiverPane.setOnDragOver(null);
                this.fx_LoadFileReceiverPane.setOnDragDropped(null);
                this.fx_LoadFileReceiverPane.setOnDragExited(null);
                this.fx_MainStackPane.setOnDragEntered(null);
            }
        } else {
            if (!this.fx_MainChatPane.getChildren().contains((Object)this.fx_ChatBottomPane)) {
                this.fx_MainChatPane.setBottom((Node)this.fx_ChatBottomPane);
            }
            if (this.fx_LoadFileReceiverPane.getOnDragOver() == null) {
                this.fx_LoadFileReceiverPane.setOnDragOver(this::onDragOver);
                this.fx_LoadFileReceiverPane.setOnDragDropped(this::onLoadFileDragDropped);
                this.fx_LoadFileReceiverPane.setOnDragExited(this::onLoadFileDragExited);
                this.fx_MainStackPane.setOnDragEntered(this::onLoadFileDragEntered);
            }
        }
    }

    private void setVisibilityOfCallButtons() {
        this.fx_ivVideoCall.setVisible(ClientSingleton.getInstance().canVideo(this.sessionInfo));
        if (this.sessionInfo.isGroup() && !this.sessionInfo.canMakeCall()) {
            this.fx_ivAudioCall.setVisible(false);
        } else {
            this.fx_ivAudioCall.setVisible(this.sessionInfo.canMakeCall());
        }
        this.fx_CallButtonsPane.getChildren().remove((Object)this.fx_ivAudioCall);
        this.fx_CallButtonsPane.getChildren().remove((Object)this.fx_ivVideoCall);
        if (this.fx_ivAudioCall.isVisible() && this.fx_ivVideoCall.isVisible()) {
            this.fx_CallButtonsPane.getChildren().addAll((Object[])new Node[]{this.fx_ivVideoCall, this.fx_ivAudioCall});
        } else if (this.fx_ivAudioCall.isVisible()) {
            this.fx_CallButtonsPane.getChildren().add((Object)this.fx_ivAudioCall);
        } else if (this.fx_ivVideoCall.isVisible()) {
            this.fx_CallButtonsPane.getChildren().add((Object)this.fx_ivVideoCall);
        }
    }

    @Override
    public void clearEditedMessage() {
        this.messageEdited = null;
        this.fx_EditPane.getChildren().clear();
    }

    @Override
    public void clearMessagePane(int height) {
        ClientSingleton.getInstance().runLater(() -> this.onClearMessagePane(height));
    }

    private void onClearMessagePane(int height) {
        int heightPane = height + 8;
        this.fx_InputPane.setMinHeight((double)heightPane);
        this.fx_InputPane.setMaxHeight((double)heightPane);
        this.fx_ChatBottomPane.setMinHeight((double)heightPane);
        this.fx_InputPane.applyCss();
        this.fx_InputPane.layout();
    }

    @Override
    public void sendMessage(String text) {
        this.checkSessionStatus();
        if (this.messageEdited != null) {
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                this.messageEdited.setContent(text, this.messageEdited.getType());
                if (this.messageEdited.getType() == 7 || MessageInfoCellLabels.isLink(this.messageEdited)) {
                    List<String> urls = MyUtils.bindLink(this.messageEdited.getContent());
                    IntStream.range(0, urls.size()).forEach(index -> {
                        String name = this.messageEdited.getId() + "_" + index;
                        ClientSingleton.getInstance().removeLinkData(name);
                        ClientSingleton.getInstance().removeImage(name);
                        File file = new File(clientConnector.getFilesDir() + File.separator + name + ".png");
                        ClientSingleton.toLog(this.getClass().getSimpleName(), "removeLinkData file.exists()= " + file.exists());
                        if (file.exists()) {
                            File renamedFile = new File(file.getAbsolutePath() + "_del");
                            boolean renamed = file.renameTo(renamedFile);
                            ClientSingleton.toLog(this.getClass().getSimpleName(), "removeLinkData renamedFile= " + renamedFile + " renamed=" + renamed);
                            if (renamed) {
                                file.deleteOnExit();
                            }
                        }
                    });
                }
                MyThreadPoolManager.getInstance().execute(() -> {
                    try {
                        clientConnector.updateMessage(this.sessionInfo, this.messageEdited);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    this.messageEdited = null;
                });
                this.fx_EditPane.getChildren().clear();
            });
        } else {
            if (text.isEmpty() || "..".equals(text)) {
                return;
            }
            if (this.sessionInfo.getSessionId() == null) {
                ClientSingleton.getInstance().setLastAction(IntentConstants.SESSION_CREATED);
            }
            if (this.fx_MainButtonsPane.getChildren().contains((Object)this.fx_SMSLabel)) {
                ClientSingleton.toLog(this.getClass().getSimpleName(), "sendSmsMms");
                AudioCaller.sendSmsMms(this.sessionInfo, text, false);
            } else {
                List<String> mentions = this.myStyledTextArea.getMentionsList();
                ClientSingleton.toLog(this.getClass().getSimpleName(), "sendMessage replayMessageInfo = " + this.replayMessageInfo + " mentions=" + mentions);
                TimerExecutor.getInstance().start(() -> {
                    if (this.fx_ReplayPane.getChildren().isEmpty() && this.replayMessageInfo != null) {
                        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> clientConnector.sendMessage(text, this.sessionInfo, this.currentMessageType, (Collection)mentions));
                    } else {
                        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> clientConnector.sendMessage(text, this.sessionInfo, this.currentMessageType, (Collection)mentions, this.replayMessageInfo));
                    }
                    ClientSingleton.getInstance().runLater(this::clearReplay);
                });
            }
        }
        if (!this.fx_EmojiPane.getChildren().isEmpty()) {
            this.fx_EmojiPane.getChildren().clear();
        }
        this.getStyledTextArea().ifPresent(myStyledTextArea1 -> myStyledTextArea1.setAutoHeight(true));
    }

    @Override
    public void sendFile(File file) {
        if (this.sessionInfo.canChat()) {
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> clientConnector.sendFile(file, this.sessionInfo, this.currentMessageType));
        } else if (this.canMMS()) {
            if (this.sessionInfo.getSessionId() == null) {
                ClientSingleton.getInstance().setLastAction(IntentConstants.SESSION_CREATED);
            }
            AudioCaller.sendSmsMms(this.sessionInfo, file, false);
        }
    }

    @Override
    public void replayMessage(MessageInfo messageInfo) {
        this.replayMessageInfo = messageInfo;
        ClientSingleton.getInstance().runLater(() -> {
            this.clearEditedMessage();
            this.setReplayMessagePane(messageInfo, false);
            this.fx_ChatBottomPane.layout();
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getReplayMessage(MessageInfo messageInfo, boolean isFindMessage) {
        if (currentFilter != 0) {
            this.fx_FilterAll.setImagePath("chat/filter/filter_all_on.png");
            this.fx_FilterCalls.setImagePath("chat/filter/filter_calls_off.png");
            this.fx_FilterStar.setImagePath("chat/filter/filter_star_off.png");
            this.fx_FilterLinks.setImagePath("chat/filter/filter_links_off.png");
            this.fx_FilterFiles.setImagePath("chat/filter/filter_files_off.png");
            this.fx_FilterSearch.setText("");
            this.fx_vbTopLine.getChildren().remove((Object)this.fx_FilterPane);
        }
        MessageInfo messageInfo2 = messageInfo;
        synchronized (messageInfo2) {
            int i = -1;
            boolean isFind = this.sessionInfo.getMessages().stream().anyMatch(messageInfo1 -> messageInfo1.getId().equals(messageInfo.getId()));
            ClientSingleton.toLog(this.getClass().getSimpleName(), "getReplayMessage isFind " + isFind + " isFindMessage=" + isFindMessage);
            if (isFind) {
                if (currentFilter == 0 && (i = this.getIndexOfMessage((List<MessageInfo>)this.messageInfos, messageInfo)) != -1) {
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "getReplayMessage 1");
                    this.setLastScrollMode(-1);
                } else {
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "getReplayMessage 2");
                    List<MessageInfo> list = UpdateLists.getMessagesList(this.sessionInfo, 0, "");
                    Collections.reverse(list);
                    i = this.getIndexOfMessage(list, messageInfo);
                    this.messageInfos.setAll(list);
                }
                this.moveToIndex(i);
                currentFilter = 0;
            } else {
                currentFilter = 0;
                ClientSingleton.toLog(this.getClass().getSimpleName(), "getReplayMessage 3");
                this.getPreviousMessages(messageInfo, true);
            }
        }
    }

    public void findAfterSearch(MessageInfo messageInfo) {
        int index = this.getIndexOfMessage((List<MessageInfo>)this.messageInfos, messageInfo);
        ClientSingleton.toLog(this.getClass().getSimpleName(), "findAfterSearch index=" + index + " " + this.getIndexOfMessage(this.sessionInfo.getMessages(), messageInfo));
        if (index != -1) {
            this.moveToIndex(index);
        } else {
            ClientSingleton.getInstance().setLastAction("All" + IntentConstants.MESSAGES_LOADED + "$;$" + messageInfo.getId());
            index = this.getIndexOfMessage(this.sessionInfo.getMessages(), messageInfo);
            if (index != -1) {
                this.messagesLoaded(this.sessionInfo.getMessages(), ClientSingleton.getInstance().getLastAction());
            } else {
                this.showProgressIndicator(true);
                ClientSingleton.getInstance().getClientConnector().get().loadPreviousMessages(this.sessionInfo, messageInfo.getTime());
            }
        }
    }

    private void moveToIndex(int i) {
        if (i != -1) {
            int index = this.virtualFlow.getLastVisibleIndex();
            AtomicInteger delay = new AtomicInteger(200);
            if (Math.abs(i - index) > 20) {
                delay.set(Math.abs(i - index) * 5);
            }
            ClientSingleton.toLog(this.getClass().getSimpleName(), "findAfterSearch delay=" + delay + " i=" + i + " index=" + index);
            TimerExecutor.getInstance().setMyAction(() -> this.virtualFlow.showAsFirst(i)).startWithDelayInGUIThread(delay.get());
        }
    }

    private int getIndexOfMessage(List<MessageInfo> list, MessageInfo messageInfo) {
        return IntStream.range(0, list.size()).filter(i -> ((MessageInfo)list.get(i)).getId().equals(messageInfo.getId())).findFirst().orElse(-1);
    }

    private int getIndexOfMessage(ObservableList<MessageInfo> list, String id) {
        return IntStream.range(0, list.size()).filter(i -> ((MessageInfo)list.get(i)).getId().equals(id)).findFirst().orElse(-1);
    }

    @Override
    public boolean isReplyMode() {
        return this.sessionInfo != null && !this.sessionInfo.isChannel() && (this.canSMS() || this.canMMS() || this.sessionInfo.canChat());
    }

    private void addMessageTextPane() {
        if (this.myStyledTextArea == null) {
            this.myStyledTextArea = new MyStyledTextArea((IInnerMessageTextArea)this, (ChangeListener<Boolean>)((ChangeListener)(observable, oldValue, newValue) -> {
                if (this.sessionInfo != null && (this.sessionInfo.canChat() || this.canMMS()) && !this.canSMS()) {
                    if (newValue.booleanValue()) {
                        this.setActionBottomPane(2);
                    } else if (this.sessionInfo.canChat()) {
                        this.setActionBottomPane(0);
                    } else if (this.canMMS()) {
                        this.setActionBottomPane(0);
                    } else if (this.canSMS()) {
                        this.setActionBottomPane(1);
                    }
                }
            }));
            this.myStyledTextArea.addEventHandler(KeyEvent.KEY_PRESSED, event -> {
                this.lastPressedKey = event.getCode();
            });
            this.myStyledTextArea.setAutoHeight(true);
            this.myStyledTextArea.addInputMap();
            VirtualizedScrollPane virtualizedScrollPane = new VirtualizedScrollPane((Node)this.myStyledTextArea);
            this.fx_InputPane.getChildren().clear();
            this.fx_InputPane.getChildren().add((Object)virtualizedScrollPane);
            AnchorPane.setTopAnchor((Node)virtualizedScrollPane, (Double)2.0);
            AnchorPane.setBottomAnchor((Node)virtualizedScrollPane, (Double)0.0);
            AnchorPane.setRightAnchor((Node)virtualizedScrollPane, (Double)0.0);
            AnchorPane.setLeftAnchor((Node)virtualizedScrollPane, (Double)2.0);
            this.resizeParent(0, 1);
            this.myStyledTextArea.textProperty().addListener((observableValue, oldValue, newValue) -> {
                if (this.sessionInfo != null && this.sessionInfo.isGroup() && newValue.contains("@")) {
                    char lastChar = newValue.toCharArray()[newValue.length() - 1];
                    if (this.mentionMenu == null) {
                        this.initMentionMenu(null);
                    } else if ((lastChar == ' ' || lastChar == '\n') && this.mentionMenu.isMenuShowing()) {
                        String str1;
                        boolean close = true;
                        int index = newValue.lastIndexOf("@");
                        if (index != -1 && this.initMentionMenu(str1 = newValue.substring(index + 1))) {
                            close = false;
                        }
                        if (close) {
                            this.mentionMenu.hide();
                            this.mentionMenu.getItems().clear();
                        }
                    } else if (lastChar == '@') {
                        String preIndexStr;
                        int index = newValue.lastIndexOf("@");
                        String string = preIndexStr = index > 0 ? String.valueOf(newValue.toCharArray()[index - 1]) : "";
                        if (index == 0 || !preIndexStr.isEmpty() && (preIndexStr.equals(" ") || preIndexStr.equals("\n"))) {
                            this.initMentionMenu(null);
                        }
                    } else if (this.mentionMenu.isMenuShowing()) {
                        int index = newValue.lastIndexOf("@");
                        String str1 = newValue.substring(index + 1);
                        this.initMentionMenu(str1);
                    }
                } else if (this.mentionMenu != null && this.mentionMenu.isMenuShowing()) {
                    this.mentionMenu.hide();
                    this.mentionMenu.getItems().clear();
                }
            });
        }
    }

    public void onDragDropped(DragEvent event) {
        Dragboard db = event.getDragboard();
        boolean success = false;
        if (db.hasFiles()) {
            success = true;
            for (File file : db.getFiles()) {
                this.sendFile(file);
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        event.setDropCompleted(success);
        event.consume();
    }

    public void onDragOver(DragEvent event) {
        Dragboard db = event.getDragboard();
        if (db.hasFiles()) {
            event.acceptTransferModes(new TransferMode[]{TransferMode.COPY});
        } else {
            event.consume();
        }
    }

    private void onLoadFileDragEntered(DragEvent dragEvent) {
        if (!this.fx_MainStackPane.getChildren().contains((Object)this.fx_LoadFileReceiverPane)) {
            this.fx_MainStackPane.getChildren().add((Object)this.fx_LoadFileReceiverPane);
        }
    }

    private void onLoadFileDragExited(DragEvent dragEvent) {
        this.fx_MainStackPane.getChildren().remove((Object)this.fx_LoadFileReceiverPane);
    }

    private void onLoadFileDragDropped(DragEvent dragEvent) {
        this.fx_MainStackPane.getChildren().remove((Object)this.fx_LoadFileReceiverPane);
        this.onDragDropped(dragEvent);
    }

    private boolean initMentionMenu(String prefix) {
        List contactInfoList = prefix == null || prefix.isEmpty() ? this.sessionInfo.getParties().stream().filter(ContactInfo::isUser).sorted().collect(Collectors.toList()) : this.sessionInfo.getParties().stream().filter(contactInfo -> contactInfo.isUser() && contactInfo.toString().toLowerCase().contains(prefix.toLowerCase())).sorted().collect(Collectors.toList());
        if (contactInfoList.isEmpty()) {
            if (this.mentionMenu.isMenuShowing()) {
                this.mentionMenu.getItems().clear();
            }
            this.mentionMenu.hide();
            return false;
        }
        if (this.mentionMenu == null) {
            this.mentionMenu = new MaxSizedContextMenu();
            this.mentionMenu.setMaxHeight(300.0);
            this.mentionMenu.setMinWidth(200.0);
        } else {
            this.mentionMenu.getItems().clear();
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "contactInfoList: " + contactInfoList.size() + " prefix=" + prefix);
        for (ContactInfo contactInfo2 : contactInfoList) {
            MenuItem menuItem = new MenuItem("@" + contactInfo2.toString());
            menuItem.setUserData((Object)contactInfo2);
            menuItem.setOnAction(eventHandler -> {
                String text = this.myStyledTextArea.getText();
                int index = text.lastIndexOf("@");
                int indexSpace = text.lastIndexOf(" ");
                if (indexSpace > index) {
                    this.myStyledTextArea.replaceText(index, text.length() - (indexSpace - index), "");
                } else {
                    this.myStyledTextArea.replaceText(index, text.length(), "");
                }
                this.myStyledTextArea.insertMentionText((ContactInfo)menuItem.getUserData());
                this.myStyledTextArea.insertText(this.myStyledTextArea.getText().length(), " ");
                this.mentionMenu.hide();
                this.mentionMenu.getItems().clear();
            });
            this.mentionMenu.getItems().add((Object)menuItem);
        }
        this.mentionMenu.show((Node)this.myStyledTextArea, this.myStyledTextArea.getCaretPositionX() + 25.0, this.myStyledTextArea.getCaretPositionY());
        return true;
    }

    public void contactStateChanged(ContactInfo contactInfo) {
        SessionInfo sessionInfo = ClientSingleton.getInstance().getSessionInfo(contactInfo, true);
        this.getCurrentSessionInfo().ifPresent(sessionInfo1 -> {
            if (sessionInfo != null && sessionInfo1.getSessionId() != null && sessionInfo.getSessionId().equals(sessionInfo1.getSessionId())) {
                this.setState();
            }
        });
    }

    private void sendChatFile() {
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(ClientSingleton.getInstance().getPackageName());
        fileChooser.setInitialDirectory(new File(System.getProperty("user.home")));
        Stage stage = (Stage)this.fx_lvChatListPane.getScene().getWindow();
        File file = fileChooser.showOpenDialog((Window)stage);
        if (file != null) {
            String filename = file.getName();
            byte[] data = new byte[(int)file.length()];
            try {
                FileInputStream fis = new FileInputStream(file);
                fis.read(data);
                fis.close();
                this.sendFile(file);
            }
            catch (Exception e) {
                e.printStackTrace();
                MyUtils.showAlert(e.getMessage());
            }
        }
    }

    public void messagesLoaded(List<MessageInfo> list, String lastAction) {
        ClientSingleton.getInstance().setLastAction("");
        boolean isReloadAllList = lastAction.startsWith("All");
        int ind = lastAction.indexOf("$;$");
        AtomicReference<String> messageId = new AtomicReference<String>("");
        if (ind != -1 && lastAction.length() > ind + 5) {
            messageId.set(lastAction.substring(ind + 3));
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "isReloadAllList " + isReloadAllList + " messagesLoaded messageId=" + messageId);
        Pair<AtomicReference<MessageInfoDate>, List<MessageInfo>> pair = UpdateLists.addDateCells(list);
        List messageInfoNodeList = (List)pair.getValue();
        if (messageId.get().isEmpty()) {
            MessageInfo lastMessage;
            MessageInfo messageInfo = lastMessage = this.messageInfos.size() > this.virtualFlow.getFirstVisibleIndex() ? null : (MessageInfo)this.messageInfos.get(this.virtualFlow.getFirstVisibleIndex());
            if (lastMessage != null) {
                messageId.set(lastMessage.getId());
            }
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "messagesLoaded isLoadingPreviousMessages=" + this.isLoadingPreviousMessages() + " messageInfos=" + this.messageInfos.size() + " getFirstVisibleIndex=" + this.virtualFlow.getFirstVisibleIndex() + " messageId=" + messageId);
        ClientSingleton.getInstance().runLater(() -> {
            if (isReloadAllList) {
                this.messageInfos.setAll((Collection)messageInfoNodeList);
            } else {
                this.messageInfos.addAll(0, (Collection)messageInfoNodeList);
            }
        });
        if (!messageId.get().isEmpty()) {
            TimerExecutor.getInstance().setMyAction(() -> {
                int index = this.getIndexOfMessage(this.messageInfos, (String)messageId.get());
                ClientSingleton.toLog(this.getClass().getSimpleName(), "messagesLoaded move to index =" + index + " messageInfos.size()=" + this.messageInfos.size());
                if (index != -1 && index != this.messageInfos.size()) {
                    this.virtualFlow.showAsFirst(index);
                }
                this.showProgressIndicator(false);
            }).startWithDelayInGUIThread(1000L);
        }
    }

    public void messagesLoaded(List<MessageInfo> list) {
        if (this.getReplyMessageInfo == null) {
            if (this.isRefreshingList) {
                this.setLoadingPreviousMessages(false);
                return;
            }
            if (this.isLoadingPreviousMessages()) {
                Pair<AtomicReference<MessageInfoDate>, List<MessageInfo>> pair = UpdateLists.addDateCells(list);
                List messageInfoNodeList = (List)pair.getValue();
                int messageInfosSize = this.messageInfos.size();
                MessageInfo lastMessage = this.messageInfos.size() > this.virtualFlow.getFirstVisibleIndex() ? null : (MessageInfo)this.messageInfos.get(this.virtualFlow.getFirstVisibleIndex());
                ClientSingleton.toLog(this.getClass().getSimpleName(), "messagesLoaded isLoadingPreviousMessages=" + this.isLoadingPreviousMessages() + " messageInfos=" + this.messageInfos.size() + " getFirstVisibleIndex=" + this.virtualFlow.getFirstVisibleIndex() + " lastMessage=" + lastMessage);
                ClientSingleton.getInstance().runLater(() -> this.messageInfos.addAll(0, (Collection)messageInfoNodeList));
                this.setLoadingPreviousMessages(false);
                TimerExecutor.getInstance().setMyAction(() -> {
                    if (lastMessage != null && this.messageInfos.size() - messageInfosSize > 0) {
                        int index;
                        for (index = 0; index < this.messageInfos.size(); ++index) {
                            MessageInfo messageInfo = (MessageInfo)this.messageInfos.get(index);
                            if (lastMessage.getId() != null && lastMessage.getId().equals(messageInfo.getId())) break;
                        }
                        ClientSingleton.toLog(this.getClass().getSimpleName(), "messagesLoaded move to index =" + index + " messageInfos.size()=" + this.messageInfos.size());
                        if (index != 0 && index != this.messageInfos.size()) {
                            this.virtualFlow.showAsFirst(index);
                        }
                    }
                }).startWithDelayInGUIThread(300L);
            } else {
                this.refreshList(-3);
            }
        } else {
            this.refreshList(-1);
        }
    }

    public void receivedMassageOnTyping(SessionInfo sessionInfo, MessageInfo messageInfo) {
        String str;
        if (!this.equalsCurrentSessionInfo(sessionInfo)) {
            return;
        }
        if (!this.fx_vbTitle.getChildren().contains((Object)this.fx_hbStatePane)) {
            this.fx_vbTitle.getChildren().add((Object)this.fx_hbStatePane);
        }
        if (!this.fx_lbStateName.isVisible()) {
            this.fx_lbStateName.setVisible(true);
        }
        if (sessionInfo == null) {
            return;
        }
        String senderName = "";
        ClientSingleton.toLog(this.getClass().getSimpleName(), "receivedMassageOnTyping isGroup = " + sessionInfo.isGroup());
        if (sessionInfo.isGroup()) {
            AtomicBoolean atomicBoolean = new AtomicBoolean();
            Optional<ClientConnector> optionalClientConnector = ClientSingleton.getInstance().getClientConnector();
            if (optionalClientConnector.isPresent()) {
                List list = optionalClientConnector.get().getContacts().stream().filter(contactInfo -> messageInfo.getSenderId().equals(ClientSingleton.getInstance().getUserID((ContactInfo)contactInfo))).collect(Collectors.toList());
                ClientSingleton.toLog(this.getClass().getSimpleName(), "receivedMassageOnTyping list = " + list);
                if (!list.isEmpty()) {
                    ContactInfo contactInfo2 = (ContactInfo)list.get(0);
                    senderName = contactInfo2.toString();
                    this.statesPane.setState(contactInfo2.getState());
                    atomicBoolean.set(true);
                }
            }
            if (!atomicBoolean.get() && !sessionInfo.getParties().isEmpty()) {
                ContactInfo contactInfo3 = (ContactInfo)sessionInfo.getParties().get(0);
                this.statesPane.setState(contactInfo3.getState());
            }
            str = senderName + " " + ClientSingleton.getInstance().getString("group_user_typing");
        } else {
            str = senderName + " " + ClientSingleton.getInstance().getString("user_typing");
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "receivedMassageOnTyping typing = " + str);
        this.fx_lbStateName.setText(str);
    }

    @Override
    public void identityChanged(LineInfo lineInfo) {
        if (this.callLinePane != null && lineInfo.getSessionInfo() != null && lineInfo.getSessionInfo().getSessionId().equals(this.sessionInfo.getSessionId())) {
            this.callLinePane.setTitles(lineInfo);
            if (lineInfo.getState() > 2) {
                this.callLinePane.setConnectCallSet(lineInfo);
            }
        }
    }

    @Override
    public void setLineViewState(LineInfo lineInfo) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "setLineViewState lineInfo=" + lineInfo + " state=" + lineInfo.getState() + " AudioCaller.getWorkingLinesCount()=" + AudioCaller.getWorkingLinesCount() + " equalsCurrentSessionInfo = " + this.equalsCurrentSessionInfo(lineInfo.getSessionInfo()));
        Optional<SessionInfo> optionalSessionInfo = this.getCurrentSessionInfo();
        if (optionalSessionInfo.isPresent()) {
            if (lineInfo.getSessionInfo() == null) {
                if (AudioCaller.getWorkingLinesCount() == 0) {
                    this.clearLine();
                    return;
                }
            } else if (AudioCaller.getWorkingLinesCount() > 1 && lineInfo.getState() == 3 && optionalSessionInfo.get().getSessionId() != null && lineInfo.getSessionInfo().getSessionId() != null && !optionalSessionInfo.get().getSessionId().equals(lineInfo.getSessionInfo().getSessionId())) {
                this.clearLine();
                return;
            }
        }
        if (!this.equalsCurrentSessionInfo(lineInfo.getSessionInfo())) {
            return;
        }
        if (lineInfo.getState() != 8 && lineInfo.getState() != 18 && lineInfo.getState() != 0) {
            this.addCallLine();
        }
        switch (lineInfo.getState()) {
            case 2: {
                this.callLinePane.setBackgroundColor(false);
                this.callLinePane.setTitles(lineInfo);
                this.callLinePane.setInputCallSet(lineInfo);
                break;
            }
            case 15: {
                this.callLinePane.setBackgroundColor(false);
                this.callLinePane.setTitle(lineInfo);
                break;
            }
            case 1: {
                this.callLinePane.setBackgroundColor(false);
                this.callLinePane.setTitles(lineInfo);
                this.callLinePane.setOutputCallSet(lineInfo);
                break;
            }
            case 3: 
            case 10: {
                if (lineInfo.getSessionInfo() == null || !lineInfo.getSessionInfo().getSessionId().equals(this.sessionInfo.getSessionId())) break;
                this.callLinePane.setTitle(lineInfo);
                this.callLinePane.setConnectCallSet(lineInfo);
                break;
            }
            case 4: {
                this.callLinePane.onHoldCall(lineInfo);
                break;
            }
            case 0: 
            case 5: 
            case 8: 
            case 18: {
                this.clearLine();
            }
        }
    }

    private void addCallLine() {
        try {
            if (!this.fx_spTopPane.getChildren().contains((Object)this.fx_hbCallTopPaneBackground) && this.fx_spTopPane.getChildren().size() == 1) {
                ((Node)this.fx_spTopPane.getChildren().get(0)).setVisible(false);
                this.fx_spTopPane.getChildren().add((Object)this.fx_hbCallTopPaneBackground);
                this.fx_vbCallInfoButtons.getChildren().add((Object)this.fx_ivActivity);
                this.fx_vbCallInfoButtons.getChildren().add((Object)this.fx_ivComment);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void clearLine() {
        this.callLinePane.clearLine();
        this.removeCallTopPane();
    }

    private void switchFilterOnStart() {
        if (currentFilter != 0) {
            currentFilter = 0;
            this.fx_FilterAll.setImagePath("chat/filter/filter_all_on.png");
            this.fx_FilterCalls.setImagePath("chat/filter/filter_calls_off.png");
            this.fx_FilterStar.setImagePath("chat/filter/filter_star_off.png");
            this.fx_FilterLinks.setImagePath("chat/filter/filter_links_off.png");
            this.fx_FilterFiles.setImagePath("chat/filter/filter_files_off.png");
        }
        this.refreshList(-3);
    }

    private void switchFilter(int filter) {
        if (currentFilter == filter) {
            this.refreshList(-1);
            return;
        }
        if (filter == 5 && this.fx_FilterSearch.getText().isEmpty()) {
            filter = 0;
        } else if (filter != 5) {
            this.fx_FilterSearch.setText("");
        }
        currentFilter = filter;
        switch (currentFilter) {
            case 0: {
                this.fx_FilterAll.setImagePath("chat/filter/filter_all_on.png");
                this.fx_FilterCalls.setImagePath("chat/filter/filter_calls_off.png");
                this.fx_FilterStar.setImagePath("chat/filter/filter_star_off.png");
                this.fx_FilterLinks.setImagePath("chat/filter/filter_links_off.png");
                this.fx_FilterFiles.setImagePath("chat/filter/filter_files_off.png");
                break;
            }
            case 1: {
                this.fx_FilterAll.setImagePath("chat/filter/filter_all_off.png");
                this.fx_FilterCalls.setImagePath("chat/filter/filter_calls_on.png");
                this.fx_FilterStar.setImagePath("chat/filter/filter_star_off.png");
                this.fx_FilterLinks.setImagePath("chat/filter/filter_links_off.png");
                this.fx_FilterFiles.setImagePath("chat/filter/filter_files_off.png");
                break;
            }
            case 2: {
                this.fx_FilterAll.setImagePath("chat/filter/filter_all_off.png");
                this.fx_FilterCalls.setImagePath("chat/filter/filter_calls_off.png");
                this.fx_FilterStar.setImagePath("chat/filter/filter_star_on.png");
                this.fx_FilterLinks.setImagePath("chat/filter/filter_links_off.png");
                this.fx_FilterFiles.setImagePath("chat/filter/filter_files_off.png");
                break;
            }
            case 3: {
                this.fx_FilterAll.setImagePath("chat/filter/filter_all_off.png");
                this.fx_FilterCalls.setImagePath("chat/filter/filter_calls_off.png");
                this.fx_FilterStar.setImagePath("chat/filter/filter_star_off.png");
                this.fx_FilterLinks.setImagePath("chat/filter/filter_links_on.png");
                this.fx_FilterFiles.setImagePath("chat/filter/filter_files_off.png");
                break;
            }
            case 4: {
                this.fx_FilterAll.setImagePath("chat/filter/filter_all_off.png");
                this.fx_FilterCalls.setImagePath("chat/filter/filter_calls_off.png");
                this.fx_FilterStar.setImagePath("chat/filter/filter_star_off.png");
                this.fx_FilterLinks.setImagePath("chat/filter/filter_links_off.png");
                this.fx_FilterFiles.setImagePath("chat/filter/filter_files_on.png");
                break;
            }
            case 5: {
                this.fx_FilterAll.setImagePath("chat/filter/filter_all_off.png");
                this.fx_FilterCalls.setImagePath("chat/filter/filter_calls_off.png");
                this.fx_FilterStar.setImagePath("chat/filter/filter_star_off.png");
                this.fx_FilterLinks.setImagePath("chat/filter/filter_links_off.png");
                this.fx_FilterFiles.setImagePath("chat/filter/filter_files_off.png");
            }
        }
        this.refreshList(-3);
    }

    private void setNotDisturb() {
        boolean check = false;
        if (this.sessionInfo.getProperty("nodisturb") != null) {
            check = (Boolean)this.sessionInfo.getProperty("nodisturb");
        }
        check = !check;
        this.sessionInfo.setProperty("nodisturb", (Object)check);
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> MyThreadPoolManager.getInstance().execute(() -> {
            try {
                Set set = Collections.emptySet();
                clientConnector.updateSession(this.sessionInfo, -1, set, false);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
        this.setState();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("sessionInfo", this.sessionInfo);
        ClientSingleton.getInstance().doNotify(Constants.DO_NOT_DISTURB_, data);
    }

    @Override
    public void resizeParent(int height, int linesCount) {
        this.getStyledTextArea().ifPresent(myStyledTextArea1 -> ClientSingleton.getInstance().runLater(() -> this.onResizeParent(height)));
    }

    private void onResizeParent(int height) {
        if (this.resizeObserver == null) {
            this.initResizeObserver();
        }
        this.resizeObserver.onNext((Object)height);
    }

    private void initResizeObserver() {
        this.resizeObserver = PublishSubject.create();
        this.disposables.add(this.resizeObserver.debounce(100L, TimeUnit.MILLISECONDS).doOnError(Throwable::printStackTrace).switchMap(height -> {
            int heightPane = height + 8;
            double delta = (double)(heightPane + 8) - this.fx_InputPane.prefHeightProperty().get();
            if (delta == 0.0) {
                return Observable.empty();
            }
            if (this.lastPressedKey == null && this.fx_EditPane.getChildren().isEmpty() || this.lastPressedKey != KeyCode.DELETE && this.lastPressedKey != KeyCode.BACK_SPACE && (double)heightPane < this.myStyledTextArea.getLayoutBounds().getHeight()) {
                return Observable.empty();
            }
            return Observable.just((Object)heightPane);
        }).observeOn((Scheduler)JavaFxScheduler.platform()).subscribe(heightPane -> {
            this.myStyledTextArea.setAutoHeight(heightPane < 150);
            heightPane = Math.min(150, heightPane);
            if (this.fx_InputPane.getMaxHeight() != 150.0) {
                this.fx_InputPane.setMinHeight((double)heightPane.intValue());
                this.fx_InputPane.setMaxHeight((double)heightPane.intValue());
                this.fx_ChatBottomPane.setMinHeight((double)heightPane.intValue());
                this.fx_ChatBottomPane.layout();
            }
        }, Throwable::printStackTrace));
    }

    private void getPreviousMessages() {
        this.getPreviousMessages(null, false);
    }

    private void getPreviousMessages(MessageInfo messageInfo, boolean isReply) {
        if (this.getReplyMessageInfo != null && this.isLoadingPreviousMessages() || currentFilter != 0) {
            return;
        }
        this.setLoadingPreviousMessages(true);
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            if (this.sessionInfo != null) {
                if (isReply && messageInfo != null) {
                    this.getReplyMessageInfo = messageInfo;
                    clientConnector.loadPreviousMessages(this.sessionInfo, messageInfo.getTime());
                } else {
                    clientConnector.loadPreviousMessages(this.sessionInfo);
                }
            }
        });
    }

    private void showProgressIndicator(boolean mode) {
        ClientSingleton.getInstance().runLater(() -> {
            if (mode) {
                this.fx_Indicator.getChildren().clear();
                this.fx_Indicator.getChildren().add((Object)this.progressIndicator);
            } else {
                this.fx_Indicator.getChildren().clear();
            }
        });
        if (mode) {
            TimerExecutor.getInstance().setMyAction(() -> {
                if (this.isLoadingPreviousMessages()) {
                    this.setLoadingPreviousMessages(false);
                }
                this.fx_Indicator.getChildren().clear();
            }).startWithDelayInGUIThread(5000L);
        }
    }

    private void initObservable() {
        String[] actions = new String[]{IntentConstants.LINE_INFO_RECORD_LINE, IntentConstants.LINE_INFO_MUTE_LINE, IntentConstants.CONTACT_DATA_UPDATED, IntentConstants.CONTACT_STATUS_CHANGED, Constants.OPEN_PROFILE_EDITOR, Constants.DO_NOT_DISTURB, Constants.CLOSE_SESSION, "smile.uccproject.GET_REPLY_MESSAGE_INFO", Constants.EDIT_MESSAGE, "smile.uccproject.RESIZE_PANE"};
        ClientSingleton.getInstance().addObserver(this, actions);
    }

    @Override
    public void onNotifiedMessage(String action, Map<String, Object> data) {
        ContactInfo contactInfo;
        SessionInfo sessionInfo;
        if (action.equals(IntentConstants.CONTACT_DATA_UPDATED) && this.sessionInfo != null && !this.sessionInfo.isGroup()) {
            ContactInfo contactInfo2 = (ContactInfo)data.get("contactInfo");
            if (contactInfo2 != null && ClientSingleton.getInstance().getUserID(contactInfo2).equals(ClientSingleton.getInstance().getUserID((ContactInfo)this.sessionInfo.getParties().get(0)))) {
                ClientSingleton.getInstance().runLater(this::initTitle);
                return;
            }
        } else if (action.equals(IntentConstants.CONTACT_STATUS_CHANGED)) {
            this.initTopMenu();
            return;
        }
        if ((sessionInfo = (SessionInfo)data.get("sessionInfo")) == null && (contactInfo = (ContactInfo)data.get("contactInfo")) != null) {
            sessionInfo = ClientSingleton.getInstance().getSessionInfo(contactInfo);
        }
        if (!(action.equals("smile.uccproject.RESIZE_PANE") || action.equals(IntentConstants.LINE_INFO_MUTE_LINE) || action.equals(IntentConstants.LINE_INFO_RECORD_LINE))) {
            Optional<SessionInfo> optionalSessionInfo = this.getCurrentSessionInfo();
            if (optionalSessionInfo.isEmpty()) {
                return;
            }
            if (sessionInfo != null && optionalSessionInfo.get().getSessionId() != null) {
                if (!sessionInfo.getSessionId().equals(optionalSessionInfo.get().getSessionId())) {
                    return;
                }
            } else {
                ClientSingleton.toLog(this.getClass().getSimpleName(), "onNotifiedMessage break on condition");
                return;
            }
        }
        this.onAction(action, data);
    }

    private void onAction(String action, Map<String, Object> data) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "onAction action=" + action);
        Platform.runLater(() -> {
            if (action.equals(Constants.DO_NOT_DISTURB)) {
                this.setNotDisturb();
            } else if (action.equals(Constants.CLOSE_SESSION)) {
                this.closeSession(false);
            } else if (action.equals(Constants.EDIT_MESSAGE)) {
                this.getStyledTextArea().ifPresent(myStyledTextArea1 -> {
                    MessageInfo messageInfo = (MessageInfo)data.get("messageInfo");
                    if (messageInfo != null) {
                        this.messageEdited = messageInfo;
                        this.clearReplay();
                        this.setEditMessagePane(messageInfo, false);
                        myStyledTextArea1.setContentToStyledTextArea(messageInfo.getContent());
                        myStyledTextArea1.layout();
                        this.fx_ChatBottomPane.layout();
                        myStyledTextArea1.requestFocus();
                    }
                });
            } else if (action.equals(IntentConstants.LINE_INFO_RECORD_LINE)) {
                LineInfo lineInfo = (LineInfo)data.get("lineInfo");
                boolean isRecord = (Boolean)data.get("isRecording");
                this.callLinePane.onRecordCall(lineInfo, isRecord);
            } else if (action.equals(IntentConstants.LINE_INFO_MUTE_LINE)) {
                this.callLinePane.onMute();
            } else if (action.equals("smile.uccproject.RESIZE_PANE")) {
                this.scrollBottom();
            }
        });
    }

    public void clearChatMessagePane() {
        TimerExecutor.getInstance().startInGUI(() -> {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "clearChatMessagePane");
            this.fx_ReplayPane.getChildren().clear();
            this.myStyledTextArea.clearMessage(null);
        });
    }

    public void clearPanes() {
        this.fx_EmojiPane.getChildren().clear();
    }

    private void closeSession(boolean isLeaveSession) {
        ClientSingleton.getInstance().showAlert(ClientSingleton.getInstance().getString(!isLeaveSession ? "chat_close_session" : "chat_leave_session"), ClientSingleton.getInstance().getString("yes"), (EventHandler<MouseEvent>)((EventHandler)mouseEvent -> {
            ClientSingleton.getInstance().addLoadingPane(isLeaveSession ? "Leaving session" : "Closing session");
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> TimerExecutor.getInstance().start(() -> {
                try {
                    if (isLeaveSession) {
                        clientConnector.closeSession(this.sessionInfo);
                    } else {
                        clientConnector.deleteSession(this.sessionInfo);
                    }
                }
                catch (Exception ex) {
                    ClientSingleton.getInstance().removeLoadingPane();
                    ex.printStackTrace();
                }
                ClientSingleton.getInstance().doNotify(IntentConstants.SESSION_REMOVED);
            }));
        }));
    }

    private void setActionBottomPane(int mode) {
        if (this.fx_ivEmojiPane == null) {
            this.fx_ivEmojiPane = new ImageButton();
            this.fx_ivEmojiPane.setSize(18, 18);
            this.fx_ivEmojiPane.setIsRounded(true);
            this.fx_ivEmojiPane.setBackgroundColor("transparent");
            this.fx_ivEmojiPane.setImagePath("chat/bottompane/smile.png");
            HBox.setMargin((Node)this.fx_ivEmojiPane, (Insets)new Insets(0.0, 12.0, 0.0, 12.0));
            this.fx_ivEmojiPane.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> {
                if (this.fx_EmojiPane.getChildren().isEmpty()) {
                    this.setEmojiPane();
                } else {
                    this.fx_EmojiPane.getChildren().clear();
                }
                event.consume();
            }));
        }
        if (this.fx_ivFileChooser == null) {
            this.fx_ivFileChooser = new ImageButton();
            this.fx_ivFileChooser.setSize(18, 18);
            this.fx_ivFileChooser.setIsRounded(true);
            this.fx_ivFileChooser.setBackgroundColor("transparent");
            this.fx_ivFileChooser.setImagePath("chat/bottompane/file.png");
            HBox.setMargin((Node)this.fx_ivFileChooser, (Insets)new Insets(0.0, 12.0, 0.0, 12.0));
            this.fx_ivFileChooser.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> {
                this.sendChatFile();
                event.consume();
            }));
        }
        if (this.fx_ivAudioMessage == null) {
            this.fx_ivAudioMessage = new ImageButton();
            this.fx_ivAudioMessage.setSize(18, 18);
            this.fx_ivAudioMessage.setIsRounded(true);
            this.fx_ivAudioMessage.setBackgroundColor("transparent");
            this.fx_ivAudioMessage.setImagePath("chat/bottompane/audio_message.png");
            HBox.setMargin((Node)this.fx_ivAudioMessage, (Insets)new Insets(0.0, 12.0, 0.0, 12.0));
            this.fx_ivAudioMessage.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> new AudioMessagePane(this.sessionInfo, this.currentMessageType)));
        }
        if (this.fx_ivSendMessage == null) {
            this.fx_ivSendMessage = new ImageButton();
            this.fx_ivSendMessage.setSize(18, 18);
            this.fx_ivSendMessage.setIsRounded(true);
            this.fx_ivSendMessage.setBackgroundColor("transparent");
            ClientSingleton.getInstance().setImageToImageView(this.fx_ivSendMessage, "chat/bottompane/chat_send.png");
            HBox.setMargin((Node)this.fx_ivSendMessage, (Insets)new Insets(0.0, 12.0, 0.0, 12.0));
            this.fx_ivSendMessage.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.sendMessage((MouseEvent)event)));
        }
        if (!this.fx_ButtonsPane.getChildren().contains((Object)this.fx_ivEmojiPane)) {
            this.fx_ButtonsPane.getChildren().addAll((Object[])new Node[]{this.fx_ivEmojiPane, this.fx_ivFileChooser, this.fx_ivAudioMessage, this.fx_ivSendMessage});
        }
        if (mode == 1) {
            this.fx_ButtonsPane.getChildren().remove((Object)this.fx_ivFileChooser);
        } else if (!this.fx_ButtonsPane.getChildren().contains((Object)this.fx_ivFileChooser)) {
            this.fx_ButtonsPane.getChildren().add(1, (Object)this.fx_ivFileChooser);
        }
    }

    private void sendMessage(MouseEvent event) {
        String text = this.myStyledTextArea.getTextString();
        this.checkSessionStatus();
        if (this.fx_MainButtonsPane.getChildren().contains((Object)this.fx_SMSLabel) && event.getButton() == MouseButton.SECONDARY) {
            List trunks = ClientSingleton.getInstance().getClientConnector().get().getSIPTrunksForSMS();
            ClientSingleton.toLog(this.getClass().getSimpleName(), "sendSmsMms trunks=" + trunks);
            if (!text.isEmpty() && trunks != null && trunks.size() > 1) {
                this.showSendContextMenu(text, event);
            } else {
                this.sendMessage(text);
            }
        } else {
            this.sendMessage(text);
            this.getStyledTextArea().ifPresent(b -> b.clearMessage(null));
        }
    }

    private void checkSessionStatus() {
        if (this.sessionInfo != null && this.sessionInfo.getStatus() >= 0) {
            this.fx_MainButtonsPane.getChildren().remove((Object)this.fx_SMSLabel);
        }
    }

    private void setLastScrollMode(int lastScrollMode) {
        if (this.timerExecutor != null) {
            try {
                this.timerExecutor.cancel();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.timerExecutor = null;
        }
        this.timerExecutor = TimerExecutor.getInstance();
        this.timerExecutor.setMyAction(() -> this.lastScrollMode.set(-1)).startWithDelay(1000L);
        if (this.lastScrollMode.get() != lastScrollMode) {
            this.lastScrollMode.set(lastScrollMode);
        }
    }

    private void showAsLast(int mode, int index) {
        this.setLastScrollMode(mode);
        ClientSingleton.getInstance().runLater(() -> this.showAsLast(index));
    }

    private void showAsLast(int index) {
        block5: {
            try {
                this.virtualFlow.getCell(index);
                this.virtualFlow.showAsLast(index);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                String mess = indexOutOfBoundsException.getMessage();
                int ind = -1;
                if (mess == null || (ind = mess.indexOf(",")) == -1) break block5;
                mess = mess.substring(ind + 1).trim().replace(")", "").replace("]", "");
                try {
                    index = Integer.parseInt(mess);
                    if (index > 0) {
                        this.virtualFlow.getCell(index);
                        this.virtualFlow.showAsLast(index);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private void scrollBottom() {
        this.showAsLast(-3, this.messageInfos.size() - 1);
        FadeTransition ft1 = new FadeTransition(Duration.millis((double)100.0), this.scrollPane);
        ft1.setFromValue(0.0);
        ft1.setToValue(1.0);
        ft1.play();
    }

    private void initTopAndBottomPane() {
        this.fx_CloseFilterLine.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)action -> this.closeFilterPane()));
        this.fx_ivMoveDown.setImagePath("buttons/arrow_down.png");
        this.fx_ivMoveDown.hideButton();
        this.fx_ivMoveDown.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> ClientSingleton.getInstance().runLater(() -> this.scrollBottom())));
        ClientSingleton.getInstance().setImageToImageView(this.fx_ivMute, "group/not_disturb.png");
        this.fx_lbMute.setText(ClientSingleton.getInstance().getString("group_mute"));
        this.fx_vbTitle.getChildren().remove((Object)this.fx_hbMutePane);
        this.fx_ivAudioCall.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "fx_ivAudioCall.canPress() = " + this.fx_ivAudioCall.canPress());
            if (this.fx_ivAudioCall.canPress()) {
                if (!this.sessionInfo.isGroup() && event.getButton() == MouseButton.SECONDARY) {
                    List trunks = ClientSingleton.getInstance().getClientConnector().get().getTrunks(null);
                    List<String> numbers = ClientSingleton.getInstance().getPhonesListForMenu((ContactInfo)this.sessionInfo.getParties().get(0));
                    if (trunks != null && trunks.size() > 1 || numbers.size() > 1) {
                        this.showCallContextMenu((MouseEvent)event);
                    } else {
                        this.makeCall(false);
                    }
                } else {
                    this.makeCall(false);
                }
            }
        }));
        this.fx_ivVideoCall.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> {
            if (this.fx_ivVideoCall.canPress()) {
                if (this.sessionInfo.isGroup() && ClientSingleton.getInstance().hasMeetingServices()) {
                    ClientSingleton.getInstance().createMeeting(this.sessionInfo);
                } else {
                    this.makeCall(true);
                }
            }
        }));
        this.fx_FilterAll.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.switchFilter(0)));
        this.fx_FilterCalls.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.switchFilter(1)));
        this.fx_FilterStar.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.switchFilter(2)));
        this.fx_FilterLinks.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.switchFilter(3)));
        this.fx_FilterFiles.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.switchFilter(4)));
        this.fx_Search.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.switchFilter(5)));
    }

    private void closeFilterPane() {
        this.switchFilter(0);
        this.fx_vbTopLine.getChildren().remove((Object)this.fx_FilterPane);
    }

    private void makeCall(boolean isVideoCall) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "makeCall sessionInfo=" + this.sessionInfo + " sessionInfo.isGroup()=" + this.sessionInfo.isGroup());
        if (this.sessionInfo.getSessionId() == null) {
            ClientSingleton.getInstance().setLastAction(IntentConstants.SESSION_CREATED_CALL);
        }
        if (this.sessionInfo.isGroup()) {
            ClientSingleton.getInstance().showAlert(ClientSingleton.getInstance().getString("group_start_conference"), ClientSingleton.getInstance().getString("alert_dialog_title3"), (EventHandler<MouseEvent>)((EventHandler)mouseEvent -> ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                ClientSingleton.toLog(this.getClass().getSimpleName(), "makeCall sessionInfo=" + this.sessionInfo);
                AudioCaller.makeCall(this.sessionInfo, isVideoCall);
            })));
        } else {
            AudioCaller.makeCall(this.sessionInfo, isVideoCall);
        }
    }

    private void initTopMenu() {
        String deleteChatTitle;
        this.fx_ivTopMenu.clearItems();
        if (this.sessionInfo != null && this.sessionInfo.getSessionId() == null) {
            this.fx_ivTopMenu.setVisible(false);
            return;
        }
        if (!this.fx_ivTopMenu.isVisible()) {
            this.fx_ivTopMenu.setVisible(true);
        }
        String addParticipantTitle = ClientSingleton.getInstance().getString("action_add_participant");
        String leaveGroupTitle = deleteChatTitle = ClientSingleton.getInstance().getString("chat_delete");
        String groupMute = ClientSingleton.getInstance().getString("group_mute");
        String pinChat = ClientSingleton.getInstance().getString("chat_pin");
        this.fx_ivTopMenu.addMenuItem(ClientSingleton.getInstance().getString("filter"), (EventHandler<ActionEvent>)((EventHandler)action -> {
            if (!this.fx_vbTopLine.getChildren().contains((Object)this.fx_FilterPane)) {
                this.switchToFilter();
            }
            this.fx_ivTopMenu.hideMenu();
        }));
        if (this.canSMS() || this.canMMS() || this.sessionInfo.canChat() || this.sessionInfo.isGroup() || this.sessionInfo.isChannel()) {
            this.fx_ivTopMenu.addItemToMenu(ClientSingleton.getInstance().getString("chat_pin"), (EventHandler<ActionEvent>)((EventHandler)action -> {
                ClientSingleton.getInstance().pinChat(this.sessionInfo);
                String sPinChat = ClientSingleton.getInstance().getString("chat_pin");
                this.fx_ivTopMenu.setItemTitleById(ClientSingleton.getInstance().getString(this.sessionInfo.getProperty("PinChat") != null && (Boolean)this.sessionInfo.getProperty("PinChat") != false ? "chat_unpin" : "chat_pin"), pinChat);
                this.fx_ivTopMenu.hideMenu();
            }), null, pinChat);
        }
        if (this.sessionInfo.getParties() != null && this.sessionInfo.getParties().size() == 1 && !ClientSingleton.getInstance().isContactInfoApproved((ContactInfo)this.sessionInfo.getParties().get(0))) {
            ContactInfo contactInfo = (ContactInfo)this.sessionInfo.getParties().get(0);
            if (ClientSingleton.getInstance().canShareContact(contactInfo)) {
                this.fx_ivTopMenu.addMenuItem(ClientSingleton.getInstance().getString("cell_menu_item6"), (EventHandler<ActionEvent>)((EventHandler)event -> {
                    ClientSingleton.getInstance().shareContact((ContactInfo)this.sessionInfo.getParties().get(0));
                    this.fx_ivTopMenu.hideMenu();
                }));
            }
        }
        this.fx_ivTopMenu.addItemToMenu(groupMute, (EventHandler<ActionEvent>)((EventHandler)action -> {
            this.setNotDisturb();
            this.fx_ivTopMenu.hideMenu();
        }), null, groupMute);
        if ((!this.sessionInfo.isGroup() && this.sessionInfo.canGroup() || ClientSingleton.getInstance().isGroupAdmin(this.sessionInfo)) && ClientSingleton.getInstance().getClientConnector().get().canSeeUsers()) {
            this.fx_ivTopMenu.addMenuItem(addParticipantTitle, (EventHandler<ActionEvent>)((EventHandler)action -> {
                GroupCreatorEditor groupCreatorEditor = this.sessionInfo.isGroup() ? new GroupCreatorEditor(this.sessionInfo, true) : new GroupCreatorEditor((ContactInfo)this.sessionInfo.getParties().get(0));
                groupCreatorEditor.show();
                this.fx_ivTopMenu.hideMenu();
            }));
        }
        boolean dismissRemoveMessages = false;
        if (this.sessionInfo.isGroup()) {
            AtomicBoolean isLeaveChat = new AtomicBoolean();
            if (this.sessionInfo.getDialogType() == 3) {
                if (this.sessionInfo.getStatus() == 1 || this.sessionInfo.getStatus() == 2) {
                    isLeaveChat.set(true);
                    leaveGroupTitle = ClientSingleton.getInstance().getString("group_leave_");
                }
                dismissRemoveMessages = true;
            }
            this.fx_ivTopMenu.addItemToMenu(leaveGroupTitle, (EventHandler<ActionEvent>)((EventHandler)action -> {
                ClientSingleton.getInstance().runLater(() -> this.closeSession(isLeaveChat.get()));
                this.fx_ivTopMenu.hideMenu();
            }), "red");
        } else {
            this.fx_ivTopMenu.addItemToMenu(deleteChatTitle, (EventHandler<ActionEvent>)((EventHandler)action -> {
                this.deleteSession();
                this.fx_ivTopMenu.hideMenu();
            }), "red");
        }
        if (!dismissRemoveMessages) {
            this.fx_ivTopMenu.addItemToMenu(ClientSingleton.getInstance().getString("chat_delete_messages"), (EventHandler<ActionEvent>)((EventHandler)action -> {
                this.deleteMessages();
                this.fx_ivTopMenu.hideMenu();
            }), "red");
        }
    }

    private void deleteMessages() {
        ClientSingleton.getInstance().showAlert(ClientSingleton.getInstance().getString("chat_clear_all_message"), ClientSingleton.getInstance().getString("delete"), (EventHandler<MouseEvent>)((EventHandler)mouseEvent -> {
            ClientSingleton.getInstance().addLoadingPane(ClientSingleton.getInstance().getString("chat_deleting_messages"));
            TimerExecutor.getInstance().start(() -> {
                try {
                    ClientSingleton.getInstance().getClientConnector().get().deleteMessages(this.sessionInfo);
                }
                catch (Exception e) {
                    ClientSingleton.getInstance().removeLoadingPane();
                    e.printStackTrace();
                }
            });
        }));
    }

    private void deleteSession() {
        ClientSingleton.getInstance().showAlert(ClientSingleton.getInstance().getString("remove_chat_dialog"), ClientSingleton.getInstance().getString("delete"), (EventHandler<MouseEvent>)((EventHandler)mouseEvent -> {
            ClientSingleton.getInstance().addLoadingPane(ClientSingleton.getInstance().getString("removing_chat_dialog"));
            TimerExecutor.getInstance().start(() -> {
                try {
                    ClientSingleton.getInstance().getClientConnector().get().deleteSession(this.sessionInfo);
                }
                catch (Exception e) {
                    ClientSingleton.getInstance().removeLoadingPane();
                    e.printStackTrace();
                }
            });
        }));
    }

    private void setEmojiPane() {
        this.fx_EmojiPane.setOpacity(0.0);
        this.fx_EmojiPane.getChildren().clear();
        ClientSingleton.toLog(this.getClass().getSimpleName(), "setEmojiPane emojiController=" + this.emojiController);
        if (this.emojiController == null) {
            this.emojiController = EmojiUtils.isHasExternalEmoji() ? ExtEmojisController.getInstance() : EmojisController.getInstance();
            this.emojiController.setEmojiAction((EventHandler<EmojiActionEvent>)((EventHandler)ev -> {
                if (ev.getEmoji() != null) {
                    this.getStyledTextArea().ifPresent(myStyledTextArea1 -> myStyledTextArea1.insertEmoji(ev.getEmoji()));
                    if (this.emojiController instanceof ExtEmojisController) {
                        EmojiUtils.addToUsedCategory(ev.getEmoji());
                    }
                }
            }));
            EventHandler eventHandler = mouseEvent -> {
                this.fx_EmojiPane.getChildren().clear();
                if (this.emojiController instanceof ExtEmojisController) {
                    ((ExtEmojisController)this.emojiController).dispose();
                }
            };
            this.emojiController.setCloseAction((EventHandler<MouseEvent>)eventHandler);
            this.emojiController.setWidth(this.textAreaWidth);
        }
        Pane pane = this.emojiController.getPane();
        pane.prefWidthProperty().bind((ObservableValue)this.fx_EmojiPane.widthProperty().subtract(10));
        this.fx_EmojiPane.getChildren().add((Object)pane);
        FadeTransition ft = new FadeTransition(Duration.millis((double)500.0), (Node)this.fx_EmojiPane);
        ft.setFromValue(0.0);
        ft.setToValue(1.0);
        ft.statusProperty().addListener((event, oldValue, newValue) -> {
            if (newValue == Animation.Status.STOPPED) {
                this.getStyledTextArea().ifPresent(Node::requestFocus);
            }
        });
        ft.play();
    }

    private void setReplayMessagePane(MessageInfo messageInfo, boolean isCell) {
        this.fx_ReplayPane.setOpacity(0.0);
        this.fx_ReplayPane.getChildren().clear();
        HBox pane = new HBox();
        ImageView imageView1 = new ImageView();
        ClientSingleton.getInstance().setImageToImageView(imageView1, "chat/reply.png");
        pane.setAlignment(Pos.CENTER_LEFT);
        HBox.setMargin((Node)imageView1, (Insets)new Insets(8.0, 8.0, 8.0, 8.0));
        Pair<String, Integer> pair = MessageInfoCellLabels.getSenderName(messageInfo);
        String name = (String)pair.getKey();
        Label label = new Label(name);
        label.setStyle("-fx-font-family: \"Arial\";-fx-font-size: 12 px;-fx-font-weight: bold;-fx-text-fill: " + ClientSingleton.getInstance().getStyleValue(Constants.CHAT_REPLY_MESSAGE_TEXT_FILL) + "; -fx-background-color:transparent;");
        HBox.setMargin((Node)label, (Insets)new Insets(8.0, 8.0, 8.0, 0.0));
        HBox empty = new HBox();
        empty.setStyle("-fx-padding: 8,8,8,8; -fx-background-color:transparent;");
        HBox.setHgrow((Node)empty, (Priority)Priority.ALWAYS);
        if (!isCell) {
            ImageButton arrowImageButton = new ImageButton();
            arrowImageButton.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.clearReplay()));
            arrowImageButton.setBackgroundColor("#f1f2f5");
            arrowImageButton.setSize(20, 20);
            arrowImageButton.setIsRounded(true);
            arrowImageButton.setImagePath("buttons/arrow_down.png");
            HBox.setMargin((Node)arrowImageButton, (Insets)new Insets(8.0, 8.0, 8.0, 8.0));
            pane.getChildren().addAll((Object[])new Node[]{imageView1, label, empty, arrowImageButton});
        } else {
            pane.getChildren().addAll((Object[])new Node[]{imageView1, label, empty});
        }
        HBox pane2 = new HBox();
        pane2.setStyle("-fx-padding: 0,0,0,0;-fx-background-color:transparent;");
        ClientSingleton.getInstance().setMouseCursor((Node)pane2);
        if (messageInfo instanceof FileInfo && (((FileInfo)messageInfo).isVideo() || ((FileInfo)messageInfo).isImage())) {
            ExecutorService executors = Executors.newSingleThreadExecutor();
            ReplyImageTask imageTask = new ReplyImageTask(messageInfo);
            imageTask.setOnSucceeded(event -> {
                Image image = (Image)imageTask.getValue();
                if (image != null) {
                    ClientSingleton.getInstance().runLater(() -> {
                        MyImageView myImageView = ClientSingleton.getInstance().getRoundedImage(image);
                        ClientSingleton.getInstance().setMouseCursor((Node)myImageView);
                        HBox.setMargin((Node)myImageView, (Insets)new Insets(0.0, 8.0, 8.0, 30.0));
                        pane2.getChildren().add((Object)myImageView);
                    });
                } else {
                    ClientSingleton.getInstance().addTextAreaToReply((Pane)pane2, messageInfo);
                }
                executors.shutdown();
            });
            executors.execute((Runnable)((Object)imageTask));
        } else {
            ClientSingleton.getInstance().addTextAreaToReply((Pane)pane2, messageInfo);
        }
        this.fx_ReplayPane.getChildren().addAll((Object[])new Node[]{pane, pane2});
        FadeTransition ft = new FadeTransition(Duration.millis((double)500.0), (Node)this.fx_ReplayPane);
        ft.setFromValue(0.0);
        ft.setToValue(1.0);
        ft.statusProperty().addListener((event, oldValue, newValue) -> {
            if (newValue == Animation.Status.STOPPED) {
                this.getStyledTextArea().ifPresent(Node::requestFocus);
            }
        });
        ft.play();
    }

    private void setEditMessagePane(MessageInfo messageInfo, boolean isCell) {
        this.fx_EditPane.setOpacity(0.0);
        this.fx_EditPane.getChildren().clear();
        HBox pane = new HBox();
        ImageView imageView1 = new ImageView();
        ClientSingleton.getInstance().setImageToImageView(imageView1, "chat/dark_edit.png");
        pane.setAlignment(Pos.CENTER_LEFT);
        HBox.setMargin((Node)imageView1, (Insets)new Insets(8.0, 8.0, 8.0, 8.0));
        Label label = new Label(ClientSingleton.getInstance().getString("chat_edit_message"));
        label.setStyle("-fx-font-family: \"Arial\";-fx-font-size: 12 px;-fx-font-weight: bold;-fx-text-fill: " + ClientSingleton.getInstance().getStyleValue(Constants.CHAT_REPLY_MESSAGE_TEXT_FILL) + " ; -fx-background-color:transparent;");
        HBox.setMargin((Node)label, (Insets)new Insets(8.0, 8.0, 8.0, 0.0));
        HBox empty = new HBox();
        empty.setStyle("-fx-padding: 8,8,8,8; -fx-background-color:transparent;");
        HBox.setHgrow((Node)empty, (Priority)Priority.ALWAYS);
        if (!isCell) {
            ImageButton arrowImageButton = new ImageButton();
            arrowImageButton.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.clearEditedMessage()));
            arrowImageButton.setBackgroundColor("#f1f2f5");
            arrowImageButton.setSize(20, 20);
            arrowImageButton.setIsRounded(true);
            arrowImageButton.setImagePath("chat/close.png");
            HBox.setMargin((Node)arrowImageButton, (Insets)new Insets(8.0, 8.0, 8.0, 8.0));
            pane.getChildren().addAll((Object[])new Node[]{imageView1, label, empty, arrowImageButton});
        } else {
            pane.getChildren().addAll((Object[])new Node[]{imageView1, label, empty});
        }
        HBox pane2 = new HBox();
        pane2.setStyle("-fx-padding: 0,0,0,0;-fx-background-color:transparent;");
        ClientSingleton.getInstance().setMouseCursor((Node)pane2);
        ClientSingleton.getInstance().addTextAreaToReply((Pane)pane2, messageInfo);
        this.fx_EditPane.getChildren().addAll((Object[])new Node[]{pane, pane2});
        ClientSingleton.getInstance().setMouseCursor((Node)this.fx_EditPane);
        FadeTransition ft = new FadeTransition(Duration.millis((double)500.0), (Node)this.fx_EditPane);
        ft.setFromValue(0.0);
        ft.setToValue(1.0);
        ft.statusProperty().addListener((event, oldValue, newValue) -> {
            if (newValue == Animation.Status.STOPPED) {
                this.getStyledTextArea().ifPresent(Node::requestFocus);
            }
        });
        ft.play();
    }

    private boolean canSMS() {
        return ClientSingleton.getInstance().canSMS(this.sessionInfo);
    }

    private boolean canMMS() {
        return ClientSingleton.getInstance().canMMS(this.sessionInfo);
    }

    private void print() {
        ClientSingleton.memoryReport();
        if (this.sessionInfo == null) {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "onCreateOptionsMenu=" + this.sessionInfo);
            return;
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "onCreateOptionsMenu (" + this.sessionInfo.hashCode() + ") " + this.sessionInfo + "\nsessionInfo.getSessionId()=" + this.sessionInfo.getSessionId() + " sessionInfo.getStatus()=" + this.sessionInfo.getStatus() + " sessionInfo.getParties()=" + this.sessionInfo.getParties() + "\nsessionInfo.getPartyNumbers()=" + this.sessionInfo.getPartyNumbers() + "\nsessionInfo.getAdmins()=" + this.sessionInfo.getAdmins() + "\nsessionInfo.isGroup()=" + this.sessionInfo.isGroup() + "\nsessionInfo.isChannel()=" + this.sessionInfo.isChannel() + "\nsessionInfo.isPublic()=" + this.sessionInfo.isPublic() + "\nsessionInfo.canGroup()=" + this.sessionInfo.canGroup() + "\nsessionInfo.canChat()=" + this.sessionInfo.canChat() + "\nsessionInfo.canMakeCall()=" + this.sessionInfo.canMakeCall() + "\nsessionInfo.canMakeVideoCall()=" + this.sessionInfo.canMakeVideoCall() + "\nsessionInfo.getConferenceState()=" + this.sessionInfo.getConferenceState() + "\nsessionInfo.canSMS()=" + this.sessionInfo.canSMS() + "\ncanMMS()=" + this.canMMS() + "\nsessionInfo.getDialogType()=" + this.sessionInfo.getDialogType() + "\nisShowChatInputMessagePane=" + ClientSingleton.getInstance().isShowChatInputMessagePane(this.sessionInfo) + "\nsessionInfo MobileApplication.hasSMSTrunks()=" + ClientSingleton.getInstance().hasSMSTrunks() + "\nsessionInfo.getProperty(SessionInfo.NODISTURB)=" + this.sessionInfo.getProperty("nodisturb"));
        Optional<ContactInfo> optional = ClientSingleton.getInstance().getContactInfo(this.sessionInfo);
        if (this.sessionInfo.getParties() != null && ClientSingleton.getInstance().isClientsChat(this.sessionInfo)) {
            ContactInfo contactInfo = optional.get();
            ClientSingleton.toLog(this.getClass().getSimpleName(), "onCreateOptionsMenu contactInfo=" + contactInfo + " name=" + contactInfo.getName() + " ContactInfo.getState()=" + contactInfo.getState() + " ContactInfo.getStatus()=" + contactInfo.getStatus() + " isMemberOfList=" + ClientSingleton.getInstance().isMemberOfList(contactInfo));
            ClientSingleton.toLog(this.getClass().getSimpleName(), "onCreateOptionsMenu contactInfo=" + contactInfo + "\ngetUserID=" + contactInfo.getUserID() + "\nuserId=" + ClientSingleton.getInstance().getUserID(contactInfo) + "\ngetLocalId=" + contactInfo.getLocalId() + "\ngetId=" + contactInfo.getId() + " getNumber=" + contactInfo.getPhoneNumbers());
        }
    }

    public Optional<SessionInfo> getCurrentSessionInfo() {
        return this.sessionInfo != null ? Optional.of(this.sessionInfo) : Optional.empty();
    }

    public void clearSessionInfo() {
        this.sessionInfo = null;
        this.clearLine();
    }

    public boolean equalsCurrentSessionInfo(SessionInfo sessionInfo) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "this.sessionInfo=" + this.sessionInfo + " sessionInfo=" + sessionInfo);
        if (this.sessionInfo == null || sessionInfo == null) {
            return false;
        }
        boolean isEquals = this.sessionInfo.equals((Object)sessionInfo);
        if (this.sessionInfo.getSessionId() == null && !isEquals) {
            isEquals = this.sessionInfo.toString().equals(sessionInfo.toString());
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "Sessions is equals=" + isEquals);
        return isEquals;
    }

    public boolean isCurrentInfoPaneVisible() {
        return this.currentVisibleInfoPane != -1;
    }

    public void clearInfoPaneImages() {
        this.setInfoPaneImages(0);
        this.currentVisibleInfoPane = 0;
        this.fx_ivInfo.setImagePath("chat/messagecell/panel_close.png");
    }

    public boolean setInfoPaneImages() {
        return this.setInfoPaneImages(this.currentVisibleInfoPane);
    }

    public boolean setInfoPaneImages(int mode) {
        if (this.currentVisibleInfoPane == mode) {
            switch (mode) {
                case 0: {
                    this.fx_ivInfo.setImagePath("chat/messagecell/info_panel_off.png");
                    break;
                }
                case 1: {
                    this.fx_ivActivity.setImagePath("chat/messagecell/activity_panel_off.png");
                    break;
                }
                case 2: {
                    this.fx_ivComment.setImagePath("chat/messagecell/comments_panel_off.png");
                }
            }
            this.currentVisibleInfoPane = -1;
            return false;
        }
        switch (mode) {
            case 0: {
                this.fx_ivInfo.setImagePath("chat/messagecell/panel_close.png");
                this.fx_ivActivity.setImagePath("chat/messagecell/activity_panel_off.png");
                this.fx_ivComment.setImagePath("chat/messagecell/comments_panel_off.png");
                break;
            }
            case 1: {
                this.fx_ivInfo.setImagePath("chat/messagecell/info_panel_off.png");
                this.fx_ivActivity.setImagePath("chat/messagecell/panel_close.png");
                this.fx_ivComment.setImagePath("chat/messagecell/comments_panel_off.png");
                break;
            }
            case 2: {
                this.fx_ivInfo.setImagePath("chat/messagecell/info_panel_off.png");
                this.fx_ivActivity.setImagePath("chat/messagecell/activity_panel_off.png");
                this.fx_ivComment.setImagePath("chat/messagecell/panel_close.png");
            }
        }
        this.currentVisibleInfoPane = mode;
        return true;
    }

    public void setInfoButtonImage() {
        this.fx_ivInfo.setImagePath("chat/messagecell/info_panel_off.png");
    }

    private LocalDate getLocalDate(long millis) {
        return Instant.ofEpochMilli(millis).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    @Override
    public void setCallPanesVisible() {
        this.isCallPanesVisible = true;
    }

    @Override
    public void setCallPanesUnVisible() {
        this.isCallPanesVisible = false;
    }

    @Override
    public void switchToFilter() {
        this.fx_vbTopLine.getChildren().add((Object)this.fx_FilterPane);
        this.fx_FilterSearch.setFocusInTextField();
    }

    public boolean isCallPanesVisible() {
        return this.isCallPanesVisible;
    }

    public AnchorPane getFx_RootPane() {
        return this.fx_RootPane;
    }

    public boolean isLoadingPreviousMessages() {
        return this.loadingPreviousMessages.get();
    }

    public SimpleBooleanProperty loadingPreviousMessagesProperty() {
        return this.loadingPreviousMessages;
    }

    public void setLoadingPreviousMessages(boolean loadingPreviousMessages) {
        if (!loadingPreviousMessages) {
            TimerExecutor.getInstance().setMyAction(() -> this.loadingPreviousMessages.set(false)).startWithDelay(100L);
        } else {
            this.loadingPreviousMessages.set(loadingPreviousMessages);
        }
    }

    public void sessionUpdated(SessionInfo sessionInfo) {
        ClientSingleton.getInstance().runLater(() -> {
            ClientSingleton.getInstance().removeLoadingPane();
            this.getCurrentSessionInfo().ifPresent(sessionInfo1 -> {
                if (this.getSessionInfo().getSessionId() != null && sessionInfo.getSessionId() != null && this.getSessionInfo().getSessionId().equals(sessionInfo.getSessionId())) {
                    this.initTitle();
                }
            });
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void messageAction(Pair<Integer, MessageInfo> pair) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "messageAction  isRefreshingList=" + this.isRefreshingList + " pair = " + pair);
        this.checkSessionStatus();
        if (this.isRefreshingList || (Integer)pair.getKey() != 3 && pair.getValue() == null) {
            return;
        }
        ObservableList<MessageInfo> observableList = this.messageInfos;
        synchronized (observableList) {
            switch ((Integer)pair.getKey()) {
                case 0: {
                    this.receiveMessage((MessageInfo)pair.getValue());
                    break;
                }
                case 1: {
                    this.updateMessage((MessageInfo)pair.getValue());
                    break;
                }
                case 2: {
                    this.removeMessage((MessageInfo)pair.getValue());
                    break;
                }
                case 3: {
                    this.updateAvatars();
                }
            }
        }
    }

    private Disposable getObservable(Pair<Integer, MessageInfo> pair1) {
        return Observable.just(pair1).observeOn((Scheduler)JavaFxScheduler.platform()).doOnError(Throwable::printStackTrace).subscribe(this::messageAction);
    }

    public void onUpdateAvatars() {
        this.queueMessagesForUpdate.add((Pair<Integer, MessageInfo>)new Pair((Object)3, null));
        if (this.disposableMessageUpdate == null) {
            this.startMessageUpdateObserver();
        }
    }

    public void onMessageRemoved(SessionInfo sessionInfo, MessageInfo messageInfo) {
        this.onNext(2, sessionInfo, messageInfo);
    }

    public void onMessageUpdated(SessionInfo sessionInfo, MessageInfo messageInfo) {
        this.onNext(1, sessionInfo, messageInfo);
    }

    public void onMessageReceived(SessionInfo sessionInfo, MessageInfo messageInfo) {
        this.onNext(0, sessionInfo, messageInfo);
    }

    private void onNext(int action, SessionInfo sessionInfo, MessageInfo messageInfo) {
        if (this.equalsCurrentSessionInfo(sessionInfo)) {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "onNext=" + this.queueMessagesForUpdate.size() + " disposableMessageUpdate=" + this.disposableMessageUpdate);
            this.queueMessagesForUpdate.add((Pair<Integer, MessageInfo>)new Pair((Object)action, (Object)messageInfo));
            if (this.disposableMessageUpdate == null) {
                this.startMessageUpdateObserver();
            }
        }
    }

    private void startMessageUpdateObserver() {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "startMessageUpdateObserver");
        this.isAddingMessageForUpdate.set(true);
        this.initUpdateMessagesObservable();
    }

    private void stopMessageUpdateObserver() {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "stopMessageUpdateObserver");
        this.isAddingMessageForUpdate.set(false);
        if (this.disposableMessageUpdate != null) {
            this.disposableMessageUpdate.dispose();
            this.disposableMessageUpdate = null;
        }
        this.queueMessagesForUpdate.clear();
    }

    private void removeMessage(MessageInfo messageInfo) {
        ClientSingleton.getInstance().runLater(() -> this.messageInfos.remove((Object)messageInfo));
    }

    private void updateMessage(MessageInfo messageInfo) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "updateMessage isRefreshingList=" + this.isRefreshingList + " messageInfo=" + messageInfo);
        if (this.isRefreshingList) {
            return;
        }
        for (int index = this.virtualFlow.getFirstVisibleIndex(); index <= this.virtualFlow.getLastVisibleIndex(); ++index) {
            this.virtualFlow.getCellIfVisible(index).ifPresent(messageInfoCell -> {
                ChatCellPane chatCellPane = (ChatCellPane)messageInfoCell.getNode();
                if (messageInfo.getId().equals(chatCellPane.getId())) {
                    chatCellPane.updateContent();
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "updateMessage done");
                }
            });
        }
    }

    private void updateAvatars() {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "updateAvatars");
        for (int index = this.virtualFlow.getFirstVisibleIndex(); index <= this.virtualFlow.getLastVisibleIndex(); ++index) {
            this.virtualFlow.getCellIfVisible(index).ifPresent(messageInfoCell -> {
                ChatCellPane chatCellPane = (ChatCellPane)messageInfoCell.getNode();
                chatCellPane.updateAvatar();
            });
        }
    }

    public void refreshCellsBackground() {
        for (int index = this.virtualFlow.getFirstVisibleIndex(); index <= this.virtualFlow.getLastVisibleIndex(); ++index) {
            this.virtualFlow.getCellIfVisible(index).ifPresent(messageInfoCell -> {
                ChatCellPane chatCellPane = (ChatCellPane)messageInfoCell.getNode();
                chatCellPane.refreshBackground();
            });
        }
    }

    private void receiveMessage(MessageInfo messageInfo) throws IndexOutOfBoundsException {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "addMessage : isRefreshingList=" + this.isRefreshingList + " messageInfo=" + messageInfo + " messageInfos=" + this.messageInfos.size());
        if (messageInfo == null || messageInfo.getSessionId() != null && !messageInfo.getSessionId().equals(this.sessionInfo.getSessionId()) || messageInfo.getType() == 14 || currentFilter != 0) {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "addMessage return");
            return;
        }
        this.isAddingMessageToList = true;
        long messageTime = messageInfo.getTime();
        Optional<String> optionalMessageInfo = this.messageInfos.stream().map(MessageInfo::getId).filter(messageId -> messageId.equals(messageInfo.getId())).findAny();
        ClientSingleton.toLog(this.getClass().getSimpleName(), "addMessage : optionalMessageInfo=" + optionalMessageInfo);
        if (optionalMessageInfo.isEmpty()) {
            if (this.lastDay == null || this.getLocalDate(this.lastDay.getTime()).isBefore(this.getLocalDate(messageTime))) {
                MessageInfoDate messageInfoDate = new MessageInfoDate(messageTime - 10L);
                this.messageInfos.add((Object)messageInfoDate);
                this.lastDay = messageInfoDate;
            }
            int index = -2;
            if (!this.messageInfos.isEmpty()) {
                long firstTime = ((MessageInfo)this.messageInfos.get(0)).getTime();
                if (firstTime > messageTime) {
                    index = 0;
                } else {
                    for (index = this.messageInfos.size() - 1; index >= 0; --index) {
                        MessageInfo mi = (MessageInfo)this.messageInfos.get(index);
                        if (mi.getTime() >= messageTime) continue;
                        ++index;
                        break;
                    }
                }
            }
            AtomicBoolean isDow = new AtomicBoolean(true);
            ClientSingleton.toLog(this.getClass().getSimpleName(), "addMessage : index=" + index);
            try {
                if (index == -2 || index >= this.messageInfos.size() - 1) {
                    this.messageInfos.add((Object)messageInfo);
                } else if (index == 0) {
                    this.messageInfos.add(0, (Object)messageInfo);
                } else {
                    try {
                        this.messageInfos.add(Math.max(index, 0), (Object)messageInfo);
                        isDow.set(false);
                    }
                    catch (Exception e) {
                        this.messageInfos.add((Object)messageInfo);
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
                ObservableList tmpMessageInfos = FXCollections.observableArrayList(this.messageInfos);
                if (index == -2 || index >= tmpMessageInfos.size() - 1) {
                    tmpMessageInfos.add((Object)messageInfo);
                } else if (index == 0) {
                    tmpMessageInfos.add(0, (Object)messageInfo);
                } else {
                    try {
                        tmpMessageInfos.add(Math.max(index, 0), (Object)messageInfo);
                        isDow.set(false);
                    }
                    catch (Exception x) {
                        tmpMessageInfos.add((Object)messageInfo);
                    }
                }
                this.messageInfos.setAll((Collection)tmpMessageInfos);
            }
            if (this.sessionInfo.getStatus() == 3 && ClientSingleton.getInstance().hasMeetingServices()) {
                ClientSingleton.toLog(this.getClass().getSimpleName(), "Last Message " + this.sessionInfo.getLastMessage());
                if (this.sessionInfo.getLastMessage() != null && this.sessionInfo.getLastMessage().getType() == 23) {
                    ClientSingleton.getInstance().openWebBrowser(messageInfo.getContent());
                }
            }
            if (isDow.get()) {
                TimerExecutor.getInstance().setMyAction(this::scrollBottom).startWithDelayInGUIThread(300L);
            }
        }
        this.isAddingMessageToList = false;
        ClientSingleton.toLog(this.getClass().getSimpleName(), "addMessage : messageInfos=" + this.messageInfos.size() + " done");
    }

    public void sendRead() {
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> this.getCurrentSessionInfo().ifPresent(arg_0 -> ((ClientConnector)clientConnector).sendRead(arg_0)));
    }

    private void showCallContextMenu(MouseEvent mouseEvent) {
        this.hideCallContextMenu();
        this.myContextMenu = new MyContextMenu();
        this.myContextMenu.setWithSelection(false);
        this.myContextMenu.addMenuItem((Object)ClientSingleton.getInstance().getString("call_menu_dial_as"), (EventHandler<MouseEvent>)((EventHandler)event1 -> {
            List trunks = ClientSingleton.getInstance().getClientConnector().get().getTrunks(null);
            ArrayList<String> numbers = new ArrayList();
            if (!this.sessionInfo.isGroup()) {
                numbers = ClientSingleton.getInstance().getPhonesListForMenu((ContactInfo)this.sessionInfo.getParties().get(0));
            }
            if (trunks != null && trunks.size() > 1 || numbers.size() > 1) {
                AudioCaller.makeAudioCallToExternal(this.sessionInfo.toString(), numbers, trunks);
            } else {
                AudioCaller.makeAudioCallToExternal(this.sessionInfo, true);
            }
            this.hideCallContextMenu();
        }));
        this.myContextMenu.show(mouseEvent.getScreenX(), mouseEvent.getScreenY());
    }

    private void hideCallContextMenu() {
        if (this.myContextMenu != null) {
            if (this.myContextMenu.isShowing()) {
                this.myContextMenu.hide();
            }
            this.myContextMenu.clear();
        }
    }

    private void showSendContextMenu(String text, MouseEvent mouseEvent) {
        this.hideSendContextMenu();
        this.mySendContextMenu = new MyContextMenu();
        this.mySendContextMenu.setWithSelection(false);
        this.mySendContextMenu.addMenuItem((Object)ClientSingleton.getInstance().getString("chat_send_menu"), (EventHandler<MouseEvent>)((EventHandler)event1 -> {
            this.hideCallContextMenu();
            AudioCaller.sendSmsMms(this.sessionInfo, text, true);
        }));
        this.mySendContextMenu.show(mouseEvent.getScreenX(), mouseEvent.getScreenY());
    }

    private void hideSendContextMenu() {
        if (this.mySendContextMenu != null) {
            if (this.mySendContextMenu.isShowing()) {
                this.mySendContextMenu.hide();
            }
            this.mySendContextMenu.clear();
        }
    }

    @Override
    public void addUrlToDownload(String messageId, String url, int index) {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "addUrlToDownload : " + Thread.currentThread().getName() + " disposableUrl=" + this.disposableUrl + " queueMessages.isEmpty()=" + this.queueUrls.isEmpty() + " isAddMessage.get()=" + this.isAddUrl.get());
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("link_messageId", messageId);
        map.put("link_url", url);
        map.put("link_index", index);
        try {
            this.queueUrls.add(map);
        }
        catch (IllegalStateException ex) {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "Error addUrlToDownload : " + ex.getMessage());
        }
        if (this.disposableUrl == null) {
            this.startDownloadLinkData();
        }
    }

    private void linkDataObservable() {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "startObservable");
        this.disposableUrl = Observable.interval((long)500L, (TimeUnit)TimeUnit.MILLISECONDS).doOnError(Throwable::printStackTrace).switchMap(i -> {
            Map map;
            ClientSingleton.toLog(this.getClass().getSimpleName(), "disposableAddMessage : " + Thread.currentThread().getName() + " queueMessages.isEmpty()=" + this.queueUrls.isEmpty() + " isAddMessage.get()=" + this.isAddUrl.get());
            if (!this.queueUrls.isEmpty() && this.isAddUrl.get() && (map = (Map)this.queueUrls.poll()) != null) {
                return Observable.just((Object)map);
            }
            this.stopDownloadLinkData();
            return Observable.empty();
        }).flatMap(map -> {
            String messageId = (String)map.get("link_messageId");
            String url = this.getUrl((String)map.get("link_url"));
            String name = messageId + "_" + map.get("link_index");
            Map<String, Object> lMessages = this.getTitles(messageId, url);
            url = (String)lMessages.get(LinkHBoxViewHolder.LINK_IMAGE_URL);
            Image image = null;
            File file = new File(ClientSingleton.getInstance().getClientConnector().get().getFilesDir() + File.separator + name + ".png");
            if (file.exists()) {
                image = new Image(Files.newInputStream(file.toPath(), new OpenOption[0]));
            } else if (url != null && !url.isEmpty()) {
                try {
                    image = new Image(url);
                    if (image.getWidth() != 0.0 && image.getHeight() != 0.0 && !ImageIO.write((RenderedImage)SwingFXUtils.fromFXImage((Image)image, null), "png", file)) {
                        ClientSingleton.toLog(this.getClass().getSimpleName(), "Error write image: not ImageIO.write ");
                    }
                }
                catch (Throwable ex) {
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "Error write image: " + ex.getMessage());
                }
            }
            if (image != null && image.getWidth() != 0.0 && image.getHeight() != 0.0) {
                int sideLength = 85;
                if (image.getWidth() > (double)sideLength || image.getHeight() > (double)sideLength) {
                    image = new Image(Files.newInputStream(file.toPath(), new OpenOption[0]), (double)sideLength, (double)sideLength, true, true);
                }
                lMessages.put(LinkHBoxViewHolder.LINK_IMAGE, image);
            }
            return Observable.just((Object)new Pair(map, lMessages));
        }).observeOn((Scheduler)JavaFxScheduler.platform()).subscribe(pair -> {
            Map map = (Map)pair.getKey();
            Map lMessages = (Map)pair.getValue();
            int linkIndex = (Integer)map.get("link_index");
            String messageId = (String)map.get("link_messageId");
            String name = messageId + "_" + linkIndex;
            ClientSingleton.getInstance().setLinkData(name, lMessages);
            for (int index = this.virtualFlow.getFirstVisibleIndex(); index <= this.virtualFlow.getLastVisibleIndex(); ++index) {
                ChatCellPane baseCell;
                Cell visibleCell;
                Optional optional = this.virtualFlow.getCellIfVisible(index);
                if (!optional.isPresent() || !((visibleCell = (Cell)optional.get()).getNode() instanceof ChatCellPane) || !messageId.equals((baseCell = (ChatCellPane)visibleCell.getNode()).getId())) continue;
                baseCell.setLinkMap(linkIndex, lMessages);
            }
        }, Throwable::printStackTrace);
    }

    private String getUrl(String mContent) {
        int index = mContent.indexOf("http://");
        if (index == -1 && (index = mContent.indexOf("https://")) == -1 && (index = mContent.indexOf("www.")) == -1) {
            return null;
        }
        String url = "";
        int i = mContent.indexOf(" ", index);
        url = index == 0 && i == -1 ? mContent : (i != -1 ? (index < i ? mContent.substring(index, i) : mContent.substring(i)) : mContent.substring(index));
        if (url.indexOf("/www.") == -1) {
            url = url.replace("www.", "http://");
        }
        return url.trim();
    }

    private Map<String, Object> getTitles(String messageId, String url) {
        Map<String, Object> data = ClientSingleton.getInstance().getLinkData(url);
        try {
            String name;
            Document doc = Jsoup.connect((String)url).get();
            Elements links = doc.head().getElementsByAttribute("property");
            data.put(LinkHBoxViewHolder.LINK_TITLE, doc.title());
            String description = null;
            String image = null;
            for (Element link : links) {
                String og = link.getElementsByAttribute("property").toString();
                if (og.indexOf("og:description") != -1) {
                    og = og.substring(0, og.length() - 2);
                    description = og = og.substring(og.lastIndexOf("\"") + 1);
                    continue;
                }
                if (og.indexOf("og:image") == -1 || image != null) continue;
                og = og.substring(0, og.length() - 2);
                image = og = og.substring(og.lastIndexOf("\"") + 1);
            }
            if (description != null) {
                data.put(LinkHBoxViewHolder.LINK_DESCRIPTION, description);
            } else {
                for (Element link : doc.select("meta")) {
                    name = link.attr("name");
                    if (name.indexOf("description") == -1) continue;
                    description = link.attr("content");
                }
                data.put(LinkHBoxViewHolder.LINK_DESCRIPTION, description);
            }
            if (image != null) {
                data.put(LinkHBoxViewHolder.LINK_IMAGE_URL, image);
            } else {
                for (Element link : doc.select("meta")) {
                    name = link.attr("name");
                    if (name.indexOf("image") == -1) continue;
                    image = link.attr("content");
                }
                if (image != null) {
                    data.put(LinkHBoxViewHolder.LINK_IMAGE_URL, image);
                } else {
                    image = this.getFirstImage(doc);
                    if (image != null) {
                        data.put(LinkHBoxViewHolder.LINK_IMAGE_URL, image);
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return data;
    }

    private String getFirstImage(Document doc) {
        try {
            Elements img = doc.getElementsByTag("img");
            for (Element el : img) {
                String src = el.absUrl("src");
                if (src.contains("doubleclick.net") || src.contains("feedburner.com") || src.contains("feedsportal.com") || src.contains("ads")) continue;
                System.out.println("src attribute is : " + src);
                return src;
            }
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    private void startDownloadLinkData() {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "starlDownload link data");
        this.isAddUrl.set(true);
        this.linkDataObservable();
    }

    private void stopDownloadLinkData() {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "stopDownload link data");
        this.isAddUrl.set(false);
        if (this.disposableUrl != null) {
            this.disposableUrl.dispose();
            this.disposableUrl = null;
        }
        this.queueUrls.clear();
    }

    public void invalidateChatView() {
        this.myStyledTextArea = null;
        if (this.scrollPane != null) {
            this.virtualFlow.dispose();
            this.scrollPane.prefHeightProperty().unbind();
            this.fx_lvChatListPane.getChildren().remove(this.scrollPane);
            this.scrollPane.estimatedScrollYProperty().removeListener(this.onScrollFinished);
            this.scrollPane.removeEventHandler(MouseEvent.MOUSE_CLICKED, this.eventHandlerMouseClicked);
            this.scrollPane.removeEventHandler(MouseEvent.MOUSE_ENTERED, this.eventHandlerMouseClicked);
            this.scrollPane.removeEventHandler(MouseEvent.MOUSE_PRESSED, this.eventHandlerMousePressed);
            this.scrollPane.removeEventHandler(MouseEvent.MOUSE_RELEASED, this.eventHandlerMouseReleased);
            if (this.emojiController != null) {
                ClientSingleton.getInstance().releaseViewResources(this.emojiController.getPaneForDispose());
                this.emojiController = null;
            }
        }
        this.dispose();
        this.callLinePane.clearCallLinePane();
        ClientSingleton.getInstance().releaseViewResources((Pane)this.fx_RootPane);
    }

    private void initMessagesListObserver() {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "initMessagesListObserver start");
        this.messagesListObserver = PublishSubject.create();
        this.disposables.add(this.messagesListObserver.debounce(150L, TimeUnit.MILLISECONDS).switchMap(mode -> {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "update chat list mode = " + mode);
            this.setLastScrollMode((int)mode);
            this.setRefreshingList(true);
            this.fx_ivMoveDown.hideButton();
            this.lastDay = null;
            if (this.fx_FilterSearch.getText() != null && !this.fx_FilterSearch.getText().isEmpty()) {
                this.disposables.add(Observable.just((Object)true).observeOn((Scheduler)JavaFxScheduler.platform()).subscribe(bl -> ClientSingleton.getInstance().addLoadingPane(ClientSingleton.getInstance().getString("searching"))));
            }
            List<MessageInfo> list = UpdateLists.getMessagesList(this.sessionInfo, currentFilter, this.fx_FilterSearch.getText());
            ClientSingleton.toLog(this.getClass().getSimpleName(), "updateList list.size()=" + list.size());
            if (list.isEmpty()) {
                return Observable.just((Object)new Pair(mode, list));
            }
            ArrayList<MessageInfo> messageInfoNodeList = new ArrayList<MessageInfo>();
            for (int index = list.size() - 1; index >= 0; --index) {
                MessageInfo messageInfo = list.get(index);
                messageInfoNodeList.add(messageInfo);
            }
            boolean isEquals = this.compare(messageInfoNodeList);
            ClientSingleton.toLog(this.getClass().getSimpleName(), "updateList isEquals=" + isEquals);
            if (isEquals) {
                return Observable.empty();
            }
            return Observable.just((Object)new Pair(mode, messageInfoNodeList));
        }).doOnNext(pair -> {
            if (currentFilter == 0) {
                List list = (List)pair.getValue();
                list.forEach(messageInfo -> {
                    if (messageInfo instanceof MessageInfoDate && (this.lastDay == null || messageInfo.getTime() > this.lastDay.getTime())) {
                        this.lastDay = (MessageInfoDate)((Object)((Object)messageInfo));
                    }
                });
            }
        }).observeOn((Scheduler)JavaFxScheduler.platform()).subscribe(pair -> {
            List list = (List)pair.getValue();
            this.messageInfos.setAll((Collection)list);
            ClientSingleton.toLog(this.getClass().getSimpleName(), "move to " + pair.getKey());
            if (!list.isEmpty() && (Integer)pair.getKey() != -1) {
                this.scrollPane.setOpacity(0.0);
                AtomicInteger index = new AtomicInteger((Integer)pair.getKey());
                if ((Integer)pair.getKey() < 0) {
                    index.set(this.messageInfos.size() - 1);
                }
                if (!this.messageInfos.isEmpty() && index.get() >= 0) {
                    this.showAsLast(index.get());
                }
                this.setRefreshingList(false);
                this.setLoadingPreviousMessages(false);
                FadeTransition ft = this.getFadeTransition(index);
                ft.play();
            } else {
                if (this.getReplyMessageInfo != null) {
                    int i = -1;
                    int indexOfMessage = this.getIndexOfMessage((List<MessageInfo>)this.messageInfos, this.getReplyMessageInfo);
                    i = indexOfMessage;
                    if (i != -1) {
                        this.setLastScrollMode(-1);
                        if (i == 1) {
                            i = 0;
                        }
                    }
                    this.moveToIndex(i);
                    this.getReplyMessageInfo = null;
                }
                this.setRefreshingList(false);
                this.setLoadingPreviousMessages(false);
                if (this.fx_FilterSearch.getText() != null) {
                    this.disposables.add(Observable.just((Object)true).observeOn((Scheduler)JavaFxScheduler.platform()).subscribe(bl -> ClientSingleton.getInstance().removeLoadingPane()));
                }
                ClientSingleton.toLog(this.getClass().getSimpleName(), "updateList done 2");
            }
        }, Throwable::printStackTrace));
    }

    private FadeTransition getFadeTransition(AtomicInteger index) {
        FadeTransition ft = new FadeTransition(Duration.millis((double)200.0), this.scrollPane);
        ft.setFromValue(0.0);
        ft.setToValue(1.0);
        ft.setOnFinished(value -> {
            if (this.fx_FilterSearch.getText() != null) {
                ClientSingleton.getInstance().removeLoadingPane();
            }
            if (!this.messageInfos.isEmpty() && index.get() >= 0) {
                this.moveToIndex(index.get());
            }
        });
        return ft;
    }

    private void initUpdateMessagesObservable() {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "initUpdateMessagesObservable");
        this.disposableMessageUpdate = Observable.interval((long)200L, (TimeUnit)TimeUnit.MILLISECONDS).doOnError(Throwable::printStackTrace).observeOn((Scheduler)JavaFxScheduler.platform()).flatMap(i -> {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "disposableMessageUpdate : " + Thread.currentThread().getName() + " queueMessagesForUpdate.isEmpty()=" + this.queueMessagesForUpdate.isEmpty() + " isAddingMessageForUpdate.get()=" + this.isAddingMessageForUpdate.get());
            if (!this.queueMessagesForUpdate.isEmpty() && this.isAddingMessageForUpdate.get()) {
                Pair pair = (Pair)this.queueMessagesForUpdate.poll();
                ClientSingleton.toLog(this.getClass().getSimpleName(), "disposableMessageUpdate : " + Thread.currentThread().getName() + " pair = " + pair);
                if (pair != null) {
                    return Observable.just((Object)pair);
                }
            }
            this.stopMessageUpdateObserver();
            return Observable.empty();
        }).subscribe(this::messageAction, Throwable::printStackTrace);
    }

    private void onPreviousMessagesRequest() {
        if (ClientSingleton.getInstance().getLastAction().contains(IntentConstants.MESSAGES_LOADED)) {
            return;
        }
        if (this.loadingPreviousMessagesObserver == null) {
            this.initLoadPreviousMessages();
        }
        this.loadingPreviousMessagesObserver.onNext((Object)false);
    }

    private void initLoadPreviousMessages() {
        this.loadingPreviousMessagesObserver = PublishSubject.create();
        this.disposables.add(this.loadingPreviousMessagesObserver.debounce(100L, TimeUnit.MILLISECONDS).switchMap(Observable::just).subscribe(in -> {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "loadingPreviousMessagesObserver start");
            this.scrollPane.setCursor(Cursor.DEFAULT);
            this.draggedLayoutY = -1.0;
            this.getPreviousMessages();
        }, Throwable::printStackTrace));
    }

    public void dispose() {
        this.stopAllPlayers();
        if (this.disposables != null) {
            this.disposables.dispose();
            this.disposables.clear();
        }
        this.disposables = new CompositeDisposable();
        this.messagesListObserver = null;
        this.loadingPreviousMessagesObserver = null;
        this.resizeObserver = null;
    }

    public boolean compare(List<MessageInfo> members) {
        boolean isEquals = true;
        if (this.messageInfos.size() == members.size()) {
            int j = this.messageInfos.size() - 1;
            for (int i = 0; i <= this.messageInfos.size() - 1; ++i) {
                MessageInfo messageInfo1 = (MessageInfo)this.messageInfos.get(i);
                MessageInfo messageInfo2 = members.get(i);
                if (messageInfo1.getId() != null && messageInfo2.getId() != null && messageInfo1.getId().equals(messageInfo2.getId()) && messageInfo1.getStatus() == messageInfo2.getStatus()) continue;
                return false;
            }
        } else {
            isEquals = false;
        }
        return isEquals;
    }

    @Override
    public void stopAllPlayers() {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "stopAllPlayers");
        for (int index = this.virtualFlow.getFirstVisibleIndex(); index <= this.virtualFlow.getLastVisibleIndex(); ++index) {
            this.virtualFlow.getCellIfVisible(index).ifPresent(messageInfoCell -> {
                ChatCellPane chatCellPane = (ChatCellPane)messageInfoCell.getNode();
                Pane pane = chatCellPane.getHolder();
                if (pane instanceof CallViewerBase) {
                    ((CallViewerBase)pane).stopPlayback();
                }
            });
        }
        if (this.iNewMessagesNotification != null) {
            this.iNewMessagesNotification.stopPlayerInCallDetailsViewController();
        }
    }

    @Override
    public String getInputText() {
        String inputText = this.fx_FilterSearch.getText();
        if (inputText.isEmpty()) {
            inputText = this.iNewMessagesNotification.getInputTextFromSearch();
        }
        return inputText;
    }

    public void openSearchPane() {
        if (!this.fx_vbTopLine.getChildren().contains((Object)this.fx_FilterPane)) {
            this.switchToFilter();
        } else {
            this.closeFilterPane();
        }
    }
}

