/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.chat.cell;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.utils.MyUtils;
import net.sipsnet.client.views.chat.cell.ChatCellPane;
import net.sipsnet.client.views.chat.interfaces.IChatListCell;
import org.fxmisc.flowless.Cell;
import org.fxmisc.flowless.VirtualFlow;
import org.fxmisc.flowless.VirtualizedScrollPane;
import smile.cti.client.EmailInfo;
import smile.cti.client.FileInfo;
import smile.cti.client.MessageInfo;

public class ChatCell
implements Cell<MessageInfo, Node> {
    private final IChatListCell iChatListCell;
    private Pane chatCellPane;
    private final VirtualizedScrollPane<VirtualFlow<MessageInfo, ?>> scrollPane;

    public ChatCell(VirtualizedScrollPane<VirtualFlow<MessageInfo, ?>> scrollPane, IChatListCell iChatListCell, MessageInfo messageInfo) {
        this.scrollPane = scrollPane;
        this.iChatListCell = iChatListCell;
        this.initCell(messageInfo);
    }

    private void initCell(MessageInfo messageInfo) {
        this.init(messageInfo);
        this.chatCellPane.prefWidthProperty().bind((ObservableValue)this.scrollPane.widthProperty().subtract(15));
    }

    private void init(MessageInfo messageInfo) {
        this.chatCellPane = new ChatCellPane(this.iChatListCell, messageInfo);
        this.chatCellPane.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number number, Number newValue) {
                ChatCell.this.chatCellPane.heightProperty().removeListener((ChangeListener)this);
                ChatCell.this.chatCellPane.setMinHeight(newValue.doubleValue());
            }
        });
        ClientSingleton.getInstance().setFocusNotTraversable(this.chatCellPane);
    }

    public Pane getNode() {
        return this.chatCellPane;
    }

    public boolean isReusable() {
        return false;
    }

    public void updateItem(MessageInfo messageInfo) {
        if (this.chatCellPane != null && this.isEqualsType(messageInfo)) {
            ChatCellPane chatCellPane1 = (ChatCellPane)this.chatCellPane;
            chatCellPane1.update(messageInfo);
            chatCellPane1.requestLayout();
            this.scrollPane.layout();
        } else {
            this.init(messageInfo);
        }
    }

    public void dispose() {
        ((ChatCellPane)this.chatCellPane).dispose();
        this.chatCellPane.prefWidthProperty().unbind();
        ClientSingleton.getInstance().releaseViewResources(this.chatCellPane);
    }

    private boolean isEqualsType(MessageInfo messageInfo) {
        if (!(messageInfo.getType() == 23 || messageInfo.getType() == 8 || messageInfo instanceof EmailInfo || messageInfo instanceof FileInfo || this.isMessageWithUrl(messageInfo.getContent()))) {
            ChatCellPane chatCellPane1 = (ChatCellPane)this.chatCellPane;
            return chatCellPane1.getMessagePaneType() == ChatCellPane.MessagePaneType.TEXT_MESSAGE;
        }
        return false;
    }

    private boolean isMessageWithUrl(String mContent) {
        return !MyUtils.bindLink(mContent).isEmpty();
    }
}

