/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.chat.cell;

import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.util.Pair;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.MyUtils;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.viewers.IActionOnRelease;
import net.sipsnet.client.utils.viewers.IOnSliderPlay;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButton;
import net.sipsnet.client.utils.viewers.imageview.MyImageView;
import net.sipsnet.client.utils.viewers.richtext.MentionLinkedText;
import net.sipsnet.client.views.chat.cell.IInvalidateListener;
import net.sipsnet.client.views.chat.cell.IRepliedMessage;
import net.sipsnet.client.views.chat.cell.MessageInfoDate;
import net.sipsnet.client.views.chat.cell.ReplyImageTask;
import net.sipsnet.client.views.chat.holders.viewerholders.AvatarViewHolder;
import net.sipsnet.client.views.chat.holders.viewerholders.ChannelMessageViewerHolder;
import net.sipsnet.client.views.chat.holders.viewerholders.DateViewHolder;
import net.sipsnet.client.views.chat.holders.viewerholders.EmailViewHolder;
import net.sipsnet.client.views.chat.holders.viewerholders.FileInfoViewerHolder;
import net.sipsnet.client.views.chat.holders.viewerholders.HeaderViewHolder;
import net.sipsnet.client.views.chat.holders.viewerholders.ImageHBoxViewerHolder;
import net.sipsnet.client.views.chat.holders.viewerholders.LinkHBoxViewHolder;
import net.sipsnet.client.views.chat.holders.viewerholders.MediaMessageViewerHolder;
import net.sipsnet.client.views.chat.holders.viewerholders.MeetingViewerHolder;
import net.sipsnet.client.views.chat.holders.viewerholders.TextInfoViewerHolder;
import net.sipsnet.client.views.chat.holders.viewerholders.VideoImageHBoxViewerHolder;
import net.sipsnet.client.views.chat.holders.viewerholders.callviewer.CallViewerHolder;
import net.sipsnet.client.views.chat.holders.viewerholders.callviewer.MissedCallViewHolder;
import net.sipsnet.client.views.chat.interfaces.IChatListCell;
import net.sipsnet.client.views.chat.messageutil.MessageInfoCellLabels;
import smile.cti.client.EmailInfo;
import smile.cti.client.FileInfo;
import smile.cti.client.MessageInfo;
import smile.cti.client.SessionInfo;

public class ChatCellPane
extends HBox
implements IRepliedMessage,
IActionOnRelease,
IOnSliderPlay,
Comparable<ChatCellPane>,
IInvalidateListener {
    private MessagePaneType messagePaneType = MessagePaneType.TEXT_MESSAGE;
    private AvatarViewHolder avatarViewHeader;
    private DateViewHolder dateViewHolder;
    private VBox fx_CellReplayPane;
    private VBox cellPane;
    private HeaderViewHolder headerViewHolder;
    private VBox fx_MainPane;
    private ImageHBoxViewerHolder imageHBoxViewerHolder;
    private FileInfoViewerHolder fileInfoViewerHolder;
    private TextInfoViewerHolder textInfoViewerHolder;
    private MessageInfo messageInfo;
    private IChatListCell iChatListCell;
    private final EventHandler<ScrollEvent> scrollEvent = event -> ClientSingleton.getInstance().chatFireScrollEvent((ScrollEvent)event);
    private EventHandler<MouseEvent> mouseEventEventHandler = mouseEvent -> this.requestFocus();
    private VideoImageHBoxViewerHolder videoImageHBoxViewerHolder;
    private LinkHBoxViewHolder linkHBoxViewHolder;

    public MessagePaneType getMessagePaneType() {
        return this.messagePaneType;
    }

    public VBox getMainPane() {
        return this.fx_MainPane;
    }

    public ChatCellPane(IChatListCell iChatListCell, MessageInfo messageInfo) {
        try {
            this.messageInfo = messageInfo;
            this.iChatListCell = iChatListCell;
            this.addEventHandler(MouseEvent.MOUSE_CLICKED, this.mouseEventEventHandler);
            if (this.isDateType()) {
                this.dateViewHolder = new DateViewHolder(messageInfo);
                this.setPrefHeight(40.0);
                this.getChildren().add((Object)this.dateViewHolder);
            } else {
                this.setPadding(new Insets(5.0, 0.0, 5.0, 0.0));
                this.setAlignment(Pos.TOP_LEFT);
                this.cellPane = new VBox();
                this.getChildren().add((Object)this.cellPane);
                this.headerViewHolder = new HeaderViewHolder(messageInfo, iChatListCell);
                this.cellPane.getChildren().add((Object)this.headerViewHolder);
                this.fx_MainPane = new VBox();
                MessageInfo replayMessage = messageInfo.getRepliedMessage();
                if (replayMessage != null) {
                    this.fx_CellReplayPane = new VBox();
                    String incomingMessageBackground = ClientSingleton.getInstance().getStyleValue(Constants.CHAT_REPLY_INCOMING_MESSAGE_BACKGROUND);
                    String outgoingMessageBackground = ClientSingleton.getInstance().getStyleValue(Constants.CHAT_REPLY_OUTGOING_MESSAGE_BACKGROUND);
                    String sColor = MessageInfoCellLabels.isISendTheMessage(messageInfo) ? outgoingMessageBackground : incomingMessageBackground;
                    Theme.getInstance().applyReplyMessageTo((Pane)this.fx_CellReplayPane, sColor);
                    Theme.getInstance().applyReplyMessageScrollTo((Pane)this.fx_CellReplayPane, sColor);
                    this.fx_CellReplayPane.prefWidthProperty().bind((ObservableValue)this.fx_MainPane.prefWidthProperty());
                    this.fx_CellReplayPane.getChildren().clear();
                    this.setReplayMessagePane(replayMessage);
                    this.fx_MainPane.getChildren().add(0, (Object)this.fx_CellReplayPane);
                }
                this.fx_MainPane.setMaxWidth(iChatListCell.isSimpleViewMode() ? 230.0 : 400.0);
                this.bindMessageCell(iChatListCell.isSimpleViewMode() ? 230 : 400);
                this.fx_MainPane.addEventHandler(MouseEvent.MOUSE_CLICKED, this.mouseEventEventHandler);
                this.cellPane.getChildren().add((Object)this.fx_MainPane);
                this.cellPane.addEventHandler(MouseEvent.MOUSE_CLICKED, this.mouseEventEventHandler);
                this.cellPane.setPrefHeight(this.headerViewHolder.getPrefHeight() + this.fx_MainPane.getPrefHeight() + (this.fx_CellReplayPane != null ? this.fx_CellReplayPane.getPrefHeight() + 10.0 : 0.0));
            }
            this.setId(messageInfo.getId());
            this.setNeedsLayout(true);
            this.addEventFilter(ScrollEvent.ANY, this.scrollEvent);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void updateContent() {
        if (this.isDateType()) {
            return;
        }
        try {
            this.headerViewHolder.update();
            String content = MessageInfoCellLabels.setContentLabel(this.messageInfo);
            Pane pane = (Pane)this.fx_MainPane.getChildren().get(this.fx_MainPane.getChildren().size() - 1);
            if (pane instanceof ChannelMessageViewerHolder) {
                ChannelMessageViewerHolder holder = (ChannelMessageViewerHolder)pane;
                holder.updateView();
            } else if (pane instanceof TextInfoViewerHolder) {
                TextInfoViewerHolder holder = (TextInfoViewerHolder)pane;
                holder.updateMessage(content);
            } else if (pane instanceof LinkHBoxViewHolder) {
                LinkHBoxViewHolder holder = (LinkHBoxViewHolder)pane;
                holder.updateMessage(this.iChatListCell.getInputText());
            } else if (pane instanceof CallViewerHolder) {
                CallViewerHolder holder = (CallViewerHolder)pane;
                holder.setSubject();
            }
        }
        catch (Exception ex) {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "updateContent error: " + ex.getMessage());
        }
    }

    public void refreshBackground() {
        if (this.linkHBoxViewHolder != null) {
            this.linkHBoxViewHolder.refreshBackground();
        } else if (this.textInfoViewerHolder != null) {
            this.textInfoViewerHolder.refreshBackground();
        }
    }

    private void bindMessageCell(int width) {
        Object pane = null;
        boolean isLostCall = MessageInfoCellLabels.isLostCall(this.messageInfo);
        SessionInfo sessionInfo = this.iChatListCell.getSessionInfo();
        boolean isComment = sessionInfo != null && sessionInfo.getDialogType() == 3 && (this.messageInfo.getCode() == 1024 || !MentionLinkedText.getMentions(this.messageInfo.getContent()).isEmpty() || (this.messageInfo.getCode() & 0x400) != 0);
        String style = MessageInfoCellLabels.getCellBackground(this.messageInfo, isLostCall, isComment) + "-fx-text-fill: #656a7c;";
        if (this.messageInfo.getType() == 23) {
            this.messagePaneType = MessagePaneType.MEETING_MESSAGE;
            pane = new MeetingViewerHolder(this.messageInfo, 200);
        } else if (this.messageInfo.getType() == 8) {
            if (isLostCall) {
                this.messagePaneType = MessagePaneType.LOST_CALL_MESSAGE;
                pane = new MissedCallViewHolder(this.messageInfo, this.iChatListCell.isSimpleViewMode() ? 230 : 300);
            } else {
                this.messagePaneType = MessagePaneType.CALL_MESSAGE;
                pane = new CallViewerHolder(this.messageInfo, this.iChatListCell);
            }
        } else if (this.messageInfo instanceof EmailInfo) {
            pane = new EmailViewHolder(this.messageInfo);
        } else if (sessionInfo != null && sessionInfo.isChannel()) {
            pane = new ChannelMessageViewerHolder(this, this.messageInfo, width);
        } else if (this.messageInfo instanceof FileInfo) {
            FileInfo fileInfo = (FileInfo)this.messageInfo;
            if (ClientSingleton.getInstance().isSound(fileInfo)) {
                this.messagePaneType = MessagePaneType.MEDIA_MESSAGE;
                pane = new MediaMessageViewerHolder(this.messageInfo, this.iChatListCell.isSimpleViewMode() ? 230 : 300, isComment);
            } else if (!fileInfo.getContent().toLowerCase().endsWith(".heic") && fileInfo.isImage()) {
                this.messagePaneType = MessagePaneType.IMAGE_MESSAGE;
                this.imageHBoxViewerHolder = new ImageHBoxViewerHolder(this, this.messageInfo);
                pane = this.imageHBoxViewerHolder;
                this.fx_MainPane.minWidthProperty().bind((ObservableValue)pane.minWidthProperty());
                this.fx_MainPane.prefWidthProperty().bind((ObservableValue)pane.prefWidthProperty());
                this.fx_MainPane.minHeightProperty().bind((ObservableValue)pane.minHeightProperty());
            } else {
                this.messagePaneType = MessagePaneType.FILE_MESSAGE;
                this.fileInfoViewerHolder = new FileInfoViewerHolder(this.messageInfo, width, isComment);
                pane = this.fileInfoViewerHolder;
            }
        } else if (this.isMessageWithUrl(this.messageInfo.getContent())) {
            this.messagePaneType = MessagePaneType.LINK_MESSAGE;
            this.linkHBoxViewHolder = new LinkHBoxViewHolder(this, this.iChatListCell, this.messageInfo, width, isComment, this.iChatListCell.getInputText());
            pane = this.linkHBoxViewHolder;
        } else {
            this.messagePaneType = MessagePaneType.TEXT_MESSAGE;
            this.textInfoViewerHolder = new TextInfoViewerHolder(this.messageInfo, width, isComment, this.iChatListCell.getInputText());
            pane = this.textInfoViewerHolder;
        }
        this.fx_MainPane.setStyle(style);
        this.fx_MainPane.getChildren().add(pane);
        this.fx_MainPane.setPrefHeight(this.fx_MainPane.getPrefHeight() + pane.getPrefHeight());
        if (this.imageHBoxViewerHolder != null) {
            this.imageHBoxViewerHolder.bind();
        } else if (this.videoImageHBoxViewerHolder != null) {
            this.videoImageHBoxViewerHolder.bind();
        } else if (this.fileInfoViewerHolder != null) {
            this.fileInfoViewerHolder.bind();
        }
        this.addAvatarView();
    }

    public Pane getHolder() {
        if (this.fx_MainPane != null && !this.fx_MainPane.getChildren().isEmpty()) {
            return (Pane)this.fx_MainPane.getChildren().get(0);
        }
        return null;
    }

    private boolean isMessageWithUrl(String mContent) {
        return !MyUtils.bindLink(mContent).isEmpty();
    }

    private void addAvatarView() {
        if (!this.isDateType()) {
            this.avatarViewHeader = new AvatarViewHolder(this.messageInfo, this);
            HBox.setMargin((Node)this.avatarViewHeader, (Insets)new Insets(20.0, 10.0, 0.0, 10.0));
            this.getChildren().add(0, (Object)this.avatarViewHeader);
        }
    }

    public boolean isAvatarViewContains() {
        return this.avatarViewHeader != null && this.getChildren().contains((Object)this.avatarViewHeader);
    }

    public void updateAvatar() {
        if (this.avatarViewHeader != null) {
            this.avatarViewHeader.updateAvatar();
        }
    }

    public boolean equals(MessageInfo o) {
        return this.messageInfo.getId().equals(o.getId());
    }

    public int hashCode() {
        return Objects.hash(this.messageInfo);
    }

    private void setReplayMessagePane(MessageInfo messageInfo) {
        HBox pane = new HBox();
        ImageView imageView1 = new ImageView();
        ClientSingleton.getInstance().setImageToImageView(imageView1, "chat/reply.png");
        pane.setAlignment(Pos.CENTER_LEFT);
        HBox.setMargin((Node)imageView1, (Insets)new Insets(8.0, 8.0, 3.0, 8.0));
        Pair<String, Integer> pair = MessageInfoCellLabels.getSenderName(messageInfo);
        Label label = new Label((String)pair.getKey());
        label.setStyle("-fx-font-family: \"Arial\";-fx-font-size: 12 px;-fx-font-weight: bold;-fx-text-fill: " + ClientSingleton.getInstance().getStyleValue(Constants.CHAT_REPLY_MESSAGE_TEXT_FILL) + "; -fx-background-color:transparent;");
        HBox.setMargin((Node)label, (Insets)new Insets(8.0, 8.0, 0.0, 0.0));
        HBox empty = new HBox();
        empty.setStyle("-fx-padding: 8 8 8 8; -fx-background-color:transparent;");
        HBox.setHgrow((Node)empty, (Priority)Priority.ALWAYS);
        ImageButton arrowReplyImageButton = new ImageButton();
        arrowReplyImageButton.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)mouseEvent -> {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "getReplayMessage setReplayMessagePane =" + messageInfo.getId());
            this.iChatListCell.getReplayMessage(messageInfo, false);
        }));
        arrowReplyImageButton.setBackgroundColor("#f1f2f5");
        arrowReplyImageButton.setSize(20, 20);
        arrowReplyImageButton.setIsRounded(true);
        arrowReplyImageButton.setImagePath("buttons/arrow_up.png");
        HBox.setMargin((Node)arrowReplyImageButton, (Insets)new Insets(8.0, 8.0, 8.0, 8.0));
        pane.setPrefHeight(32.0);
        pane.getChildren().addAll((Object[])new Node[]{imageView1, label, empty, arrowReplyImageButton});
        HBox pane2 = new HBox();
        pane2.setStyle("-fx-padding: 0 0 0 0;-fx-background-color:transparent;");
        if (messageInfo instanceof FileInfo && (((FileInfo)messageInfo).isVideo() || ((FileInfo)messageInfo).isImage())) {
            AtomicReference atomicReference = new AtomicReference();
            ExecutorService executors = Executors.newSingleThreadExecutor();
            ReplyImageTask imageTask = new ReplyImageTask(messageInfo);
            imageTask.setOnSucceeded(event -> {
                Image image = (Image)imageTask.getValue();
                if (image != null) {
                    ClientSingleton.getInstance().runLater(() -> {
                        MyImageView myImageView = ClientSingleton.getInstance().getRoundedImage(image);
                        ClientSingleton.getInstance().setMouseCursor((Node)myImageView);
                        HBox.setMargin((Node)myImageView, (Insets)new Insets(0.0, 8.0, 8.0, 30.0));
                        pane2.getChildren().add((Object)myImageView);
                        pane.prefHeight(myImageView.getFitHeight());
                    });
                } else {
                    ClientSingleton.getInstance().addTextAreaToReply((Pane)pane2, messageInfo);
                }
                executors.shutdown();
            });
            executors.execute((Runnable)((Object)imageTask));
        } else {
            ClientSingleton.getInstance().addTextAreaToReply((Pane)pane2, messageInfo, true);
        }
        this.fx_CellReplayPane.setPrefHeight((pane.getPrefHeight() + pane2.getPrefHeight()) * 1.1);
        this.fx_CellReplayPane.getChildren().addAll((Object[])new Node[]{pane, pane2});
    }

    public void hideMenu() {
        if (this.headerViewHolder != null) {
            this.headerViewHolder.hideMenu();
        }
    }

    public String getDateLabel() {
        return this.messageInfo.getContent();
    }

    public boolean isDateType() {
        return this.messageInfo instanceof MessageInfoDate;
    }

    @Override
    public void onRelease() {
        TimerExecutor.getInstance().setMyAction(() -> {
            if (this.fx_MainPane != null) {
                this.fx_MainPane.removeEventHandler(MouseEvent.MOUSE_CLICKED, this.mouseEventEventHandler);
                this.cellPane.removeEventHandler(MouseEvent.MOUSE_CLICKED, this.mouseEventEventHandler);
            }
            this.removeEventFilter(ScrollEvent.ANY, this.scrollEvent);
            this.removeEventHandler(MouseEvent.MOUSE_CLICKED, this.mouseEventEventHandler);
            ClientSingleton.getInstance().releaseViewResources((Pane)this);
            this.mouseEventEventHandler = null;
            this.videoImageHBoxViewerHolder = null;
            this.imageHBoxViewerHolder = null;
        }).startWithDelayInGUIThread(100L);
    }

    public void setSimpleMode(boolean mode) {
        if (this.fx_MainPane != null) {
            this.fx_MainPane.setMaxWidth(mode ? 267.0 : 400.0);
        }
        if (this.avatarViewHeader != null) {
            if (mode) {
                this.getChildren().remove((Object)this.avatarViewHeader);
            } else if (!this.getChildren().contains((Object)this.avatarViewHeader)) {
                this.getChildren().remove((Object)this.avatarViewHeader);
            }
        }
    }

    @Override
    public void onStopPlaying(boolean isShow) {
        this.setPadding(new Insets(13.0, 0.0, 13.0, !isShow ? 0.0 : 20.0));
    }

    public long getMessageTime() {
        if (this.messageInfo == null) {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "messageInfo is null");
            return 0L;
        }
        return this.messageInfo.getTime();
    }

    @Override
    public int compareTo(ChatCellPane chatCellPane) {
        return (int)(chatCellPane.getMessageTime() - this.getMessageTime());
    }

    public void dispose() {
        if (this.linkHBoxViewHolder != null) {
            this.linkHBoxViewHolder.dispose();
        }
        if (this.imageHBoxViewerHolder != null) {
            this.imageHBoxViewerHolder.dispose();
        }
    }

    public void setLinkMap(int linkIndex, Map<String, Object> lMessages) {
        if (this.linkHBoxViewHolder != null) {
            this.linkHBoxViewHolder.setLinkMap(linkIndex, lMessages);
        }
    }

    @Override
    public void invalidate(double height) {
        this.cellPane.setPrefHeight(this.headerViewHolder.getPrefHeight() + height + (this.fx_CellReplayPane != null ? this.fx_CellReplayPane.getPrefHeight() + 10.0 : 0.0));
        super.applyCss();
        super.layoutChildren();
    }

    @Override
    public int getRepliedMessagePaneHeight() {
        return this.fx_CellReplayPane != null ? (int)this.fx_CellReplayPane.getPrefHeight() : 0;
    }

    public void update(MessageInfo messageInfo) {
        this.messageInfo = messageInfo;
        SessionInfo sessionInfo = this.iChatListCell.getSessionInfo();
        boolean isComment = sessionInfo.getDialogType() == 3 && (messageInfo.getCode() == 1024 || !MentionLinkedText.getMentions(messageInfo.getContent()).isEmpty() || (messageInfo.getCode() & 0x400) != 0);
        this.headerViewHolder.update(messageInfo);
        Pane pane = (Pane)this.fx_MainPane.getChildren().get(this.fx_MainPane.getChildren().size() - 1);
        if (pane instanceof TextInfoViewerHolder) {
            TextInfoViewerHolder holder = (TextInfoViewerHolder)pane;
            holder.update(messageInfo, isComment, this.iChatListCell.isSimpleViewMode() ? 230 : 400);
        }
    }

    public static enum MessagePaneType {
        MEETING_MESSAGE,
        CALL_MESSAGE,
        LOST_CALL_MESSAGE,
        MEDIA_MESSAGE,
        IMAGE_MESSAGE,
        FILE_MESSAGE,
        LINK_MESSAGE,
        TEXT_MESSAGE;

    }
}

