/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.chat.holders.viewerholders;

import java.util.HashMap;
import java.util.Iterator;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.viewers.imageview.MyImageView;
import net.sipsnet.client.utils.viewers.label.MyLabel;
import net.sipsnet.client.views.chat.cell.IInvalidateListener;
import net.sipsnet.client.views.chat.holders.viewerholders.TextInfoViewerHolder;
import net.sipsnet.client.views.chat.messageutil.MessageInfoCellLabels;
import smile.cti.client.ContactInfo;
import smile.cti.client.MessageInfo;
import smile.cti.client.SessionInfo;

public class ChannelMessageViewerHolder
extends VBox {
    private final MessageInfo messageInfo;
    private final TextInfoViewerHolder textInfoViewerHolder;
    private MyLabel viewLabel;
    private HBox replyBox;
    private HBox bottomBox;
    private IInvalidateListener iInvalidateListener;

    public ChannelMessageViewerHolder(IInvalidateListener iInvalidateListener, MessageInfo messageInfo, int width) {
        this.messageInfo = messageInfo;
        this.textInfoViewerHolder = new TextInfoViewerHolder(messageInfo, width, false);
        this.getChildren().add((Object)this.textInfoViewerHolder);
        this.addAttributeMessage();
        width = (int)Math.max((double)width, this.textInfoViewerHolder.getMaxWidth() + 25.0);
        this.setMaxWidth(width);
        this.setMinWidth(width);
        this.setPrefWidth(width);
        this.setStyle(MessageInfoCellLabels.getCellBackground(messageInfo, false));
        this.setPrefHeight(this.textInfoViewerHolder.getPrefHeight() + 64.0);
    }

    private void addAttributeMessage() {
        boolean isAttributeTask;
        this.bottomBox = new HBox();
        this.bottomBox.prefWidthProperty().bind((ObservableValue)this.widthProperty().subtract(20));
        this.bottomBox.setStyle("   -fx-border-color: #f1f2f5;    -fx-border-width: 1 0 0 0;");
        this.viewLabel = new MyLabel();
        this.viewLabel.setPrefHeight(32.0);
        this.viewLabel.setLabelFontColor("#252B40");
        this.viewLabel.setLabelFontSize(11);
        this.viewLabel.setLabelFontFamily("HelveticaNeue");
        HBox.setMargin((Node)this.viewLabel, (Insets)new Insets(0.0, 18.0, 0.0, 18.0));
        HBox.setHgrow((Node)this.viewLabel, (Priority)Priority.ALWAYS);
        this.bottomBox.getChildren().add((Object)this.viewLabel);
        this.getChildren().add((Object)this.bottomBox);
        boolean bl = isAttributeTask = (this.messageInfo.getCode() & 0x20) != 0 && (this.messageInfo.getCode() & 0x10) == 0;
        if (isAttributeTask) {
            this.addReplyBox();
        }
        this.setRecipientMessage();
    }

    private void addReplyBox() {
        this.replyBox = new HBox();
        this.replyBox.setAlignment(Pos.CENTER_RIGHT);
        MyImageView replayImageView = MyImageView.getInstance("chat/messagecell/groupsms_reply.png", 12, 10);
        this.replyBox.getChildren().add((Object)replayImageView);
        MyLabel replyLabel = new MyLabel();
        replyLabel.setPrefHeight(32.0);
        replyLabel.setLabelFontColor("#252B40");
        replyLabel.setLabelFontSize(11);
        replyLabel.setLabelFontFamily("HelveticaNeue");
        replyLabel.setText(ClientSingleton.getInstance().getString("reply"));
        HBox.setMargin((Node)replyLabel, (Insets)new Insets(0.0, 20.0, 0.0, 10.0));
        this.replyBox.getChildren().add((Object)replyLabel);
        this.bottomBox.getChildren().add((Object)this.replyBox);
        ClientSingleton.getInstance().setMouseCursor((Node)this.replyBox);
        ClientSingleton.getInstance().setMouseCursor((Node)replayImageView);
        ClientSingleton.getInstance().setMouseCursor((Node)replyLabel);
        EventHandler mouseEvent = event -> ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            try {
                SessionInfo sessionInfo = clientConnector.acceptChatRequest(this.messageInfo);
                if (sessionInfo != null) {
                    ClientSingleton.getInstance().addSessionListener(sessionInfo);
                    HashMap<String, Object> data = new HashMap<String, Object>();
                    data.put("sessionInfo", sessionInfo);
                    ClientSingleton.getInstance().doNotify(Constants.OPEN_SESSION, data);
                    ClientSingleton.getInstance().doNotify(Constants.UPDATE_SESSIONS_LIST);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        this.replyBox.addEventHandler(MouseEvent.MOUSE_PRESSED, mouseEvent);
        replayImageView.addEventHandler(MouseEvent.MOUSE_PRESSED, mouseEvent);
        replyLabel.addEventHandler(MouseEvent.MOUSE_PRESSED, mouseEvent);
    }

    private void setRecipientMessage() {
        Iterator itr;
        StringBuilder message = new StringBuilder();
        boolean isAttributeTask = (this.messageInfo.getCode() & 0x20) != 0 && (this.messageInfo.getCode() & 0x10) == 0;
        String mess = isAttributeTask ? ClientSingleton.getInstance().getString("no_reply") : ClientSingleton.getInstance().getString("replied_by");
        message.append(mess);
        if (!isAttributeTask && this.messageInfo.getRecepients() != null && (itr = this.messageInfo.getRecepients().iterator()).hasNext()) {
            try {
                Object object = itr.next();
                ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                    ContactInfo contactInfo = clientConnector.getContact(object.toString());
                    if (contactInfo != null) {
                        message.append(" ").append(contactInfo);
                    }
                });
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        if (this.viewLabel != null) {
            this.viewLabel.setText(message.toString());
        }
    }

    public void updateView() {
        boolean isAttributeTask;
        boolean bl = isAttributeTask = (this.messageInfo.getCode() & 0x20) != 0 && (this.messageInfo.getCode() & 0x10) == 0;
        if (isAttributeTask) {
            if (this.replyBox == null || !this.bottomBox.getChildren().contains((Object)this.replyBox)) {
                if (this.replyBox == null) {
                    this.addReplyBox();
                } else {
                    this.bottomBox.getChildren().add((Object)this.replyBox);
                }
            }
        } else {
            this.bottomBox.getChildren().remove((Object)this.replyBox);
        }
        this.setRecipientMessage();
        this.setStyle(MessageInfoCellLabels.getCellBackground(this.messageInfo, false));
    }
}

