/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.chat.holders.viewerholders;

import java.io.File;
import javafx.animation.AnimationTimer;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.viewers.IActionOnRelease;
import net.sipsnet.client.utils.viewers.imageview.MyImageView;
import net.sipsnet.client.utils.viewers.label.MyLabel;
import smile.cti.client.EmailInfo;
import smile.cti.client.FileInfo;
import smile.cti.client.FileTransferListener;
import smile.cti.client.MessageInfo;

public class EmailViewHolder
extends VBox
implements IActionOnRelease,
FileTransferListener {
    private MyImageView imageView;
    private final HBox imagePane = new HBox();
    private ProgressIndicator progressIndicator;
    private Label tvEmailSubject;
    private Label fx_From;
    private double loadPercent;
    private MessageInfo messageInfo;
    private final AnimationTimer programButtonAnimation = new AnimationTimer(){
        private long lastUpdate = 0L;

        public void handle(long now) {
            if (now - this.lastUpdate >= 50000000L) {
                EmailViewHolder.this.progressIndicator.setProgress(EmailViewHolder.this.loadPercent);
                this.lastUpdate = now;
            }
        }
    };

    public EmailViewHolder(MessageInfo messageInfo) {
        this.create();
        this.bind(messageInfo);
    }

    private void bind(MessageInfo messageInfo) {
        this.messageInfo = messageInfo;
        EmailInfo emailInfo = (EmailInfo)messageInfo;
        if (emailInfo.getSubject() != null && emailInfo.getSubject().length() > 0 && !"null".equals(emailInfo.getSubject())) {
            this.tvEmailSubject.setText(emailInfo.getSubject());
        } else if (emailInfo.getText() != null) {
            this.tvEmailSubject.setText(emailInfo.getText());
        } else {
            this.tvEmailSubject.setText("");
        }
        this.fx_From.setText(emailInfo.getFrom());
    }

    private void create() {
        this.progressIndicator = ClientSingleton.getInstance().getProgressIndicator();
        this.progressIndicator.setMaxWidth(20.0);
        this.progressIndicator.setMaxHeight(20.0);
        this.setAlignment(Pos.CENTER);
        this.setMinWidth(300.0);
        HBox hBox = new HBox();
        hBox.setAlignment(Pos.CENTER_LEFT);
        VBox.setVgrow((Node)hBox, (Priority)Priority.ALWAYS);
        this.tvEmailSubject = new Label();
        Theme.getInstance().applyTo(Constants.CHAT_MESSAGE_TEXT_FILL, (Labeled)this.tvEmailSubject);
        HBox.setHgrow((Node)hBox, (Priority)Priority.ALWAYS);
        HBox.setMargin((Node)this.tvEmailSubject, (Insets)new Insets(10.0, 0.0, 0.0, 0.0));
        hBox.getChildren().add((Object)this.tvEmailSubject);
        this.fx_From = new Label();
        HBox.setMargin((Node)this.fx_From, (Insets)new Insets(5.0, 0.0, 0.0, 0.0));
        HBox bBox = new HBox();
        this.imageView = new MyImageView(20, 20);
        this.imageView.setImage("chat/e_mail.png");
        this.imagePane.setAlignment(Pos.CENTER);
        this.imagePane.getChildren().add((Object)this.imageView);
        HBox.setMargin((Node)this.imagePane, (Insets)new Insets(0.0, 5.0, 0.0, 0.0));
        bBox.getChildren().add((Object)this.imagePane);
        bBox.setAlignment(Pos.CENTER_LEFT);
        bBox.getChildren().add((Object)this.fx_From);
        HBox.setHgrow((Node)bBox, (Priority)Priority.ALWAYS);
        HBox.setMargin((Node)this, (Insets)new Insets(16.0, 0.0, 0.0, 16.0));
        Theme.getInstance().applyTo(Constants.CHAT_MESSAGE_TEXT_FILL, (Labeled)this.fx_From);
        this.setPadding(new Insets(9.0, 5.0, 9.0, 16.0));
        this.getChildren().add((Object)bBox);
        this.getChildren().add((Object)hBox);
        HBox actionBox = this.getActionPane();
        VBox.setMargin((Node)actionBox, (Insets)new Insets(10.0, 0.0, 0.0, 0.0));
        actionBox.prefWidthProperty().bind((ObservableValue)this.widthProperty().subtract(10));
        this.getChildren().add((Object)actionBox);
    }

    private HBox getActionPane() {
        HBox hBox = new HBox();
        hBox.setStyle("   -fx-border-color: #f1f2f5;    -fx-border-width: 1 0 0 0;");
        MyLabel viewLabel = new MyLabel();
        viewLabel.setText("e_mail_view");
        viewLabel.setPrefHeight(40.0);
        viewLabel.setIsUnderline(true);
        viewLabel.setLabelFontColor("#656a7c");
        viewLabel.setLabelFontSize(11);
        viewLabel.setLabelFontFamily("HelveticaNeue");
        ClientSingleton.getInstance().setMouseCursor((Node)viewLabel);
        viewLabel.addEventHandler(MouseEvent.MOUSE_PRESSED, event -> {
            EmailInfo emailInfo = (EmailInfo)this.messageInfo;
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                if (!emailInfo.isLoaded()) {
                    ((EmailInfo)this.messageInfo).addTransfrerListener((FileTransferListener)this);
                    clientConnector.loadFile((FileInfo)emailInfo);
                } else {
                    this.openFile((FileInfo)emailInfo);
                }
            });
        });
        HBox.setMargin((Node)viewLabel, (Insets)new Insets(0.0, 20.0, 0.0, 0.0));
        hBox.getChildren().add((Object)viewLabel);
        return hBox;
    }

    private void assignEmail() {
        this.openFile((FileInfo)this.messageInfo);
    }

    @Override
    public void onRelease() {
    }

    public void transferStarted(FileInfo fileInfo) {
        this.programButtonAnimation.start();
        this.progressIndicator.setProgress(0.0);
        Platform.runLater(() -> {
            this.imagePane.getChildren().remove((Object)this.imageView);
            this.imagePane.getChildren().add((Object)this.progressIndicator);
        });
    }

    public void transferProgress(FileInfo fileInfo) {
        this.loadPercent = fileInfo.getLoadingPercent();
    }

    public void transferEnded(FileInfo fileInfo) {
        this.programButtonAnimation.stop();
        Platform.runLater(() -> {
            this.imagePane.getChildren().remove((Object)this.progressIndicator);
            this.imagePane.getChildren().add((Object)this.imageView);
        });
        this.loadPercent = 0.0;
        fileInfo.removeTransfrerListener((FileTransferListener)this);
        this.openFile(fileInfo);
    }

    private void openFile(FileInfo fileInfo) {
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            if (this.messageInfo.getStatus() == 1 && this.messageInfo.getCode() != 32) {
                ClientSingleton.getInstance().getSessionInfo(this.messageInfo.getSessionId()).ifPresent(sessionInfo -> clientConnector.mailRead((EmailInfo)this.messageInfo, sessionInfo));
            }
            File file = null;
            try {
                file = clientConnector.getFile(fileInfo);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (file == null || !file.exists()) {
                return;
            }
            ClientSingleton.getInstance().openFile(file);
        });
    }
}

