/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.chat.holders.viewerholders;

import io.reactivex.Observable;
import io.reactivex.Scheduler;
import io.reactivex.rxjavafx.schedulers.JavaFxScheduler;
import io.reactivex.schedulers.Schedulers;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Optional;
import javafx.animation.AnimationTimer;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.stage.FileChooser;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.utils.viewers.IActionOnRelease;
import net.sipsnet.client.utils.viewers.RichTextViwer.MyTextArea;
import net.sipsnet.client.utils.viewers.contextmenu.MyContextMenu;
import net.sipsnet.client.views.chat.messageutil.MessageInfoCellLabels;
import smile.cti.client.FileInfo;
import smile.cti.client.FileTransferListener;
import smile.cti.client.MessageInfo;

public class FileInfoViewerHolder
extends HBox
implements FileTransferListener,
IActionOnRelease {
    private ProgressIndicator progressIndicator;
    private final StackPane stackPane;
    private ImageView myImageView;
    private boolean isBinded = false;
    private FileInfo fileInfo;
    private final boolean isOutgoing;
    private MyContextMenu myContextMenu;
    private boolean isOpenFile;
    private final int width;
    private boolean isComment = false;
    private final EventHandler<? super MouseEvent> eventHandler = event -> {
        event.consume();
        if (event.isSecondaryButtonDown()) {
            if (this.myContextMenu == null) {
                this.createFileMenu();
            }
            this.myContextMenu.show((Node)event.getSource());
        } else {
            this.isOpenFile = true;
            this.showSaveFile();
        }
    };
    private float loadPercent = 0.0f;
    private final AnimationTimer programButtonAnimation = new AnimationTimer(){
        private long lastUpdate = 0L;

        public void handle(long now) {
            if (now - this.lastUpdate >= 50000000L) {
                if (FileInfoViewerHolder.this.progressIndicator == null) {
                    FileInfoViewerHolder.this.createIndicator();
                }
                FileInfoViewerHolder.this.progressIndicator.setProgress((double)FileInfoViewerHolder.this.loadPercent);
                this.lastUpdate = now;
            }
        }
    };

    public FileInfoViewerHolder(MessageInfo messageInfo, int width, boolean isComment) {
        this.createIndicator();
        this.isComment = isComment;
        this.width = width;
        this.setMaxWidth(width);
        this.setMinWidth(width);
        this.setPrefWidth(width);
        this.setAlignment(Pos.CENTER_LEFT);
        this.isOutgoing = MessageInfoCellLabels.isISendTheMessage(messageInfo);
        this.stackPane = new StackPane();
        this.stackPane.setMinHeight(40.0);
        this.stackPane.setMinWidth(40.0);
        this.stackPane.setPrefHeight(40.0);
        this.stackPane.setAlignment(Pos.CENTER);
        this.getChildren().add((Object)this.stackPane);
        HBox.setMargin((Node)this.stackPane, (Insets)new Insets(16.0, 10.0, 10.0, 16.0));
        this.fileInfo = (FileInfo)messageInfo;
        String style = MessageInfoCellLabels.getCellBackground(messageInfo, false, isComment);
        this.setStyle(style);
        this.setPrefHeight(50.0);
    }

    private void showSaveFile() {
        if (this.fileInfo.isLoaded() && this.fileInfo.exists()) {
            if (this.isOpenFile) {
                File file = new File(this.fileInfo.getFilePath());
                if (file.exists()) {
                    ClientSingleton.getInstance().openFile(file);
                } else {
                    this.loadFile();
                }
            } else {
                this.saveFile();
            }
        } else {
            this.loadFile();
        }
    }

    private void loadFile() {
        this.stackPane.getChildren().remove((Object)this.myImageView);
        if (!this.stackPane.getChildren().contains((Object)this.progressIndicator)) {
            this.stackPane.getChildren().add((Object)this.progressIndicator);
        }
        this.fileInfo.addTransfrerListener((FileTransferListener)this);
        ClientSingleton.getInstance().getClientConnector().get().loadFile(this.fileInfo);
    }

    private void createIndicator() {
        this.progressIndicator = new ProgressIndicator(0.0);
        this.progressIndicator.setMaxWidth(40.0);
        this.progressIndicator.setMaxHeight(40.0);
        this.progressIndicator.progressProperty().addListener((observable, oldValue, newValue) -> {
            Text text = (Text)this.progressIndicator.lookup(".percentage");
            if (text != null) {
                text.setText("");
                text.setFont(new Font("Area", 0.0));
                this.progressIndicator.setPrefWidth(text.getLayoutBounds().getWidth());
            }
        });
    }

    private void getFileIcon() {
        Observable.just((Object)true).observeOn(Schedulers.computation()).doOnError(Throwable::printStackTrace).flatMap(bol -> {
            Object fileExtIcon;
            String suffix;
            String fileName = this.fileInfo.getFileName();
            String string = suffix = fileName.contains(".") ? fileName.substring(fileName.lastIndexOf(".") + 1) : "";
            if (!suffix.isEmpty() && ClientSingleton.getInstance().isHasFileIcon(suffix + ".png")) {
                suffix = "xlsx".equals(suffix) ? "xls" : suffix;
                fileExtIcon = "filesicons/" + suffix + ".png";
            } else {
                fileExtIcon = "filesicons/unknown.png";
            }
            Optional<Image> optionalImage = ClientSingleton.getInstance().getImageFromResources((String)fileExtIcon);
            if (optionalImage.isEmpty()) {
                return Observable.empty();
            }
            return Observable.just((Object)optionalImage.get());
        }).observeOn((Scheduler)JavaFxScheduler.platform()).subscribe(image -> {
            this.myImageView = new ImageView();
            this.myImageView.setFitWidth(30.0);
            this.myImageView.setFitHeight(30.0);
            ClientSingleton.getInstance().setMouseCursor((Node)this.myImageView);
            this.myImageView.addEventHandler(MouseEvent.MOUSE_PRESSED, this.eventHandler);
            this.myImageView.setImage(image);
            this.stackPane.getChildren().add((Object)this.myImageView);
        });
    }

    public void transferStarted(FileInfo fileInfo) {
        this.programButtonAnimation.start();
    }

    public void transferProgress(FileInfo fileInfo) {
        this.loadPercent = fileInfo.getLoadingPercent();
        if (this.loadPercent > 1.0f) {
            this.loadPercent -= 1.0f;
        }
    }

    public void transferEnded(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
        fileInfo.removeTransfrerListener((FileTransferListener)this);
        this.programButtonAnimation.stop();
        ClientSingleton.getInstance().runLater(() -> {
            if (this.progressIndicator != null) {
                this.progressIndicator.setProgress(1.0);
                this.stackPane.getChildren().remove((Object)this.progressIndicator);
            }
            if (!this.stackPane.getChildren().contains((Object)this.myImageView)) {
                this.stackPane.getChildren().add((Object)this.myImageView);
            }
            if (!this.isOpenFile) {
                this.saveFile();
            }
        });
        if (this.isOpenFile) {
            try {
                File file = new File(fileInfo.getFilePath());
                ClientSingleton.getInstance().openFile(file);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        this.loadPercent = 0.0f;
    }

    @Override
    public void onRelease() {
        this.progressIndicator = null;
        this.fileInfo = null;
    }

    public void bind() {
        AnchorPane anchorPane = this.getTextPane();
        anchorPane.prefWidthProperty().bind((ObservableValue)this.prefWidthProperty().subtract(55));
        this.getChildren().add((Object)anchorPane);
        if (!this.isBinded) {
            this.isBinded = true;
            this.getFileIcon();
        }
    }

    private AnchorPane getTextPane() {
        AnchorPane hBox = new AnchorPane();
        MyTextArea myTextArea = new MyTextArea((MessageInfo)this.fileInfo, (Pane)hBox, "", true, this.eventHandler);
        if (this.isComment) {
            myTextArea.setCommentBackground();
        } else if (!this.isOutgoing) {
            myTextArea.setIncomingBackground();
        } else {
            myTextArea.setOutgoingBackground();
        }
        hBox.getChildren().add((Object)myTextArea);
        AnchorPane.setTopAnchor((Node)myTextArea, (Double)10.0);
        AnchorPane.setLeftAnchor((Node)myTextArea, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)myTextArea, (Double)0.0);
        AnchorPane.setRightAnchor((Node)myTextArea, (Double)0.0);
        return hBox;
    }

    private void createFileMenu() {
        this.myContextMenu = MyContextMenu.getInstance(false, ClientSingleton.getInstance().getParentWindow());
        this.myContextMenu.addMenuItem((Object)ClientSingleton.getInstance().getString("message_menu_open"), (EventHandler<MouseEvent>)((EventHandler)event -> {
            this.isOpenFile = true;
            this.myContextMenu.hide();
            this.showSaveFile();
        }));
        this.myContextMenu.addMenuItem((Object)ClientSingleton.getInstance().getString("message_menu_save"), (EventHandler<MouseEvent>)((EventHandler)event -> {
            this.isOpenFile = false;
            this.myContextMenu.hide();
            this.showSaveFile();
        }));
    }

    private void saveFile() {
        File file = null;
        try {
            file = ClientSingleton.getInstance().getClientConnector().get().getFile(this.fileInfo);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        String name = file.getName();
        int n = name.indexOf("-");
        if (n != -1) {
            name = name.substring(n + 1);
        }
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(ClientSingleton.getInstance().getPackageName());
        fileChooser.setInitialDirectory(new File(System.getProperty("user.home")));
        fileChooser.setInitialFileName(name);
        File selectedFile = fileChooser.showSaveDialog(this.getScene().getWindow());
        if (selectedFile != null) {
            if (selectedFile.exists()) {
                boolean bl = selectedFile.delete();
            }
            try (FileInputStream fis = new FileInputStream(file);
                 FileOutputStream fos = new FileOutputStream(selectedFile);){
                byte[] b = new byte[4096];
                while ((n = fis.read(b)) != -1) {
                    fos.write(b, 0, n);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

