/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.chat.holders.viewerholders;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Modality;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Pair;
import net.sipsnet.client.click2dial.GetSelectedText;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.connector.utils.JsonMessageParser;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.MyUtils;
import net.sipsnet.client.utils.threadpool.MyThreadPoolManager;
import net.sipsnet.client.utils.viewers.IActionOnRelease;
import net.sipsnet.client.utils.viewers.buttoncombobox.MenuImageButton;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButton;
import net.sipsnet.client.utils.viewers.callStateArrow.CallStateArrowPane;
import net.sipsnet.client.utils.viewers.imageview.MyImageView;
import net.sipsnet.client.views.chat.ChatPaneWithFlowListController;
import net.sipsnet.client.views.chat.interfaces.IChatListCell;
import net.sipsnet.client.views.chat.messageutil.MessageInfoCellLabels;
import smile.cti.client.ClientConnector;
import smile.cti.client.ContactInfo;
import smile.cti.client.FileInfo;
import smile.cti.client.FileTransferListener;
import smile.cti.client.MessageInfo;
import smile.cti.client.SessionInfo;

public class HeaderViewHolder
extends HBox
implements IActionOnRelease {
    private final MenuImageButton fx_ivMenu;
    private final Label fx_lbContactName;
    private HBox fx_hbIvReplyContainer;
    private final HBox fx_hbMessageTime;
    private final StackPane fx_hbIvReadContainer;
    private final HBox fx_hbContactName;
    private final HBox fx_hbIvStarContainer;
    private final ImageButton fx_ivStar;
    private final CallStateArrowPane fx_hbIvCallArrowContainer;
    private final MyImageView fx_ivRead;
    public static final int lineHeight = 25;
    private ProgressIndicator progressIndicator;
    private final ProgressIndicator readProgressIndicator;
    private HBox fx_hbUpdateContainer;
    private MessageInfo messageInfo;
    private final Label fx_lbMessageTime;
    private final IChatListCell iChatListCell;

    public HeaderViewHolder(MessageInfo messageInfo, IChatListCell iChatListCell) {
        this.messageInfo = messageInfo;
        this.iChatListCell = iChatListCell;
        this.setMinHeight(25.0);
        this.setMaxHeight(25.0);
        this.setPrefHeight(25.0);
        this.setAlignment(Pos.TOP_LEFT);
        this.fx_hbIvCallArrowContainer = CallStateArrowPane.getInstance();
        this.getChildren().add((Object)this.fx_hbIvCallArrowContainer);
        this.fx_hbContactName = new HBox();
        this.fx_hbContactName.maxHeightProperty().bind((ObservableValue)this.maxHeightProperty());
        this.fx_hbContactName.setAlignment(Pos.CENTER);
        VBox.setVgrow((Node)this.fx_hbContactName, (Priority)Priority.ALWAYS);
        this.fx_lbContactName = new Label("");
        VBox.setVgrow((Node)this.fx_lbContactName, (Priority)Priority.ALWAYS);
        HBox.setMargin((Node)this.fx_lbContactName, (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
        this.fx_hbContactName.getChildren().add((Object)this.fx_lbContactName);
        this.getChildren().add((Object)this.fx_hbContactName);
        this.fx_hbIvReadContainer = new StackPane();
        this.fx_hbIvReadContainer.setAlignment(Pos.CENTER);
        VBox.setVgrow((Node)this.fx_hbIvReadContainer, (Priority)Priority.ALWAYS);
        String imagePath = "chat/messagecell/mes_status_read.png";
        this.fx_ivRead = MyImageView.getInstance(imagePath, 22, 14);
        HBox.setMargin((Node)this.fx_ivRead, (Insets)new Insets(0.0, 10.0, 0.0, 10.0));
        this.fx_hbIvReadContainer.getChildren().add((Object)this.fx_ivRead);
        this.readProgressIndicator = ClientSingleton.getInstance().getProgressIndicator();
        this.readProgressIndicator.setMaxWidth(14.0);
        this.readProgressIndicator.setMaxHeight(14.0);
        this.readProgressIndicator.setMinWidth(14.0);
        this.readProgressIndicator.setMinHeight(14.0);
        this.fx_hbIvReadContainer.maxHeightProperty().bind((ObservableValue)this.maxHeightProperty());
        if (messageInfo.getType() != 23) {
            this.getChildren().add((Object)this.fx_hbIvReadContainer);
        }
        this.fx_hbMessageTime = new HBox();
        this.fx_hbMessageTime.setAlignment(Pos.CENTER);
        VBox.setVgrow((Node)this.fx_hbMessageTime, (Priority)Priority.ALWAYS);
        this.fx_lbMessageTime = new Label("");
        if (Theme.getInstance().isDarkTheme() && MessageInfoCellLabels.isLostCall(messageInfo)) {
            Theme.getInstance().applyTo(Constants.CHAT_CELL_HEADER_TEXT_FILL, (Labeled)this.fx_lbContactName, Theme.RED_EXTRA_COLOR);
            Theme.getInstance().applyTo(Constants.CHAT_CELL_HEADER_TEXT_FILL, (Labeled)this.fx_lbMessageTime, Theme.RED_EXTRA_COLOR);
        } else {
            Theme.getInstance().applyTo(Constants.CHAT_CELL_HEADER_TEXT_FILL, (Labeled)this.fx_lbContactName);
            Theme.getInstance().applyTo(Constants.CHAT_CELL_HEADER_TEXT_FILL, (Labeled)this.fx_lbMessageTime);
        }
        this.fx_lbMessageTime.setAlignment(Pos.CENTER_LEFT);
        HBox.setMargin((Node)this.fx_lbMessageTime, (Insets)new Insets(0.0, 10.0, 0.0, 5.0));
        this.fx_hbMessageTime.getChildren().add((Object)this.fx_lbMessageTime);
        this.fx_hbMessageTime.maxHeightProperty().bind((ObservableValue)this.maxHeightProperty());
        this.getChildren().add((Object)this.fx_hbMessageTime);
        this.fx_hbIvStarContainer = new HBox();
        this.fx_hbIvStarContainer.setAlignment(Pos.CENTER);
        VBox.setVgrow((Node)this.fx_hbIvStarContainer, (Priority)Priority.ALWAYS);
        this.fx_ivStar = new ImageButton();
        this.fx_ivStar.setBackgroundColor("transparent");
        this.fx_ivStar.setSize(14, 14);
        this.fx_ivStar.setIsRounded(true);
        this.fx_ivStar.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.makeStarMessage()));
        HBox.setMargin((Node)this.fx_ivStar, (Insets)new Insets(0.0, 17.0, 0.0, 0.0));
        this.fx_hbIvStarContainer.getChildren().add((Object)this.fx_ivStar);
        this.fx_hbIvStarContainer.maxHeightProperty().bind((ObservableValue)this.maxHeightProperty());
        this.getChildren().add((Object)this.fx_hbIvStarContainer);
        if (iChatListCell.isReplyMode()) {
            this.fx_hbIvReplyContainer = new HBox();
            this.fx_hbIvReplyContainer.setAlignment(Pos.CENTER);
            VBox.setVgrow((Node)this.fx_hbIvReplyContainer, (Priority)Priority.ALWAYS);
            ImageButton fx_ivReply = new ImageButton();
            fx_ivReply.setBackgroundColor("transparent");
            fx_ivReply.setSize(14, 14);
            fx_ivReply.setIsRounded(true);
            fx_ivReply.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> iChatListCell.replayMessage(messageInfo)));
            HBox.setMargin((Node)this.fx_hbIvReplyContainer, (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
            ClientSingleton.getInstance().setImageToImageView(fx_ivReply, "chat/messagecell/dark_reply.png");
            this.fx_hbIvReplyContainer.getChildren().add((Object)fx_ivReply);
        }
        StackPane fx_hbIvMenuContainer = new StackPane();
        fx_hbIvMenuContainer.setAlignment(Pos.CENTER);
        VBox.setVgrow((Node)fx_hbIvMenuContainer, (Priority)Priority.ALWAYS);
        this.fx_ivMenu = new MenuImageButton();
        this.fx_ivMenu.setBackgroundColor("transparent");
        this.fx_ivMenu.setSize(14, 14);
        ClientSingleton.getInstance().setImageToImageView(this.fx_ivMenu, "buttons/dot_menu.png");
        HBox.setMargin((Node)this.fx_ivMenu, (Insets)new Insets(0.0, 17.0, 0.0, 0.0));
        fx_hbIvMenuContainer.getChildren().add((Object)this.fx_ivMenu);
        fx_hbIvMenuContainer.maxHeightProperty().bind((ObservableValue)this.maxHeightProperty());
        this.getChildren().add((Object)fx_hbIvMenuContainer);
        this.bind();
    }

    private boolean isTaskAttribute() {
        return this.iChatListCell.getSessionInfo().isChannel() && (this.messageInfo.getCode() & 0x20) != 0 && (this.messageInfo.getCode() & 0x10) == 0;
    }

    private boolean canSMS() {
        AtomicBoolean isContactCanChat = new AtomicBoolean(false);
        SessionInfo sessionInfo = this.iChatListCell.getSessionInfo();
        if (ClientSingleton.getInstance().isClientsChat(sessionInfo)) {
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> isContactCanChat.set((clientConnector.canSendSMS((ContactInfo)sessionInfo.getParties().get(0)) || sessionInfo.canSMS()) && !clientConnector.getSIPTrunksForSMS().isEmpty()));
        }
        return isContactCanChat.get();
    }

    private void messageUpdated() {
        if (((this.messageInfo.getCode() & 0x200) == 512 || this.messageInfo.getCode() == 512) && this.fx_hbUpdateContainer == null) {
            this.fx_hbUpdateContainer = new HBox();
            this.fx_hbUpdateContainer.setAlignment(Pos.CENTER);
            VBox.setVgrow((Node)this.fx_hbUpdateContainer, (Priority)Priority.ALWAYS);
            MyImageView fx_ivUpdate = MyImageView.getInstance("chat/messagecell/mes_edit.png", 14, 14);
            this.fx_hbUpdateContainer.getChildren().add((Object)fx_ivUpdate);
            this.getChildren().add(0, (Object)this.fx_hbUpdateContainer);
        }
    }

    private void makeStarMessage() {
        int code = (this.messageInfo.getCode() & 1) == 1 ? 0 : 1;
        try {
            ClientSingleton.getInstance().getClientConnector().get().markMessages(this.iChatListCell.getSessionInfo(), List.of(this.messageInfo), code);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.fx_ivStar.setImagePath((this.messageInfo.getCode() & 1) == 1 ? "chat/messagecell/star_yellow.png" : "chat/messagecell/star_grey.png");
    }

    private void makeMenu() {
        this.fx_ivMenu.clear();
        if (ChatPaneWithFlowListController.currentFilter != 0) {
            this.fx_ivMenu.addMenuItemToList(ClientSingleton.getInstance().getString("message_menu_goto"), (EventHandler<MouseEvent>)((EventHandler)event -> {
                this.fx_ivMenu.hideMenu();
                ClientSingleton.toLog(this.getClass().getSimpleName(), "Go to clicked");
                this.iChatListCell.getReplayMessage(this.messageInfo, true);
            }));
        }
        this.fx_ivMenu.setVisible(true);
        SessionInfo sessionInfo = this.iChatListCell.getSessionInfo();
        if (this.messageInfo.getType() == 8) {
            if (sessionInfo != null && !sessionInfo.isGroup()) {
                ContactInfo contactInfo = (ContactInfo)sessionInfo.getParties().get(0);
                if (contactInfo != null && ("".equals(contactInfo.getName()) || ClientSingleton.getInstance().isNotMember(contactInfo))) {
                    this.fx_ivMenu.addMenuItemToList(ClientSingleton.getInstance().getString("call_menu_copy"), (EventHandler<MouseEvent>)((EventHandler)event1 -> {
                        try {
                            GetSelectedText.setClipboardText(contactInfo.getNumber());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        this.fx_ivMenu.hideMenu();
                    }));
                } else {
                    this.fx_ivMenu.setVisible(false);
                }
            } else {
                this.fx_ivMenu.setVisible(false);
            }
        } else if (this.messageInfo.getType() != 5) {
            if (this.messageInfo.getType() == 10 && this.messageInfo.getContent().contains("<") && this.messageInfo.getContent().contains(">")) {
                this.fx_ivMenu.addMenuItemToList(ClientSingleton.getInstance().getString("message_menu_open"), (EventHandler<MouseEvent>)((EventHandler)event -> {
                    this.fx_ivMenu.hideMenu();
                    ClientSingleton.getInstance().openNewContact(this.messageInfo);
                }));
            } else if (this.messageInfo.getType() == 2 || this.messageInfo.getType() == 20 && this.messageInfo.getContent().contains("content")) {
                this.fx_ivMenu.addMenuItemToList(ClientSingleton.getInstance().getString("message_menu_open"), (EventHandler<MouseEvent>)((EventHandler)event -> this.openSaveFile(true)));
                this.fx_ivMenu.addMenuItemToList(ClientSingleton.getInstance().getString("message_menu_save"), (EventHandler<MouseEvent>)((EventHandler)event -> this.openSaveFile(false)));
                this.fx_ivMenu.addMenuItemToList(ClientSingleton.getInstance().getString("message_menu_share"), (EventHandler<MouseEvent>)((EventHandler)event -> ClientSingleton.getInstance().shareMessage(this.messageInfo)));
            } else if (this.messageInfo.getContent().contains("https://www.google.com/maps/search/")) {
                this.fx_ivMenu.addMenuItemToList(ClientSingleton.getInstance().getString("message_menu_copy"), (EventHandler<MouseEvent>)((EventHandler)event -> this.toClipBoard(false)));
                this.fx_ivMenu.addMenuItemToList(ClientSingleton.getInstance().getString("message_menu_on_map"), (EventHandler<MouseEvent>)((EventHandler)event -> this.showOnMap()));
                this.fx_ivMenu.addMenuItemToList(ClientSingleton.getInstance().getString("message_menu_share"), (EventHandler<MouseEvent>)((EventHandler)event -> ClientSingleton.getInstance().shareMessage(this.messageInfo)));
            } else {
                boolean canEdit;
                this.fx_ivMenu.addMenuItemToList(ClientSingleton.getInstance().getString("message_menu_copy"), (EventHandler<MouseEvent>)((EventHandler)event -> this.toClipBoard(false)));
                this.fx_ivMenu.addMenuItemToList(ClientSingleton.getInstance().getString("message_menu_share"), (EventHandler<MouseEvent>)((EventHandler)event -> ClientSingleton.getInstance().shareMessage(this.messageInfo)));
                if (MessageInfoCellLabels.isLink(this.messageInfo)) {
                    this.fx_ivMenu.addMenuItemToList(ClientSingleton.getInstance().getString("message_menu_link"), (EventHandler<MouseEvent>)((EventHandler)event -> this.toClipBoard(true)));
                }
                boolean bl = canEdit = sessionInfo != null && sessionInfo.getStatus() != -3 && sessionInfo.getDialogType() != 3;
                if (canEdit && (this.messageInfo.getStatus() == -1 || this.messageInfo.getStatus() == 0 || this.messageInfo.getStatus() == 4 || this.messageInfo.getStatus() == 3) && System.currentTimeMillis() - this.messageInfo.getTime() < 3600000L) {
                    this.fx_ivMenu.addMenuItemToList(ClientSingleton.getInstance().getString("message_menu_edit"), (EventHandler<MouseEvent>)((EventHandler)event -> this.updateMessageContext()));
                }
            }
        }
        if (this.messageInfo.canBeDeleted()) {
            this.fx_ivMenu.addMenuItemToList(ClientSingleton.getInstance().getString("message_menu_delete"), (EventHandler<MouseEvent>)((EventHandler)event -> this.deleteMessage()), "red");
        }
    }

    private void updateMessageContext() {
        this.hideMenu();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("sessionInfo", this.iChatListCell.getSessionInfo());
        data.put("messageInfo", this.messageInfo);
        ClientSingleton.getInstance().doNotify(Constants.EDIT_MESSAGE, data);
    }

    private void saveFile(FileInfo fileInfo) {
        File file = null;
        try {
            file = ClientSingleton.getInstance().getClientConnector().get().getFile(fileInfo);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        String name = file.getName();
        int n = name.indexOf("-");
        if (n != -1) {
            name = name.substring(n + 1);
        }
        FileChooser fileChooser = new FileChooser();
        fileChooser.setTitle(ClientSingleton.getInstance().getPackageName());
        fileChooser.setInitialDirectory(new File(System.getProperty("user.home")));
        fileChooser.setInitialFileName(name);
        File selectedFile = fileChooser.showSaveDialog(this.getScene().getWindow());
        if (selectedFile != null) {
            if (selectedFile.exists()) {
                boolean bl = selectedFile.delete();
            }
            try (FileInputStream fis = new FileInputStream(file);
                 FileOutputStream fos = new FileOutputStream(selectedFile);){
                byte[] b = new byte[4096];
                while ((n = fis.read(b)) != -1) {
                    fos.write(b, 0, n);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public boolean showAlert(String text) {
        ButtonType buttonTypeSave = new ButtonType(ClientSingleton.getInstance().getString("button_save"), ButtonBar.ButtonData.YES);
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION, text, new ButtonType[]{buttonTypeSave});
        alert.initModality(Modality.WINDOW_MODAL);
        alert.initStyle(StageStyle.UTILITY);
        Optional<Image> image = ClientSingleton.getInstance().getImageFromResources("notify_emblem.png");
        image.ifPresent(img -> {
            Stage stage = (Stage)alert.getDialogPane().getScene().getWindow();
            stage.getIcons().add(img);
        });
        alert.setTitle(ClientSingleton.getInstance().getPackageName());
        alert.showAndWait();
        return ((ButtonType)alert.getResult()).getButtonData() == ButtonBar.ButtonData.YES;
    }

    private void deleteMessage() {
        this.hideMenu();
        MyThreadPoolManager.getInstance().execute(() -> ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            try {
                if (this.messageInfo.canBeDeleted()) {
                    clientConnector.deleteMessage(this.iChatListCell.getSessionInfo(), this.messageInfo);
                } else {
                    clientConnector.removeMessages(this.iChatListCell.getSessionInfo(), List.of(this.messageInfo));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }));
    }

    public void openSaveFile(boolean isOpenFile) {
        this.hideMenu();
        FileInfo fileInfo = (FileInfo)this.messageInfo;
        Optional<ClientConnector> optionalClientConnector = ClientSingleton.getInstance().getClientConnector();
        if (optionalClientConnector.isPresent()) {
            try {
                if (fileInfo.getFilePath() != null && !ClientSingleton.getInstance().isThumbnailImage(fileInfo.getFilePath())) {
                    if (MyUtils.setOriginalFileName(fileInfo)) {
                        this.loadFile(fileInfo, isOpenFile);
                        return;
                    }
                    if (fileInfo.isLoaded()) {
                        if (isOpenFile) {
                            try {
                                File file = optionalClientConnector.get().getFile(fileInfo);
                                ClientSingleton.getInstance().openFile(file);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        } else {
                            this.saveFile(fileInfo);
                        }
                    } else {
                        this.loadFile(fileInfo, isOpenFile);
                    }
                } else {
                    this.loadFile(fileInfo, isOpenFile);
                }
            }
            catch (Exception ex) {
                ClientSingleton.toLog(this.getClass().getSimpleName(), "Error openSaveFile : " + ex.getMessage());
                this.loadFile(fileInfo, isOpenFile);
            }
        }
    }

    private void loadFile(FileInfo fileInfo, boolean isOpenFile) {
        this.progressIndicator = ClientSingleton.getInstance().getProgressIndicator();
        this.progressIndicator.setMaxWidth(14.0);
        this.progressIndicator.setMaxHeight(14.0);
        ClientSingleton.getInstance().addLoadingPane(fileInfo.isImage() ? "Load image ..." : "Load file ...");
        ClientSingleton.toLog(this.getClass().getSimpleName(), "loadFile fileInfo = " + fileInfo + " fileInfo.isLoading()=" + fileInfo.isLoading() + " isLoaded() = " + fileInfo.isLoaded() + " hasFile() = " + fileInfo.hasFile() + " isOpenFile=" + isOpenFile);
        fileInfo.addTransfrerListener((FileTransferListener)new FileLoadListener(isOpenFile));
        ClientSingleton.getInstance().getClientConnector().get().loadFile(fileInfo);
    }

    private void showOnMap() {
        this.hideMenu();
        List<String> list = MyUtils.bindLink(this.messageInfo.getContent());
        for (String url : list) {
            if (!url.contains("https://www.google.com/maps/search/")) continue;
            ClientSingleton.getInstance().openWebBrowser(url);
            break;
        }
    }

    private void toClipBoard(boolean isLink) {
        this.hideMenu();
        ClientSingleton.getInstance().toClipBoard(this.messageInfo, isLink);
    }

    public void hideMenu() {
        this.fx_ivMenu.hideMenu();
    }

    private void bind() {
        AtomicReference<String> name = new AtomicReference<String>(ClientSingleton.getInstance().getString("my_message"));
        if (this.messageInfo.getType() == 8) {
            boolean isLost = MessageInfoCellLabels.isLostCall(this.messageInfo);
            this.fx_hbIvCallArrowContainer.setArrowImageView(this.messageInfo, isLost);
            String from = this.messageInfo.getCallCallerNumber();
            if (isLost) {
                name.set(ClientSingleton.getInstance().getString("call_missed"));
            } else if (from != null) {
                Object label;
                boolean isIncoming = this.messageInfo.getStatus() == 5;
                Object object = label = isIncoming ? ClientSingleton.getInstance().getString("call_incoming") : ClientSingleton.getInstance().getString("call_outgoing");
                if (!"Conference".equals(from)) {
                    label = (String)label + " " + ClientSingleton.getInstance().getString("sms_from") + " " + from;
                }
                name.set((String)label);
            } else if (this.messageInfo.getStatus() == 5) {
                name.set(ClientSingleton.getInstance().getString("call_incoming"));
            } else {
                name.set(ClientSingleton.getInstance().getString("call_outgoing"));
            }
            if (!this.getChildren().contains((Object)this.fx_hbIvCallArrowContainer)) {
                this.getChildren().add((Object)this.fx_hbIvCallArrowContainer);
            }
        } else {
            String from = null;
            if (this.messageInfo.getType() == 20) {
                from = JsonMessageParser.getJsonFrom(this.messageInfo.getContent());
                String number = JsonMessageParser.getJsonNumber(this.messageInfo.getContent());
                name.set((String)(!from.isEmpty() ? from + " \u2794 " : "") + number);
            } else {
                SessionInfo sessionInfo = this.iChatListCell.getSessionInfo();
                if (this.messageInfo.getType() != 5 && sessionInfo != null && sessionInfo.isChannel()) {
                    ClientSingleton.getInstance().getContactInfoByUserId(this.messageInfo.getSenderId()).ifPresent(contactInfo -> name.set(contactInfo.toString().trim()));
                } else {
                    Pair<String, Integer> pair = MessageInfoCellLabels.getSenderName(this.messageInfo);
                    name.set((String)pair.getKey());
                }
            }
            this.getChildren().remove((Object)this.fx_hbIvCallArrowContainer);
        }
        if (this.messageInfo.getCode() == 1024 || (this.messageInfo.getCode() & 0x400) != 0) {
            name.set(name.get() + " (" + ClientSingleton.getInstance().getString("chat_comment_type") + ")");
        }
        this.fx_lbContactName.setText(name.get());
        this.fx_ivStar.setImagePath((this.messageInfo.getCode() & 1) == 1 ? "chat/messagecell/star_yellow.png" : "chat/messagecell/star_grey.png");
        this.makeMenu();
        if (this.messageInfo.getType() != 23) {
            if (this.messageInfo.getType() != 8) {
                if (this.fx_hbIvReplyContainer != null && !this.getChildren().contains((Object)this.fx_hbIvReplyContainer)) {
                    this.getChildren().add(this.getChildren().size() - 1, (Object)this.fx_hbIvReplyContainer);
                }
                if (MessageInfoCellLabels.isISendTheMessage(this.messageInfo)) {
                    if (this.messageInfo.getStatus() != -1) {
                        String imagePath = this.messageInfo.getStatus() == 4 ? "chat/messagecell/mes_status_read.png" : "chat/messagecell/mes_status_new.png";
                        this.fx_ivRead.setImage(imagePath);
                        this.fx_hbIvReadContainer.getChildren().remove((Object)this.readProgressIndicator);
                        this.fx_ivRead.setVisible(true);
                    } else {
                        if (!this.fx_hbIvReadContainer.getChildren().contains((Object)this.readProgressIndicator)) {
                            this.fx_hbIvReadContainer.getChildren().add((Object)this.readProgressIndicator);
                        }
                        this.fx_ivRead.setVisible(false);
                    }
                    if (!this.getChildren().contains((Object)this.fx_hbIvReadContainer)) {
                        this.getChildren().add((Object)this.fx_hbIvReadContainer);
                    }
                } else {
                    this.getChildren().remove((Object)this.fx_hbIvReadContainer);
                }
            } else {
                if (this.fx_hbIvReplyContainer != null) {
                    this.getChildren().remove((Object)this.fx_hbIvReplyContainer);
                }
                this.getChildren().remove((Object)this.fx_hbIvReadContainer);
            }
        }
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            String cur = ClientSingleton.getInstance().getDateTimeString(this.messageInfo.getTime());
            this.fx_lbMessageTime.setText(cur);
        });
    }

    public void update() {
        this.fx_ivStar.setImagePath((this.messageInfo.getCode() & 1) == 1 ? "chat/messagecell/star_yellow.png" : "chat/messagecell/star_grey.png");
        if (this.messageInfo.getType() != 8 && MessageInfoCellLabels.isISendTheMessage(this.messageInfo)) {
            if (this.messageInfo.getStatus() != -1) {
                String imagePath = this.messageInfo.getStatus() == 4 ? "chat/messagecell/mes_status_read.png" : "chat/messagecell/mes_status_new.png";
                this.fx_ivRead.setImage(imagePath);
                this.fx_hbIvReadContainer.getChildren().remove((Object)this.readProgressIndicator);
                this.fx_ivRead.setVisible(true);
            } else if (this.messageInfo.getStatus() == -3) {
                String imagePath = "chat/messagecell/mes_error.png";
                this.fx_ivRead.setImage(imagePath);
                this.fx_hbIvReadContainer.getChildren().remove((Object)this.readProgressIndicator);
                this.fx_ivRead.setVisible(true);
            } else {
                if (!this.fx_hbIvReadContainer.getChildren().contains((Object)this.readProgressIndicator)) {
                    this.fx_hbIvReadContainer.getChildren().add((Object)this.readProgressIndicator);
                }
                this.fx_ivRead.setVisible(false);
            }
        }
        this.messageUpdated();
    }

    public void update(MessageInfo messageInfo) {
        if (!messageInfo.getId().equals(this.messageInfo.getId())) {
            this.messageInfo = messageInfo;
            this.bind();
        }
    }

    @Override
    public void onRelease() {
    }

    class FileLoadListener
    implements FileTransferListener {
        private final boolean isOpenFile;

        public FileLoadListener(boolean isOpenFile) {
            this.isOpenFile = isOpenFile;
        }

        public void transferStarted(FileInfo fileInfo) {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "transferStarted fileInfo = " + fileInfo);
            ClientSingleton.getInstance().runLater(() -> HeaderViewHolder.this.fx_hbIvStarContainer.getChildren().add((Object)HeaderViewHolder.this.progressIndicator));
        }

        public void transferProgress(FileInfo fileInfo) {
        }

        public void transferEnded(FileInfo fileInfo) {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "transferEnded fileInfo = " + fileInfo + " fileInfo.isLoading()=" + fileInfo.isLoading() + " isLoaded() = " + fileInfo.isLoaded() + " hasFile() = " + fileInfo.hasFile());
            fileInfo.removeTransfrerListener((FileTransferListener)this);
            ClientSingleton.getInstance().runLater(() -> {
                HeaderViewHolder.this.fx_hbIvStarContainer.getChildren().remove((Object)HeaderViewHolder.this.progressIndicator);
                ClientSingleton.getInstance().removeLoadingPane();
            });
            Optional<ClientConnector> optionalClientConnector = ClientSingleton.getInstance().getClientConnector();
            if (optionalClientConnector.isPresent() && fileInfo.isLoaded()) {
                try {
                    if (this.isOpenFile) {
                        File file = optionalClientConnector.get().getFile(fileInfo);
                        ClientSingleton.getInstance().openFile(file);
                    } else {
                        ClientSingleton.getInstance().runLater(() -> HeaderViewHolder.this.saveFile(fileInfo));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

