/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.chat.holders.viewerholders;

import java.io.File;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.text.Font;
import javafx.scene.text.Text;
import javafx.util.Duration;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.audioplayer.IAudioPlayer;
import net.sipsnet.client.utils.audioplayer.MyMediaPlayer;
import net.sipsnet.client.utils.viewers.IActionOnRelease;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButton;
import net.sipsnet.client.utils.viewers.slider.MySlider;
import net.sipsnet.client.views.chat.messageutil.MessageInfoCellLabels;
import smile.cti.client.ClientConnector;
import smile.cti.client.FileInfo;
import smile.cti.client.FileTransferListener;
import smile.cti.client.MessageInfo;

public class MediaMessageViewerHolder
extends HBox
implements FileTransferListener,
IAudioPlayer,
IActionOnRelease {
    private VBox audioMessage;
    private final Label fx_lbPlayingTime;
    private final Label fx_lbTotalPlayingTime;
    private ProgressIndicator progressIndicator;
    private final StackPane fx_spPlaying;
    private final ImageButton fx_ivPlaying;
    private MyMediaPlayer myMediaPlayer;
    private FileInfo fileInfo;
    private Timer timer;
    private MediaPlayer mediaPlayer;
    private final TimerTask loadingTimerTask = new TimerTask(){

        @Override
        public void run() {
            if (MediaMessageViewerHolder.this.fileInfo != null && MediaMessageViewerHolder.this.fileInfo.isLoading()) {
                ClientSingleton.getInstance().runLater(() -> {
                    MediaMessageViewerHolder.this.fx_spPlaying.getChildren().remove((Object)MediaMessageViewerHolder.this.fx_ivPlaying);
                    if (!MediaMessageViewerHolder.this.fx_spPlaying.getChildren().contains((Object)MediaMessageViewerHolder.this.progressIndicator)) {
                        MediaMessageViewerHolder.this.fx_spPlaying.getChildren().add((Object)MediaMessageViewerHolder.this.progressIndicator);
                    }
                    MediaMessageViewerHolder.this.progressIndicator.setProgress((double)MediaMessageViewerHolder.this.fileInfo.getLoadingPercent());
                });
            } else {
                this.cancel();
                MediaMessageViewerHolder.this.timer.cancel();
                MediaMessageViewerHolder.this.timer.purge();
                MediaMessageViewerHolder.this.timer = null;
                MediaMessageViewerHolder.this.showDuration();
            }
        }
    };
    private final boolean isComment;

    public MediaMessageViewerHolder(MessageInfo messageInfo, int width, boolean isComment) {
        this.setPrefWidth(width);
        this.setAlignment(Pos.CENTER_LEFT);
        this.isComment = isComment;
        this.fx_spPlaying = new StackPane();
        HBox.setMargin((Node)this.fx_spPlaying, (Insets)new Insets(10.0, 10.0, 10.0, 10.0));
        this.getChildren().add((Object)this.fx_spPlaying);
        this.fx_spPlaying.setPrefWidth(32.0);
        this.fx_spPlaying.setPrefHeight(32.0);
        this.fx_ivPlaying = new ImageButton();
        this.fx_ivPlaying.setSize(32, 32);
        this.fx_ivPlaying.setClickImages(new String[]{"chat/messagecell/play_recording.png", "chat/messagecell/pause_recording.png"});
        this.fx_ivPlaying.setIsRounded(true);
        HBox.setMargin((Node)this.fx_ivPlaying, (Insets)new Insets(10.0, 10.0, 10.0, 10.0));
        this.fx_spPlaying.getChildren().add((Object)this.fx_ivPlaying);
        this.fx_lbPlayingTime = new Label("00:00");
        this.fx_lbPlayingTime.setMinWidth(40.0);
        Theme.getInstance().applyTo(Constants.CHAT_MESSAGE_TEXT_FILL, (Labeled)this.fx_lbPlayingTime);
        HBox.setMargin((Node)this.fx_lbPlayingTime, (Insets)new Insets(0.0, 6.0, 0.0, 5.0));
        this.getChildren().add((Object)this.fx_lbPlayingTime);
        MySlider fx_Slider = new MySlider();
        HBox.setHgrow((Node)fx_Slider, (Priority)Priority.ALWAYS);
        VBox.setVgrow((Node)fx_Slider, (Priority)Priority.ALWAYS);
        this.getChildren().add((Object)fx_Slider);
        this.fx_lbTotalPlayingTime = new Label("00:00");
        this.fx_lbTotalPlayingTime.setMinWidth(40.0);
        Theme.getInstance().applyTo(Constants.CHAT_MESSAGE_TEXT_FILL, (Labeled)this.fx_lbTotalPlayingTime);
        HBox.setMargin((Node)this.fx_lbTotalPlayingTime, (Insets)new Insets(0.0, 6.0, 0.0, 5.0));
        this.getChildren().add((Object)this.fx_lbTotalPlayingTime);
        this.fx_ivPlaying.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.onPlayAction()));
        this.progressIndicator = new ProgressIndicator(0.0);
        this.progressIndicator.setMaxWidth(32.0);
        this.progressIndicator.setMaxHeight(32.0);
        this.progressIndicator.setPadding(new Insets(0.0, 0.0, -16.0, 0.0));
        this.progressIndicator.progressProperty().addListener((observable, oldValue, newValue) -> {
            Text text = (Text)this.progressIndicator.lookup(".percentage");
            if (text != null) {
                text.setText("");
                text.setFont(new Font("Area", 0.0));
                this.progressIndicator.setPrefWidth(text.getLayoutBounds().getWidth());
            }
        });
        if (this.myMediaPlayer == null) {
            this.myMediaPlayer = new MyMediaPlayer(fx_Slider, this.fx_lbTotalPlayingTime, this);
        }
        this.bind(messageInfo);
        this.setPrefHeight(32.0);
    }

    private void onPlayAction() {
        if (!this.myMediaPlayer.isMediaPlayerCreated()) {
            Optional<ClientConnector> optionalClientConnector = ClientSingleton.getInstance().getClientConnector();
            File file = null;
            try {
                file = optionalClientConnector.get().getFile(this.fileInfo);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            if (file != null && file.exists()) {
                this.myMediaPlayer.setFile(file);
                this.myMediaPlayer.startPlayback();
            } else {
                this.fileInfo.addTransfrerListener((FileTransferListener)this);
                optionalClientConnector.get().loadFile(this.fileInfo);
            }
        } else if (!this.myMediaPlayer.isPlaying()) {
            this.myMediaPlayer.startPlayback();
        } else {
            this.myMediaPlayer.pausePlayback();
        }
    }

    public void transferStarted(FileInfo fileInfo) {
        ClientSingleton.getInstance().runLater(() -> this.fx_spPlaying.getChildren().add((Object)this.progressIndicator));
    }

    public void transferProgress(FileInfo fileInfo) {
        ClientSingleton.getInstance().runLater(() -> {
            double loadingPercent = fileInfo.getLoadingPercent();
            if (loadingPercent > 1.0) {
                loadingPercent -= 1.0;
            }
            this.progressIndicator.setProgress(loadingPercent);
        });
    }

    public void transferEnded(FileInfo fileInfo) {
        this.fileInfo = fileInfo;
        fileInfo.removeTransfrerListener((FileTransferListener)this);
        try {
            this.showDuration();
            Optional<ClientConnector> optionalClientConnector = ClientSingleton.getInstance().getClientConnector();
            if (optionalClientConnector.isPresent()) {
                File file = optionalClientConnector.get().getFile(fileInfo);
                if (file != null) {
                    this.myMediaPlayer.setFile(file);
                    this.myMediaPlayer.startPlayback();
                } else {
                    ClientSingleton.getInstance().showAlert(ClientSingleton.getInstance().getString("call_record_not_found"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void showDuration() {
        ClientSingleton.getInstance().runLater(() -> {
            this.fx_spPlaying.getChildren().remove((Object)this.progressIndicator);
            if (!this.fx_spPlaying.getChildren().contains((Object)this.fx_ivPlaying)) {
                this.fx_spPlaying.getChildren().add((Object)this.fx_ivPlaying);
            }
        });
    }

    @Override
    public void onStartPlayback() {
    }

    @Override
    public void onStopPlayback() {
    }

    @Override
    public void onEndPlayback() {
        ClientSingleton.getInstance().runLater(this.fx_ivPlaying::setSelectedImage);
    }

    @Override
    public void setTimeValue(long time) {
        ClientSingleton.getInstance().runLater(() -> this.fx_lbPlayingTime.setText(ClientSingleton.getInstance().getTimeDuration(time)));
    }

    @Override
    public void onRelease() {
        if (this.myMediaPlayer != null) {
            if (this.myMediaPlayer.isPlaying()) {
                this.myMediaPlayer.stopPlayback();
            }
            if (this.myMediaPlayer.isMediaPlayerCreated()) {
                this.myMediaPlayer.dispose();
            }
            this.myMediaPlayer = null;
        }
        this.progressIndicator = null;
        this.fileInfo = null;
    }

    private void bind(MessageInfo messageInfo) {
        this.fx_ivPlaying.setBackgroundColor(MessageInfoCellLabels.getCellBackground(messageInfo, false, this.isComment));
        this.fileInfo = (FileInfo)messageInfo;
        this.fx_lbPlayingTime.setText("00:00");
        this.fx_lbTotalPlayingTime.setText("00:00");
        if (this.fileInfo.isLoading()) {
            if (this.timer == null) {
                this.timer = new Timer();
                this.timer.schedule(this.loadingTimerTask, 0L, 50L);
            }
        } else {
            try {
                File audioFile = ClientSingleton.getInstance().getClientConnector().get().getFile(this.fileInfo);
                if (audioFile != null && audioFile.exists()) {
                    final Media media = new Media(audioFile.toURI().toString());
                    media.durationProperty().addListener((ChangeListener)new ChangeListener<Duration>(){

                        public void changed(ObservableValue<? extends Duration> observable, Duration oldValue, Duration newValue) {
                            MediaMessageViewerHolder.this.fx_lbTotalPlayingTime.setText(ClientSingleton.getInstance().getTimeDuration((long)newValue.toMillis()));
                            if (MediaMessageViewerHolder.this.mediaPlayer != null) {
                                MediaMessageViewerHolder.this.mediaPlayer.dispose();
                                MediaMessageViewerHolder.this.mediaPlayer = null;
                            }
                            media.durationProperty().removeListener((ChangeListener)this);
                        }
                    });
                    this.mediaPlayer = new MediaPlayer(media);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

