/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.chat.holders.viewerholders;

import java.util.ArrayList;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.IndexRange;
import javafx.scene.control.MenuItem;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.VBox;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.viewers.IActionOnRelease;
import net.sipsnet.client.utils.viewers.richtext.MyStyledTextArea;
import net.sipsnet.client.views.chat.holders.viewerholders.TextBase;
import net.sipsnet.client.views.chat.messagepane.IInnerMessageTextArea;
import net.sipsnet.client.views.chat.messageutil.MessageInfoCellLabels;
import smile.cti.client.MessageInfo;

public class TextInfoViewerHolder
extends TextBase
implements IActionOnRelease,
IInnerMessageTextArea {
    private MyStyledTextArea myStyledTextArea;
    private final MessageInfo messageInfo;
    private ContextMenu contextMenu;

    public TextInfoViewerHolder(MessageInfo messageInfo, int width, boolean isComment) {
        this(messageInfo, width, true, isComment, "");
    }

    public TextInfoViewerHolder(MessageInfo messageInfo, int width, boolean isComment, String inputText) {
        this(messageInfo, width, true, isComment, inputText);
    }

    public TextInfoViewerHolder(MessageInfo messageInfo, int width, boolean isWithStyle, boolean isComment, String inputText) {
        this.messageInfo = messageInfo;
        this.isComment = isComment;
        String content = MessageInfoCellLabels.setContentLabel(messageInfo);
        this.addStyledTextArea(content, inputText);
        this.setDefaultSize(width);
        if (isWithStyle) {
            this.setStyle(MessageInfoCellLabels.getCellBackground(messageInfo, false, isComment));
        }
    }

    private void setDefaultSize(int width) {
        double height = 25.0;
        this.setPrefHeight(height);
        this.setMinHeight(height);
        this.setMaxHeight(Double.MAX_VALUE);
        this.setMaxWidth(width);
        this.setMinWidth(width);
        this.setPrefWidth(width);
    }

    private void addStyledTextArea(String content, String inputText) {
        String color = Theme.getInstance().getCommentTextFill(this.isComment);
        VBox.setMargin((Node)this, (Insets)new Insets(10.0, 10.0, 10.0, 0.0));
        this.myStyledTextArea = new MyStyledTextArea(this, null, color, 12);
        this.myStyledTextArea.setAutoHeight(true);
        this.myStyledTextArea.setEditable(false);
        this.myStyledTextArea.setMaxHeight(Double.MAX_VALUE);
        AnchorPane.setTopAnchor((Node)this.myStyledTextArea, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)this.myStyledTextArea, (Double)0.0);
        AnchorPane.setRightAnchor((Node)this.myStyledTextArea, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)this.myStyledTextArea, (Double)0.0);
        this.myStyledTextArea.setMinWidth(350.0);
        this.myStyledTextArea.setContentToStyledTextArea(content);
        if (this.messageInfo.getType() == 10 && this.messageInfo.getContent().contains("<") && this.messageInfo.getContent().contains(">")) {
            this.myStyledTextArea.setUnderLine();
            ClientSingleton.getInstance().setMouseCursor((Node)this.myStyledTextArea);
            this.myStyledTextArea.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
                try {
                    this.addContextMenu((MouseEvent)event, (MyStyledTextArea)((Object)((Object)event.getSource())));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        if (!inputText.isEmpty()) {
            int index = content.toLowerCase().indexOf(inputText.toLowerCase());
            ArrayList<IndexRange> indexRanges = new ArrayList<IndexRange>();
            while (index != -1) {
                indexRanges.add(new IndexRange(index, index + inputText.length()));
                index = content.toLowerCase().indexOf(inputText.toLowerCase(), index + 1);
            }
            if (!indexRanges.isEmpty()) {
                try {
                    this.myStyledTextArea.updateTextColor(indexRanges, "#8B8000");
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        this.getChildren().add((Object)this.myStyledTextArea);
    }

    private void addContextMenu(MouseEvent mouseEvent, MyStyledTextArea pane) {
        this.contextMenu = new ContextMenu();
        MenuItem menuItem1 = new MenuItem(ClientSingleton.getInstance().getString("message_menu_open"));
        menuItem1.setOnAction(event -> ClientSingleton.getInstance().openNewContact(this.messageInfo));
        this.contextMenu.getItems().add((Object)menuItem1);
        this.contextMenu.show((Node)pane, mouseEvent.getScreenX(), mouseEvent.getScreenY());
    }

    public void refreshBackground() {
        if (this.myStyledTextArea != null) {
            this.myStyledTextArea.clearStyleInSelection();
        } else {
            String content = MessageInfoCellLabels.setContentLabel(this.messageInfo);
            this.getChildren().clear();
            this.addTextArea(content, "");
        }
    }

    public void updateMessage(String content) {
        if (this.myStyledTextArea != null) {
            this.myStyledTextArea.setContentToStyledTextArea(content);
        } else {
            this.getChildren().clear();
            this.addTextArea(content, "");
        }
    }

    public void update(MessageInfo messageInfo, boolean isComment, int width) {
        String content = MessageInfoCellLabels.setContentLabel(messageInfo);
        TimerExecutor.getInstance().startInGUI(() -> {
            if (this.myStyledTextArea != null) {
                this.myStyledTextArea.clear();
                this.myStyledTextArea.setContentToStyledTextArea(content);
            } else {
                this.getChildren().clear();
                this.addTextArea(content, "");
            }
            this.setStyle(MessageInfoCellLabels.getCellBackground(messageInfo, false, isComment));
        });
    }

    @Override
    public void onRelease() {
        ClientSingleton.getInstance().runLater(() -> {
            if (this.myStyledTextArea != null) {
                this.myStyledTextArea.prefWidthProperty().unbind();
                this.myStyledTextArea.clear();
                this.myStyledTextArea = null;
            }
            this.getChildren().clear();
        });
    }

    @Override
    public void resizeParent(int height, int linesCount) {
        height = this.myStyledTextArea.getText().length() < 10 ? 25 : Math.max(height, 25 * linesCount);
        this.setPrefHeight(height);
        this.setMinHeight(height);
        this.setMaxHeight(height);
        this.applyCss();
        this.layout();
    }

    @Override
    public void sendMessage(String message) {
    }

    @Override
    public void clearEditedMessage() {
    }

    @Override
    public void clearMessagePane(int height) {
    }
}

