/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.chat.holders.viewerholders;

import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.media.Media;
import javafx.scene.media.MediaPlayer;
import javafx.scene.media.MediaView;
import javax.imageio.ImageIO;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.viewers.IActionOnRelease;
import net.sipsnet.client.views.chat.cell.IInvalidateListener;
import net.sipsnet.client.views.chat.holders.viewerholders.FileInfoViewerHolder;
import net.sipsnet.client.views.chat.holders.viewerholders.imageviewers.ImageViewer;
import net.sipsnet.client.views.chat.messageutil.MessageInfoCellLabels;
import smile.cti.client.MessageInfo;

public class VideoImageHBoxViewerHolder
extends ImageViewer
implements IActionOnRelease {
    private VBox imageViewPane;
    private final boolean isSmall;
    private ImageView fx_ivImageViewer;
    private Pane parentPane = null;
    private final MessageInfo messageInfo;
    private boolean isDone = false;
    private final boolean isComment;

    public void setParentPane(Pane parentPane) {
        this.parentPane = parentPane;
    }

    public VideoImageHBoxViewerHolder(MessageInfo messageInfo) {
        this(null, messageInfo, false, false);
    }

    public VideoImageHBoxViewerHolder(IInvalidateListener iInvalidateListener, MessageInfo messageInfo, boolean isSmall, boolean isComment) {
        super(iInvalidateListener, messageInfo);
        this.isComment = isComment;
        this.messageInfo = messageInfo;
        this.isSmall = isSmall;
        super.setFileInfoConsumer(this::getVideoFrame);
    }

    private void showVideoFrame(Image image) {
        if (this.parentPane != null) {
            this.parentPane.setMaxWidth(230.0);
        }
        this.showImage(image);
    }

    private void getVideoFrame(File videoFile) {
        StringBuilder filePath = new StringBuilder();
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> filePath.append(clientConnector.getFilesDir()).append(File.separator).append(this.getFileInfo().getId()).append(".png"));
        File file = new File(filePath.toString());
        Image image = null;
        ClientSingleton.toLog(this.getClass().getSimpleName(), "getVideoFrame 2 filePath=" + filePath + " file.exists() =" + file.exists());
        if (file.exists()) {
            try {
                image = new Image((InputStream)new FileInputStream(file), 277.0, 277.0, true, true);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "getVideoFrame 2 image =" + image);
        if (image != null) {
            Image img = image;
            ClientSingleton.toLog(this.getClass().getSimpleName(), "getVideoFrame 5 image =" + image.getWidth() + "x" + image.getHeight());
            ClientSingleton.getInstance().runLater(() -> this.showVideoFrame(img));
            return;
        }
        Media media = null;
        try {
            media = new Media(videoFile.toURI().toString());
        }
        catch (Exception ex) {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "Error :" + ex.getMessage());
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "getVideoFrame 3 media =" + media);
        if (media != null) {
            MediaPlayer mediaPlayer = new MediaPlayer(media);
            mediaPlayer.setAutoPlay(false);
            ClientSingleton.toLog(this.getClass().getSimpleName(), "mediaPlayer.statusProperty() init");
            TimerExecutor.getInstance().setMyAction(() -> {
                if (!this.isDone && this.parentPane != null) {
                    FileInfoViewerHolder fileInfoViewerHolder = new FileInfoViewerHolder(this.messageInfo, this.isSmall ? 230 : 400, this.isComment);
                    this.parentPane.getChildren().clear();
                    this.parentPane.getChildren().add((Object)fileInfoViewerHolder);
                    fileInfoViewerHolder.bind();
                    String style = MessageInfoCellLabels.getCellBackground(this.messageInfo, false) + "-fx-text-fill: #656a7c;";
                    this.parentPane.setStyle(style);
                }
            }).startWithDelayInGUIThread(200L);
            mediaPlayer.statusProperty().addListener((event, oldValue, newValue) -> {
                ClientSingleton.toLog(this.getClass().getSimpleName(), "mediaPlayer.statusProperty() newValue=" + newValue);
                if (newValue == MediaPlayer.Status.READY) {
                    int width = mediaPlayer.getMedia().getWidth();
                    int height = mediaPlayer.getMedia().getHeight();
                    WritableImage wim = new WritableImage(width, height);
                    MediaView mv = new MediaView();
                    mv.setFitWidth((double)width);
                    mv.setFitHeight((double)height);
                    mv.setMediaPlayer(mediaPlayer);
                    ClientSingleton.getInstance().runLater(() -> {
                        mv.snapshot(null, wim);
                        this.isDone = true;
                        try {
                            if (!ImageIO.write((RenderedImage)SwingFXUtils.fromFXImage((Image)wim, null), "png", file)) {
                                System.err.println("not ImageIO.write ");
                                return;
                            }
                            this.getImage(this.getFileInfo().getId(), this.isSmall, file).ifPresent(this::showVideoFrame);
                        }
                        catch (Exception s) {
                            System.out.println(s);
                        }
                        mediaPlayer.dispose();
                    });
                }
            });
        }
    }

    @Override
    public void onRelease() {
        super.onRelease();
    }
}

