/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.chat.holders.viewerholders.imageviewers;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Optional;
import javafx.scene.image.Image;
import javafx.scene.layout.HBox;
import net.sipsnet.client.connector.ClientSingleton;
import smile.cti.client.ClientConnector;

public class ImageViewerUtil
extends HBox {
    private static final int VERTICAL_WIDTH = 182;
    public static final int HORIZONTAL_WIDTH = 277;
    private static final int SMALL_VERTICAL_WIDTH = 97;
    private static final int SMALL_HORIZONTAL_WIDTH = 140;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<Image> getImage(String messageId, boolean isSmall, File file) throws Exception {
        int horizontalWidth = isSmall ? 140 : 277;
        int verticalWidth = isSmall ? 140 : 277;
        Optional<ClientConnector> optionalClientConnector = ClientSingleton.getInstance().getClientConnector();
        if (!optionalClientConnector.isPresent()) return Optional.empty();
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            Image image = new Image((InputStream)fileInputStream, (double)horizontalWidth, (double)verticalWidth, true, true);
            if (image.isError()) {
                Optional<Image> optional = ClientSingleton.getInstance().getImageFromResources("chat/ic_broken_image.png");
                return optional;
            }
            this.setMinWidth(image.getWidth() + 10.0);
            this.setMinHeight(image.getHeight() + 10.0);
            Optional<Image> optional = Optional.of(image);
            return optional;
        }
        catch (Exception ex) {
            ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "Error : " + ex.getMessage());
        }
        return Optional.empty();
    }
}

