/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.chat.messageutil;

import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javafx.scene.paint.Color;
import javafx.util.Pair;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.connector.utils.JsonMessageParser;
import net.sipsnet.client.constants.Constants;
import org.json.smile.JSONException;
import org.json.smile.JSONObject;
import smile.cti.client.ClientConnector;
import smile.cti.client.ContactInfo;
import smile.cti.client.FileInfo;
import smile.cti.client.LineInfo;
import smile.cti.client.MessageInfo;

public class MessageInfoCellLabels {
    private static final String CONFERENCE = "conference";

    public static String setContentLabel(MessageInfo messageInfo) {
        return MessageInfoCellLabels.setContentLabel(messageInfo, false);
    }

    public static String setContentLabel(MessageInfo messageInfo, boolean isNotification) {
        Object contentLabel = null;
        if (messageInfo.getType() == 8) {
            String caller = "";
            try {
                caller = JsonMessageParser.getCaller(messageInfo.getContent(), messageInfo.getStatus());
                if (caller != null && CONFERENCE.equalsIgnoreCase(caller)) {
                    return caller;
                }
                String name = MessageInfoCellLabels.getSender(caller);
                if (name != null) {
                    caller = name;
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            if (messageInfo.getContent().contains("cause")) {
                JSONObject object = null;
                try {
                    int cause;
                    object = new JSONObject(messageInfo.getContent());
                    int n = cause = object.has("cause") ? object.getInt("cause") : 0;
                    if (cause == 26) {
                        contentLabel = ClientSingleton.getInstance().getString("AnsweredElsewhere");
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                }
            }
            if (contentLabel == null) {
                if (ClientSingleton.getInstance().isChatWithTrunks() && !isNotification) {
                    Pair<String, String> trunks = null;
                    try {
                        trunks = JsonMessageParser.getCallerCalled(messageInfo.getContent(), messageInfo.getStatus());
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                    if (trunks == null) {
                        contentLabel = MessageInfoCellLabels.getCallTypeLabel(messageInfo, caller);
                    } else {
                        String name = MessageInfoCellLabels.getSender((String)trunks.getValue());
                        caller = name != null ? name : (String)trunks.getValue();
                        contentLabel = caller == null || caller.isEmpty() ? "" : ClientSingleton.getInstance().getString("call_to_with_trunk") + " " + caller;
                    }
                } else {
                    contentLabel = MessageInfoCellLabels.getCallTypeLabel(messageInfo, caller);
                }
            }
        } else if (messageInfo.getType() == 2 || messageInfo.getType() == 20 && messageInfo.getContent().contains("content\":\"")) {
            AtomicReference<String> aString = new AtomicReference<String>(messageInfo.getContent());
            if (messageInfo.getType() == 20) {
                try {
                    JSONObject object = new JSONObject(messageInfo.getContent());
                    if (object.has("content")) {
                        aString.set(object.getString("content"));
                    }
                }
                catch (JSONException e) {
                    e.printStackTrace();
                    aString.set(JsonMessageParser.getJsonContent(messageInfo.getContent()));
                }
            }
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                if (clientConnector.getUserId() != null && ((String)aString.get()).contains(clientConnector.getUserId()) || ((String)aString.get()).contains(clientConnector.getUserInfo(false).toString())) {
                    if (!MessageInfoCellLabels.checkFileContent(aString, clientConnector.getUserInfo(false), true)) {
                        MessageInfoCellLabels.checkFileContent(aString, clientConnector.getUserInfo(false), false);
                    }
                } else {
                    ClientSingleton.getInstance().getContactInfoStream().forEach(contactInfo -> {
                        if (!MessageInfoCellLabels.checkFileContent(aString, contactInfo, true)) {
                            MessageInfoCellLabels.checkFileContent(aString, contactInfo, false);
                        }
                    });
                }
            });
            contentLabel = aString.get();
        } else {
            contentLabel = messageInfo.getContent();
            if (((String)contentLabel).contains("number\":\"") && ((String)contentLabel).contains("text\":\"") || messageInfo.getType() == 20 && !((String)contentLabel).contains("content\":\"")) {
                String text = "";
                if (JsonMessageParser.hasTag((String)contentLabel, "text\":\"")) {
                    text = JsonMessageParser.getJsonText((String)contentLabel);
                } else {
                    try {
                        JSONObject object = new JSONObject((String)contentLabel);
                        text = object.getString("text");
                    }
                    catch (JSONException e) {
                        ClientSingleton.toLog("MessageInfoCellLabels", "ERROR: message id " + messageInfo.getId() + " message : " + e.getLocalizedMessage());
                        text = JsonMessageParser.getJsonText((String)contentLabel);
                    }
                }
                contentLabel = text;
            } else if (messageInfo.getType() == 10) {
                if (((String)contentLabel).contains("<")) {
                    contentLabel = ((String)contentLabel).substring(0, ((String)contentLabel).indexOf("<")).trim();
                }
                contentLabel = messageInfo.getStatus() == 9 ? ClientSingleton.getInstance().getString(messageInfo.getStatus() == 1 || messageInfo.getStatus() == 2 ? "chat_contact_phone" : "chat_contact_phone_") + ": " + (String)contentLabel : ClientSingleton.getInstance().getString(messageInfo.getStatus() == 1 || messageInfo.getStatus() == 2 ? "chat_contact_info" : "chat_contact_info_") + ": " + (String)contentLabel;
            } else if (messageInfo.getType() == 3 || messageInfo.getType() == 4) {
                if (messageInfo.getType() == 3) {
                    contentLabel = ClientSingleton.getInstance().getString("chat_user_added") + " " + (String)contentLabel;
                } else if (messageInfo.getType() == 4) {
                    contentLabel = ((String)contentLabel).isEmpty() ? ClientSingleton.getInstance().getString("chat_user_left") : ClientSingleton.getInstance().getString("chat_user_removed") + " " + (String)contentLabel;
                }
            } else {
                contentLabel = messageInfo.getContent();
            }
        }
        return contentLabel;
    }

    private static String getCallTypeLabel(MessageInfo messageInfo, String caller) {
        String contentLabel;
        if (messageInfo.getStatus() == 5 || messageInfo.getStatus() == 12) {
            boolean isLost;
            boolean bl = isLost = messageInfo.getType() == 8 && MessageInfoCellLabels.isLostCall(messageInfo);
            contentLabel = caller == null || caller.isEmpty() ? "" : (String)(isLost ? ClientSingleton.getInstance().getString("call_missed") + " " + ClientSingleton.getInstance().getString("sms_from") : ClientSingleton.getInstance().getString("call_from")) + " " + caller;
        } else {
            contentLabel = caller == null || caller.isEmpty() ? "" : ClientSingleton.getInstance().getString("call_to") + " " + caller;
        }
        return contentLabel;
    }

    private static boolean checkFileContent(AtomicReference<String> atomicReference, ContactInfo contactInfo, boolean isCheckName) {
        String start;
        if (ClientSingleton.getInstance().getUserID(contactInfo) == null) {
            return false;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(isCheckName ? contactInfo.toString() : ClientSingleton.getInstance().getUserID(contactInfo)).append("-");
        if (atomicReference.get().contains(stringBuilder.toString())) {
            atomicReference.set(atomicReference.get().replace(stringBuilder.toString(), ""));
            return true;
        }
        int index = -1;
        index = atomicReference.get().indexOf("-");
        if (index != -1 && (start = atomicReference.get().substring(0, index)).length() >= 20) {
            try {
                Float.parseFloat(start);
                atomicReference.set(atomicReference.get().substring(index + 1));
                return true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    public static Pair<String, Integer> getSenderName(MessageInfo messageInfo) {
        Pair pair = messageInfo.getType() == 8 ? MessageInfoCellLabels.getCallPair(messageInfo) : new Pair((Object)MessageInfoCellLabels.getSender(messageInfo), (Object)0);
        return pair;
    }

    public static String getSender(MessageInfo messageInfo) {
        String senderName = "";
        if (MessageInfoCellLabels.isISendTheMessage(messageInfo)) {
            senderName = ClientSingleton.getInstance().getString("my_message");
        } else {
            Optional<ClientConnector> optionalClientConnector = ClientSingleton.getInstance().getClientConnector();
            if (optionalClientConnector.isPresent()) {
                senderName = MessageInfoCellLabels.getSender(messageInfo.getSenderId());
            }
        }
        return senderName;
    }

    private static String getSender(String senderId) {
        AtomicReference senderName = new AtomicReference();
        ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
            List list = ClientSingleton.getInstance().getContactInfoStream().filter(contactInfo -> senderId.equals(ClientSingleton.getInstance().getUserID((ContactInfo)contactInfo))).collect(Collectors.toList());
            if (!list.isEmpty()) {
                senderName.set(((ContactInfo)list.get(0)).toString());
            }
        });
        return (String)senderName.get();
    }

    private static Pair<String, Integer> getCallPair(MessageInfo messageInfo) {
        Pair pair = null;
        int duration = 0;
        try {
            pair = JsonMessageParser.getMessageString(messageInfo.getContent(), messageInfo.getStatus(), true);
            duration = (Integer)pair.getValue();
        }
        catch (NullPointerException | JSONException e) {
            e.printStackTrace();
        }
        if (!ClientSingleton.getInstance().isChatWithTrunks()) {
            if (messageInfo.getStatus() == 5 || messageInfo.getStatus() == 6 && duration != 0) {
                pair = new Pair((Object)ClientSingleton.getInstance().getString(messageInfo.getStatus() == 5 ? "call_incoming" : "call_outgoing"), (Object)duration);
            }
        } else {
            try {
                Pair<String, String> trunks = JsonMessageParser.getCallerCalled(messageInfo.getContent(), messageInfo.getStatus());
                if (trunks == null) {
                    pair = new Pair((Object)ClientSingleton.getInstance().getString(messageInfo.getStatus() == 5 ? "call_incoming" : "call_outgoing"), (Object)duration);
                } else {
                    String callerName = MessageInfoCellLabels.getSender((String)trunks.getKey());
                    pair = new Pair((Object)(ClientSingleton.getInstance().getString("call_from_with_trunk") + " " + (callerName == null ? (String)trunks.getKey() : callerName)), (Object)duration);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return pair;
    }

    public static String getBaseBackgroundColor(MessageInfo messageInfo) {
        if (MessageInfoCellLabels.isISendTheMessage(messageInfo) || messageInfo.getStatus() == 6) {
            return "#dce0ec;";
        }
        return "white;";
    }

    public static String getCellBackground(MessageInfo messageInfo, boolean isLostCall) {
        return MessageInfoCellLabels.getCellBackground(messageInfo, isLostCall, false);
    }

    public static String getCellBackground(MessageInfo messageInfo, boolean isLostCall, boolean isComment) {
        boolean isAttributeTask;
        boolean bl = isAttributeTask = (messageInfo.getCode() & 0x20) != 0 && (messageInfo.getCode() & 0x10) == 0;
        if (isAttributeTask) {
            return MessageInfoCellLabels.getEmailBackground(messageInfo);
        }
        Object style = "";
        if (isLostCall) {
            String chatMissedCall = ClientSingleton.getInstance().getStyleValue(Constants.CHAT_MISSED_CALL_BACKGROUND);
            style = Theme.getInstance().formatedString("-fx-background-color: %s;-fx-border-radius: 0 10 10 10;-fx-background-radius: 0 10 10 10;", chatMissedCall);
        } else {
            String incomingMessageBackground = ClientSingleton.getInstance().getStyleValue(Constants.CHAT_INCOMING_MESSAGE_BACKGROUND);
            String outgoingMessageBackground = ClientSingleton.getInstance().getStyleValue(Constants.CHAT_OUTGOING_MESSAGE_BACKGROUND);
            String color = messageInfo.getType() == 8 ? (messageInfo.getStatus() == 6 ? outgoingMessageBackground : incomingMessageBackground) : (isComment ? (Theme.getInstance().isDarkTheme() ? "#a8a285" : "#fff3bd") : (MessageInfoCellLabels.isISendTheMessage(messageInfo) ? outgoingMessageBackground : incomingMessageBackground));
            style = "-fx-background-color: " + color + ";-fx-border-radius: 0 10 10 10;-fx-background-radius: 0 10 10 10;";
        }
        return style;
    }

    public static boolean isLostCall(MessageInfo messageInfo) {
        return messageInfo.getType() == 8 && (messageInfo.getStatus() == 12 || messageInfo.getStatus() == 5 && messageInfo.getCallDuration() == 0 && messageInfo.getCallCauseCode() != 26);
    }

    private static String getEmailBackground(MessageInfo messageInfo) {
        String style = "";
        style = messageInfo.getCode() == 32 || messageInfo.getStatus() == 1 && messageInfo.getCode() != 32 ? "-fx-background-color: #ffb0b0;-fx-border-radius: 0 10 10 10;-fx-background-radius: 0 10 10 10;" : "-fx-background-color: #dce0ec;-fx-border-radius: 0 10 10 10;-fx-background-radius: 0 10 10 10;";
        return style;
    }

    public static String getCellBackgroundColor(MessageInfo messageInfo, boolean isLostCall) {
        String color = isLostCall ? "#ffb0b0" : (MessageInfoCellLabels.isISendTheMessage(messageInfo) || messageInfo.getStatus() == 6 ? "#dce0ec" : "white");
        return color;
    }

    public static String getCellTextFill(boolean isLostCall) {
        return isLostCall ? "-fx-text-fill: #e65d5d;" : "-fx-text-fill: #252b40;";
    }

    public static Color getCellTextColor(MessageInfo messageInfo, boolean isLostCall) {
        Color color = isLostCall ? Color.valueOf((String)"#656a7c") : (MessageInfoCellLabels.isISendTheMessage(messageInfo) || messageInfo.getStatus() == 6 ? Color.valueOf((String)"#242b42") : Color.valueOf((String)"#656a7c"));
        return color;
    }

    public static String getCellTextFill(MessageInfo messageInfo, boolean isLostCall) {
        String color = isLostCall ? "#656a7c" : (MessageInfoCellLabels.isISendTheMessage(messageInfo) || messageInfo.getStatus() == 6 ? "#242b42" : "#656a7c");
        return color;
    }

    public static String getArrowPngPath(MessageInfo messageInfo, boolean isLostCall) {
        String arrow = "";
        arrow = messageInfo.getType() == 8 ? (messageInfo.getStatus() == 12 || isLostCall ? "arrow_missed.png" : (messageInfo.getStatus() == 5 ? "arrow_inc.png" : "arrow_out.png")) : (MessageInfoCellLabels.isISendTheMessage(messageInfo) ? "arrow_out.png" : "arrow_inc.png");
        return "tab/calls/" + arrow;
    }

    public static String getArrowPngPath(LineInfo lineInfo) {
        Object arrow = "";
        if (lineInfo != null) {
            arrow = "tab/calls/" + (lineInfo.isInbound() ? "arrow_inc.png" : "arrow_out.png");
        }
        return arrow;
    }

    public static boolean hasRecordFile(MessageInfo messageInfo) {
        JSONObject object = null;
        String file = null;
        try {
            object = new JSONObject(messageInfo.getContent());
            if (object.has("file")) {
                file = object.getString("file");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return file != null;
    }

    public static int getCallCause(MessageInfo messageInfo) {
        int cause = -1;
        try {
            JSONObject object = new JSONObject(messageInfo.getContent());
            if (object.has("cause")) {
                cause = object.getInt("cause");
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return cause;
    }

    public static boolean isLink(MessageInfo messageInfo) {
        if (messageInfo instanceof FileInfo) {
            return false;
        }
        String content = messageInfo.getContent();
        return MessageInfoCellLabels.isLink(content);
    }

    public static boolean isLink(String content) {
        return !content.startsWith("{\"number\":") && (content.contains("http://") || content.contains("https://") || content.contains("www.") && !content.contains("=www.") && !content.contains("-www."));
    }

    public static boolean isMyMessage(MessageInfo messageInfo) {
        return (messageInfo.getStatus() == -1 || messageInfo.getStatus() == 0 || messageInfo.getStatus() == 3 || messageInfo.getStatus() == 4 || messageInfo.getSenderId() != null && messageInfo.getSenderId().equals(ClientSingleton.getInstance().getClientConnector().get().getUserId())) && System.currentTimeMillis() - messageInfo.getTime() < 30000L;
    }

    public static boolean isISendTheMessage(MessageInfo messageInfo) {
        return messageInfo.getStatus() == -1 || messageInfo.getStatus() == -3 || messageInfo.getStatus() == 0 || messageInfo.getStatus() == 3 || messageInfo.getStatus() == 4 || messageInfo.getSenderId() != null && messageInfo.getSenderId().equals(ClientSingleton.getInstance().getClientConnector().get().getUserId());
    }

    public static String checkFileName(String fileName) {
        String uid;
        if (fileName == null || !fileName.contains("-") || fileName.length() <= 21) {
            return fileName;
        }
        String ret = fileName;
        while (ret.contains("_") && ret.length() > 5) {
            ret = ret.startsWith("_") ? fileName.substring(1) : fileName;
        }
        while (ret.contains("-") && ret.length() > 21 && (uid = ret.substring(0, 20)).matches("\\d*")) {
            ret = ret.substring(21);
        }
        return ret;
    }
}

