/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.chat.withlistview;

import java.util.Optional;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.ListCell;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.views.chat.cell.ChatCellPane;
import net.sipsnet.client.views.chat.interfaces.IChatListCell;
import smile.cti.client.MessageInfo;

public class ChatListViewCell
extends ListCell<MessageInfo> {
    private final IChatListCell iChatListCell;
    private MessageInfo messageInfo;
    private ChatCellPane chatCellPane;

    public Optional<ChatCellPane> getChatCell() {
        if (this.chatCellPane != null) {
            return Optional.of(this.chatCellPane);
        }
        return Optional.empty();
    }

    public void setChatCell(ChatCellPane chatCellPane) {
        this.chatCellPane = chatCellPane;
    }

    public ChatListViewCell(IChatListCell iChatListCell) {
        this.iChatListCell = iChatListCell;
        this.chatCellPane = null;
        this.messageInfo = null;
    }

    protected void updateItem(MessageInfo messageInfo_, boolean empty) {
        super.updateItem((Object)messageInfo_, empty);
        ClientSingleton.getInstance().runLater(() -> this.myUpdateItem(messageInfo_, empty));
    }

    public MessageInfo getMessageInfo() {
        return this.messageInfo;
    }

    public Optional<String> getMessageId() {
        if (this.messageInfo != null && this.messageInfo.getId() != null) {
            return Optional.of(this.messageInfo.getId());
        }
        return Optional.empty();
    }

    private void myUpdateItem(MessageInfo messageInfo_, boolean empty) {
        super.updateItem((Object)messageInfo_, empty);
        if (empty || messageInfo_ == null) {
            this.setText(null);
            this.setGraphic(null);
        } else {
            this.messageInfo = messageInfo_;
            this.setId(this.messageInfo.toString());
            this.chatCellPane = new ChatCellPane(this.iChatListCell, this.messageInfo);
            this.minHeightProperty().bind((ObservableValue)this.chatCellPane.heightProperty());
            this.chatCellPane.applyCss();
            this.chatCellPane.requestLayout();
            this.setText(null);
            this.setGraphic((Node)this.chatCellPane);
        }
    }
}

