/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.chat.withlistview;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.IntStream;
import javafx.animation.Animation;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Bounds;
import javafx.geometry.Orientation;
import javafx.scene.AccessibleAttribute;
import javafx.scene.control.IndexedCell;
import javafx.scene.control.ListView;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.skin.ListViewSkin;
import javafx.scene.control.skin.VirtualFlow;
import javafx.scene.input.MouseEvent;
import javafx.scene.input.ScrollEvent;
import javafx.util.Duration;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.views.chat.interfaces.IChatListCell;
import net.sipsnet.client.views.chat.withlistview.ChatListViewCell;
import smile.cti.client.MessageInfo;
import smile.cti.client.SessionInfo;

public class MyChatListView
extends ListView<MessageInfo> {
    private SessionInfo sessionInfo;
    private VirtualFlow<ChatListViewCell> virtualFlow;
    private ScrollBar scrollBar;
    private IChatListCell iChatListCell;

    public void setIChatListCell(IChatListCell iChatListCell, ObservableList<MessageInfo> observableList) {
        this.setItems(observableList);
        this.iChatListCell = iChatListCell;
        this.getStylesheets().clear();
        this.getStylesheets().add((Object)((Object)((Object)this)).getClass().getResource("/extracss/mylistview.css").toExternalForm());
        this.setOrientation(Orientation.VERTICAL);
        this.setCellFactory(messageInfo -> new ChatListViewCell(iChatListCell));
        this.initScrollListener();
    }

    private void initScrollListener() {
        TimerExecutor.getInstance().setMyAction(() -> {
            ListViewSkin ts;
            this.virtualFlow = (VirtualFlow)this.lookup(".virtual-flow");
            this.scrollBar = (ScrollBar)this.queryAccessibleAttribute(AccessibleAttribute.VERTICAL_SCROLLBAR, new Object[0]);
            if (this.scrollBar != null) {
                this.smoothScrollingListView(0.09);
            }
            if (this.virtualFlow == null && (ts = (ListViewSkin)this.getSkin()) != null) {
                this.virtualFlow = (VirtualFlow)ts.getChildren().get(0);
            }
            if (this.virtualFlow != null) {
                if (((ChatListViewCell)this.virtualFlow.getLastVisibleCell()).getIndex() != this.getItems().size() - 1) {
                    this.iChatListCell.showScrollButton();
                } else {
                    this.iChatListCell.hideScrollButton();
                }
            }
        }).startWithDelay(1500L);
    }

    public void setSessionInfo(SessionInfo sessionInfo) {
        this.sessionInfo = sessionInfo;
    }

    public void setListViewItems(ObservableList<MessageInfo> observableList) {
        this.setItems(observableList);
    }

    public Optional<ChatListViewCell> getChatListCell(String messageId) {
        AtomicReference chatListViewCellAtomicReference = new AtomicReference();
        if (this.virtualFlow != null) {
            IntStream.range(0, this.virtualFlow.getCellCount()).forEach(i -> {
                ChatListViewCell chatListViewCell = (ChatListViewCell)this.virtualFlow.getVisibleCell(i);
                if (chatListViewCell != null) {
                    chatListViewCell.getMessageId().ifPresent(id -> {
                        if (id.equals(messageId)) {
                            chatListViewCellAtomicReference.set(chatListViewCell);
                        }
                    });
                }
            });
        }
        if (chatListViewCellAtomicReference.get() != null) {
            return Optional.of((ChatListViewCell)((Object)chatListViewCellAtomicReference.get()));
        }
        return Optional.empty();
    }

    public void scrollToBottom(int index) {
        if (this.virtualFlow != null) {
            MessageInfo messageInfo = null;
            if (index < this.getItems().size()) {
                messageInfo = (MessageInfo)this.getItems().get(index);
            }
            if (messageInfo != null && messageInfo.getId() != null) {
                String messageId = messageInfo.getId();
                AtomicReference chatListViewCellAtomicReference = new AtomicReference();
                IntStream.range(0, this.virtualFlow.getCellCount()).forEach(i -> {
                    ChatListViewCell chatListViewCell = (ChatListViewCell)this.virtualFlow.getVisibleCell(i);
                    if (chatListViewCell != null) {
                        chatListViewCell.getMessageId().ifPresent(id -> {
                            ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "ON_SCROLL_TO_UNREAD scrollToBottom id=" + id);
                            if (id.equals(messageId)) {
                                chatListViewCellAtomicReference.set(chatListViewCell);
                            }
                        });
                    }
                });
                ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "ON_SCROLL_TO_UNREAD scrollToBottom chatListViewCellAtomicReference.get()=" + chatListViewCellAtomicReference.get());
                if (chatListViewCellAtomicReference.get() != null) {
                    ClientSingleton.getInstance().runLater(() -> this.virtualFlow.scrollToBottom((IndexedCell)((ChatListViewCell)((Object)((Object)chatListViewCellAtomicReference.get())))));
                } else {
                    this.scrollTo(index);
                }
            } else {
                this.scrollTo(index);
            }
        } else {
            this.scrollTo(index);
        }
    }

    public void scrollToIndex(int index) {
        if (this.virtualFlow != null) {
            this.virtualFlow.scrollTo(index);
        } else {
            this.scrollTo(index);
        }
    }

    public int getFirstVisibleCellIndex() {
        int first = -1;
        try {
            if (this.virtualFlow == null) {
                this.initScrollListener();
                return first;
            }
            first = ((ChatListViewCell)this.virtualFlow.getFirstVisibleCell()).getIndex();
        }
        catch (Exception ex) {
            ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "Error in getLastVisibleCellIndex: " + ex);
        }
        return first;
    }

    public int getLastVisibleCellIndex() {
        int last = -1;
        try {
            if (this.virtualFlow == null) {
                this.initScrollListener();
                return last;
            }
            last = ((ChatListViewCell)this.virtualFlow.getLastVisibleCell()).getIndex();
        }
        catch (Exception ex) {
            ClientSingleton.toLog(((Object)((Object)this)).getClass().getSimpleName(), "Error in getLastVisibleCellIndex: " + ex);
        }
        return last;
    }

    public void smoothScrollingListView(double speed) {
        this.smoothScrollingListView(speed, Orientation.VERTICAL, bounds -> bounds.getHeight());
    }

    public void smoothHScrollingListView(double speed) {
        this.smoothScrollingListView(speed, Orientation.HORIZONTAL, bounds -> bounds.getHeight());
    }

    private void smoothScrollingListView(double speed, Orientation orientation, Function<Bounds, Double> sizeFunc) {
        this.scrollBar.valueProperty().addListener((observableValue, number, t1) -> {
            int last = this.getLastVisibleCellIndex();
            if (last != -1) {
                if (this.getLastVisibleCellIndex() != this.getItems().size() - 1) {
                    this.iChatListCell.showScrollButton();
                } else {
                    this.iChatListCell.hideScrollButton();
                }
            }
        });
        this.scrollBar.setUnitIncrement(5.0);
        double[] frictions = new double[]{0.9, 0.1, 0.05, 0.04, 0.03, 0.02, 0.01, 0.04, 0.01, 0.008, 0.008, 0.008, 0.008, 6.0E-4, 5.0E-4, 3.0E-5, 1.0E-5};
        double[] pushes = new double[]{speed};
        double[] derivatives = new double[frictions.length];
        double[] lastVPos = new double[]{0.0};
        Timeline timeline = new Timeline();
        EventHandler dragHandler = event -> timeline.stop();
        EventHandler scrollHandler = event -> {
            lastVPos[0] = this.getLastVisibleCellIndex();
            if (event.getEventType() == ScrollEvent.SCROLL) {
                double direction = event.getDeltaY() > 0.0 ? -1.0 : 1.0;
                for (int i = 0; i < pushes.length; ++i) {
                    int n = i;
                    derivatives[n] = derivatives[n] + direction * pushes[i];
                }
                if (timeline.getStatus() == Animation.Status.STOPPED) {
                    timeline.play();
                }
            }
            event.consume();
        };
        if (this.scrollBar.getParent() != null) {
            this.scrollBar.getParent().addEventHandler(MouseEvent.DRAG_DETECTED, dragHandler);
            this.scrollBar.getParent().addEventHandler(ScrollEvent.ANY, scrollHandler);
        }
        this.scrollBar.parentProperty().addListener((o, oldVal, newVal) -> {
            if (oldVal != null) {
                oldVal.removeEventHandler(MouseEvent.DRAG_DETECTED, dragHandler);
                oldVal.removeEventHandler(ScrollEvent.ANY, scrollHandler);
            }
            if (newVal != null) {
                newVal.addEventHandler(MouseEvent.DRAG_DETECTED, dragHandler);
                newVal.addEventHandler(ScrollEvent.ANY, scrollHandler);
            }
        });
        timeline.getKeyFrames().add((Object)new KeyFrame(Duration.millis((double)3.0), event -> {
            int i;
            for (i = 0; i < derivatives.length; ++i) {
                int n = i;
                derivatives[n] = derivatives[n] * frictions[i];
            }
            for (i = 1; i < derivatives.length; ++i) {
                int n = i;
                derivatives[n] = derivatives[n] + derivatives[i - 1];
            }
            double dy = derivatives[derivatives.length - 1];
            double size = (Double)sizeFunc.apply(this.scrollBar.getLayoutBounds());
            this.scrollBar.valueProperty().set(Math.min(Math.max(this.scrollBar.getValue() + dy / size, 0.0), 1.0));
            lastVPos[0] = this.scrollBar.getValue();
            if (Math.abs(dy) < 1.0 && Math.abs(dy) < 0.001) {
                timeline.stop();
            }
        }, new KeyValue[0]));
        timeline.setCycleCount(-1);
    }
}

