/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.contactsgroup.createeditgroup;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.WhiteLabels;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.popupstage.MyPopupWindow;
import net.sipsnet.client.utils.threadpool.MyThreadPoolManager;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.CloseImageButton;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButton;
import net.sipsnet.client.utils.viewers.buttons.labelbutton.MyLabelButton;
import net.sipsnet.client.utils.viewers.label.MyLabel;
import net.sipsnet.client.utils.viewers.mylistview.MyListView;
import net.sipsnet.client.utils.viewers.textfieldwithsearch.TextFieldWithSearch;
import net.sipsnet.client.views.contactslist.IContactListChanged;
import net.sipsnet.client.views.contactslist.ScrolledContactInfosList;
import net.sipsnet.client.views.profiles.contactpane.ContactInfoPane;
import net.sipsnet.client.views.profiles.contactpane.IContactSelected;
import net.sipsnet.client.views.profiles.contactpane.IOnLoad;
import net.sipsnet.client.views.settings.MyRadioButton;
import smile.cti.client.ContactInfo;

public class ContactsGroupCreatorEditor
extends ScrolledContactInfosList
implements IContactSelected,
IOnLoad,
IContactListChanged {
    private final HBox rootPane;
    private final String groupName;
    private MyLabelButton myLabelButton;
    private MyPopupWindow myPopupWindow;
    private VBox participateBox;
    private Label participantCount;
    private MyListView myListView;
    private final int rightWidth = 215;
    private TextFieldWithSearch groupNameTextField;
    private final int panelsWidth = 600;
    private boolean isUpdated = false;
    private HBox closeBox;

    private void setGroupMembers(String groupName) {
        this.myLabelButton.setButtonLabelText(ClientSingleton.getInstance().getString("save"));
        List ids = ClientSingleton.getInstance().getClientConnector().get().getContactList(groupName);
        for (String id : ids) {
            Optional<ContactInfo> optional = ClientSingleton.getInstance().getContactInfoByUserId(id);
            optional.ifPresent(this::addContactToList);
        }
        for (ContactInfoPane contactInfoPane : super.getContactsList()) {
            String userId = contactInfoPane.getId();
            if (!ids.stream().anyMatch(userId::equals)) continue;
            contactInfoPane.makeSelected();
        }
        this.participantCount.setText(this.participateBox.getChildren().size() + " " + ClientSingleton.getInstance().getString("group_participants"));
    }

    public void setGroupMembers(List<String> list) {
        this.myLabelButton.setButtonLabelText(ClientSingleton.getInstance().getString("save"));
        for (String id : list) {
            Optional<ContactInfo> optional = ClientSingleton.getInstance().getContactInfoByUserId(id);
            optional.ifPresent(this::addContactToList);
        }
        for (ContactInfoPane contactInfoPane : super.getContactsList()) {
            String userId = contactInfoPane.getId();
            if (!list.stream().anyMatch(userId::equals)) continue;
            contactInfoPane.makeSelected();
        }
        this.participantCount.setText(this.participateBox.getChildren().size() + " " + ClientSingleton.getInstance().getString("group_participants"));
    }

    public ContactsGroupCreatorEditor() {
        this(null, new ArrayList<ContactInfo>());
    }

    public ContactsGroupCreatorEditor(String groupName) {
        this(groupName, new ArrayList<ContactInfo>());
    }

    public ContactsGroupCreatorEditor(List<ContactInfo> contactsFromImport) {
        this(null, contactsFromImport);
    }

    public ContactsGroupCreatorEditor(String groupName, List<ContactInfo> contactsFromImport) {
        super(new ArrayList<ContactInfo>());
        this.groupName = groupName;
        this.setWithMinusImage(false);
        this.setColumnCount(2);
        this.setItemOnList(12);
        this.setWithSearchImage(true);
        this.rootPane = this.getRootPane();
        this.bindPane((Pane)this.rootPane);
        this.setMaxPaneHeight(645);
        super.setIChildContactSelected(this);
        super.setIContactListChanged(this);
        super.setIOnLoad(this);
        super.setShowOnlyUsers(2);
        super.populateLists(contactsFromImport);
        super.setWithMouseSelection(true);
        VBox vBox = new VBox();
        Pane searchBox = this.getHeaderLine(null);
        VBox.setMargin((Node)searchBox, (Insets)new Insets(0.0, 0.0, 10.0, 0.0));
        if (groupName != null) {
            vBox.setStyle("-fx-border-width: 0 1 0 1; -fx-border-insets: 0 1 0 1;-fx-border-color:  #d9e0ef");
            vBox.setPadding(new Insets(0.0, 0.0, 0.0, 5.0));
        } else {
            vBox.setStyle("-fx-border-width: 0 1 0 0; -fx-border-insets: 0 1 0 0;-fx-border-color:  #d9e0ef");
        }
        HBox hbGroupName = new HBox();
        vBox.getChildren().addAll((Object[])new Node[]{this.getTitle(), hbGroupName, searchBox, this.initComponents()});
        this.rootPane.getChildren().add((Object)vBox);
        this.rootPane.getChildren().add((Object)this.getRightPane());
        searchBox.setMinWidth((double)this.getMaxPaneWidth());
        hbGroupName.getChildren().add((Object)this.getEditTextField());
        this.groupNameTextField.setTextWidth(270);
        if (groupName != null) {
            this.setGroupMembers(groupName);
            if (this.groupNameTextField != null) {
                this.groupNameTextField.setText(groupName);
            }
        }
        MyRadioButton myRadioButton = new MyRadioButton();
        HBox.setMargin((Node)myRadioButton, (Insets)new Insets(10.0, 0.0, 0.0, 8.0));
        myRadioButton.setRadioRadius(13);
        myRadioButton.setDotRadius(7);
        myRadioButton.setBorderColor("#646a7e");
        myRadioButton.setSelected(false);
        myRadioButton.setOnMouseClicked(mouseEvent -> {
            boolean isSelect = !myRadioButton.isSelected();
            myRadioButton.setSelected(isSelect);
            Optional<String> optional = ClientSingleton.getInstance().getStyle(Constants.TAB_CELL_TEXT_FILL);
            String sc = isSelect ? "#c2c5d2" : optional.orElse("#646a7e");
            myRadioButton.setBorderColor(sc);
            this.selectAllContact(isSelect);
        });
        hbGroupName.getChildren().add((Object)myRadioButton);
        Label label = new Label();
        label.prefHeightProperty().bind((ObservableValue)hbGroupName.minHeightProperty());
        HBox.setMargin((Node)label, (Insets)new Insets(10.0, 10.0, 0.0, 8.0));
        hbGroupName.getChildren().add((Object)label);
        label.setText(ClientSingleton.getInstance().getString("call_transfer0"));
        Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)label);
        label.setTextFill((Paint)Color.web((String)WhiteLabels.getCustomBlueColor()));
    }

    private MyLabel getTitle() {
        MyLabel labelBox = new MyLabel();
        VBox.setVgrow((Node)labelBox, (Priority)Priority.ALWAYS);
        labelBox.setText(ClientSingleton.getInstance().getString(this.groupName == null ? "group_new_group" : "group_group_name"));
        labelBox.setLabelFontColor(ClientSingleton.getInstance().getStyleValue(Constants.TABS_TITLE_TEXT_FILL));
        labelBox.setLabelFontSize(16);
        labelBox.setLabelFontFamily("Arial");
        labelBox.setTextAlignment(Pos.CENTER_LEFT);
        VBox.setMargin((Node)labelBox, (Insets)new Insets(0.0, 0.0, 15.0, 10.0));
        return labelBox;
    }

    private Pane getEditTextField() {
        this.groupNameTextField = new TextFieldWithSearch();
        if (this.groupName != null) {
            this.groupNameTextField.setText(this.groupName);
        }
        this.groupNameTextField.setPromptText("group_group_name");
        this.groupNameTextField.setBackgroundColor(ClientSingleton.getInstance().getStyleValue(Constants.BASE_COLOR));
        this.groupNameTextField.setTextFontColor(ClientSingleton.getInstance().getStyleValue(Constants.CALLS_PANES_AND_SEARCH_TEXT_FILL));
        this.groupNameTextField.setPadding(new Insets(0.0, 0.0, 0.0, 7.0));
        this.groupNameTextField.setFocusInTextField();
        HBox.setMargin((Node)this.groupNameTextField, (Insets)new Insets(0.0, 0.0, 15.0, 5.0));
        HBox.setHgrow((Node)this.groupNameTextField, (Priority)Priority.ALWAYS);
        return this.groupNameTextField;
    }

    private void addContactToList(ContactInfo contactInfo) {
        ParticipateContact participateContact = new ParticipateContact(contactInfo);
        VBox.setMargin((Node)participateContact, (Insets)new Insets(5.0, 0.0, 5.0, 0.0));
        this.myListView.add((Pane)participateContact);
    }

    private void createGroup() {
        String name = this.groupNameTextField.getText();
        if (name.isEmpty()) {
            ClientSingleton.getInstance().showAlert(ClientSingleton.getInstance().getString("group_warning"));
            return;
        }
        ClientSingleton.getInstance().addLoadingPane(ClientSingleton.getInstance().getString("creating") + " " + name);
        MyThreadPoolManager.getInstance().execute(() -> {
            ArrayList<ContactInfo> parties = new ArrayList<ContactInfo>();
            for (Node node : this.participateBox.getChildren()) {
                ParticipateContact participateContact = (ParticipateContact)node;
                ContactInfo contactInfo = participateContact.getContactInfo();
                parties.add(contactInfo);
            }
            ClientSingleton.toLog(this.getClass().getSimpleName(), "Session parties  " + parties);
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                try {
                    clientConnector.createContactList(name, parties.stream().map(contactInfo -> ClientSingleton.getInstance().getUserID((ContactInfo)contactInfo)).collect(Collectors.toList()));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        });
        this.hide();
    }

    private void updateMembers() {
        ClientSingleton.toLog(this.getClass().getSimpleName(), "updateSessionMembers getSelectedIds()=" + this.participateBox.getChildren());
        ClientSingleton.getInstance().addLoadingPane(ClientSingleton.getInstance().getString("call_group_message"));
        MyThreadPoolManager.getInstance().execute(() -> {
            ArrayList<ContactInfo> parties = new ArrayList<ContactInfo>();
            for (Node node : this.participateBox.getChildren()) {
                ParticipateContact participateContact = (ParticipateContact)node;
                ContactInfo contactInfo = participateContact.getContactInfo();
                ClientSingleton.toLog(this.getClass().getSimpleName(), "updateMembers contactInfo=" + contactInfo + " " + contactInfo.getUserID());
                parties.add(contactInfo);
            }
            ClientSingleton.toLog(this.getClass().getSimpleName(), "parties=" + parties);
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                try {
                    String groupId = clientConnector.getContactListId(this.groupName);
                    clientConnector.updateContactList(groupId, this.groupName, parties.stream().map(contactInfo -> ClientSingleton.getInstance().getUserID((ContactInfo)contactInfo)).collect(Collectors.toList()));
                }
                catch (Exception exception) {
                    ClientSingleton.getInstance().removeLoadingPane();
                    exception.printStackTrace();
                }
            });
        });
        this.isUpdated = true;
    }

    private VBox getRightPane() {
        VBox vBox = new VBox();
        this.closeBox = new HBox();
        VBox.setVgrow((Node)this.closeBox, (Priority)Priority.ALWAYS);
        VBox.setMargin((Node)this.closeBox, (Insets)new Insets(0.0, 0.0, 15.0, 0.0));
        this.closeBox.setMinHeight(40.0);
        this.closeBox.setMaxHeight(40.0);
        vBox.getChildren().add((Object)this.closeBox);
        this.closeBox.setAlignment(Pos.CENTER_LEFT);
        HBox countBox = new HBox();
        HBox.setHgrow((Node)countBox, (Priority)Priority.ALWAYS);
        countBox.setAlignment(Pos.CENTER_LEFT);
        this.participantCount = new Label();
        HBox.setMargin((Node)this.participantCount, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
        HBox.setHgrow((Node)countBox, (Priority)Priority.ALWAYS);
        countBox.getChildren().add((Object)this.participantCount);
        this.closeBox.getChildren().add((Object)countBox);
        CloseImageButton closeImageButton = new CloseImageButton();
        closeImageButton.setBackgroundColor("transparent");
        closeImageButton.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.hide()));
        this.closeBox.getChildren().add((Object)closeImageButton);
        closeImageButton.requestFocus();
        this.myListView = new MyListView();
        this.participateBox = new VBox();
        this.myListView.setContent(this.participateBox, null);
        VBox.setMargin((Node)this.myListView, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
        vBox.getChildren().add((Object)this.myListView);
        vBox.setAlignment(Pos.CENTER);
        VBox.setVgrow((Node)this.myListView, (Priority)Priority.ALWAYS);
        this.myLabelButton = new MyLabelButton(ClientSingleton.getInstance().getString("group_create_group"), 32);
        this.myLabelButton.prefWidthProperty().bind((ObservableValue)vBox.prefWidthProperty());
        vBox.getChildren().add((Object)this.myLabelButton);
        this.myLabelButton.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> {
            if (this.groupName != null) {
                this.updateMembers();
                this.hide();
            } else {
                this.createGroup();
            }
        }));
        VBox.setMargin((Node)this.myLabelButton, (Insets)new Insets(10.0, 0.0, 0.0, 0.0));
        vBox.setPrefWidth(215.0);
        vBox.setMinWidth(215.0);
        this.closeBox.setPrefWidth(215.0);
        this.closeBox.setMinWidth(215.0);
        this.participateBox.setPrefWidth(215.0);
        this.participateBox.setMinWidth(215.0);
        this.myListView.setPrefWidth(225.0);
        this.myListView.setMinWidth(225.0);
        Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.participantCount);
        return vBox;
    }

    public boolean show() {
        ClientSingleton.getInstance().runLater(this::onShow);
        return this.isUpdated;
    }

    private void onShow() {
        this.rootPane.setMaxWidth((double)(this.getMaxPaneWidth() + 215 + 15));
        this.myPopupWindow = MyPopupWindow.getNewInstance((Pane)this.rootPane).initMotionListeners((Node)this.closeBox);
        this.myPopupWindow.showAndWait();
    }

    public void hide() {
        ClientSingleton.getInstance().runLater(() -> {
            this.myPopupWindow.hide();
            long st = System.currentTimeMillis();
            super.onClose();
            ClientSingleton.getInstance().releaseViewResources((Pane)this.rootPane);
        });
    }

    private HBox getRootPane() {
        HBox hBox = new HBox();
        hBox.setPadding(new Insets(20.0, 10.0, 20.0, 10.0));
        hBox.setStyle("-fx-background-color: white;-fx-border-radius: 8 8 8 8;-fx-background-radius: 8 8 8 8;-fx-background-insets: 4 4 4 4; -fx-effect: dropshadow(three-pass-box, rgba(0, 0, 0, 0.23), 4, 0, 0, 0);");
        hBox.setSpacing(2.0);
        return hBox;
    }

    @Override
    public void contactSelected(ContactInfo contactInfo, boolean isSelected) {
        if (isSelected) {
            this.addContactToList(contactInfo);
        } else {
            this.myListView.removeItem(ClientSingleton.getInstance().getUserID(contactInfo));
        }
        this.participantCount.setText(this.participateBox.getChildren().size() + " " + ClientSingleton.getInstance().getString("group_participants"));
    }

    @Override
    public void listUpdated() {
    }

    @Override
    public void contactListChanged() {
        ObservableList<Node> list = this.myListView.getChildrenPanes();
        for (int i = 0; i < list.size(); ++i) {
            ParticipateContact participateContact = (ParticipateContact)((Object)list.get(i));
            ContactInfo contactInfo = participateContact.getContactInfo();
            this.getContactsList().stream().filter(contactInfoPane1 -> contactInfoPane1.getId().equals(ClientSingleton.getInstance().getUserID(contactInfo) == null ? String.valueOf(contactInfo.hashCode()) : ClientSingleton.getInstance().getUserID(contactInfo)) && !contactInfoPane1.isSelected()).findAny().ifPresent(ContactInfoPane::makeSelected);
        }
    }

    private class ParticipateContact
    extends HBox {
        private ContactInfo contactInfo;

        private void setContactInfo(ContactInfo contactInfo) {
            this.contactInfo = contactInfo;
        }

        public ContactInfo getContactInfo() {
            return this.contactInfo;
        }

        private ParticipateContact(ContactInfo contactInfo) {
            this.setContactInfo(contactInfo);
            ContactInfoPane contactInfoPane = ContactInfoPane.getInstance().setDefaultTextFontColor("#646a7e").setDefaultSelectColor("#f1f2f5").setLabel(contactInfo).setWithAvatar(false).setSelected(true).setWithState(false).setPreventSelection(false).build();
            contactInfoPane.maxWidthProperty().bind((ObservableValue)ContactsGroupCreatorEditor.this.participateBox.widthProperty().subtract(10));
            contactInfoPane.minWidthProperty().bind((ObservableValue)ContactsGroupCreatorEditor.this.participateBox.widthProperty().subtract(10));
            this.setAlignment(Pos.CENTER);
            this.getChildren().add((Object)contactInfoPane);
            HBox hBox = new HBox();
            HBox.setMargin((Node)hBox, (Insets)new Insets(2.0, 2.0, 2.0, 2.0));
            hBox.setAlignment(Pos.CENTER);
            HBox.setHgrow((Node)hBox, (Priority)Priority.ALWAYS);
            ImageButton myImageView = new ImageButton();
            ClientSingleton.getInstance().setMouseCursor((Node)myImageView);
            myImageView.setSize(15, 15);
            myImageView.setImagePath("profiles/profile_minus.png");
            myImageView.setBackgroundColor("transparent");
            myImageView.setOnMouseClickedEvent((EventHandler<MouseEvent>)((EventHandler)event -> {
                ContactsGroupCreatorEditor.this.unselectContactInfoPane(contactInfo);
                ContactsGroupCreatorEditor.this.myListView.removeItemByHash(((Object)((Object)this)).hashCode());
            }));
            HBox.setMargin((Node)myImageView, (Insets)new Insets(0.0, 5.0, 0.0, 5.0));
            contactInfoPane.getChildren().add((Object)myImageView);
            this.setId(ClientSingleton.getInstance().getUserID(contactInfo));
        }

        private String getSelectionStyle(boolean isAdmin) {
            return " -fx-background-color:" + (String)(isAdmin ? WhiteLabels.getCustomBlueColor() + ";" : ClientSingleton.getInstance().getStyleValue(Constants.SECOND_BASE_COLOR)) + "    -fx-border-radius: 15 15 15 15;    -fx-background-radius: 15 15 15 15;";
        }

        public boolean equals(ContactInfo contactInfo_) {
            return ClientSingleton.getInstance().getUserID(this.contactInfo).equals(ClientSingleton.getInstance().getUserID(contactInfo_));
        }
    }
}

