/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.contactslist;

import javafx.event.EventHandler;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.viewers.label.MyLabel;
import net.sipsnet.client.views.contactslist.ISwitchTab;

public class TabLabel
extends MyLabel {
    private String title;
    private final String selectedBackgroundColor = "#242b42";
    private final String unselectedBackgroundColor = "#969aae";
    private final String selectedTextColor = Theme.getInstance().isDarkTheme() ? ClientSingleton.getInstance().getStyleValue(Constants.TABS_TITLE_TEXT_FILL) : "#242b42";
    private final String unselectedTextColor = "#969aae";
    private boolean selected = false;
    private boolean isWithRightBorder = true;
    private int labelMarginRight = 10;
    private ISwitchTab iSwitchTab;

    private TabLabel(ISwitchTab iSwitchTab) {
        this.setISwitchTab(iSwitchTab);
    }

    public TabLabel() {
    }

    public static TabLabel getInstance() {
        return new TabLabel();
    }

    public static TabLabel getInstance(ISwitchTab iSwitchTab) {
        return new TabLabel(iSwitchTab);
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        if (this.selected) {
            this.setLabelFontColor(this.selectedTextColor);
        } else {
            this.setLabelFontColor("#969aae");
        }
    }

    public String getTitle() {
        return this.title;
    }

    public TabLabel setTitle(String title) {
        this.title = title;
        return this;
    }

    public TabLabel setTabId(String id) {
        super.setId(id);
        return this;
    }

    private void setISwitchTab(ISwitchTab iSwitchTab) {
        this.iSwitchTab = iSwitchTab;
    }

    public TabLabel setTabWithRightBorder(boolean withRightBorder) {
        this.isWithRightBorder = withRightBorder;
        return this;
    }

    public TabLabel setTabLabelMarginRight(int labelMarginRight) {
        this.labelMarginRight = labelMarginRight;
        return this;
    }

    public TabLabel build() {
        this.setMaxHeight(15.0);
        this.setIsUnderline(true);
        this.setText(this.title);
        this.setAlignment(Pos.CENTER);
        this.setBackgroundColor("transparent");
        this.setLabelFontSize(12);
        this.setLabelFontColor("#969aae");
        this.setLabelFontFamily("Arial");
        this.setLabelMarginLeft(this.labelMarginRight);
        this.setWithRightBorder(this.isWithRightBorder);
        ClientSingleton.getInstance().setMouseCursor((Node)this);
        this.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)mouseEvent -> this.iSwitchTab.switchTab(this.getId())));
        return this;
    }
}

