/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.emoji;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButton;
import net.sipsnet.client.views.emoji.EmojiActionEvent;
import net.sipsnet.client.views.emoji.EmojisController;
import net.sipsnet.client.views.emoji.ExtDiversityEmojisController;
import net.sipsnet.client.views.emoji.utils.EmojiClass;

public class EmojiButton
extends ImageButton {
    private final String paneStyle = "-fx-border-radius: 5 5 5 5; -fx-background-radius: 5 5 5 5; -fx-background-color: %s;";
    public static int BUTTON_WIDTH = 38;
    private ObjectProperty<EmojiClass> emoji;
    private final BooleanProperty focusable;
    private final SimpleBooleanProperty hasImage = new SimpleBooleanProperty(false);
    private final ChangeListener<Boolean> changeListener = (observable, oldValue, newValue) -> {
        if (!oldValue.booleanValue() && newValue.booleanValue() && this.emoji != null) {
            super.setImagePath(((EmojiClass)this.emoji.get()).getFileName());
            super.setImageSize(30, 30);
            super.setSize(BUTTON_WIDTH, BUTTON_WIDTH);
            if (!((EmojiClass)this.emoji.get()).getDiversityChildren().isEmpty()) {
                Pane child = new Pane();
                StackPane.setMargin((Node)child, (Insets)new Insets(0.0, 5.0, 5.0, 0.0));
                StackPane.setAlignment((Node)child, (Pos)Pos.BOTTOM_RIGHT);
                child.setStyle(Theme.getInstance().formatedString("-fx-border-radius: 5 5 5 5; -fx-background-radius: 5 5 5 5; -fx-background-color: %s;", ClientSingleton.getInstance().getStyleValue(Constants.SELECTED_LINE_STYLE)));
                ClientSingleton.getInstance().setMouseCursor((Node)child);
                child.setPrefSize(5.0, 5.0);
                child.setMaxSize(5.0, 5.0);
                super.getChildren().add((Object)child);
            }
            ++EmojisController.iconsCount;
        }
    };
    private final ObjectProperty<EventHandler<EmojiActionEvent>> onEmojiAction = new ObjectPropertyBase<EventHandler<EmojiActionEvent>>(){

        protected void invalidated() {
            EmojiButton.this.setEventHandler(EmojiActionEvent.EMOJI_ACTION, (EventHandler)this.get());
        }

        public Object getBean() {
            return EmojiButton.this;
        }

        public String getName() {
            return "onEmojiAction";
        }
    };

    public EmojiButton(EmojiClass emojiClass) {
        this.emoji = new SimpleObjectProperty((Object)emojiClass);
        this.focusable = new SimpleBooleanProperty(false);
        super.setImageSize(30, 30);
        super.setSize(BUTTON_WIDTH, BUTTON_WIDTH);
        this.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)e -> {
            if (e.isPrimaryButtonDown()) {
                this.fireEvent(new EmojiActionEvent(this.getEmoji()));
            } else if (!((EmojiClass)this.emoji.get()).getDiversityChildren().isEmpty()) {
                ExtDiversityEmojisController.getInstance().setEmojiButton(this).build();
            }
        }));
        this.hasImage.addListener(this.changeListener);
    }

    public void setImagePath() {
        this.hasImage.set(true);
    }

    public boolean isHasImage() {
        return this.hasImage.get();
    }

    public SimpleBooleanProperty hasImageProperty() {
        return this.hasImage;
    }

    public void requestFocus() {
        if (this.isFocusable()) {
            super.requestFocus();
        }
    }

    public boolean isFocusable() {
        return this.focusable.get();
    }

    public BooleanProperty focusableProperty() {
        return this.focusable;
    }

    public void setFocusable(boolean focusable) {
        this.focusable.set(focusable);
    }

    public EmojiClass getEmoji() {
        return (EmojiClass)this.emoji.get();
    }

    public ObjectProperty<EmojiClass> emojiProperty() {
        return this.emoji;
    }

    public final ObjectProperty<EventHandler<EmojiActionEvent>> onEmojiActionProperty() {
        return this.onEmojiAction;
    }

    public final EventHandler<EmojiActionEvent> getOnEmojiAction() {
        return (EventHandler)this.onEmojiActionProperty().get();
    }

    public final void setOnEmojiAction(EventHandler<EmojiActionEvent> value) {
        this.onEmojiActionProperty().set(value);
    }
}

