/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.emoji;

import java.util.List;
import java.util.stream.Collectors;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.stage.Window;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.popupstage.MyPopupWindow;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.CloseImageButton;
import net.sipsnet.client.views.emoji.EmojiButton;
import net.sipsnet.client.views.emoji.utils.EmojiClass;
import net.sipsnet.client.views.emoji.utils.EmojiUtils;

public class ExtDiversityEmojisController {
    @FXML
    private Pane fx_MainPane;
    @FXML
    private ScrollPane fx_spDiversityEmojis;
    @FXML
    private GridPane fx_gpDiversityEmojis;
    @FXML
    private CloseImageButton fx_CloseStage;
    private EmojiButton emojiButton;
    private MyPopupWindow myPopupWindow;

    public static ExtDiversityEmojisController getInstance() {
        return new ExtDiversityEmojisController();
    }

    public ExtDiversityEmojisController setEmojiButton(EmojiButton emojiButton) {
        this.emojiButton = emojiButton;
        return this;
    }

    public void build() {
        EmojiClass ec = this.emojiButton.getEmoji();
        List<String> emojiNames = ec.getDiversityChildren();
        List emojisList = emojiNames.stream().map(EmojiUtils::getEmojiClass).collect(Collectors.toList());
        int columnIndex = 0;
        int rowIndex = 0;
        for (EmojiClass emojiClass : emojisList) {
            EmojiButton button = new EmojiButton(emojiClass);
            button.setImagePath(emojiClass.getFileName());
            button.setImageSize(30, 30);
            button.setSize(EmojiButton.BUTTON_WIDTH, EmojiButton.BUTTON_WIDTH);
            button.setBackgroundColor(ClientSingleton.getInstance().getStyleValue(Constants.CHAT_REPLY_MESSAGE_BACKGROUND));
            button.setOnEmojiAction(this.emojiButton.getOnEmojiAction());
            button.setOnMouseClicked(event -> {
                this.myPopupWindow.hide();
                ClientSingleton.getInstance().releaseViewResources(this.fx_MainPane);
            });
            GridPane.setColumnIndex((Node)button, (Integer)columnIndex);
            GridPane.setRowIndex((Node)button, (Integer)rowIndex);
            this.fx_gpDiversityEmojis.getChildren().add((Object)button);
            ++columnIndex;
        }
        this.fx_MainPane.setMinWidth((double)(++columnIndex) * this.emojiButton.getWidth());
        this.fx_MainPane.setMaxWidth((double)columnIndex * this.emojiButton.getWidth());
        this.fx_MainPane.setPrefWidth((double)columnIndex * this.emojiButton.getWidth());
        this.fx_CloseStage.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> {
            this.myPopupWindow.hide();
            ClientSingleton.getInstance().releaseViewResources(this.fx_MainPane);
        }));
        this.myPopupWindow = MyPopupWindow.getNewInstance(this.fx_MainPane, (Window)ClientSingleton.getInstance().getParentWindow(), true);
        this.myPopupWindow.showAutoPosition((Node)this.emojiButton);
    }

    public void show(Pane pane) {
        ClientSingleton.getInstance().addToOpenedPopupsList(this.myPopupWindow);
        this.myPopupWindow.show((Node)pane, false);
    }

    public ExtDiversityEmojisController() {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fxml/emoji/emoji_diversity.fxml"));
        loader.setResources(ClientSingleton.getInstance().getResourceBundle());
        loader.setController((Object)this);
        try {
            this.fx_MainPane = (Pane)loader.load();
            Theme.getInstance().applyTo(Constants.CHAT_REPLY_MESSAGE_BACKGROUND, this.fx_MainPane);
            String color = ClientSingleton.getInstance().getStyleValue(Constants.CHAT_TOP_AND_BOTTOM_BACKGROUND);
            Theme.getInstance().applyTo(Constants.SCROLL_PANE_STYLE, (Control)this.fx_spDiversityEmojis, color);
            loader.setController((Object)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

