/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.emoji;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.VBox;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButton;
import net.sipsnet.client.views.emoji.EmojiActionEvent;
import net.sipsnet.client.views.emoji.EmojiBaseController;
import net.sipsnet.client.views.emoji.EmojiButton;
import net.sipsnet.client.views.emoji.EmojiTabHeader;
import net.sipsnet.client.views.emoji.IEmojiController;
import net.sipsnet.client.views.emoji.utils.EmojiClass;
import net.sipsnet.client.views.emoji.utils.EmojiUtils;

public class ExtEmojisController
extends EmojiBaseController
implements IEmojiController {
    private final String[] tabs = new String[]{"recent", "people", "activity", "objects", "travel", "food", "nature", "symbols", "flags"};
    private final Map<EmojiTabHeader, ScrollPane> tabScrolls = new HashMap<EmojiTabHeader, ScrollPane>();
    private EventHandler<EmojiActionEvent> onEmojiAction;
    private VBox fx_MainPane;
    private int currentWidth;
    private EmojiTabHeader selectedTabLabel;
    @FXML
    private ScrollPane fx_spTitles;
    @FXML
    private ImageButton fx_CloseStage;
    @FXML
    private HBox fx_spEmojis;
    @FXML
    private HBox fx_TabTitles;

    public static ExtEmojisController getInstance() {
        return new ExtEmojisController();
    }

    @Override
    public Pane getPane() {
        List<EmojiClass> used = EmojiUtils.getEmojisList(this.tabs[0]);
        EmojiTabHeader emojiTabHeader = this.selectedTabLabel;
        if (emojiTabHeader == null) {
            HBox hBox = (HBox)this.fx_TabTitles.getChildren().get(used.isEmpty() ? 1 : 0);
            this.selectedTabLabel = (EmojiTabHeader)hBox.getChildren().get(0);
        }
        this.selectedTabLabel.setSelectedButton();
        this.setSelectTab(this.selectedTabLabel);
        this.addGridPaneRows();
        return this.fx_MainPane;
    }

    @Override
    public Pane getPaneForDispose() {
        this.dispose();
        return this.fx_MainPane;
    }

    @Override
    public void setEmojiAction(EventHandler<EmojiActionEvent> event) {
        this.onEmojiAction = event;
        Arrays.stream(this.tabs).forEach(this::addEmojiTab);
    }

    @Override
    public void setCloseAction(EventHandler<MouseEvent> mouseEvent) {
        this.fx_CloseStage.addMouseEventHandler(mouseEvent);
        this.fx_CloseStage.setImagePath("buttons/arrow_down.png");
    }

    @Override
    public void setWidth(int width) {
        this.currentWidth = width;
    }

    private ExtEmojisController() {
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fxml/emoji/emoji_ext.fxml"));
        loader.setResources(ClientSingleton.getInstance().getResourceBundle());
        loader.setController((Object)this);
        try {
            this.fx_MainPane = (VBox)loader.load();
            Theme.getInstance().applyTo(Constants.CHAT_TOP_AND_BOTTOM_BACKGROUND, (Pane)this.fx_MainPane);
            String color = ClientSingleton.getInstance().getStyleValue(Constants.CHAT_TOP_AND_BOTTOM_BACKGROUND);
            Theme.getInstance().applyTo(Constants.SCROLL_PANE_SECOND_STYLE, (Control)this.fx_spTitles, color);
            loader.setController((Object)this);
            this.fx_MainPane.widthProperty().addListener((event, oldValue, newValue) -> {
                this.currentWidth = newValue.intValue() - 5;
                ClientSingleton.toLog(this.getClass().getSimpleName(), "onResize oldValue = " + oldValue + " newValue=" + newValue);
                if (Math.abs(oldValue.intValue() - newValue.intValue()) > 15) {
                    ClientSingleton.toLog(this.getClass().getSimpleName(), "onResize Platform.isFxApplicationThread() = " + Platform.isFxApplicationThread());
                    this.onResize(() -> {
                        this.tabScrolls.forEach((emojiButton, scrollPane) -> {
                            GridPane gridPane = (GridPane)scrollPane.getContent();
                            gridPane.getChildren().clear();
                            this.initTabScrollPane(emojiButton.getCategory(), gridPane);
                        });
                        this.addGridPaneRows();
                    });
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void checkVisible(ScrollPane scrollPane) {
        this.onCheckVisible(scrollPane);
    }

    private void addGridPaneRows() {
        AtomicReference selectedTab = new AtomicReference();
        List<EmojiClass> used = EmojiUtils.getEmojisList(this.tabs[0]);
        this.tabScrolls.forEach((myLabel, scrollPane) -> {
            if (myLabel.isSelected()) {
                selectedTab.set(myLabel);
            }
            if (selectedTab.get() == null) {
                if (!used.isEmpty() && myLabel.getCategory().equals(this.tabs[0])) {
                    selectedTab.set(myLabel);
                } else if (myLabel.getCategory().equals(this.tabs[1])) {
                    selectedTab.set(myLabel);
                }
            }
        });
        ScrollPane scrollPane2 = this.tabScrolls.get(selectedTab.get());
        this.setSelectedTab((EmojiTabHeader)selectedTab.get(), scrollPane2);
    }

    private void addEmojiTab(String title) {
        String[] images;
        switch (title) {
            case "people": {
                images = new String[]{"emojis_people_off.png", "emojis_people_on.png"};
                break;
            }
            case "activity": {
                images = new String[]{"emojis_activity_off.png", "emojis_activity_on.png"};
                break;
            }
            case "objects": {
                images = new String[]{"emojis_objects_off.png", "emojis_objects_on.png"};
                break;
            }
            case "travel": {
                images = new String[]{"emojis_travel_off.png", "emojis_travel_on.png"};
                break;
            }
            case "food": {
                images = new String[]{"emojis_food_off.png", "emojis_food_on.png"};
                break;
            }
            case "nature": {
                images = new String[]{"emojis_nature_off.png", "emojis_nature_on.png"};
                break;
            }
            case "symbols": {
                images = new String[]{"emojis_symbols_off.png", "emojis_symbols_on.png"};
                break;
            }
            case "flags": {
                images = new String[]{"emojis_flags_off.png", "emojis_flags_on.png"};
                break;
            }
            default: {
                images = new String[]{"emojis_recent_off.png", "emojis_recent_on.png"};
            }
        }
        String prefix = "emojis_tabs/";
        images[0] = prefix + images[0];
        images[1] = prefix + images[1];
        EmojiTabHeader emojiTabHeader = new EmojiTabHeader(title, images);
        emojiTabHeader.setSize(24, 24);
        HBox hBox = new HBox();
        hBox.setMinWidth(50.0);
        HBox.setHgrow((Node)hBox, (Priority)Priority.ALWAYS);
        hBox.setAlignment(Pos.CENTER);
        hBox.getChildren().add((Object)emojiTabHeader);
        this.fx_TabTitles.getChildren().add((Object)hBox);
        ScrollPane scrollPane = this.getScrollPane(title);
        scrollPane.prefWidthProperty().bind((ObservableValue)this.fx_MainPane.widthProperty().subtract(5));
        this.tabScrolls.put(emojiTabHeader, scrollPane);
        emojiTabHeader.setOnMouseClicked(event -> {
            ScrollPane scrollPane1 = this.tabScrolls.get(emojiTabHeader);
            this.setSelectedTab(emojiTabHeader, scrollPane1);
        });
    }

    private void setSelectedTab(EmojiTabHeader imageButton, ScrollPane scrollPane) {
        ClientSingleton.getInstance().runLater(() -> {
            EmojiButton emojiButton;
            this.setSelectTab(imageButton);
            String category = imageButton.getCategory();
            GridPane gridPane = (GridPane)scrollPane.getContent();
            this.fx_spEmojis.getChildren().clear();
            if ("recent".equals(category)) {
                gridPane.getChildren().clear();
                this.initTabScrollPane(category, gridPane);
            }
            if (this.currentWidth != 0 && !gridPane.getChildren().isEmpty() && !(emojiButton = (EmojiButton)gridPane.getChildren().get(0)).isHasImage()) {
                TimerExecutor.getInstance().setMyAction(() -> this.checkVisible(scrollPane)).startWithDelayInGUIThread(200L);
            }
            this.fx_spEmojis.getChildren().add((Object)scrollPane);
        });
    }

    private void initTabScrollPane(String category, GridPane gridPane) {
        int columnIndex = 0;
        int rowIndex = 0;
        EmojiButton button = null;
        List<EmojiClass> emojisList = EmojiUtils.getEmojisList(category);
        if (emojisList != null) {
            int EMOJIS_PER_LINE = this.currentWidth / EmojiButton.BUTTON_WIDTH - 1;
            for (EmojiClass emojiClass : emojisList) {
                if (columnIndex > EMOJIS_PER_LINE) {
                    ++rowIndex;
                    columnIndex = 0;
                }
                button = new EmojiButton(emojiClass);
                button.setBackgroundColor("transparent");
                button.setOnEmojiAction((EventHandler<EmojiActionEvent>)((EventHandler)arg_0 -> this.onEmojiAction.handle(arg_0)));
                GridPane.setColumnIndex((Node)button, (Integer)columnIndex);
                GridPane.setRowIndex((Node)button, (Integer)rowIndex);
                gridPane.getChildren().add((Object)button);
                ++columnIndex;
            }
        }
    }

    private void setSelectTab(EmojiTabHeader selectedTab) {
        this.tabScrolls.keySet().forEach(emojiTabHeader -> {
            if (!emojiTabHeader.getCategory().equals(selectedTab.getCategory()) && emojiTabHeader.isSelected()) {
                emojiTabHeader.unselectedButton();
            }
        });
        this.selectedTabLabel = selectedTab;
    }

    private ScrollPane getScrollPane(String category) {
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        scrollPane.setVbarPolicy(ScrollPane.ScrollBarPolicy.AS_NEEDED);
        GridPane gridPane = new GridPane();
        gridPane.prefWidthProperty().bind((ObservableValue)scrollPane.widthProperty());
        scrollPane.setContent((Node)gridPane);
        scrollPane.setFitToHeight(true);
        scrollPane.setPannable(true);
        String color = ClientSingleton.getInstance().getStyleValue(Constants.CHAT_TOP_AND_BOTTOM_BACKGROUND);
        Theme.getInstance().applyTo(Constants.SCROLL_PANE_SECOND_STYLE, (Control)scrollPane, color);
        scrollPane.vvalueProperty().addListener(obs -> this.checkVisible(scrollPane));
        scrollPane.hvalueProperty().addListener(obs -> this.checkVisible(scrollPane));
        HBox.setHgrow((Node)scrollPane, (Priority)Priority.ALWAYS);
        this.initTabScrollPane(category, gridPane);
        return scrollPane;
    }
}

