/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.emoji.utils;

import java.util.ArrayList;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;

public class EmojiClass
implements Comparable<EmojiClass> {
    private String emojiCode;
    private final String fileNameForChat;
    private final String category;
    private final String emojiName;
    private String emojiFileName;
    private final String fileName;
    private String shortName;
    private List<String> ascii = new ArrayList<String>();
    private List<String> keywords = new ArrayList<String>();
    private List<String> diversity = new ArrayList<String>();
    private String diversity_parent;
    private final List<String> diversity_children = new ArrayList<String>();
    private String info;
    private int order;
    private int humanform;

    public EmojiClass(String emojiCode, String category, int humanform, int order, List<String> asciiS, List<String> keywordsS, String diversity_parent, List<String> diversity, List<String> diversity_children) {
        this.emojiCode = emojiCode;
        this.fileName = "/ext/emojis/" + emojiCode + ".png";
        this.fileNameForChat = "/ext/emojis/" + emojiCode + ".png";
        this.category = category;
        this.emojiCode = emojiCode;
        this.emojiName = this.fileName.replace(" ", "-").toLowerCase();
        this.humanform = humanform;
        this.ascii.addAll(asciiS);
        this.keywords.addAll(keywordsS);
        this.diversity_children.addAll(diversity_children);
        this.order = order;
        this.diversity_parent = diversity_parent;
        this.diversity = diversity;
    }

    public String getCategory() {
        return this.category;
    }

    public List<String> getDiversityChildren() {
        return this.diversity_children;
    }

    public boolean isHasDiversity() {
        return this.diversity != null && !this.diversity.isEmpty();
    }

    public int getOrder() {
        return this.order;
    }

    public int getHumanform() {
        return this.humanform;
    }

    public EmojiClass(String category, String emojiCode, String fileName, String shortName, ArrayList asciiS, ArrayList keywordsS) {
        this.category = category;
        this.emojiCode = emojiCode;
        this.emojiName = fileName.replace(" ", "-").toLowerCase();
        this.emojiFileName = "/emoji/" + this.emojiName + ".png";
        this.fileName = "/emoji/" + emojiCode + ".png";
        this.fileNameForChat = "/emoji/emoji_chat/" + emojiCode + ".png";
        this.shortName = shortName;
        if (asciiS != null) {
            this.ascii = asciiS;
        }
        if (keywordsS != null) {
            this.keywords = keywordsS;
        }
    }

    public JsonObject getJson() {
        JsonArrayBuilder jsonArrayBuilder;
        JsonObjectBuilder model = Json.createObjectBuilder().add("category", this.category).add("order", this.order).add("humanform", this.humanform);
        if (this.diversity.isEmpty()) {
            model.add("diversity", Json.createArrayBuilder().build());
        } else {
            jsonArrayBuilder = Json.createArrayBuilder();
            for (String acs : this.diversity) {
                jsonArrayBuilder.add(acs);
            }
            model.add("diversity", jsonArrayBuilder.build());
        }
        if (this.diversity_children.isEmpty()) {
            model.add("diversity_children", Json.createArrayBuilder().build());
        } else {
            jsonArrayBuilder = Json.createArrayBuilder();
            for (String acs : this.diversity_children) {
                jsonArrayBuilder.add(acs);
            }
            model.add("diversity_children", jsonArrayBuilder.build());
        }
        if (this.ascii.isEmpty()) {
            model.add("ascii", Json.createArrayBuilder().build());
        } else {
            jsonArrayBuilder = Json.createArrayBuilder();
            for (String acs : this.ascii) {
                jsonArrayBuilder.add(acs);
            }
            model.add("ascii", jsonArrayBuilder.build());
        }
        if (this.keywords.isEmpty()) {
            model.add("keywords", Json.createArrayBuilder().build());
        } else {
            jsonArrayBuilder = Json.createArrayBuilder();
            for (String acs : this.keywords) {
                jsonArrayBuilder.add(acs);
            }
            model.add("keywords", jsonArrayBuilder.build());
        }
        JsonObjectBuilder code_points = Json.createObjectBuilder();
        code_points.add("diversity_parent", this.diversity_parent);
        code_points.build();
        model.add("code_points", code_points);
        return model.build();
    }

    public String getEmojiFileName() {
        return this.emojiFileName;
    }

    public String getEmojiName() {
        return this.emojiName;
    }

    public String getEmojiCode() {
        return this.emojiCode;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFileNameForChat() {
        return this.fileNameForChat;
    }

    public String getShortName() {
        return this.shortName;
    }

    public List<String> getAscii() {
        return this.ascii;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public String toString() {
        return this.emojiCode + "=" + this.fileName;
    }

    @Override
    public int compareTo(EmojiClass emojiClass) {
        return this.order - emojiClass.getOrder();
    }
}

