/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.emoji.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import javafx.util.Pair;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.utils.threadpool.MyThreadPoolManager;
import net.sipsnet.client.views.emoji.utils.EmojiClass;
import org.json.smile.JSONException;
import org.json.smile.JSONObject;

public class EmojiUtils {
    public static final String TAB_USED = "recent";
    public static final String USED_FILE_NAME = "used_emojis";
    public static final String KEY_CATEGORY = "category";
    public static final String KEY_NAME = "name";
    public static final String KEY_SHORTNAME = "shortname";
    public static final String KEY_ASCII = "ascii";
    public static final String KEY_KEYWORDS = "keywords";
    public static final String KEY_ORDER = "order";
    public static final String KEY_HUMAN_FORM = "humanform";
    public static final String KEY_DIVERSITY = "diversity";
    public static final String KEY_DIVERSITY_CHILDREN = "diversity_children";
    public static final String KEY_DIVERSITY_PARENT = "diversity_parent";
    public static final String KEY_CODE_POINT = "code_points";
    private static boolean isHasExternalEmoji = false;
    private static final Set<String> EMOJI_WITH_IMAGE_HASH_SET = new HashSet<String>();
    private static final Map<String, List<EmojiClass>> mCategories = new HashMap<String, List<EmojiClass>>();

    private static String toHexStr(char c) {
        return Integer.toHexString(c);
    }

    private static String toHexStr(int c) {
        return Integer.toHexString(c);
    }

    public static boolean containsEmoji(String str) {
        int cpCnt = str.codePointCount(0, str.length());
        for (int index = 0; index < cpCnt; ++index) {
            int i = str.offsetByCodePoints(0, index);
            int codepoint = str.codePointAt(i);
            if (!EMOJI_WITH_IMAGE_HASH_SET.contains(EmojiUtils.toHexStr(codepoint))) continue;
            return true;
        }
        return false;
    }

    public static boolean isContainsEmoji(String str) {
        return str.codePointCount(0, str.length()) >= 0;
    }

    public static TreeMap<Integer, String> containsEmojiAt(String str) {
        TreeMap<Integer, String> indexes = new TreeMap<Integer, String>();
        int cpCnt = str.codePointCount(0, str.length());
        for (int index = 0; index < cpCnt; ++index) {
            int i = str.offsetByCodePoints(0, index);
            int codepoint = str.codePointAt(i);
            if (!EMOJI_WITH_IMAGE_HASH_SET.contains(EmojiUtils.toHexStr(codepoint))) continue;
            indexes.put(index, EmojiUtils.toHexStr(codepoint));
        }
        if (isHasExternalEmoji && indexes.size() > 1) {
            EmojiUtils.modifyIfFindGenderEmoji(str, indexes);
        }
        return indexes;
    }

    private static void modifyIfFindGenderEmoji(String str, TreeMap<Integer, String> indexes) {
        int startIndex = indexes.firstKey();
        Object emoji = indexes.get(indexes.firstKey());
        for (int index = indexes.firstKey() + 1; index < str.length(); ++index) {
            String emojiCode = indexes.get(index);
            String lastEmoji = emoji;
            if (emojiCode != null) {
                if (EMOJI_WITH_IMAGE_HASH_SET.contains(emoji = (String)(emoji == null ? "" : (String)emoji + "-") + emojiCode)) {
                    indexes.put(index, "");
                    continue;
                }
                if (lastEmoji == null) continue;
                indexes.put(startIndex, lastEmoji);
                emoji = emojiCode;
                startIndex = index;
                continue;
            }
            if (lastEmoji != null) {
                indexes.put(startIndex, lastEmoji);
                emoji = null;
            }
            startIndex = index;
        }
        ArrayList<Pair> modifiers = new ArrayList<Pair>();
        Iterator<Integer> iterator = indexes.keySet().iterator();
        int emptyEntryCount = 0;
        while (iterator.hasNext()) {
            Integer key = iterator.next();
            if (indexes.get(key).isEmpty()) {
                ++emptyEntryCount;
                continue;
            }
            if (emptyEntryCount == 0) continue;
            modifiers.add(new Pair((Object)key, (Object)emptyEntryCount));
            emptyEntryCount = 0;
        }
        for (Pair pair : modifiers) {
            int key = (Integer)pair.getKey() - (Integer)pair.getValue();
            if (key <= 0) continue;
            String value = indexes.remove(pair.getKey());
            indexes.put(key, value);
        }
        indexes.values().removeIf(String::isEmpty);
    }

    public static String removeEmoji(String str) {
        StringBuilder sb = new StringBuilder();
        int cpCnt = str.codePointCount(0, str.length());
        for (int index = 0; index < cpCnt; ++index) {
            int i = str.offsetByCodePoints(0, index);
            int codepoint = str.codePointAt(i);
            if (!EMOJI_WITH_IMAGE_HASH_SET.contains(EmojiUtils.toHexStr(codepoint))) {
                sb.append(Character.toChars(codepoint));
                continue;
            }
            sb.append(" ");
        }
        if (String.valueOf(sb.charAt(sb.length() - 1)).equals("\n")) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public static EmojiClass getEmojiClass(String emojiCode) {
        AtomicReference emojiClass = new AtomicReference();
        mCategories.values().forEach(emojiClasses -> emojiClasses.stream().filter(emojiClass1 -> emojiClass1.getEmojiCode().equals(emojiCode)).findAny().ifPresent(emojiClass::set));
        return (EmojiClass)emojiClass.get();
    }

    public static List<EmojiClass> getEmojisList(String category) {
        List<EmojiClass> list = mCategories.get(category);
        if (list == null) {
            list = new ArrayList<EmojiClass>();
        }
        if (EmojiUtils.isHasExternalEmoji() && !TAB_USED.equals(category)) {
            return list.stream().filter(emojiClass -> !emojiClass.isHasDiversity()).sorted().collect(Collectors.toList());
        }
        return list;
    }

    public static void readEmojiJson() {
        EmojiUtils.checkExternalEmoji();
        if (!isHasExternalEmoji) {
            MyThreadPoolManager.getInstance().execute(() -> {
                ClientSingleton.toLog("EmojiUtils", "readEmojiJson() ");
                StringBuilder stringBuffer = new StringBuilder();
                try (InputStream in = ClientSingleton.class.getResourceAsStream("/emoji/emoji.json");
                     BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                    String line;
                    while ((line = reader.readLine()) != null) {
                        stringBuffer.append(line);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                if (!stringBuffer.toString().isEmpty()) {
                    try {
                        JSONObject object = new JSONObject(stringBuffer.toString());
                        Map map = object.getMap();
                        ClientSingleton.toLog("EmojiUtils", "readEmojiJson() map=" + map.size());
                        map.forEach((key, value) -> {
                            String name;
                            EMOJI_WITH_IMAGE_HASH_SET.add((String)key);
                            String category = (String)value.get(KEY_CATEGORY);
                            ArrayList keywords = (ArrayList)value.get(KEY_KEYWORDS);
                            List<EmojiClass> lCategories = mCategories.get(category);
                            if (lCategories == null) {
                                lCategories = new ArrayList<EmojiClass>();
                                mCategories.put(category, lCategories);
                            }
                            if (!(name = (String)value.get(KEY_NAME)).contains(":")) {
                                String shortName = (String)value.get(KEY_SHORTNAME);
                                ArrayList ascii = new ArrayList();
                                if (value.get(KEY_ASCII) != null) {
                                    ascii = (ArrayList)value.get(KEY_ASCII);
                                }
                                EmojiClass emojiClass = new EmojiClass(category, (String)key, name, shortName, ascii, keywords);
                                lCategories.add(emojiClass);
                            }
                        });
                    }
                    catch (JSONException e) {
                        e.printStackTrace();
                    }
                } else {
                    ClientSingleton.toLog("EmojiUtils", "empty");
                }
            });
        }
    }

    private static void convertExtEmojiJson() {
        MyThreadPoolManager.getInstance().execute(() -> {
            ClientSingleton.toLog("EmojiUtils", "convertTestEmojiJson() 0 ");
            StringBuilder stringBuffer = new StringBuilder();
            try (InputStream in = ClientSingleton.class.getResourceAsStream("/emoji/ext/emoji.json");
                 BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
                String line;
                while ((line = reader.readLine()) != null) {
                    stringBuffer.append(line);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            EmojiUtils.parseEmojisJson(stringBuffer, false);
            EmojiUtils.getUsedEmojis();
        });
    }

    private static void parseEmojisJson(StringBuilder stringBuffer, boolean isUsedCategory) {
        if (!stringBuffer.toString().isEmpty()) {
            try {
                JSONObject object = new JSONObject(stringBuffer.toString());
                Map map = object.getMap();
                if (!isUsedCategory) {
                    EMOJI_WITH_IMAGE_HASH_SET.clear();
                }
                map.forEach((key, value) -> {
                    if (!isUsedCategory) {
                        EMOJI_WITH_IMAGE_HASH_SET.add((String)key);
                    }
                    String category = isUsedCategory ? TAB_USED : (String)value.get(KEY_CATEGORY);
                    int order = (Integer)value.get(KEY_ORDER);
                    int humanity = (Integer)value.get(KEY_HUMAN_FORM);
                    List ascii = (List)value.get(KEY_ASCII);
                    List keywords = (List)value.get(KEY_KEYWORDS);
                    Map cp = (Map)value.get(KEY_CODE_POINT);
                    String diversity_parent = (String)cp.get(KEY_DIVERSITY_PARENT);
                    ArrayList<String> diversity = new ArrayList();
                    if (value.containsKey(KEY_DIVERSITY_CHILDREN) && !value.get(KEY_DIVERSITY_CHILDREN).equals(JSONObject.NULL)) {
                        diversity = (List)value.get(KEY_DIVERSITY);
                    }
                    List diversity_children = (List)value.get(KEY_DIVERSITY_CHILDREN);
                    List lCategories = mCategories.computeIfAbsent(category, k -> new ArrayList());
                    EmojiClass emojiClass = new EmojiClass((String)key, category, humanity, order, ascii, keywords, diversity_parent, (List<String>)diversity, diversity_children);
                    lCategories.add(emojiClass);
                });
                ClientSingleton.toLog("EmojiUtils", "convertTestEmojiJson() map=" + map.size());
                ClientSingleton.toLog("EmojiUtils", "convertTestEmojiJson() mCategories=" + mCategories.size());
                ClientSingleton.toLog("EmojiUtils", "convertTestEmojiJson() EMOJI_WITH_IMAGE_HASH_SET=" + EMOJI_WITH_IMAGE_HASH_SET.size());
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        } else {
            ClientSingleton.toLog("EmojiUtils", "empty");
        }
    }

    private static void checkExternalEmoji() {
        String dirPath = System.getProperty("user.dir");
        String resourcesJarPath = dirPath + File.separator + "bin" + File.separator + "emojis.jar";
        File file = new File(resourcesJarPath);
        if (file.exists()) {
            EmojiUtils.convertExtEmojiJson();
            isHasExternalEmoji = true;
        }
        ClientSingleton.toLog("EmojiUtils", "convertTestEmojiJson() isHasExternalEmoji=" + isHasExternalEmoji);
    }

    public static boolean isHasExternalEmoji() {
        return isHasExternalEmoji;
    }

    public static void addToUsedCategory(EmojiClass emojiClass) {
        List lCategories = mCategories.computeIfAbsent(TAB_USED, k -> new ArrayList());
        Optional<EmojiClass> optional = lCategories.stream().filter(emojiClass1 -> emojiClass.getEmojiCode().equals(emojiClass1.getEmojiCode())).findAny();
        if (optional.isEmpty()) {
            lCategories.add(emojiClass);
            EmojiUtils.saveUsedEmojis(lCategories);
        }
    }

    private static void getUsedEmojis() {
        StringBuilder stringBuffer = new StringBuilder();
        try (FileReader fileReader = new FileReader(EmojiUtils.getFileName());
             LineNumberReader reader = new LineNumberReader(fileReader);){
            String line;
            while ((line = reader.readLine()) != null) {
                stringBuffer.append(line);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!stringBuffer.toString().isEmpty()) {
            EmojiUtils.parseEmojisJson(stringBuffer, true);
        }
    }

    private static void saveUsedEmojis(List<EmojiClass> emojiClassList) {
        MyThreadPoolManager.getInstance().execute(() -> {
            String fileName = EmojiUtils.getFileName();
            File theme = new File(fileName);
            boolean exists = theme.exists();
            if (!exists) {
                try {
                    exists = theme.createNewFile();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                try {
                    Files.newBufferedWriter(Path.of(System.getProperty("user.home"), "." + ClientSingleton.getInstance().getPackageName().toLowerCase(), USED_FILE_NAME), StandardOpenOption.TRUNCATE_EXISTING);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (exists && !emojiClassList.isEmpty()) {
                JsonObjectBuilder model = Json.createObjectBuilder();
                for (EmojiClass emojiClass : emojiClassList) {
                    JsonObject jsonObject = emojiClass.getJson();
                    model.add(emojiClass.getEmojiCode(), jsonObject);
                }
                try (PrintWriter prn = new PrintWriter(fileName);){
                    prn.println(model.build().toString());
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private static String getFileName() {
        return System.getProperty("user.home") + File.separator + "." + ClientSingleton.getInstance().getPackageName().toLowerCase() + File.separator + USED_FILE_NAME;
    }
}

