/*
 * Decompiled with CFR 0.152.
 */
package net.sipsnet.client.views.group.groupprofileviewer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.atomic.AtomicBoolean;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.geometry.Bounds;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.Labeled;
import javafx.scene.control.MenuItem;
import javafx.scene.control.ScrollBar;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.skin.ScrollPaneSkin;
import javafx.scene.image.Image;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import net.sipsnet.client.connector.ClientSingleton;
import net.sipsnet.client.connector.WhiteLabels;
import net.sipsnet.client.connector.observer.IGUIObservable;
import net.sipsnet.client.connector.theme.Theme;
import net.sipsnet.client.connector.utils.AudioCaller;
import net.sipsnet.client.constants.Constants;
import net.sipsnet.client.constants.IntentConstants;
import net.sipsnet.client.utils.scheduledwork.TimerExecutor;
import net.sipsnet.client.utils.viewers.avatar.AvatarPane;
import net.sipsnet.client.utils.viewers.buttons.imagebutton.ImageButton;
import net.sipsnet.client.utils.viewers.combobox.IOnHiddenListener;
import net.sipsnet.client.utils.viewers.combobox.MaxSizedContextMenu;
import net.sipsnet.client.utils.viewers.richtext.MyStyledTextArea;
import net.sipsnet.client.utils.viewers.textfieldwithsearch.TextFieldWithSearch;
import net.sipsnet.client.views.chat.interfaces.IOnCloseViewer;
import net.sipsnet.client.views.chat.utils.ICallPanesVisibility;
import net.sipsnet.client.views.group.createeditgroup.GroupCreatorEditor;
import net.sipsnet.client.views.profiles.contactpane.ContactInfoPane;
import org.fxmisc.flowless.VirtualizedScrollPane;
import smile.cti.client.ContactInfo;
import smile.cti.client.SessionInfo;

public class GroupProfileViewController
implements IGUIObservable,
IOnHiddenListener {
    private final double HEADER_HEIGHT = 40.0;
    private Image arrow_up;
    private Image arrow_down;
    private final IOnCloseViewer iOnCloseViewer;
    private final Map<String, List<Node>> mapDetails = new HashMap<String, List<Node>>();
    private SessionInfo sessionInfo;
    private VBox participateBox;
    private final MaxSizedContextMenu participantContextMenu;
    private Label participantCount;
    private VirtualizedScrollPane virtualizedScrollPane;
    @FXML
    private HBox fx_MainAvatarPane;
    @FXML
    private HBox fx_TopAvatarBox;
    @FXML
    private VBox fx_vbMainPane;
    @FXML
    private HBox fx_AvatarImage;
    @FXML
    private ImageButton fx_ivEdit;
    @FXML
    private VBox fx_GroupInfo;
    @FXML
    private Label fx_GroupName;
    @FXML
    private VBox fx_AvatarViewPane;
    @FXML
    private ImageButton fx_ibMute;
    @FXML
    private Label fx_lMute;
    @FXML
    private Label fx_lAddUser;
    @FXML
    private ImageButton fx_ibLeave;
    @FXML
    private Label fx_lLeave;
    @FXML
    private VBox fx_MembersViewPane;
    @FXML
    private ScrollPane fx_spMembersViewPane;
    @FXML
    private ImageButton fx_ibAddUser;
    @FXML
    private HBox fx_ButtonBox;
    @FXML
    private VBox fx_vbAddUser;

    public GroupProfileViewController(ResourceBundle resourceBundle, IOnCloseViewer iOnCloseViewer) {
        this.iOnCloseViewer = iOnCloseViewer;
        FXMLLoader loader = new FXMLLoader(this.getClass().getResource("/fxml/profiles/groupprofileviewer.fxml"));
        loader.setResources(resourceBundle);
        loader.setController((Object)this);
        try {
            this.fx_vbMainPane = (VBox)loader.load();
            loader.setController((Object)this);
            this.fx_vbMainPane.setId(this.getClass().getSimpleName());
            this.fx_spMembersViewPane.prefWidthProperty().bind((ObservableValue)this.fx_vbMainPane.widthProperty().subtract(5));
            this.fx_MainAvatarPane.prefWidthProperty().bind((ObservableValue)this.fx_vbMainPane.widthProperty().subtract(10));
            Theme.getInstance().applyProfilesPaneTo((Pane)this.fx_MembersViewPane);
            Theme.getInstance().applyProfilesPaneTo((Pane)this.fx_AvatarViewPane);
            Theme.getInstance().applyTo(Constants.TABS_TITLE_TEXT_FILL, (Labeled)this.fx_GroupName);
            Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.fx_lAddUser);
            Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.fx_lMute);
            Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.fx_lLeave);
            Theme.getInstance().applyTo(Constants.CONTEXT_MENU, (Pane)this.fx_vbMainPane);
            Theme.getInstance().applyTo(Constants.SCROLL_PANE_SECOND_STYLE, (Control)this.fx_spMembersViewPane);
            Theme.getInstance().applyTo(Constants.TABS_VIRTUALIZED_SCROLL, (Pane)this.fx_GroupInfo);
            this.fx_spMembersViewPane.setHbarPolicy(ScrollPane.ScrollBarPolicy.NEVER);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.fx_ibMute.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("sessionInfo", this.sessionInfo);
            ClientSingleton.getInstance().doNotify(Constants.DO_NOT_DISTURB, data);
            TimerExecutor.getInstance().setMyAction(this::setDoNotDisturb).startWithDelay(200L);
        }));
        this.fx_ibLeave.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> {
            ClientSingleton.toLog(this.getClass().getSimpleName(), "Constants.CLOSE_SESSION");
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("sessionInfo", this.sessionInfo);
            ClientSingleton.getInstance().doNotify(Constants.CLOSE_SESSION, data);
        }));
        this.fx_ibAddUser.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.callGroupEditor(this.sessionInfo, true)));
        this.fx_ivEdit.addMouseEventHandler((EventHandler<MouseEvent>)((EventHandler)event -> this.callGroupEditor(this.sessionInfo, false)));
        StackPane.setAlignment((Node)this.fx_ivEdit, (Pos)Pos.BOTTOM_CENTER);
        String[] actions = new String[]{Constants.DO_NOT_DISTURB_, IntentConstants.CONTACT_STATE_CHANGED};
        ClientSingleton.getInstance().addObserver(this, actions);
        this.participantContextMenu = new MaxSizedContextMenu();
        this.participantContextMenu.setMaxHeight(300.0);
        this.participantContextMenu.setMinWidth(150.0);
        this.participantContextMenu.setPrefWidth(150.0);
        this.participantContextMenu.setMaxWidth(150.0);
        this.participantContextMenu.setHideListener(this);
        this.fx_MainAvatarPane.setMinHeight(90.0);
        this.fx_GroupInfo.prefWidthProperty().bind((ObservableValue)this.fx_AvatarViewPane.widthProperty());
        StackPane.setAlignment((Node)this.fx_AvatarImage, (Pos)Pos.TOP_CENTER);
        StackPane.setAlignment((Node)this.fx_ivEdit, (Pos)Pos.BOTTOM_CENTER);
        this.getParticipatePane();
        this.fx_spMembersViewPane.skinProperty().addListener((observable, oldValue, newValue) -> {
            ScrollBar scrollBar;
            if (newValue != null && (scrollBar = ((ScrollPaneSkin)newValue).getVerticalScrollBar()) != null) {
                scrollBar.visibleProperty().addListener((observable1, oldValue1, newValue1) -> this.setPaneInScrollPaneWidth((Pane)this.fx_MembersViewPane, (boolean)newValue1));
            }
        });
    }

    private void setPaneInScrollPaneWidth(Pane pane, boolean isScrollBarVisible) {
        pane.maxWidthProperty().unbind();
        pane.maxWidthProperty().unbind();
        if (isScrollBarVisible) {
            pane.maxWidthProperty().bind((ObservableValue)this.fx_spMembersViewPane.widthProperty().subtract(15));
            pane.minWidthProperty().bind((ObservableValue)this.fx_spMembersViewPane.widthProperty().subtract(15));
        } else {
            pane.maxWidthProperty().bind((ObservableValue)this.fx_spMembersViewPane.widthProperty());
            pane.minWidthProperty().bind((ObservableValue)this.fx_spMembersViewPane.widthProperty());
        }
    }

    public Pane getNode(SessionInfo sessionInfo) {
        this.sessionInfo = sessionInfo;
        this.fx_GroupName.setText(sessionInfo.toString());
        String description = sessionInfo.getDescription();
        if (sessionInfo.getDescription() == null) {
            description = "";
        }
        if (!description.trim().isEmpty()) {
            if (this.virtualizedScrollPane == null) {
                this.virtualizedScrollPane = ClientSingleton.getInstance().addTextAreaToPane((Pane)this.fx_GroupInfo, description);
            } else {
                ((MyStyledTextArea)((Object)this.virtualizedScrollPane.getChildrenUnmodifiable().get(0))).setContentToStyledTextArea(description);
            }
            this.fx_GroupInfo.getChildren().clear();
            this.fx_GroupInfo.getChildren().add((Object)this.virtualizedScrollPane);
            String style = " -fx-background-color: %s;-fx-border-insets:  0;-fx-background-insets: 0; -fx-control-inner-background: #f1f2f5;    -fx-border-radius: 10 10 10 10;    -fx-background-radius: 10 10 10 10;";
            String color = ClientSingleton.getInstance().getStyleValue(Theme.getInstance().isDarkTheme() ? Constants.BASE_COLOR : Constants.SECOND_BASE_COLOR);
            this.fx_GroupInfo.setStyle(Theme.getInstance().formatedString(style, color));
            if (!this.fx_AvatarViewPane.getChildren().contains((Object)this.fx_GroupInfo)) {
                this.fx_AvatarViewPane.getChildren().add(1, (Object)this.fx_GroupInfo);
            }
        } else {
            this.fx_AvatarViewPane.getChildren().remove((Object)this.fx_GroupInfo);
            this.fx_GroupInfo.setStyle(null);
        }
        this.fx_AvatarImage.getChildren().clear();
        this.fx_AvatarImage.getChildren().add((Object)AvatarPane.getInstance(sessionInfo, 65, 36, true));
        this.participateBox.getChildren().clear();
        this.makeParticipateList(this.participateBox, "");
        this.participantCount.setText(this.participateBox.getChildren().size() + " " + ClientSingleton.getInstance().getString("group_members"));
        ClientSingleton.toLog(this.getClass().getSimpleName(), "ClientSingleton.getInstance().isGroupAdmin(sessionInfo)=" + ClientSingleton.getInstance().isGroupAdmin(sessionInfo));
        if (!ClientSingleton.getInstance().isGroupAdmin(sessionInfo) || !ClientSingleton.getInstance().getClientConnector().get().canSeeUsers()) {
            this.fx_ivEdit.setVisible(false);
            this.fx_ButtonBox.getChildren().remove((Object)this.fx_vbAddUser);
            this.fx_ButtonBox.getChildren().remove((Object)this.fx_vbAddUser);
        } else {
            this.fx_ivEdit.setVisible(true);
            if (!this.fx_ButtonBox.getChildren().contains((Object)this.fx_vbAddUser)) {
                this.fx_ButtonBox.getChildren().add(0, (Object)this.fx_vbAddUser);
            }
        }
        this.setDoNotDisturb();
        String leaveGroupTitle = ClientSingleton.getInstance().getString("group_delete");
        AtomicBoolean isLeaveChat = new AtomicBoolean();
        if (sessionInfo.getDialogType() == 3 && (sessionInfo.getStatus() == 1 || sessionInfo.getStatus() == 2)) {
            isLeaveChat.set(true);
            leaveGroupTitle = ClientSingleton.getInstance().getString("group_leave");
        }
        this.fx_lLeave.setText(leaveGroupTitle);
        this.fx_vbMainPane.applyCss();
        this.fx_vbMainPane.layout();
        this.fx_vbMainPane.setId("GroupProfileViewController");
        return this.fx_vbMainPane;
    }

    private void setDoNotDisturb() {
        AtomicBoolean check = new AtomicBoolean();
        if (this.sessionInfo.getProperty("nodisturb") != null) {
            check.set((Boolean)this.sessionInfo.getProperty("nodisturb"));
        }
        ClientSingleton.toLog(this.getClass().getSimpleName(), "setDoNotDisturb check=" + check);
        ClientSingleton.getInstance().runLater(() -> {
            this.fx_ibMute.setImagePath(check.get() ? "group/not_disturb_on.png" : "group/not_disturb.png");
            this.fx_lMute.setText(ClientSingleton.getInstance().getString(check.get() ? "group_unmute" : "group_mute"));
        });
    }

    public String getSessionId() {
        return this.sessionInfo.getSessionId();
    }

    private double getTextHeight(String content) {
        Text text = new Text(content);
        text.setWrappingWidth(150.0);
        double height = text.getBoundsInLocal().getHeight();
        return Math.min(120.0, height) + 10.0;
    }

    private void callGroupEditor(SessionInfo sessionInfo, boolean isAddParticipants) {
        GroupCreatorEditor groupCreatorEditor = new GroupCreatorEditor(sessionInfo, isAddParticipants);
        if (groupCreatorEditor.show()) {
            this.onCloseViewer();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("sessionInfo", sessionInfo);
            ClientSingleton.getInstance().doNotify(Constants.OPEN_PROFILE, data);
        }
    }

    private void addToMap(String key, Node node) {
        List details = this.mapDetails.computeIfAbsent(key, k -> new ArrayList());
        details.add(node);
    }

    private List<Node> getFromMap(String key) {
        return this.mapDetails.get(key);
    }

    private void getParticipatePane() {
        this.fx_MembersViewPane.getChildren().clear();
        HBox countBox = new HBox();
        VBox.setMargin((Node)countBox, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
        countBox.setMinHeight(40.0);
        countBox.setMaxHeight(40.0);
        this.fx_MembersViewPane.getChildren().add((Object)countBox);
        countBox.setAlignment(Pos.CENTER_LEFT);
        this.participantCount = new Label();
        HBox.setHgrow((Node)countBox, (Priority)Priority.ALWAYS);
        countBox.getChildren().add((Object)this.participantCount);
        HBox.setMargin((Node)this.participantCount, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
        this.participateBox = new VBox();
        this.fx_MembersViewPane.setAlignment(Pos.CENTER);
        this.participateBox.prefWidthProperty().bind((ObservableValue)this.fx_MembersViewPane.prefWidthProperty());
        VBox.setMargin((Node)this.participateBox, (Insets)new Insets(0.0, 10.0, 10.0, 10.0));
        this.participateBox.prefWidthProperty().bind((ObservableValue)this.fx_MembersViewPane.prefWidthProperty());
        TextFieldWithSearch textFieldWithSearch = new TextFieldWithSearch();
        textFieldWithSearch.setBackgroundColor(ClientSingleton.getInstance().getStyleValue(Constants.BASE_COLOR));
        textFieldWithSearch.setTextFontColor(ClientSingleton.getInstance().getStyleValue(Constants.CALLS_PANES_AND_SEARCH_TEXT_FILL));
        VBox.setMargin((Node)textFieldWithSearch, (Insets)new Insets(0.0, 10.0, 10.0, 10.0));
        textFieldWithSearch.setPromptText("group_search_participants");
        textFieldWithSearch.setTextWidth(230);
        textFieldWithSearch.setWithSearch(true);
        textFieldWithSearch.addListener((ChangeListener<? super String>)((ChangeListener)(observable, oldValue, newValue) -> {
            if (oldValue.isEmpty() && newValue.isEmpty()) {
                return;
            }
            this.makeParticipateList(this.participateBox, (String)newValue);
        }));
        this.fx_MembersViewPane.getChildren().addAll((Object[])new Node[]{textFieldWithSearch, this.participateBox});
        Theme.getInstance().applyTo(Constants.SUBJECT_TEXT_FILL, (Labeled)this.participantCount);
    }

    private void makeParticipateList(VBox participateBox, String prefix) {
        participateBox.getChildren().clear();
        List administrator = this.sessionInfo.getAdmins();
        List members = this.sessionInfo.getParties();
        ContactInfo userInfo = ClientSingleton.getInstance().getUserInfo();
        if (ClientSingleton.getInstance().isGroupAdmin(this.sessionInfo)) {
            ParticipateContact participateContact = new ParticipateContact(userInfo, true);
            participateBox.getChildren().add((Object)participateContact);
            participateContact.minWidthProperty().bind((ObservableValue)participateBox.widthProperty());
        } else {
            Optional<String> str = members.stream().map(contactInfo -> ClientSingleton.getInstance().getUserID((ContactInfo)contactInfo)).filter(userInfo.getUserID()::equals).findAny();
            if (str.isEmpty()) {
                ParticipateContact participateContact = new ParticipateContact(userInfo, false);
                participateBox.getChildren().add((Object)participateContact);
                participateContact.minWidthProperty().bind((ObservableValue)participateBox.widthProperty());
            }
        }
        for (ContactInfo contactInfo2 : members) {
            if (!prefix.isEmpty() && !contactInfo2.toString().toLowerCase().contains(prefix.toLowerCase())) continue;
            ParticipateContact participateContact = new ParticipateContact(contactInfo2, administrator.contains(ClientSingleton.getInstance().getUserID(contactInfo2)) || ClientSingleton.getInstance().isGroupWithAllAdmins(this.sessionInfo) && !ClientSingleton.getInstance().isExternalContact(contactInfo2));
            participateBox.getChildren().add((Object)participateContact);
            participateContact.minWidthProperty().bind((ObservableValue)participateBox.widthProperty());
        }
    }

    @Override
    public void onNotifiedMessage(String action, Map<String, Object> data) {
        TimerExecutor.getInstance().setMyAction(() -> {
            if (action.equals(Constants.DO_NOT_DISTURB_)) {
                this.setDoNotDisturb();
            } else if (action.equals(IntentConstants.CONTACT_STATE_CHANGED)) {
                ContactInfo contactInfo = (ContactInfo)data.get("contactInfo");
                this.contactInfoStateChanged(contactInfo);
            }
        }).startWithDelayInGUIThread(200L);
    }

    public void removeParticipantPane(ParticipateContact participateContact) {
        this.participateBox.getChildren().remove((Object)participateContact);
    }

    private void makeMenu(ParticipateContact participateContact) {
        this.participantContextMenu.getItems().clear();
        this.participantContextMenu.setId(participateContact.contactInfo == null ? "" : ClientSingleton.getInstance().getUserID(participateContact.contactInfo));
        if (this.sessionInfo.getConferenceState() == 0) {
            if (this.sessionInfo.getStatus() == 3) {
                this.participantContextMenu.getItems().add((Object)this.addMenuItem(ClientSingleton.getInstance().getString("group_menu1_"), (EventHandler<ActionEvent>)((EventHandler)action -> {
                    if (participateContact.isAdmin()) {
                        participateContact.removeParticipant(participateContact.contactInfo, false);
                    } else {
                        participateContact.addAdmin(participateContact.contactInfo);
                    }
                    this.participantContextMenu.hide();
                })));
            } else {
                this.participantContextMenu.getItems().add((Object)this.addMenuItem(ClientSingleton.getInstance().getString("call_menu_dial"), (EventHandler<ActionEvent>)((EventHandler)action -> {
                    AudioCaller.makeCall(participateContact.contactInfo);
                    this.participantContextMenu.hide();
                })));
            }
        } else if (this.sessionInfo.getConferenceState() > 0 && this.sessionInfo.getStatus() == 3) {
            if (participateContact.contactInfo.getConferenceState() > 0 && participateContact.isContactInfoInConnect()) {
                this.participantContextMenu.getItems().add((Object)this.addMenuItem(ClientSingleton.getInstance().getString("group_menu5"), (EventHandler<ActionEvent>)((EventHandler)action -> {
                    this.participantContextMenu.hide();
                    ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                        try {
                            clientConnector.dropFromConference(participateContact.contactInfo);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    });
                }), null));
            } else {
                this.participantContextMenu.getItems().add((Object)this.addMenuItem(ClientSingleton.getInstance().getString("group_menu6"), (EventHandler<ActionEvent>)((EventHandler)action -> {
                    this.participantContextMenu.hide();
                    ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                        try {
                            clientConnector.addToConference(participateContact.contactInfo);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    });
                }), null));
            }
        }
        this.participantContextMenu.getItems().add((Object)this.addMenuItem(ClientSingleton.getInstance().getString("group_menu3"), (EventHandler<ActionEvent>)((EventHandler)action -> {
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("contactInfo", participateContact.contactInfo);
            ClientSingleton.getInstance().doNotify(Constants.OPEN_SESSION, data);
            this.participantContextMenu.hide();
        }), null));
        if (this.sessionInfo.getConferenceState() == 0 && this.sessionInfo.getStatus() == 3) {
            this.participantContextMenu.getItems().add((Object)this.addMenuItem(ClientSingleton.getInstance().getString("group_menu2"), (EventHandler<ActionEvent>)((EventHandler)action -> {
                ClientSingleton.getInstance().showAlert(ClientSingleton.getInstance().getString("group_menu4"), ClientSingleton.getInstance().getString("delete"), (EventHandler<MouseEvent>)((EventHandler)mouseEvent -> ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> participateContact.removeParticipant(participateContact.contactInfo, true))));
                this.participantContextMenu.hide();
            }), "#e65d5d"));
        }
        Bounds boundsInScene = participateContact.menuImageButton.localToScreen(participateContact.menuImageButton.getBoundsInLocal());
        this.participantContextMenu.show((Node)participateContact.menuImageButton, boundsInScene.getMinX(), boundsInScene.getMaxY());
    }

    private MenuItem addMenuItem(String title, EventHandler<ActionEvent> eventHandler) {
        return this.addMenuItem(title, eventHandler, null);
    }

    private MenuItem addMenuItem(String title, EventHandler<ActionEvent> eventHandler, String color) {
        MenuItem menuItem = new MenuItem(title);
        menuItem.setOnAction(eventHandler);
        if (color != null) {
            menuItem.setStyle("-fx-text-fill: " + color + ";");
        }
        return menuItem;
    }

    @Override
    public void onHidden() {
        for (Node child : this.participateBox.getChildren()) {
            ParticipateContact participateContact = (ParticipateContact)child;
            participateContact.unChecked(this.participantContextMenu.getId());
        }
    }

    public void contactInfoStateChanged(ContactInfo contactInfo) {
        for (Node child : this.participateBox.getChildren()) {
            ParticipateContact participateContact = (ParticipateContact)child;
            participateContact.contactInfoStateChanged(contactInfo);
        }
    }

    private void onCloseViewer() {
        this.iOnCloseViewer.onCloseViewer();
        this.fx_GroupInfo.getChildren().clear();
        ClientSingleton.getInstance().removeObserver(this, new String[]{Constants.DO_NOT_DISTURB_});
    }

    public void setMaxWidth(int defaultPanelWidth) {
        this.fx_vbMainPane.setMaxWidth((double)(defaultPanelWidth + 5));
        this.fx_vbMainPane.setMinWidth((double)(defaultPanelWidth + 5));
    }

    private class ParticipateContact
    extends HBox
    implements ICallPanesVisibility {
        private final ContactInfoPane contactInfoPane;
        private ContactInfo contactInfo = null;
        private ImageButton menuImageButton;
        HBox hbAdmin = null;
        private boolean isAdmin = false;

        public boolean isAdmin() {
            return this.isAdmin;
        }

        public void setAdmin(boolean admin) {
            this.isAdmin = admin;
        }

        private ParticipateContact(Object ci, boolean isAdmin) {
            VBox.setMargin((Node)this, (Insets)new Insets(2.0, 0.0, 2.0, 0.0));
            this.isAdmin = isAdmin;
            if (ci instanceof ContactInfo) {
                this.contactInfo = (ContactInfo)ci;
            }
            StackPane stackPane = new StackPane();
            stackPane.setMaxWidth(20.0);
            stackPane.setMaxHeight(32.0);
            HBox.setMargin((Node)stackPane, (Insets)new Insets(0.0, 10.0, 0.0, 0.0));
            this.contactInfoPane = ContactInfoPane.getInstance().setDefaultSelectColor("transparent").setDefaultTextFontColor(this.isContactInfoInConnect() ? "#252b40" : "#646a7e").setLabel(ci).setWithAvatar(false).setSelected(false).setWithState(true).setWithMouseSelection(false).setItemPaneHeight(32).setPreventSelection(false);
            AtomicBoolean withSelection = new AtomicBoolean(true);
            ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                if (clientConnector.getUserId().equals(this.contactInfo.getUserID())) {
                    withSelection.set(false);
                }
            });
            if (withSelection.get()) {
                this.menuImageButton = new ImageButton();
                this.addEventFilter(MouseEvent.MOUSE_ENTERED, event -> {
                    if (GroupProfileViewController.this.participantContextMenu.isMenuShowing()) {
                        return;
                    }
                    this.setCursor(Cursor.HAND);
                    if (this.menuImageButton != null) {
                        this.menuImageButton.setVisible(true);
                    }
                    Theme.getInstance().applyTabCellTo((Pane)this, true, false);
                });
                this.addEventFilter(MouseEvent.MOUSE_EXITED, event -> this.unChecked());
                this.menuImageButton.addEventFilter(MouseEvent.MOUSE_CLICKED, event -> {
                    if (GroupProfileViewController.this.participantContextMenu.isMenuShowing()) {
                        GroupProfileViewController.this.participantContextMenu.hide();
                    } else {
                        GroupProfileViewController.this.makeMenu(this);
                    }
                    event.consume();
                });
                stackPane.getChildren().add((Object)this.menuImageButton);
                this.menuImageButton.setImagePath("buttons/dot_menu.png");
                this.menuImageButton.setBackgroundColor("transparent");
                this.menuImageButton.setVisible(false);
                HBox.setMargin((Node)this.menuImageButton, (Insets)new Insets(0.0, 10.0, 0.0, 8.0));
                Theme.getInstance().applyTabCellTo((Pane)this, false, false);
            }
            this.setAdmin(isAdmin);
            if (this.isAdmin()) {
                if (this.hbAdmin == null) {
                    this.hbAdmin = this.getAdminPane();
                }
                this.contactInfoPane.setAddAfterText((Pane)this.hbAdmin);
            }
            this.contactInfoPane.build();
            HBox.setHgrow((Node)this.contactInfoPane, (Priority)Priority.ALWAYS);
            this.getChildren().add((Object)this.contactInfoPane);
            if (this.contactInfo != null) {
                this.contactInfoPane.getChildren().add((Object)stackPane);
            }
        }

        private boolean isContactInfoInConnect() {
            return this.contactInfo != null && this.contactInfo.getState() >= 6 && this.contactInfo.getState() <= 8;
        }

        private HBox getAdminPane() {
            HBox hbAdmin = new HBox();
            hbAdmin.setMaxHeight(15.0);
            hbAdmin.setPadding(new Insets(0.0, 5.0, 0.0, 5.0));
            hbAdmin.setAlignment(Pos.CENTER);
            Label text = new Label("admin");
            text.setTextAlignment(TextAlignment.CENTER);
            String style = "-fx-text-fill:#ffffff;-fx-font-family: \"Arial\";-fx-font-size: 9pt;-fx-line-height: 1.19;-fx-background-color: transparent;";
            text.setStyle(style);
            hbAdmin.getChildren().add((Object)text);
            hbAdmin.setStyle(" -fx-background-color:" + WhiteLabels.getCustomBlueColor() + ";    -fx-border-radius: 8;    -fx-background-radius: 8;");
            return hbAdmin;
        }

        private void addAdmin(ContactInfo contactInfo) {
            if (!GroupProfileViewController.this.sessionInfo.getAdmins().contains(ClientSingleton.getInstance().getUserID(contactInfo))) {
                if (this.hbAdmin == null) {
                    this.hbAdmin = this.getAdminPane();
                }
                this.contactInfoPane.addAfterText((Pane)this.hbAdmin);
                this.isAdmin = true;
                GroupProfileViewController.this.sessionInfo.getAdmins().add(ClientSingleton.getInstance().getUserID(contactInfo));
                ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                    try {
                        clientConnector.updateSession(GroupProfileViewController.this.sessionInfo, -1, new HashSet(), false);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                });
            }
        }

        private void removeParticipant(ContactInfo contactInfo, boolean withRemove) {
            if (withRemove) {
                List<ContactInfo> remove = Collections.singletonList(contactInfo);
                GroupProfileViewController.this.removeParticipantPane(this);
                ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                    try {
                        clientConnector.updateSession(GroupProfileViewController.this.sessionInfo, 2, new HashSet(remove), GroupProfileViewController.this.sessionInfo.hasAvatar());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                });
            }
            if (GroupProfileViewController.this.sessionInfo.getAdmins().contains(ClientSingleton.getInstance().getUserID(contactInfo))) {
                this.contactInfoPane.removeAddAfterText();
                this.isAdmin = false;
                GroupProfileViewController.this.sessionInfo.getAdmins().remove(ClientSingleton.getInstance().getUserID(contactInfo));
                ClientSingleton.getInstance().getClientConnector().ifPresent(clientConnector -> {
                    try {
                        clientConnector.updateSession(GroupProfileViewController.this.sessionInfo, -1, new HashSet(), false);
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                });
            }
        }

        @Override
        public void setCallPanesVisible() {
        }

        @Override
        public void setCallPanesUnVisible() {
            this.unChecked();
        }

        @Override
        public void switchToFilter() {
        }

        private void unChecked() {
            this.setCursor(Cursor.DEFAULT);
            if (GroupProfileViewController.this.participantContextMenu.isMenuShowing()) {
                return;
            }
            if (this.menuImageButton != null) {
                this.menuImageButton.setVisible(false);
            }
            Theme.getInstance().applyTabCellTo((Pane)this, false, false);
        }

        public void contactInfoStateChanged(ContactInfo contactInfo) {
            if (this.contactInfo != null && ClientSingleton.getInstance().getUserID(this.contactInfo).equals(ClientSingleton.getInstance().getUserID(contactInfo))) {
                this.contactInfoPane.setDefaultTextFontColor(this.isContactInfoInConnect() ? "#252b40" : "#646a7e");
                this.contactInfoPane.setTextFontStyle(this.isContactInfoInConnect());
                this.contactInfoPane.setState();
            }
        }

        public void unChecked(String elementId) {
            if (this.contactInfo != null && ClientSingleton.getInstance().getUserID(this.contactInfo).equals(elementId)) {
                this.unChecked();
            }
        }
    }
}

